.EQ
delim $$
define not= '= back 40 /^'
gsize 12
.EN
.nr PS 16
.LP
.DS C

\fBSmall Ramsey Numbers\fP
.DE
.nr PS 12
.nr VS 15
.sp 1.5
.LP
.ds CH
.ds CF - \\n% -
.DS C
Stanis\(l/aw P. Radziszowski
Department of Computer Science
Rochester Institute of Technology
Rochester, NY 14623, spr@cs.rit.edu
\s-2\fHhttp://www.cs.rit.edu/~spr\fP\s0


Submitted: June 11, 1994; Revision #14: January 4, 2014
\s-2\fHhttp://www.combinatorics.org\fP\s0
.DE
.nr LL 5.5i
.sp
.RS
.RS
.LP
\fBABSTRACT:\fP We present data which, to the best of our knowledge,
includes all known nontrivial values and bounds for specific graph,
hypergraph and multicolor
Ramsey numbers, where the avoided graphs are complete or complete
without one edge. Many results pertaining to other more studied cases
are also presented. We give references to all
cited bounds and values, as well as to previous similar compilations.
We do not attempt complete coverage of asymptotic behavior of Ramsey numbers,
but rather we concentrate on their specific values.
.RE
.RE
.nr LL 6.5i
.sp
.nr LT 6.5i
.RS
.IP
Mathematical Reviews Subject Number 05C55
.ds RH "\s10T\s-2HE\s0 E\s-2LECTRONIC\s0 J\s-2OURNAL OF\s0 C\s-2OMBINATORICS\s0 (2014), DS1\s-2.14
.RS
.sp .5
.nr PS 10
.nr VS 12
.LP
.SH
Revisions
.RS
.DS L
1993, February		preliminary version, RIT-TR-93-009 [Ra2]
1994, July 3			first posted on the web at the \fIElJC\fP
1994, November 7		\fIElJC\fP revision #1
1995, August 28		\fIElJC\fP revision #2
1996, March 25		\fIElJC\fP revision #3
1997, July 11			\fIElJC\fP revision #4
1998, July 9			\fIElJC\fP revision #5
1999, July 5			\fIElJC\fP revision #6
2000, July 25			\fIElJC\fP revision #7
2001, July 12			\fIElJC\fP revision #8
2002, July 15			\fIElJC\fP revision #9
2004, July 4			\fIElJC\fP revision #10
2006, August 1		\fIElJC\fP revision #11
2009, August 4		\fIElJC\fP revision #12
2011, August 22		\fIElJC\fP revision #13
2014, January 4		\fIElJC\fP revision #14
.DE
.RE
.RE
.RE
.bp
.EQ
gsize 9
.EN
.nr PS 10
.nr VS 11
.RS
.SH
Table of Contents													 2
.RS
.RS
.DS L
\fB1. Scope and Notation										 3\fP
.sp .3
\fB2. Classical Two-Color Ramsey Numbers						 4\fP
.sp .2
	2.1 $~$Values and bounds for $R(k,^l)$, $k^<=~10,~l^<=~15$					$~^$4
	2.2 $~$Bounds for $R(k,^l)$, higher parameters						$~^$6
	2.3 $~$General results on $R(k,^l)$								$~^$8
.sp .3
\fB3. Two Colors:\fP $K sub n ^-^e$, $K sub 3$, $K sub {m,^n}$								\fB11\fP
.sp .2
	3.1 $~$Dropping one edge from complete graph			 		11
	3.2 $~$Triangle versus other graphs							13
	3.3 $~$Complete bipartite graphs							14
.sp .3
\fB4. Two Colors: Numbers Involving Cycles						18\fP
.sp .2
	4.1 $~$Cycles, cycles versus paths and stars						18
	4.2 $~$Cycles versus complete graphs							19
	4.3 $~$Cycles versus wheels								21
	4.4 $~$Cycles versus books								22
	4.5 $~$Cycles versus other graphs							23
.sp .3
\fB5. General Graph Numbers in Two Colors						24\fP
.sp .2
	5.1 $~$Paths											24
	5.2 $~$Wheels											24
	5.3 $~$Books											25
	5.4 $~$Trees and forests									25
	5.5 $~$Stars, stars versus other graphs							26
	5.6 $~$Paths versus other graphs								27
	5.7 $~$Fans, fans versus other graphs							28
	5.8 $~$Wheels versus other graphs							28
	5.9 $~$Books versus other graphs							29
	5.10 Trees and forests versus other graphs						29
	5.11 Cases for $n(G),~n(H)~<=~5$								30
	5.12 Mixed cases										31
	5.13 Multiple copies of graphs, disconnected graphs				31
	5.14 General results for special graphs						32
	5.15 General results for sparse graphs						32
	5.16 General results									34
.sp .3
\fB6. Multicolor Ramsey Numbers								36\fP
.sp .2
	6.1 $~^$Bounds for classical numbers							36
	6.2 $~^$General results for complete graphs						38
	6.3 $~^$Cycles											39
	6.4 $~^$Paths, paths versus other graphs						43
	6.5 $~^$Special cases										45
	6.6 $~^$General results for special graphs						46
	6.7 $~^$General results									47
.sp .3
\fB7. Hypergraph Numbers									49\fP
.sp .2
	7.1 $~^$Values and bounds for numbers						49
	7.2 $~^$Cycles and paths									49
	7.3 $~^$General results for 3-uniform hypergraphs					51
	7.4 $~^$General results									51
.sp .3
\fB8. Cumulative Data and Surveys								52\fP
.sp .2
	8.1 $~^$Cumulative data for two colors							52
	8.2 $~^$Cumulative data for three colors						53
	8.3 $~^$Electronic resources								54
	8.4 $~^$Surveys										54
.sp .3
\fB9. Concluding Remarks									56\fP
.sp .3
\fBReferences												57-94\fP
.DE
.RE
.RE
.RE
.EQ
gsize 12
.EN
.nr PS 12
.nr VS 15
.NH
Scope and Notation
.sp
.PP
There is vast literature on Ramsey type problems starting in
1930 with the original paper of Ramsey [Ram]. Graham, Rothschild
and Spencer in their book [GRS] present an exciting development
of Ramsey Theory. The subject has grown amazingly, in particular
with regard to asymptotic bounds for various types of Ramsey
numbers (see the survey papers
[GrR\o'o\(:a', Ne\o's\(be', ChGra2, Ros2]),
but the progress on evaluating
the basic numbers themselves has been unsatisfactory for a long
time. In the last three decades, however, considerable progress
has been obtained in this area, mostly by employing computer
algorithms. The few known
exact values and several bounds for different numbers are scattered
among many technical papers. This compilation is a fast
source of references for the best results known for specific numbers.
It is not supposed to serve as a source of definitions or
theorems, but these can be easily accessed via the
references gathered here.
.PP
Ramsey Theory studies conditions when a combinatorial object
contains necessarily some smaller given objects. The role of
Ramsey numbers is to quantify some of the general existential
theorems in Ramsey Theory.
.PP
Let $G sub 1 ,^G sub 2 ,...,^G sub m$ be graphs or $s$-uniform
hypergraphs ($s$ is the number of vertices in each edge).
$R(^G sub 1 ,^G sub 2 ,...,^G sub m ^;^s)$ denotes the $m$-color
.B
Ramsey number
.R
for $s$-uniform graphs/hypergraphs, avoiding $G sub i$ in color $i$
for $1^<=~i^<=~m$. It is defined as the least integer $n$ such that, in any
coloring with $m$ colors of the $s$-subsets of a set of $n$
elements, for some $i$ the $s$-subsets of color $i$ contain
a sub-(hyper)graph isomorphic to $G sub i$ (not necessarily induced).
The value of $R(^G sub 1 ,^G sub 2 ,...,^G sub m ^;^s)$
is fixed under permutations of the first $m$ arguments.
If $s^=^2$ (standard graphs) then $s$ can be omitted. If $G sub i$
is a complete graph $K sub k$, then we may write $k$ instead of
$G sub i$, and if $G sub i ^=^G$ for all $i$ we may use the abbreviation
$R sub m (G;^s)$ or $R sub m (G)$. For $s^=^2$, $K sub k -^e$ denotes
a $K sub k$ without one edge, and for $s^=^3$, $K sub k -^t$ denotes
a $K sub k$ without one triangle (hyperedge).
.PP
The graph $nG$ is formed by $n$ disjoint copies of $G$,
$G  up 20 {size 7 union} ^H$ stands for vertex disjoint union of graphs,
and the \fBjoin\fP $G+^H$ is obtained by adding all of the edges
between vertices of $G$ and $H$ to $G  up 20 {size 7 union} ^H$.
$P sub i$ is a \fBpath\fP
on $i$ vertices, $C sub i$ is a \fBcycle\fP of length $i$, and $W sub i$
is a \fBwheel\fP with $i-1$ spokes, i.e. a graph formed by some vertex $x$,
connected to all vertices of the cycle $C sub i-1$
(thus $W sub i ~=~K sub 1 ^+^C sub i-1$).
$K sub n,m$ is a complete $n$ by $m$ bipartite
graph, in particular $K sub 1,n$ is a \fBstar\fP graph.
The \fBbook\fP graph
$B sub i ^=^ K sub 2 ^+^ K bar sub i ^=^ K sub 1 ^+^K sub 1,i$
has $i+^2$ vertices, and can
be seen as $i$ triangular pages attached to a single edge.
The \fBfan\fP graph $F sub n$ is defined by
$F sub n ~=~ K sub 1 ^+~ nK sub 2$.
For a graph $G$, $n(G)$ and $e(G)$ denote the number of vertices
and edges, respectively, and $delta (G)$ and $DELTA (G)$ minimum
and maximum degree of $G$. Finally, $chi (G)$ denotes the chromatic
number of $G$. In general, we follow the notation used by West [West].

.PP
Section 2 contains the data for the classical two color Ramsey
numbers $R(k,^l)$ for complete graphs, section 3 for the much
studied two color cases of $K sub n ^-^e$, $K sub 3$, $K sub {m,^n}$,
and section 4 for numbers involving cycles. Section 5 lists other
often studied two color cases for general graphs.
The multicolor and hypergraph
cases are gathered in sections 6 and 7, respectively.
Finally, section 8 gives pointers to cumulative data and to
other surveys.

.NH
Classical Two-Color Ramsey Numbers
.sp
.NH 2
Values and bounds for $R(k,^l)$, $k^<=^10,~l^<=^15$
.nr PS 10
.nr VS 12
.LP
.TS
box center tab(,);
cp8 cp8 || rp8 | rp8 | rp8 | rp8 | rp8 | rp8 | rp8 | rp8 | rp8 | rp8 | rp8 | rp8| rp8 .
,$size 8 l$,$~ size 8 3$,4,5,6,7,8,9,10,11,12,13,14,15
\fIk\fP,,,,,,,,,,,,,,
=
.sp .2
3,,6,9,14,18,23,28,36,40,47,52,59,66,73
\^,,\^,\^,\^,\^,\^,\^,\^,42,50,59,68,77,87
_
4,,,18,25,36,49,58,73,92,98,128,133,141,153
\^,,,\^,\^,41,61,84,115,149,191,238,291,349,417
_
5,,,,43,58,80,101,126,144,171,191,213,239,265
\^,,,,49,87,143,216,316,442,633,848,1138,1461,1878
_
6,,,,,102,113,132,169,179,253,263,317,,401
\^,,,,,165,298,495,780,1171,1804,2566,3703,5033,6911
_
7,,,,,,205,217,241,289,405,417,511
\^,,,,,,540,1031,1713,2826,4553,6954,10578,15263,22112
_
8,,,,,,,282,317,,,,817,,861
\^,,,,,,,1870,3583,6090,10630,16944,27485,41525,63609
_
9,,,,,,,,565,581,,,,,
\^,,,,,,,,6588,12677,22325,38832,64864
_
10,,,,,,,,,798,,,,,1265
\^,,,,,,,,,23556,45881,81123
.TE
.nr PS 12
.nr VS 15
.DS C
Table I. Known nontrivial values and bounds for two color
Ramsey numbers $R(k,^l)~=~R(k,^l^;^2)$.
.DE
.sp
.nr PS 10
.nr VS 12
.LP
.TS
box center tab(,);
cp8 cp8 || cp8 | cp8 | cp8 | cp8 | cp8 | cp8 | cp8 | cp8 | cp8 | cp8 | cp8| cp8 .
,$size 8 l$,$~ size 8 4$,5,6,7,8,9,10,11,12,13,14,15
\fIk\fP,,,,,,,,,,,,,,
=
.sp .2
3,,GG,GG,K\o'e\(aa'ry,Ka2,GR,Ka2,Ex5,Ex20,Ex12,Piw1,Ex8,WW
\^,,\^,\^,\^,GrY,MZ,GR,GoR1,GoR1,Les,GoR1,GoR1,GoR1
_
4,,GG,Ka1,Ex19,Ex3,Ex20,Ex16,HaKr1,Ex17,SLL,2.3.e,XXR,XXR
\^,,\^,MR4,MR5,Mac,Mac,Mac,Mac,Spe4,Spe4,Spe4,Spe4,Spe4
_
5,,,Ex4,Ex9,CaET,HaKr1,Ex17,Ex17,Gerb,Gerb,Gerb,Gerb,Ex16
\^,,,MR5,HZ1,Spe4,Spe4,Mac,Mac,HW+,HW+,HW+,HW+,HW+
_
6,,,,Ka1,Ex16,XSR2,XXER,Ex16,XXR,XSR2,XXER,,2.3.h
\^,,,,Mac,Mac,Mac,Mac,Mac,HW+,HW+,HW+,HW+,HW+
_
7,,,,,She2,XSR2,XSR2,2.3.h,XXER,XSR2,XXR
\^,,,,,Mac,Mac,HZ1,Mac,HW+,HW+,HW+,HW+,HW+
_
8,,,,,,BR,XXER,,,,XXER,,2.3.h
\^,,,,,,Mac,Ea1,HZ1,HW+,HW+,HW+,HW+,HW+
_
9,,,,,,,She2,XSR2,,,,,
\^,,,,,,,ShZ1,Ea1,HW+,HW+,HW+
_
10,,,,,,,,She2,,,,,2.3.h
\^,,,,,,,,Shi2,HW+,HW+
.TE
.nr PS 12
.nr VS 15
.DS C
References for Table I;
HW+ abbreviates HWSYZH, as enhanced by Boza [Boza5], see 2.1.m.
.DE
.sp
.PP
We split the data into the table of values and a table with
corresponding references. In Table I, known exact values appear
as centered entries, lower bounds as top entries, and upper
bounds as bottom entries. For some of the exact values two
references are given when the lower and upper bound credits
are different.

.IP (a)
The task of proving $R(3,^3) ~<=~ 6$ was the second problem in Part I
of the William Lowell Putnam Mathematical Competition held in March
1953 [Bush].
.IP (b)
Greenwood and Gleason [GG] established the initial
values $R(3,^4)~=~9$, $R(3,^5)~=~14$ and $R(4,^4)~=~18$
in 1955.
.IP (c)
K\o'e\(aa'ry [K\o'e\(aa'ry]
proved that $R(3,^6)~=~18$ in 1964, but only in 2007 an elementary
and self-contained proof of this result appeared in English [Car].
.IP (d)
All of the critical graphs for the numbers $R(k,^l)$ (graphs on
$R(k,^l)^-^1$ vertices without $K sub k$ and without $K sub l$ in
the complement) are known for
$k^=^3$ and $l^=^$3, 4, 5 [K\o'e\(aa'ry], 6 [Ka2], 7 [RK2, MZ],
8 [BrGS] and 9 [GoR1], and there are
1, 3, 1, 7, 191, 477142, and 1 of them, respectively.
All $(3,^k)$-graphs, for $k~<=~6$, were enumerated in [RK2], and
all (4,4)-graphs in [MR2]. There exists a unique
critical graph for $R(4,4)$ [Ka2]. There are 350904 known
critical graphs for $R(4,^5)$ [MR4], but there might be more
of them.
.IP (e)
In [MR5], strong evidence is given
for the conjecture that $R(5,^5)~=~43$ and that there exist
exactly 656 critical graphs on 42 vertices.
.IP (f)
The graphs constructed by Exoo in [Ex9, Ex12-Ex20], and some others,
are available electronically from
\s-2\fHhttp://ginger.indstate.edu/ge/RAMSEY\fP\s0.
Fujita [Fuj1] maintains a website with some lower bound constructions;
in particular, it presents the bound $R(4,8)~>=~58$ obtained independently
from Exoo.
.IP (g)
$Cyclic$ (or $circular$) graphs are often used for Ramsey
graph constructions. Several cyclic graphs establishing lower bounds
were given in the Ph.D. dissertation by J.G. Kalbfleisch in 1966, and
many others were published in the next few decades (see [RK1]).
Harborth and Krause [HaKr1] presented all best lower bounds
up to 102 from cyclic graphs avoiding complete graphs. In particular, no
lower bound in Table I can be improved with a cyclic graph on less than
102 vertices, except possibly for $R(3,^k)$ for $k~>=~13$.
See also item 2.3.k and section 5.16 [HaKr1]. Several best lower
bounds from \fIdistance colorings\fP, a slightly more general
concept than circular graphs, are presented in [HaKr2].
.IP (h)
The claim that $R(5,^5)~=~50$ posted
on the web [Stone] is in error, and despite being shown
to be incorrect more than once, this value is still
being cited by some authors.
The bound $R(3,^13)~>=~60$ [XieZ] cited in the 1995 version of this
survey was shown to be incorrect in [Piw1].
Another incorrect construction for $R(3,^10)~>=~41$ was
described in [DuHu].
.IP (i)
There are really only two general upper bound inequalities
useful for small parameters, namely 2.3.a and 2.3.b.
Stronger upper bounds for specific parameters were difficult to obtain,
and they often involved massive computations, like those for 
the cases of (3,8) [MZ], (3,10) [GoR1],
(4,5) [MR4], (4,6) and (5,5) [MR5].
The bound $R(6,^6)~<=~166$, only 1 more than the best known [Mac],
is an easy consequence of a theorem in [Walk] (2.3.b)
and $R(4,^6)~<=~41$.
.IP (j)
T. Spencer [Spe4], Mackey [Mac], and Huang and Zhang [HZ1],
using the bounds for minimum and maximum number of edges in (4,5) Ramsey
graphs listed in [MR3, MR5], were able to establish new upper bounds
for several higher Ramsey numbers, improving on all of the previous
longstanding best results by Giraud [Gi3, Gi5, Gi6].
.IP (k)
Only some of the higher bounds implied by 2.3.*
are shown, and more similar bounds could be derived.
In general, we show bounds beyond the contiguous
small values if they improve on results previously reported
in this survey or published elsewhere.
Some easy upper bounds implied by 2.3.a are marked as [Ea1].
.IP (l)
In 2009,
we have recomputed the upper bounds in Table I marked [HZ1]
using the method from the paper [HZ1], because the bounds
there relied on an overly optimistic personal communication
from T. Spencer. Further refinements of this method are studied
in [HZ2, ShZ1, Shi2]. The paper [Shi2] subsumes the main results
of the manuscripts [ShZ1, Shi2].
.IP (m)
In 2013, Boza [Boza5] using the method of [HWSYZH], which
is abbreviated as HW+ in Table I, computed the bounds marked
HW+ by starting from better upper bounds for smaller parameters.
Most of the currently shown bounds are thus better than those
originally listed in [HWSYZH, HZ2]. Five upper bounds
not shown in Table I can be obtained similarly
but they are larger than $10 sup 5$.

.sp .5
.NH 2
Bounds for $R(k,^l)$, higher parameters

.nr PS 10
.nr VS 12
.LP
.sp .5
.TS
box center tab(,);
cp8 cp8 || rp8 | rp8 | rp8 | rp8 | rp8 | rp8 | rp8 | rp8 | rp8 .
,$size 8 l$,$~ size 8 15$,16,17,18,19,20,21,22,23
\fIk\fP
=
3,,73,82,92,99,106,111,122,131,139
\^,,WW,Ex21,W1+,Ex16,W1+,Ex16,W1+,W2+,XWCS
\^,,87,98,109,121,132,145,158,171,185
\^,,GoR1,Back1,Back1,Les,Back2,Les,Les,Back2,Back2
_
4,,153,164,200,205,213,234,242,314
\^,,XXR,Gerb,Lia+,2.3.e,2.3.g,Ex16,SLZL,LSLW
_
5,,265,289,388,396,411,424,441,485,521
\^,,Ex16,2.3.h,XSR2,2.3.g,XSR2,XSR2,2.3.h,2.3.h,2.3.h
_
6,,401,434,548,614,710,878,,1070
\^,,2.3.h,SLLL,SLLL,SLLL,SLLL,SLLL,,SLLL
_
7,,,609,711,797,908,,1214
\^,,,2.3.h,2.3.g,2.3.h,SLLL,,SLLL
_
8,,861,,961,1045,1236,,1617
\^,,2.3.h,,XSR2,2.3.g,2.3.g,,2.3.h
.TE
.nr PS 12
.nr VS 15
.LP
.DS C
Table IIa. Known bounds for higher two-color Ramsey numbers $R(k,^l)$, with references.
Lower and upper bounds are given for $k^=^3$, only lower bounds for $k^>=^4$;
Lia+, W1+ and W2+ abbreviate LiaWXS, WWY1 and WSLX2, respectively.
.DE
.nr PS 10
.nr VS 12
.LP

.sp 3
.TS
box center tab(,);
cp8 cp8 || rp8 | rp8 | rp8 | rp8 | rp8 | rp8 | rp8 | rp8 .
,$size 8 l$,$~ size 8 24$,25,26,27,28,29,30,31
\fIk\fP
=
3,,143,154,159,167,173,184,190,199
\^,,W1+,W2+,W1+,W1+,W2+,W2+,W2+,W2+
.TE
.TS
box center tab(,);
cp8 cp8 || rp8 | rp8 | rp8 | rp8 | rp8 | rp8 | rp8 | rp8 | rp8 .
,$size 8 l$,$~ size 8 32$,33,34,35,36,37,38,$~^ size 8 39$,$~^ size 8 40$
\fIk\fP
=
.sp .2
3,,214,218,226,231,239,244,256
\^,,W2+,Ch+,Ch+,Ch+,Ch+,Ch+,Ch+
.TE
.nr PS 12
.nr VS 15
.LP
.DS C
Table IIb. Known lower bounds for higher Ramsey numbers $R(3,^l)~$ for $l~>=~24$;
W1+, W2+ and Ch+ abbreviate WSLX1, WSLX2 and ChWXSL, respectively.
.DE

.nr PS 10
.nr VS 12
.LP
.TS
box center tab(,);
rp8 || rp8 | rp8 | rp8 | rp8 | rp8 | rp8 | rp8 .
$size 8 k$,$~ size 8 11$,12,13,14,15,16,17
lower bound,1597,1639,2557,2989,5485,5605,8917
reference,2.2.c,XSR2,2.2.c,2.2.c,2.2.c,2.2.c,LSL
.sp .1
_
$size 8 k$,$~ size 8 18$,19,20,21,22,23,24
lower bound,11005,17885,19069,27077,29941
reference,LSL,LSL,Lia+,Lia+,Lia+
.TE
.nr PS 12
.nr VS 15
.LP
.DS C
Table IIc. Known lower bounds for diagonal Ramsey numbers $R(k,^k)~$ for $k~>=~11$;
Lia+ abreviates LiaWXCS, see also 2.2.c below.
.DE

.sp .5
.IP (a)
The upper bounds in Tables I and IIa marked [GoR1, Les, Back1]
were obtained mainly by deriving lower bounds for several cases
of $e(3,^k,^n)$, which denotes the minimum number of edges in
$n$-vertex triangle-free graphs with independence number less
than $k$. The study of $e(3,^k,^n)$ was also the main tool
for the results obtained in [GrY, GR, RK2, RK3, GoR2].
.IP (b)
\fIRamsey Calculus\fP [Back1], is an extensive manuscript
by Backelin, which, among other goals, addresses
the derivation of $e(3,^k,^n)$ and the corresponding
realisers while avoiding reliance on
computer assisted results as far as possible.
It achieves the derivation of several lower bounds for
$e(3,^k+^1,^n)$ better than those in [GoR1, RK3, RK4]
for $n$ close to and above $13k/4$.
.IP (c)
The construction by Mathon [Mat] and Shearer [She2]
(see also items 2.3.i, 6.2.k and 6.2.l),
using the data obtained by Shearer [She4] for primes up to 7000, 
implies the lower bounds in Table IIc marked 2.2.c.
The first two bounds credited in Table IIc to [LSL]
also follow similarly from the data in [She4].
The same approach does not improve on the bound
$R(12,12)~>=~1639$ [XSR2]. The bounds in [Lia+] were
obtained by extending data for Payley graphs beyond [Sha4].
.IP (d)
The lower bounds marked [XXR], [XXER], [XSR2], 2.3.e and 2.3.h need
not be cyclic. Several of the Cayley colorings from [Ex16] are
also non-cyclic. All other lower bounds listed in Table IIab were
obtained by construction of cyclic graphs.
.IP (e)
The graphs establishing lower bounds marked 2.3.g can be constructed
by using appropriately chosen graphs $G$ and $H$ with a common $m$-vertex
induced subgraph, similarly as it was done in several cases in [XXR].
.IP (f)
Yu [Yu2] constructed a special class of triangle-free cyclic
graphs establishing several lower bounds for $R(3,^k)$, for $k^>=^61$.
All of these bounds can be improved by the inequalities
in 2.3.c and data from Tables I and II.
.IP (g)
Unpublished bound $R(4,^22)~>=~314$ [LSLW] improves over 282
given in [SL]. [LSLW] includes also $R(4,^25)~>=~458$.
Not yet published bounds $R(3,^23)~>=~139$ [XWCS]
and $R(4,^17)~>=~200$ [LiaWXS] improve over 137 and 182 obtained
in [WSLX2] and [LSS1], respectively.
.IP (h)
Two special cases
which improve on bounds listed in earlier revisions:
$R(9,^17)~>=~1411$ is given in [XXR] and
$R(10,^15)~>=~1265$ can be obtained using 2.3.h.
.IP (i)
One can expect that
the lower bounds in Table II are weaker than those in Table I,
especially smaller ones, in the sense that some of them should
not be that hard to improve, in contrast to the bounds
in Table I.
.sp
.NH 2
General results on $R(k,^l)$
.sp
.IP (a)
$R(k,^l)~<=~R(k-1,^l)^+^R(k,^l-1)$,
with strict inequality when both terms on the right hand side are even [GG].
There are obvious generalizations of this inequality for avoiding graphs other
than complete.
.IP (b)
$R(k ,^k )~<=~4R(k ,^k^-^2 )^+^2$ [Walk].
.IP (c)
Explicit construction for
$R(3,^3k^+^1)~>=~4R(3,^k^+^1)^-^3$, for all $k^>=^2^$ [CleDa],
.br
explicit construction for
$R(3,^4k^+^1)~>=~6R(3,^k^+^1)^-^5$, for all $k^>=^1^$ [ChCD].
.IP (d)
Explicit triangle-free graphs with independence $k$
on $~OMEGA (k sup {down 20 {3/^2}} ^)$ vertices [Alon2, CPR].
For other constructive results in relation to $R(3,^k)^$ see
[BBH1, BBH2, Fra1, Fra2, FrLo, GoR1, Gri, KlaM1, Loc, RK2, RK3,
RK4, Stat, Yu1]. See also 2.3.(3) and 2.3.(4) below.
.IP (e)
The study of bounds for the difference between consecutive
Ramsey numbers was initiated in [BEFS], where the bound
$R(k,^l)~>=~R(k,^l^-^1)~+~2k^-^3~$, for $k,^l~>=~3$,
was established by a construction.
In 1980, Erd\o'o\(hu's and S\o'o\(aa's (cf. [Erd2,ChGra2])
asked: If we set $DELTA sub {^k,^l} ~=~ R(k,^l)~-~R(k,^l^-^1)$,
then is it true that $DELTA sub {^k,^k^+^1}^/^k^ -> ~inf^$
as $k^ -> ~inf^$? Only easy
bounds on $DELTA sub {^k,^l}$ are known, in particular
$3~<=~ DELTA sub {^3,^l}~<=~l~$ for $k~=~3$.
For some discussion of the latter see [XSR2, GoR2].
.sp .2
.IP (f)
By taking a disjoint union of two critical graphs one can easily see
that $R(k,^p)^>=^s$ and $R(k,^q)^>=^t$ imply $R(k,^p+^q-1)~>=~s+^t-1$.
Xu and Xie [XX1] improved this construction to yield better general lower
bounds, in particular $R(k,^p+^q-1)~>=~s+^t^+^k^-^3$.
.IP (g)
For $2^<=^p^<=^q$ and $3^<=^k$,
if $(k,^p)$-graph $G$ and $(k,^q)$-graph $H$ have a common
induced subgraph on $m$ vertices without $K sub up 20 {k-1}$,
then $R(k,^p+^q^-^1)^>$ $n(G)^+$ $n(H)^+^m$. In particular,
this implies the bounds
$R(k,^p+^q^-^1)~>=~R(k,^p)~+~R(k,^q)^+^k^-^3$ and
$R(k,^p+^q^-^1)~>=$ $R(k,^p)~+~R(k,^q)^+^p^-^2$ [XX1, XXR],
with further small improvements in some cases,
such as using the term $k^-~2$ instead of $k^-^3$ in the previous
bound [XSR2].
.IP (h)
$R(2k^-^1,^l)~>=~4R(k,^l^-^1)~-~3~$ for $l~>=~5$ and $k~>=~2$,
and in particular for $k^=^3$ we have
$R(5,^l)~>=~4R(3,^l^-^1)~-~3~$ [XXER].
.IP (i)
If the quadratic residues Paley graph $Q sub up 20 p$ of prime
order $p^=~4t^+^1$ contains no $K sub k$, then
$R(k,^k) ~>=~p^+^1$ and $R(k^+^1,^k^+^1) ~>=~2p^+^3$ [She2, Mat].
Data for larger $p$ was obtained in [LSL]. See also 3.1.c,
and items 6.2.k and 6.2.l for similar multicolor results.
.IP (j)
Study of Ramsey numbers for large disjoint unions of graphs [Bu1, Bu9],
in particular
.br
$R(nK sub k ,^nK sub l )~=~n(k^+^l^-^1)~+~R(K sub k-1 ,^K sub l-1 )~-~2$,
for $n$ large enough [Bu8].
.IP (k)
$R(k,^l)~>=~L(k,^l)~+~1$, where $L(k,^l)$ is the maximal order of
any cyclic $(k,^l)^-$graph.
.br
A compilation of many best cyclic bounds was presented in [HaKr1].
.IP (l)
The graphs critical for $R(k,^l)$ are $(k^-^1)^-$vertex
connected and $(2k^-^4)^-$edge connected, for $k,^l~>=~3$ [BePi].
This was improved to vertex connectivity $k$
for $k~>=~5$ and $l~>=~3$ in [XSR2].
.IP (m)
All Ramsey-critical $(k,^l)^-$graphs are Hamiltonian for
$k~>=~l^-^1~>=~1$ and $k~>=~3$,
except when $(k,^l)~=~(3,^2)~$ [XSR2].
.IP (n)
Two-color lower bounds can be obtained by using items 6.2.m,
6.2.n and 6.2.o with $r~=~2$. Some generalizations of these were
obtained in [ZLLS].

.sp
.PP
In the last seven items (1)-(7) of this section
we only briefly mention some pointers
to the literature dealing with asymptotics of Ramsey numbers. This survey
was designed mostly for small, finite, and combinatorial results,
but still we wish to give the reader some useful and representative
references to more traditional papers studying the infinite.
.sp
.IP (1)
In 1947, Erd\o'o\(hu's gave a simple probabilistic
proof that $R(k,^k)~>=~ck2 sup {down 20 {^k/^2}}$ [Erd1].
Spencer [Spe1] improved the constant $c$ to $down 5 sqrt up 5 {^2^}/e$.
More probabilistic asymptotic lower bounds for other
Ramsey numbers were obtained in [Spe1, Spe2, AlPu].
.IP (2)
The limit of $R(k,^k) sup {^1^/^k}$, if it exists,
is between $down 5 sqrt up 5 {^2^}$ and $4~$ [GRS, GrR\o'o\(:a', ChGra2].
.IP (3)
In 1995, Kim obtained a breakthrough result by proving that
$R(3,^k)~=~THETA (k sup {down 20 2} /^ log^k)$ [Kim]. The best known
lower and upper bounds constants are 1/4 [BohK2] and 1 (implicit
in [She1]), respectively. An independent proof of the lower bound
constant 1/4 and a conjecture that it is the best possible are
presented in [FizGM].
.IP (4)
Other asymptotic and general results on triangle-free graphs in relation
to $R(3,^k)$ can be found in
[Boh, AlBK, AjKS, Alon2, CleDa, ChCD, CPR, Gri, FrLo, Loc, She1, She3].
.IP (5)
Explicit constructions yielded the lower bounds
$R(4,^k)~>=~OMEGA (k sup {down 20 {8/^5}} )$,
$R(5,^k)~>=~OMEGA (k sup {down 20 {5/^3}} )$ and
$R(6,^k)~>=~OMEGA (k sup {down 20 {2}} )~$
[KosPR]. For the same cases of $k$ classical probabilistic
arguments give
$OMEGA ((k/^roman log ^k) sup {down 20 {5/^2}} )$,
$OMEGA ((k/^roman log ^k) sup {down 20 3} )$ and
$OMEGA ((k/^roman log ^k) sup {down 20 {7/^2}} )$,
respectively [Spe2]. These were improved to
$OMEGA (k sup {down 20 {5/^2}} /^( roman log ^k) sup {down 20 2} )$,
$OMEGA (k sup {down 20 3} /^( roman log ^k) sup {down 20 {8/^3}} )$ and
$OMEGA (k sup {down 20 {7/^2}} /^( roman log ^k) sup {down 20 {13/^4}} )$,
respectively, in [Boh, BohK1], and in general to
$R(s,^t)~=~OMEGA (t sup { down 20 {(s+1)/^2}}^/^
( roman log ^t) sup {down 20 {(s sup 2 -^s-^4)/(2s-^4)}})$,
for fixed $s$ and large $t~$ [BohK1].
.IP (6)
Explicit construction of a graph with clique and independence $k$
on $2 sup down 10 { ^c log sup {down 20 2} ^k^/ ^log^log^k}^$
vertices was presented by Frankl and Wilson [FraWi], and
further constructions by Chung [Chu3] and Grolmusz [Grol1, Grol2].
In 2012, the best explicit construction for large $k$ by Barak
et al. [BarRSW] improved over [FraWi] by giving such a graph on
$2 sup down 7 {2 sup down 7 {(^log^log^k) sup c}}^$
vertices for some $c^>^1$, or equivalently, on
$n$ vertices, where $log^log^n~=~(^log^log^k) sup c$.
Explicit constructions such as these are usually weaker
than known probabilistic results.
.sp .1
.IP (7)
In 2010, Conlon [Con1] obtained the best until now upper bound
for the diagonal case:

.EQ
R(k^+^1,^k^+^1)~<=~
down 30
left (
cpile { 2k above k}
right )
k sup down 20 { ^-^c log ^k^/ ^log^log^k}
.EN

Other asymptotic bounds can be found, for example, in
[Chu3, McS, Boh, BohK1] (lower bound) and [Tho] (upper bound),
and for many other bounds in the general case of
$R(k,^l)$ consult [Spe2, GRS, GrR\o'o\(:a', Chu4, ChGra2, LiRZ1, AlPu, Kriv].

.bp
.NH
Two Colors: $K sub n ^-^e$, $K sub 3$, $K sub {m,^n}$
.sp .4
.NH 2
Dropping one edge from complete graph
.sp .4
.LP
This section contains known values and nontrivial bounds for the two
color case when the avoided graphs are complete or have the
form $K sub k -^e$, but not both are complete.
.sp
.nr PS 10
.nr VS 11
.EQ
gsize 8
.EN
.LP
.TS
box center tab(,);
cp8 cp8 || rp8 | rp8 | rp8 | rp8 | rp8 | rp8 | rp8 | rp8 | rp8 .
,$H$,$K sub 3 ^-^e$,$K sub 4 ^-^e$,$K sub 5 ^-^e$,$K sub 6 ^-^e$,$K sub 7 ^-^e$,$K sub 8 ^-^e$,$K sub 9 ^-^e$,$K sub 10 ^-^e$,$K sub 11 ^-^e$
$G$,,,,,,,,,,
=
$K sub 3 ^-^e$,,3,5,7,9,11,13,15,17,19
\^,,\^,\^,\^,\^,\^,\^,\^,\^,\^
_
.sp .1
$K sub 3$,,5,7,11,17,21,25,31,37,42
\^,,\^,\^,\^,\^,\^,\^,\^,\^,45
_
$K sub 4 ^-^e$,,5,10,13,17,28,29,34,41
\^,,\^,\^,\^,\^,\^,38
_
$K sub 4$,,7,11,19,30,37
\^,,\^,\^,\^,33,52,75,105,139,184
_
$K sub 5 ^-^e$,,7,13,22,31,40
\^,,\^,\^,\^,39,66
_
$K sub 5$,,9,16,30,43
\^,,\^,\^,34,67,112,183,277,409,581
_
$K sub 6 ^-^e$,,9,17,31,45,59
\^,,\^,\^,39,70,135
_
$K sub 6$,,11,21,37
\^,,\^,\^,53,110,205,373,621,1007,1544
_
.sp .1
$K sub 7 ^-^e$,,11,28,40,59
\^,,\^,\^,66,135,251
_
$K sub 7$,,13,28,51
\^,,\^,30,83,193,392,753,1336,2303,3751
_
$K sub 8$,,15
\^,,\^,42,123,300,657,1349,2558,4722,8200
.TE
.nr PS 12
.nr VS 15
.EQ
gsize 12
.EN
.LP
.DS C
Table IIIa. Two types of Ramsey numbers $R(G,^H)$,
includes all known nontrivial values.
.DE
.sp
.IP (a) 0.35i
The exact values in Table IIIa involving $K sub 3 ^-^e$ are obvious,
since one can easily see that
$R(K sub 3 ^-^e,^K sub k ^)~=~R(K sub 3 ^-^e,^K sub k+1 ^-^e )~=~2k^-^1~$
for all $k^>=^2$.
.IP (b)
More bounds (beyond those shown in Tables IIIa/b)
can be easily obtained using Table I,
an obvious generalization of the inequality
$R(k,^l)~<=~R(k-1,^l)~+~R(k,^l-1)$, and by monotonicity of
Ramsey numbers, in this case
$R(K sub k-1 ,^G)~<=~R(K sub k ^-^e,^G)~<=~R(K sub k ,^G)$.
.IP (c)
If the quadratic residues Paley graph $Q sub up 20 p$ of prime
order $p^=~4t^+^1$ contains no $K sub k ^-^e$, then
$R(K sub k+1 ^-^e,^K sub k+1 ^-^e) ~>=~2p^+^1$.
In particular, $R(K sub 14 ^-^e,^K sub 14 ^-^e)~>=~2987$
[LiShen]. This was generalized to $K sub k ^-^F$ for some
small graphs $F$ instead of an edge $e^(=^K sub 2 )^$ [WaLi].
See also item 2.3.i.

.nr PS 10
.nr VS 11
.EQ
gsize 8
.EN
.LP
.TS
box center tab(,);
cp8 cp8 || cp8 | cp8 | cp8 | cp8 | cp8 | cp8 | cp8 | cp8 .
.sp .5
,$H$,$K sub 4 ^-^e$,$K sub 5 ^-^e$,$K sub 6 ^-^e$,$K sub 7 ^-^e$,$K sub 8 ^-^e$,$K sub 9 ^-^e$,$K sub 10 ^-^e$,$K sub 11 ^-^e$
$G$,,,,,,,,,
=
.sp .2
$K sub 3$,,CH2,Clan,FRS1,GH,Ra1,Ra1,MPR,WWY2
\^,,\^,\^,\^,\^,\^,\^,GoR2,GoR2
_
.sp .1
$K sub 4 ^-^e$,,CH1,FRS2,McR,McR,Ea1,Ex14,Ex14
\^,,\^,\^,\^,\^,HZ2
_
$K sub 4$,,CH2,EHM1,Boza6,Ex14
\^,,\^,\^,Boza5,HZ2,BZ2,BZ2,BZ2,Ea1
_
$K sub 5 ^-^e$,,FRS2,CE+,Ex14,Ex14
\^,,\^,\^,Ea1,HZ2
_
$K sub 5$,,BoH,Ex6,Ea1
\^,,\^,Ex8,HZ2,HZ2,BZ2,BZ2,BZ2,BZ2
_
$K sub 6 ^-^e$,,McR,Ex14,Ex14,Ex14
\^,,\^,Ea1,HZ2,HZ2
_
$K sub 6$,,McN/,Ex14
\^,,ShWR,BZ1,BZ2,ShZ2,BZ2,BZ2,BZ2,BZ2
_
$K sub 7 ^-^e$,,McR,Ex14,Ex14
\^,,\^,HZ2,HZ2,ShZ1
_
$K sub 7$,,Ea1,Ex14
\^,,BoPo,Ea1,Ea1,BZ2,BZ2,BZ2,BZ2,BZ2
_
$K sub 8$,
\^,,BZ1,BZ1,BZ2,BZ2,BZ2,BZ2,BZ2,BZ2
.TE
.nr PS 12
.nr VS 15
.EQ
gsize 12
.EN
.LP
.DS C
References for Table IIIa;
CE+ abbreviates CEHMS, for some details on BZ1 and BZ2 see item 3.1.d below.
.DE
.nr PS 10
.nr VS 12
.LP
.sp
.TS
box center tab(,);
cp8 || rp8 | rp8 | rp8 | rp8 | rp8 | rp8 .
$size 8 k$,$~ size 8 11$,12,13,14,15,16
.sp 0.2
=
.sp 0.1
lower,42,47,55,59,69,73
bound,WWY2,Ea1,GoR2,Ea1,WWY2,Ea1
_
upper,45,53,62,71,80,91
bound,GoR2,GoR2,GoR2,GoR2,GoR2,GoR2
_
.TE
.nr PS 12
.nr VS 15
.LP
.DS C
Table IIIb. Lower and upper bounds for $R(K sub 3 ,^K sub k ^-^e )~$ for $11~<=~k~<=~16$;
lower bounds for $k~=~12,^14,^16$ are the same as for $R(K sub 3 ,^K sub k-1 )$.
.DE
.sp 1.5
.IP (d)
This item follows personal communication from Boza [Boza5].
The upper bounds marked [BZ1] were obtained until 2012, while ones
marked [BZ2] are from 2013. They are implied by [Boza6],
the previous work [Boza1, Boza3, BoPo], the method of [HZ2],
and the bounds given in [GoR2]. The enumeration of all
$(K sub 6 ,^K sub 4 ^-^e)$-graphs [ShWR] is used in [BoPo].
.IP (e)
All $(K sub 3 ,^K sub k ^-^e)$-graphs
were enumerated for $k~<=~6$ [Ra1] and $k~=~7$ [Fid2, GoR2].
Full sets of $(K sub l ,^K sub k ^-^e)$-graphs were
posted for the parameters
$(K sub 3 ,^K sub k ^-^e)^$ for $k~<=~7$,
$(K sub 4 ,^K sub k ^-^e)^$ for $k~<=~5$, and
$(K sub 5 ,^K sub k ^-^e)^$ for $k~<=~4~$ at [Fid2],
and other full and restricted families at [BrCGM, Fuj1].
.IP (f)
The number of $(K sub 3 ,^K sub l ^-^e)$-critical graphs
for $l^=~4,^5$ and 8 is 4, 2 and 9, respectively [MPR].
There are 7 critical graphs for
$R(K sub 3 ,^K sub 9 ^-^e)$, and at least 40 such graphs
for $R(K sub 3 ,^K sub 10 ^-^e)~$ [GoR2].
.IP (g)
The critical graphs are unique for:
$R(K sub 3 ,^K sub l ^-^e)$ for $l^=^$3 [Tr], 6 and 7 [Ra1],
$R(K sub 4 ^-^e ,^K sub 4 ^-^e )~$ [FRS2],
$R(K sub 5 ^-^e ,^K sub 5 ^-^e )~$ [Ra3] and
$R(K sub 4 ^-^e ,^K sub 7 ^-^e )~$ [McR].
.IP (h)
All of the critical graphs for the cases
$R(K sub 4 ^-^e ,^K sub 4 ^)$ [EHM1],
$R(K sub 4 ^-^e ,^K sub 5 ^)$ and
$R(K sub 5 ^-^e ,^K sub 4 ^)$ [DzFi1]
are known, and there are
5, 13 and 6 of them, respectively.
The unpublished value of $R(K sub 4 ^-^e ,^K sub 6 ^)$ [McN]
was confirmed in [ShWR], where in addition all 24976 critical
graphs were found.
.IP (i)
It is known that $R(K sub 4 ,^K sub 12 ^-^e) ~>=~128$ [Shao]
by using one color of the $(4,4,4;127)$- coloring defined in [HiIr].
.IP (j)
$R(K sub k ^-^e,^K sub k ^-^e) ~<=~ 4R(K sub k-2 ,^K sub k ^-^e)~-~2$ [LiShen].
.br
For a similar inequality for complete graphs see 2.3.b.
.IP (k)
Study of the cases $R(K sub m ,^K sub n ^-^K sub 1,s )$
and $R(K sub m ^-^e ,^K sub n ^-^K sub 1,s )$, with several
exact values for special parameters [ChaMR].
.IP (l)
The upper bounds from [ShZ1, ShZ2] are subsumed
by a later article [Shi2].
.IP (m)
The upper bounds in [HZ2] were obtained by a reasoning
generalizing the bounds for classical numbers in [HZ1].
Several other results from section 2.3 apply, though
checking in which situation they do
may require looking inside the proofs whether they still hold
for $K sub n ^-^e$.
.sp
.NH 2
Triangle versus other graphs
.sp
.IP (a)
$R(3,^k)~=~THETA (k sup {down 20 2} /^ log^k)$ [Kim].
.br
For more comments on asymptotics see section 2.3
and the item 3.2.o/p below.
.IP (b)
Explicit construction for
$R(3,^3k^+^1)~>=~4R(3,^k^+^1)^-~3$, for all $k^>=^2^$ [CleDa],
.br
explicit construction for
$R(3,^4k^+^1)~>=~6R(3,^k^+^1)^-~5$, for all $k^>=^1^$ [ChCD].
.IP (c)
Explicit triangle-free graphs with independence $k$
on $OMEGA (k sup {down 20 3/2} ^)$ vertices [Alon2, CPR].
.IP (d)
$R(K sub 3 ,^K sub 7 ^-^2P sub 2 ^)~=~R(K sub 3 ,^K sub 7 ^-^3P sub 2 ^)~=~18$ [SchSch2].
.IP (e)
$R(K sub 3 ,^K sub 3 ^+~ K bar sub m ) ~=~
 R(K sub 3 ,^K sub 3 ^+~ C sub m ) ~=~2m^+^5$
for $m^>=~212^$ [Zhou1].
.IP (f)
$R(K sub 3 ,^K sub 2 ^+~ T sub n ) ~=~2n^+^3~$ for $n$-vertex trees $T sub n$,
for $n^>=~4^$ [SonGQ].
.sp .2
.IP (g)
$R(K sub 3 ,^G)~=~2n(G)^-^1$ for any connected $G$ on at least 4 vertices
and with at most $(17n(G)^+^1)/15$ edges, in particular
for $G^=~P sub i$ and $G^=~C sub i$, for all $i^>=~4^$ [BEFRS1].
.sp .2
.IP (h)
$R(K sub 3 ,^Q sub n )~=~2 sup n+1 ^-^1^$ for large $n^$
[FizGMSS], where $Q sub n$ is the $n$-dimensional hypercube.
For the general case of $R(K sub m ,^Q sub n )$ see item 5.15.n.
.sp .2
.IP (i)
Relations between $R(3,^k)$ and graphs with large $chi (G)^$ [F\o'u\(:a'r],
.br
further detailed study of the relation between $R(3,^k)$
and the chromatic gap [GySeT].
.sp .2
.IP (j)
$R(K sub 3 ,^G)~<=~2e(G)^+^1$ for any graph $G$ without
isolated vertices [Sid3, GoK].
.IP (k)
$R(K sub 3 ,^G)^<=^n(G)^+^e(G)$ for all $G$, a conjecture [Sid2].
.IP (l)
$R(K sub 3 ,^G)$ for all connected $G$ up to 9 vertices [BBH1, BBH2].
.IP (m)
$R(K sub 3 ,^G)$ for all graphs $G$ on 10 vertices [BrGS],
except 10 cases (three of which, including $G^=^K sub 10 ^-^e$,
were solved [GoR2]). See also section 8.1.
.IP (n)
Formulas for $R(nK sub 3 ,^mG)$ for all $G$ of order 4
without isolates [Zeng].
.IP (o)
For every positive constant $c,$ $DELTA$, and $n$ large enough,
there exists graph $G$ with $DELTA (G)~<=~DELTA~$ for which
$R(K sub 3 ,^G)~>~cn~$ [Bra3].
.IP (p)
$R(K sub 3 ,^K sub k,k )~=~THETA (k sup {down 20 2} /^ log^k)^$ [LinLi2].
.IP (q)
For $R(K sub 3 ,^K sub n )$ see section 2, and for
$R(K sub 3 ,^K sub n ^-^e)$ see section 3.1.
.IP (r)
Since $B sub 1 ~=~F sub 1 ~=~C sub 3 ~=~W sub 3 ~=~K sub 3$, other sections apply.
See also [Boh, AjKS, BBH1, BBH2, FrLo, Fra1, Fra2, F\o'u\(:a'r, Gri,
GySeT, Loc, KlaM1, LiZa1, RK2, RK3, RK4, She1, She3, Spe2, Stat, Yu1].
.EQ
delim $$
gsize 12
.EN
.nr LL 6.5i
.nr LT 6.5i
.nr PS 12
.nr VS 15
.sp
.LP
.NH 2
Complete bipartite graphs
.sp .5
.LP
Note: This subsection gathers information on Ramsey numbers where
specific bipartite graphs are avoided in edge colorings of $K sub n$
(as everywhere in this survey), in contrast to the often studied
bipartite Ramsey numbers, which are not covered in this survey,
where the edges of complete bipartite graphs $K sub {n,^m}$ are colored.
.sp
.NH 3
Numbers
.sp .2
.LP
The following Tables IVa and IVb gather information mostly
from the surveys by Lortz and Mengersen [LoM3, LoM4]. All cases involving
$K sub 1,2 ~=~ P sub 3$ are solved by a formula for $R(P sub 3 ,^G)$,
which holds for all isolate-free graphs $G$, derived in [CH2].
All star versus star numbers are given below in the item
3.3.2.a and in section 5.5.
.sp .8
.nr PS 10
.nr VS 12
$gsize 8$
.LP
.TS
box center tab(-);
cp8 cp8 || rp8 | rp8 | rp8 | rp8 | rp8 || rp8 | rp8 | rp8 | rp8 || rp8 | rp8 .
-$p,^q$-$~~~1,^2$-1, 3-1, 4-1, 5-1, 6-2, 2-2, 3-2, 4-2, 5-3, 3-3, 4
$m,^n$-
.sp .2
=
.sp .2
2, 2--4-6-7-8-9-6
\^--CH2-CH2-Par3-Par3-FRS4-CH1
_
2, 3--5-7-9-10-11-8-10
\^--CH2-FRS4-Stev-FRS4-FRS4-HaMe4-Bu4
_
2, 4--6-8-9-11-13-9-12-14
\^--CH2-HaMe3-Stev-HaMe4-LoM4-HaMe4-ExRe-EHM2
_
2, 5--7-9-11-13-14-11-13-16-18
\^--CH2-HaMe3-Stev-Stev-LoM4-HaMe4-LoM3-LoM1-EHM2
_
2, 6--8-10-11-14-$15 sup down 20 *$-12-14-17-20
\^--CH2-HaMe3-Stev-Stev-Shao-HaMe4-LoM3-LoM3-LoM1
.sp .2
=
.sp .2
3, 3--7-8-11-12-13-11-13-16-18-18
\^--CH2-HaMe3-LoM4-LoM4-LoM4-Lortz-HaMe3-LoM4-LoM4-HaMe3
_
3, 4--7-9-11-13-14-11-14-17-$<=^21$-$<=^25$-$<=^30$
\^--CH2-HaMe3-LoM4-LoM4-LoM4-Lortz-LoM4-Sh1+-LoM4-LoM2-LoM2
_
3, 5--9-10-13-15--14-$17 sup down 20 *$--$>= 21$-$<=^28$-$<=^33$
\^--CH2-HaMe3-Sh1+-Sh1+--HaMe4-Shao--Sh2+-LoM2-LoM2
.sp .2
.TE
.nr PS 12
.nr VS 15
$gsize 12$
.DS C
Table IVa. Ramsey numbers $R(K sub {m,^n} ,^K sub {p,^q} ^)$;
unpublished results are marked with a *, and Sh1+, Sh2+ abbreviate ShaXBP, ShaoWX.
.DE
.sp
.nr PS 10
.nr VS 12
$gsize 8$
.LP
.sp
.TS
box center tab(,);
cp8 cp8 || rp8 | rp8 | rp8 | rp8 | rp8 | rp8 | rp8 | rp8 | rp8 | rp8 .
,$m$,2,3,4,5,6,7,8,9,10,11
$n$,
.sp .2
=
.sp .2
6,,12,14,17,20,21
\^,,HaMe4,LoM3,LoM3,LoM1,EHM2
_
7,,14,17,19,21,24,26
\^,,HaMe4,LoM3,LoM3,LoM3,LoM1,EMH2
_
8,,15,18,20,$22 sup down 20 *$-23,24-25,28,30
\^,,HaMe4,LoM3,LoM3,LoM3,LoM3,LoM1,EMH2
_
9,,16,19,22,$25 sup down 20 *$,$27 sup down 20 *$,$29 sup down 20 *$,32,33
\^,,HaMe4,LoM3,LoM3,Shao,Shao,Shao,LoM1,EHM2
_
10,,17,21,24,27,27-29,28-31,32-33,36,38
\^,,HaMe4,LoM3,LoM3,LoM3,LoM3,LoM3,LoM3,LoM1,EHM2
_
11,,18,,,,,,$<=^35$,36-37,40,42
\^,,HaMe4,,,,,,LoM3,LoM3,LoM1,EHM2
.sp .2
.TE
.nr PS 12
.nr VS 15
$gsize 12$
.DS C
Table IVb. Known Ramsey numbers $R(K sub {2,^n} ,^K sub {2,^m} ^)~$ for $6~<=~n~<=~11,~~2~<=~m~<=~11$;
unpublished results improving over [LoM3] are marked with a *.
.DE
.sp 2
.IP (a)
The next few easily computed values of $R(K sub 1,n ,^K sub 2,2 ^)$,
extending data in the first row of Table IVa, are
13, 14, 21 and 22 for $n$ equal to 9, 10, 16 and 17, respectively. 
See function $f(n)$ in 3.3.2.c of the next subsection below.
.IP (b)
Formula for $R(K sub {1,^n} ,^K sub {k sub 1 ,^k sub 2 ,^... ,^k sub t ,^m}^)$
for $m$ large enough, in particular for $t^=^1,^k sub 1 ^=^2$ with
$n^<=^5,^m^>=^3$ and $n^=^6,^m^>=^11$, for example
$R(K sub 1,5 ,^K sub 2,7 ^)~=~15~$ [Stev].
.IP (c)
The values and bounds for higher cases of $R(K sub 2,2 ,^K sub 2,n ^)$
are 20, 22, 22, 24, 25, 26, 27/28, 28/29, 30 and 32 for
$12~<=~n~<=~21^$, respectively. All of them were given in [HaMe4],
except those for $n~=~14$, 15 and 18, which were obtained in [Dyb].
More exact values for prime powers
${down 3 \(lc} down 20 sqrt up 20 {^n} {down 3 \(rc}$ and
${down 3 \(lc} down 20 sqrt up 20 {^n} {down 3 \(rc}^+^1~$
can be found in [HaMe4].
.IP (d)
The known values of $R(K sub 2,2 ,^K sub 3,n ^)$
are 15, 16, 17, 20 and 22 for $6~<=~n~<=~10^$ [Lortz],
and $R(K sub 2,2 ,^K sub 3,12 ^)~=~24$ [Shao].
See Tables IVa and IVb for the smaller cases, and [HaMe4]
for upper bounds and values for some prime powers
${down 3 \(lc} down 20 sqrt up 20 {^n} {down 3 \(rc}$.
.IP (e)
$R(K sub 2,n ,^K sub 2,n )$ is equal to 46, 50, 54, 57 and 62
for $12~<=~n~<=~16$, respectively.
.br
The first open diagonal case is
$65~<=~R(K sub 2,17 ,^K sub 2,17 ^)~<=~66~$ [EHM2].
.br
The status of all higher cases for $n^<~30$ is listed in  [LoM1].
.IP (f)
$R(K sub 1,4 ,^K sub 4,4 ^)~=~R(K sub 1,5 ,^K sub 4,4 ^)~=~13~~$ [ShaXPB]
.br
$R(K sub 1,4 ,^K sub 1,2,3 ^)~=~R(K sub 1,4 ,^K sub 2,2,2 ^)~=~11~$ [GuSL]
.br
$R(K sub 1,7 ,^K sub 2,3 ^)~=~13~~$ [Par4, Par6]
.br
$R(K sub 1,15 ,^K sub 2,2 ^)~=~20~$ [La2]
.br
$R(K sub 2,2 ,^K sub 4,4 ^)~=~14~~$ [HaMe4]
.br
$R(K sub 2,2 ,^K sub 4,5 ^)~=~15~~$ [Shao]
.br
$R(K sub 2,2 ,^K sub 4,6 ^)~=~16~~$ [Shao]
.br
$R(K sub 2,2 ,^K sub 5,5 ^)~=~R(K sub 2,3 ,^K sub 3,5 ^)~=~17~~$ [Shao]
.IP (g)
A number of general upper and lower bounds for $R(K sub s,t ,^K sub s,t )$,
in particular for small fixed $s,$ and for some slightly off-diagonal cases
were obtained in [LoM2].
They can be used to derive the upper bounds
for the cases listed in (h) and (i) below.
.IP (h)
Several lower bounds of the form $R(K sub s,t ,^K sub s,t )~>=~m$
from distance colorings, a slightly more general concept than circular
graphs, were presented in [HaKr2] for the following triples
$(s,^t,^m)$: (3,6,38), (3,7,42), (3,8,43), (3,9,54), (4,5,42),
(4,6,43), (4,7,54), (5,5,54).
.IP (i)
$30~<=~R(K sub 3,5 ,^K sub 3,5 ^)~<=~38~~$ [HaKr2][LoM2]
.br
$30~<=~R(K sub 4,4 ,^K sub 4,4 ^)~<=~62~~$ [HaKr2][LoM2]
.sp
.NH 3
General results
.sp .5
.IP (a)
$R(K sub 1,n ,^K sub 1,m )~=~ n^+^m^-^epsilon$, where $epsilon ^=^1$
if both $n$ and $m$ are even and $epsilon ^=^0$ otherwise [Har1].
It is also a special case of multicolor numbers for stars obtained in [BuRo1].
.IP (b)
$R(K sub 1,3 ,^K sub {m,^n} ^)~=~m^+^n^+^2~$ for $~m,^n~>=~1~$ [HaMe3].
.IP (c)
$R(K sub 1,n ,^K sub 2,2 ^)~=~f(n)~<=~n^+^ down 10 sqrt up 10 {^n} ~+^1$,
with $f(q sup down 30 2 ^)~=~q sup down 30 2 ^+^q^+^1$
and $f(q sup down 30 2 ^+^1^)~=~q sup down 30 2 ^+^q^+^2$
for every $q$ which is a prime power [Par3]. Furthermore,
$f(n)~>=~n^+^down 10 sqrt up 10 {^n} ~-~6n sup down 20 {11^/^40} ~$
[BEFRS4].
For more bounds on $f(n)$ see [Par5, Chen, ChenJ, MoCa, WuSZR].
.IP (d)
$R(K sub {1,{n+^1}} ,^K sub 2,2 ^)~<=~R(K sub 1,n ,^K sub 2,2 ^)~+^2~$ [Chen].
.IP (e)
$R(K sub {2, lambda +1},^K sub {1, v-^k+1}^)$ is either $v^+^1$ or
$v^+~2$ if there exists a $(v,^k,^lambda )$-difference set.
This and other related results are presented in [Par4, Par5].
See also [GoCM, GuLi].
.IP (f)
Formulas and bounds on $R(K sub 2,2 ,^K sub 2,n )$,
and bounds on $R(K sub 2,2 ,^K sub m,n )$.
In particular, we have
$R(K sub 2,2 ,^K sub 2,k )~=~n^+^k down 20 sqrt up 20 {^n} ^+^c$,
for $k^=^2,^3,^4$, some prime powers
${down 3 \(lc} down 20 sqrt up 20 {^n} {down 3 \(rc}$ and
${down 3 \(lc} down 20 sqrt up 20 {^n} {down 3 \(rc}~+^1$,
and some $-^1~<=~c~<=~3~$ [HaMe4]. An improvement of the latter
for some special cases of $n$ was obtained in [Dyb].
.IP (g)
$R(K sub 2,n ,^K sub 2,n )~<=~4n^-^2$ for all $n~>=~2$,
and the equality holds if and only if there exists a strongly regular
$(4n^-^3,^2n^-^2,^n^-^2,^n^-^1 ^)$-graph [EHM2].
.IP (h)
Conjecture that $4n^-^3~<=~R(K sub 2,n ,^K sub 2,n )~<=~4n^-^2$
for all $n~>=~2$. Many special cases are solved and several others
are discussed in [LoM1].
.IP (i)
$R(K sub 2,n-1 ,^K sub 2,n )~<=~4n^-~4~$ for all $n^>=~3$, with
the equality if there exists a symmetric Hadamard matrix of order
$4n^-~4$. There are only 4 cases in which the equality is
still open for $3^<=~n^<=~58$, namely 30, 40, 44 and 48 [LoM1].
.IP (j)
$R(K sub 2,n-s ,^K sub 2,n )~<=~4n^-^2s^-^3~$ for $s^>=~2^$
and $^n^>=~s^+^2$, with the equality in many cases
involving Hadamard matrices or strongly regular graphs.
Asymptotics of $R(K sub 2,n ,^K sub 2,m )$ for $m >> n~$ [LoM3].
.IP (k)
Some algebraic lower and upper bounds on
$R(K sub s,n ,^K sub t,m )$ for various combinations
of $n$, $m$ and $1 ~<=~t,^s ~<=~3~$ [BaiLi, BaLX].
A general lower bound
$R(K sub {m,n} )~>=~2 sup m (n^-~n sup {down 15 0.525})$
for large $n~$ [Dong].
.IP (l)
Upper bounds for $R(K sub 2,2 ,^K sub m,n ^)$ for $m,^n^>=^2^$, with
several cases identified for which the equality holds. Special focus
on the cases for $m~=~2~$ [HaMe4].
.IP (m)
Bounds for the numbers of the form $R(K sub k,n ,^K sub k,m )$,
specially for fixed $k$ and close to the diagonal cases.
Asymptotics of $R(K sub 3,n ,^K sub 3,m )^$ for $m >> n~$ [LoM2].
.IP (n)
$R(nK sub 1,3 ,^mK sub 1,3 ^)~=~4n^+^m^-^1$ for
$n^>=~m^>=^1,~n^>=~2~$ [BES].
.IP (o)
Asymptotics for $K sub 2,m$ versus $K sub n$ [CaLRZ].
Upper bound asymptotics for $K sub k,m$ versus $K sub n$ [LiZa1]
and for some bipartite graphs $K sub n$ [JiSa].
.IP (p)
Special two-color cases apply in the study of asymptotics
for multicolor Ramsey numbers for complete bipartite graphs [ChGra1].
.bp
.LP
.NH
Two Colors: Numbers Involving Cycles
.NH 2
Cycles, cycles versus paths and stars
.sp 0.3
.LP
Note:
The paper \fI Ramsey Numbers Involving Cycles\fP [Ra4]
is based on the revision #12 of this survey. It collects
and comments on the results involving cycles versus any
graphs, in two or more colors. It contains some more details
than this survey, but only until 2009.
.sp .4
.LP
\fBCycles\fP
.IP (a)
$R(C sub 3 ,^C sub 3^)~ =~6~$ [GG, Bush],
.br
$R(C sub 4 ,^C sub 4^)~ =~6~$ [CH1].
.IP (b)
$R(C sub 3 ,^C sub n^)~ =~2n^-^1$ for $n~>=~4,$
$R(C sub 4 ,^C sub n^)~ =~n^+^1$ for $n~>=~6$,
.br
$R(C sub 5 ,^C sub n^)~ =~2n^-^1$ for $n~>=~5$, and $R(C sub 6 ,^C sub 6^)~ =~8~$ [ChaS].
.sp .2
.IP (c)
Result obtained independently in [Ros1] and [FS1], a new simpler proof in [K\o'a\(aa'Ros]:
.sp 1.4
.EQ
R(C sub m ,^C sub n ) ~ =~
down 25 left { up 25
{
 ~ lpile
   {
down 20    {2n^-^1} above
    {n^-^1^+^m/^2} above
up 20    { max roman "{"^ n^-^1^+^m/^2,^2m^-^1 roman "}" }
   }
 ~~~lpile
   {
down 20    { roman for ~~3~<=~m^<=~n,~m~roman odd,~(m,^n)~ not= ~(3,3),} above
    { roman for ~~4~<=~m^<=~n,~m~and~n~roman even,~(m,^n)~ not= ~(4,4),} above
up 20    { roman for ~~4~<=~m^<^n,~m~roman even~and~n~roman odd.}
   }
}
.EN
.sp 1.3
.IP (d)
Characterization of all graphs critical for $R(C sub 4 ,^C sub n )^$ [WuSR].
.IP (e)
$R(mC sub 3 ,^nC sub 3 ^)~ =~3n^+~2m$ for $n^>=~m^>=~1,~n^>=~2^$ [BES].
.IP (f)
$R(mC sub 4 ,^nC sub 4 ^)~ =~2n^+~4m^-^1$ for
$m^>=~n^>=~1,~(n,^m)^ not= ^(1,1)^$ [LiWa1].
.IP (g)
Formulas for $R(mC sub 4 ,^nC sub 5 ^)^$ [LiWa2].
.IP (h)
Formulas and bounds for $R(nC sub m ,^nC sub m )~$ [Den2, Biel1].
.IP (i)
Study of $R( S sub 1 ,^S sub 2 )$, where $S sub 1$ and $S sub 2$ are sets of cycles [Hans].
.IP (j)
Unions of cycles, formulas and bounds for various cases including
diagonal, different lengths, different multiplicities [MiSa, Den2],
powers of cycles [AllBS],
disjoint cycles versus $K sub n^$ [Fuj2],
and their relation to 2-local Ramsey numbers [Biel1].
.sp
.LP
\fBCycles versus paths\fP
.LP
Result obtained by Faudree, Lawrence, Parsons and Schelp in 1974 [FLPS]:
.sp 2.3
.EQ L
~~~R(^C sub m ,^P sub n ) ~ =~
down 50 left { up 50
{
 ~ lpile
   {
    {2n^-~1} above
    {n^-~1^+~m/^2} above
    { max roman "{"^ m^-~1^+~ down 10 \(lf n/^2  down 10 \(rf ^,^2n^-~1 roman "}" } above
    {m^-~1^+~ down 10 \(lf n/^2  down 10 \(rf }
   }
 ~~~lpile
   {
    { roman for ~~3~<=~m~<=~n,~~m~ roman odd,} above
    { roman for ~~4~<=~m~<=~n,~~m~ roman even,} above
    { roman for ~~2~<=~n~<=~m,~~m~ roman odd,} above
    { roman for ~~2~<=~n~<=~m,~~m~ roman even.}
   }
}
.EN

.sp 1.5
.LP
For all $n$ and $m$ it holds that
$R(^P sub m ,^P sub n )~<=~R(^C sub m ,^P sub n ) ~<=~ R(C sub m ,^C sub n )$.
Each of the two inequalities can become an equality,
and, as derived in [FLPS], all four possible combinations
of $~<~$ and $~=~$ hold for an infinite number of pairs $(m,^n)$.
For example, if both $m$ and $n$ are even, and at least one
of them is greater than 4, then
$R(^P sub m ,^P sub n ) ~=~ R(^C sub m ,^P sub n ) ~=~ R(C sub m ,^C sub n )$.
For related generalizations see [BEFRS2].
.sp
.LP
\fBCycles versus stars\fP
.LP
Only partial results for $C sub m$ versus stars are known.
Lawrence [La1] settled the cases for odd $m$ and for long
cycles (see also [Clark, Par6]). The case for short even cycles
is open, and it is related in particular to bipartite graphs.
Partial results for $C sub 4 ~=~K sub 2,2$ are pointed
to in subsections 3.3.1 and 3.3.2.
The most known exact result in [La1] is:
.sp 1
.EQ
R(C sub m ,^K sub {1,^n} ) ~ =~
down 45 left { up 20
{
 ~ lpile
   {
down 10    {2n^+^1} above
up 10    {m}
   }
 ~~~lpile
   {
down 10    { roman for ~ roman odd ~m~<=~2n^+^1,} above
up 10    { roman for ~m~>=~2n.}
   }
}
.EN
.sp 1.2
.NH 2
Cycles versus complete graphs
.sp .5
.PP
Since 1976, it was conjectured that
$R(C sub n ,^K sub m ^)~=~(n^-^1)(m^-^1)~+~1~$
for all $n^>=~m^>=~3$, except $n^=~m^=~3$ [FS4, EFRS2].
Various parts of this conjecture were proved as follows:
for $n~>=~m sup {down 20 2} ^-^2$ [BoEr],
for $n~>~3~=~m$ [ChaS], for $n~>=~4~=~m$ [YHZ1], for $n~>=~5~=~m$
[BolJY+], for $n~>=~6~=~m$ [Schi1], for $n~>=~m~>=~7$ with
$n~>=~m(m^-^2)$ [Schi1], for $n~>=~7~=~m$ [ChenCZ1],
and for $n~>=~4m^+^2,~m~>=~3$ [Nik].
Open conjectured cases are marked in Table V by "conj."
.EQ
delim $$
gsize 8
.EN
.nr PS 10
.nr VS 12
.LP
.TS
box center tab(,);
rp8 || rp8 | rp8 | rp8 | rp8 | rp8 | rp8 | rp8 | rp8 rp8 .
,$C sub 3$,$C sub 4$,$C sub 5$,$C sub 6$,$C sub 7$,\
$C sub 8$,$~~~~~~~C sub 9$, ... ,$C sub n$ $roman for$ $n ^>=^m$
=
.sp .2
$K sub 3$,6,7,9,11,13,15,17, ... , $2n^-^1$
\^,GG-Bush,ChaS, ... ,,,,, ... ,ChaS
_
$K sub 4$,9,10,13,16,19,22,25, ... , $3n^-^2$
\^,GG,CH2,He4/JR4,JR2,YHZ1, ... ,, ... ,YHZ1
_
$K sub 5$,14,14,17,21,25,29,33, ... , $4n^-^3$
\^,GG,Clan,He2/JR4,JR2,$~$YHZ2,BolJY+, ... , ... ,BolJY+
_
$K sub 6$,18,18,21,$~~~~~~~26$,31,36,41, ... , $5n^-^4$
\^,K\o'e\(aa'ry,Ex2-RoJa1,JR5,Schi1, ... ,,, ... ,Schi1
_
$K sub 7$,23,22,25,31,37,43,49, ... , $6n^-^5$
\^,Ka2-GrY,RT-JR1,Schi2,CheCZN,CheCZN,JaBa/Ch+,Ch+, ... ,Ch+
_
$K sub 8$,28,26,29-33,36,43,50,57, ... , $7n^-^6$
\^,GR-MZ,RT,JaAl2,ChenCX,ChenCZ1,JaAl1/ZZ3,BatJA, ... ,conj.
_
$K sub 9$,36,30,,,,,65, ... , $8n^-^7$
\^,Ka2-GR,RT-LivLR,,,,,conj., ... ,conj.
_
$K sub 10$,40-42,36,,,,,, ... , $9n^-^8$
\^,Ex5-GoR1,LivLR,,,,,,\^,conj.
_
$K sub 11$,47-50,39-44,,,,,, ... , $10n^-^9$
\^,Ex20-GoR1,LivLR,,,,,,\^,conj.
.TE
.nr PS 12
.nr VS 15
.EQ
gsize 12
.EN
.LP
.DS C
Table V. Known Ramsey numbers $R(C sub n ,^K sub m )$;
Ch+ abbreviates ChenCZ1, for comments on joint credits see 4.2.b.
.DE

.sp 2
.IP (a)
The first column in Table V gives data from the first row in Table I.
.IP (b)
Joint credit [He2/JR4] in Table V
refers to two cases in which Hendry [He2] announced
the values without presenting the proofs, which later were given in [JR4].
The special cases of $R(C sub 6 ,^K sub 5 ^)~=~21$ [JR2]
and $R(C sub 7 ,^K sub 5^)~=~25$ were solved independently
in [YHZ2] and [BolJY+].
The double pointer [JaBa/ChenCZ1] refers to two independent papers,
similarly as [JaAl1/ZZ3], except that in the latter case [ZZ3]
refers to an unpublished manuscript.
For joint credits marked in Table V with "-", the first
reference is for the lower bound and the second for the upper bound.
.IP (c)
Erd\o'o\(hu's et al. [EFRS2] asked what is the minimum value
of $R(C sub n ,^K sub m )^$ for fixed $m$, and they
suggested that it might be possible that $R(C sub n ,^K sub m )^$
first decreases monotonically, then attains a unique minimum,
then increases monotonically with $n$.
.IP (d)
There exist constants $c sub 1 ,^c sub 2 ^>^0$ such that
$c sub 1 ( m  sup {3/^2} / ^log ^m ) ~<=~R(C sub 4 ,^K sub m )~<=$
$c sub 2 ( m / ^log ^m ) sup 2 .$
The lower bound, recently obtained by Bohman and Keevash ([BohK1],
see also 4.2.h below) improved over an almost 40 years old
bound $c ( m / ^log ^m ) sup {3/^2}$ by Spencer [Spe2],
using the probabilistic method. The upper bound was reported
in a paper by Caro, Li, Rousseau and Zhang [CaLRZ],
who in turn give the credit to an unpublished work by
Szemer\o'e\(aa'di from 1980.
.IP (e)
Erd\o'o\(hu's, in 1981, in the Ramsey problems section
of the paper [Erd3] formulated a challenge by asking
for a proof of
$R(C sub 4 ,^K sub m )~<~m sup down 15 {2~-~ epsilon}~$,
for some $epsilon ~>~0$.
To date, no such proof is known.
.IP (f)
Let $C sub <=m$ be the set of cycles of length at most $m$,
and let the \fIgirth\fP $g(G)$ be the length of the shortest
cycle in graph $G$.
Probabilistic lower bound asymptotics for
$R(C sub <=m ,^K sub k )$ [Spe2] currently is
the same as for $R(C sub m ,^K sub k )$,
for fixed $m$. However, there
are clear differences already for girth 4 and 5
and small $k$: Backelin [Back1, Back2]
found that $R(C sub <=4 ,^K sub k )$ =
6, 8, 11, 15, 18 for
$k$ = 3, 4, 5, 6, 7, and that
$R(C sub <=5 ,^K sub k )$ =
5, 8, 10, 13, 15, also for $k$ = 3, 4, 5, 6, 7, respectively.
.IP (g)
Erd\o'o\(hu's et al. [EFRS2] proved various facts about
$R(C sub <=m ,^K sub k )$, and in particular that it is
equal to $2n^-^1$ for $m^>=^2n^-^1$, and to $2n$ for
$n^<^m^<^2n^-^1$. The upper asymptotics for $R(C sub <=m ,^K sub k )$
is implied in the study of independence number in graphs
with odd girth $m$ [Den1].
.IP (h)
The best known lower bound asymptotics
$R(C sub n ,^K sub m )~=~OMEGA ( m sup { down 20 {(n-1)/(n-2)}}^/^roman log ^m )$,
for fixed $n$ and large $m$,
was obtained by Bohman and Keevash [BohK1].
Note that for $n^=~4$ it gives the lower bound in 4.2.d above.
See also [Spe2, FS4, AlR\o'o\(:a'] for previous results.
.IP (i)
Upper bound asymptotics
[BoEr, FS4, EFRS2, CaLRZ, Sud1, LiZa2, AlR\o'o\(:a', DoLL2].

.bp
.NH 2
Cycles versus wheels
.sp .7
.LP
Note: In this survey the wheel graph
$W sub n ~=~ K sub 1 ^+~C sub n-1$ has $n$ vertices,
.br
while some authors use the definition
$W sub n ~=~ K sub 1 ^+~C sub n$ with $n^+^1$ vertices.
.br
For the cases involving $W sub 3 ~=~ C sub 3$ versus
$C sub m$ see sections 3.2 and 4.2.
.EQ
delim $$
gsize 8
.EN
.nr PS 10
.nr VS 12
.LP
.sp
.TS
box center tab(,);
rp8 || rp8 | rp8 | rp8 | rp8 | rp8 | rp8 || rp8 rp8 .
,$C sub 3$,$C sub 4$,$C sub 5$,$~~~C sub 6$,$C sub 7$,\
$~~~~~~C sub 8$,$C sub m$,for
=
$W sub 4$,9,10,13,16,19,22,$3m^-^2$,$m^>=~4$
\^,GG,CH2,He4,JR2,YHZ1,...,...,YHZ1
_
$W sub 5$,11,9,9,11,13,15,$2m^-^1$,$m^>=~5$
\^,Clan,Clan,He2,JR2,SuBB2,...,...,SuBB2
_
$W sub 6$,11,10,13,16,19,22,$3m^-^2$,$m^>=~4$
\^,BE3,JR3,ChvS,SuBB2,...,...,...,SuBB2
_
$W sub 7$,13,9,13,11,13,,$2m^-^1$,$m^>=~10$
\^,BE3,Tse1,LuLL,LuLL,LuLL,,...,Ch1
_
$W sub 8$,15,11,15,16,19,22,$3m^-^2$,$m^>=~6$
\^,BE3,Tse1,LuLL,LuLL,Ch2,...,...,Ch2
_
$W sub 9$,17,12,17,13,17,,$2m^-^1$,$m^>=~13$
\^,BE3,Tse1,LuLL,LuLL,LuLL,,,Ch1
_
$W sub 10$,19,13,,,,,$3m^-^2$,$m^>=~9$
\^,BE3,Tse1,,,,,,Ch2
=
,...,,,,,,,cycles
$W sub n$,$2n^-^1$,,$2n^-^1$,,$2n^-^1$
for,$n^>=~6$,,$n^>=~19$,,$n^>=~29$,,large
,BE3,,Zhou2,,Zhou2,,wheels
.TE
.nr PS 12
.nr VS 15
.EQ
gsize 12
.EN
.LP
.DS C
Table VI. Ramsey numbers $R(W sub n ,^C sub m ^)~$ for $n^<=~10,~m^<=~8$;
Ch1 abbreviates ChenCMN, Ch2 abbreviates ChenCNZ.
.DE

.IP (a)
$R(C sub 3 ,^W sub n ^)~=~2n^-^1$ for $n^>=~6~$ [BE3].
All critical graphs have been enumerated.
.br
The critical graphs are unique for $n^=~3,^5,~$
and for no other $n^$ [RaJi].
.IP (b)
$R(C sub 4 ,^W sub n ^)~=$ 14, 16, 17
for $n~=$ 11, 12, 13, respectively [Tse1],
.br
$R(C sub 4 ,^W sub n ^)~=$ 18, 19, 20, 21
for $n~=$ 14, 15, 16, 17, respectively [DyDz2],
and several higher
values and bounds, including 9 cases of $n$ between 18 and 44 [WuSR, WuSZR].
.IP (c)
$R(C sub 4 ,^W sub n ^)~<=~n^+~{down 8 \(lc} (n^-^1)^/^3  {down 8 \(rc}^$
for $n^>=~7~$ [SuBUB], which was improved to
.br
$R(C sub 4 ,^W sub n ^)~<=~n^+~sqrt{n^-^2} ~+^1^$ for $n^>=~11^~$ [DyDz2].
.IP (d)
$R(C sub 4 ,^W sub {q sup 2 +^1})~=~q sup 2^+~q^+^1~$
for prime power $q~>=~4^$ [DyDz2],
.br
exact values of $R(C sub 4 ,^W sub {q sup 2 +^2})$ and
$R(C sub 4 ,^W sub {q sup 2 -^i})^$ for special $q$ and small $i^$ [WuSZR].
.IP (e)
$R(W sub n ,^C sub m )~=~2n^-^1$ for odd $m$ with $n^>=~5m^-^6^$ [Zhou2].
.IP (f)
$R(W sub n ,^C sub m )~=~3m^-^2$ for even $n^>=~4$ with
$m^>=~n^-^1,~m not= 3$, was conjectured by Surahmat et
al. [SuBT1, SuBT2, Sur]. Parts of this conjecture were proved
in [SuBT1, ZhaCC1, Shi5], and the proof was completed in [ChenCNZ].
.IP (g)
Conjecture that $R(W sub n ,^C sub m )~=~2m^-^1$
for odd $n^>=~3$ and all $m^>=~5$ with $m^>^n^$ [Sur].
.br
It was proved for $2m^>=~5n^-^7^$ [SuBT1],
and further for $2m^>=~3n^-^1^$ [ChenCMN].
.br
See also [Shi5].
.IP (h)
Observe apparently four distinct situations with respect
to parity of $m$ and $n$.
.IP (i)
Cycles are Ramsey unsaturated for some wheels [AliSur],
.br
see also comments on [BaLS] in subsection 5.16.
.IP (j)
Study of cycles versus generalized wheels $W sub k,n$ [Sur, SuBTB, Shi5].

.LP
.NH 2
Cycles versus books
.LP
.EQ
delim $$
gsize 8
.EN
.nr PS 10
.nr VS 12
.sp .5
.LP
.TS
box center tab(,);
rp8 || rp8 | rp8 | rp8 | rp8 | rp8 | rp8 | rp8 | rp8 | rp8 || rp8 rp8 .
,$C sub 3$,$C sub 4$,$C sub 5$,$C sub 6$,$C sub 7$,\
$C sub 8$,$C sub 9$,$C sub 10$,$C sub 11$,$C sub m$,for
=
$B sub 2$,7,7,9,11,13,15,17,19,21,$2m^-^1$,$m^>=^4$
\^,RS1,F\fIal\fP6,C\fIal\fP,F\fIal\fP8,...,,,,,...,F\fIal\fP8
_
$B sub 3$,9,9,10,11,13,15,17,19,21,$2m^-^1$,$m^>=^6$
\^,RS1,F\fIal\fP6,F\fIal\fP8,JR2,Shi5,F\fIal\fP8,...,,,...,F\fIal\fP8
_
$B sub 4$,11,11,11,12,13,15,17,19,21,$2m^-^1$,$m^>=^7$
\^,RS1,F\fIal\fP6,F\fIal\fP8,S\fIal\fP1,S\fIal\fP1,Shi5,Shi5,F\fIal\fP8,...,...,F\fIal\fP8
_
$B sub 5$,13,12,13,14,15,15,17,19,21,$2m^-^1$,$m^>=^8$
\^,RS1,F\fIal\fP6,F\fIal\fP8,S\fIal\fP1,S\fIal\fP1,S\fIal\fP2,S\fIal\fP2,Shi5,Shi5,...,F\fIal\fP8
_
$B sub 6$,15,13,15,16,17,18,18,,21,$2m^-^1$,$m^>=^11$
\^,RS1,F\fIal\fP6,F\fIal\fP8,S\fIal\fP2,S\fIal\fP2,S\fIal\fP2,S\fIal\fP2,,Shi5,...,Shi5
_
$B sub 7$,17,16,17,16,19,20,21,,,$2m^-^1$,$m^>=^13$
\^,RS1,F\fIal\fP6,F\fIal\fP8,S\fIal\fP2,S\fIal\fP2,S\fIal\fP2,S\fIal\fP2,,,,Shi5
_
$B sub 8$,19,17,19,17,19,22,$>=^23$,,,$2m^-^1$,$m^>=^14$
\^,RS1,Tse1,F\fIal\fP8,S\fIal\fP2,S\fIal\fP2,S\fIal\fP2,S\fIal\fP2,,,,Shi5
_
$B sub 9$,21,18,21,18,,,$>=^25$,$>=^26$,,$2m^-^1$,$m^>=^16$
\^,RS1,Tse1,F\fIal\fP8,S\fIal\fP2,,,S\fIal\fP2,S\fIal\fP2,,,Shi5
_
$B sub 10$,23,19,23,19,,,,$>=^28$,,$2m^-^1$,$m^>=^17$
\^,RS1,Tse1,F\fIal\fP8,S\fIal\fP2,,,,S\fIal\fP2,,,Shi5
_
$B sub 11$,25,20,25,,,,,,,$2m^-^1$,$m^>=^19$
\^,RS1,Tse1,F\fIal\fP8,,,,,,,,Shi5
=
,...,,...,,,,,,,,cycles
$B sub n$,$2n^+^3$,$approx ^n$,$2n^+^3$,,$2n^+^3$,,$2n^+^3$,,$2n^+^3$
for,$n^>=^2$,some,$n^>=^4$,,$n^>=^15$,,$n^>=^23$,,$n^>=^31$,large
,RS1,(c),F\fIal\fP8,,F\fIal\fP8,,F\fIal\fP8,,F\fIal\fP8,books
.TE
.nr PS 12
.nr VS 15
.EQ
gsize 12
.EN
.DS C
Table VII. Ramsey numbers $R(B sub n ,^C sub m )~$ for $n,^m^<=~11$;
\fIet al.\fP abbreviations: F\fIal\fP/FRS, C\fIal\fP/CRSPS, S\fIal\fP1/ShaXBP, S\fIal\fP2/ShaXB.
.DE
.sp 1.5
.IP (a)
For the cases of $B sub 1 ~=~K sub 3$ versus $C sub m$ see section 4.2.
.br
The exact values for the cases $(3,7),~(4,8),~(4,9),~(5,10),~(5,11)^$ were obtained
independently in [S\fIal\fP1, S\fIal\fP2]/[ShaXBP, ShaXB] using computer algorithms.
.IP (b)
$R(C sub 4 ,^B sub 12 ^)~=~21~$ [Tse1],
$R(C sub 4 ,^B sub 13 ^)~=~22~$,
$R(C sub 4 ,^B sub 14 ^)~=~24~$ [Tse2].
.br
$R(C sub 4 ,^B sub 8 ^)~=~17$ [Tse2] (it was reported incorrectly in [FRS7] to be 16).
.IP (c)
$q sup 2 ^+~q^+^2 ~<=~R(C sub 4 ,^B sub {q sup 2 ^-~q^+^1}^)~<=~q sup 2 ^+~q^+~4$
for prime power $q$ [FRS7].
$B sub n$ is a subgraph of $B sub {n+^1}$,
hence likely $R(C sub 4 ,^B sub n ^)~=~n^+~O( down 10 sqrt up 10 {^n} )$
(compare to $R(C sub 4 ,^K sub 2,n )$ in section 3.3).
.IP (d)
$R(B sub n ,^C sub m^)~=~2n^+~3~$ for odd $m^>=~5$ with $n^>=~4m^-^13~$ [FRS9].
.IP (e)
$R(B sub n ,^C sub m^)~=~2m^-^1~$ for $n^>=^1,~m^>=~2n^+^2~$ [FRS9].
The range of $m~$ was extended to
$m^>=~2n^-^1~>=~7~$ in [ShaXB], and to $m^>~(6n^+^7)^/^4~$ in [Shi5].
.IP (f)
$R(B sub n ,^C sub n )~>=~3n~-~2~$ and
$~R(B sub {n^-^1},^C sub n )~>=~3n~-~4$ for $n^>=^3~$ [ShaXB].
.IP (g)
More theorems on $R(B sub n ,^C sub m^)$ in [FRS7, FRS9, NiRo4, Zhou1].
.IP (h)
Cycles versus some generalized books [Shi5].
.sp .8
.NH 2
Cycles versus other graphs
.sp .5
.IP (a)
$C sub 4$ versus stars [Par3, Par4, Par5, BEFRS4, Chen, ChenJ, GoMC, MoCa, WuSZR].
For several exact results see $K sub {2,2}$ in Tables IVa and IVb, and for
general results see items 3.3.1.a, 3.3.2.c and 3.3.2.d.
.IP (b)
$C sub 4$ versus unions of stars [HaABS, Has]
.IP (c)
$C sub 4$ versus trees [EFRS4, Bu7, BEFRS4, Chen]
.IP (d)
$C sub 4$ versus all graphs on six vertices [JR3]
.IP (e)
$C sub 4$ versus various types of complete bipartite graphs,
see section 3.3
.IP (f)
$R(C sub 4 ,^G)~<=~2q^+^1$ for any isolate-free graph $G$ with $q$ edges [RoJa2]
.IP (g)
$R(C sub 4 ,^G)~<=~p^+^q^-^1$ for any connected
graph $G$ on $p$ vertices and $q$ edges [RoJa2]
.sp .5
.IP (h)
$R(C sub 5 ,^K sub 6 ^-^e)~=~17^$ [JR4]
.IP (i)
$R(C sub 5 ,^K sub 4 ^-^e)~=~9^$ [CRSPS]
.IP (j)
$C sub 5$ versus all graphs on six vertices [JR4]
.IP (k)
$R(C sub 6 ,^K sub 5 ^-^e)~=~17^$ [JR2]
.IP (l)
$C sub 6$ versus all graphs on five vertices [JR2]
.sp .5
.IP (m)
$R(C sub 2m+1 ,^G)~=~2n^-^1^$ for sufficiently large
sparse graphs $G$ on $n$ vertices, in particular 
.br
$R(C sub 2m+1 ,^T sub n ^)~=~2n^-^1^$ for all $^n^>^1512m^+^756$,
for $n$-vertex trees $T sub n ~$ [BEFRS2].
.IP (n)
$R(C sub n ,^G)~<=~2q^+~{down 8 \(lf} ^n/^2^ {down 8 \(rf} ~-^1$,
for $3^<=~n^<=~5$, for any isolate-free graph $G$ with $q^>^3$ edges.
It is conjectured
that it also holds for other $n^$ [RoJa2].
.IP (o)
Cycles versus trees [BEFRS2, FSS1]
.IP (p)
Monotone paths and cycles [Lef]
.IP (q)
Cycles versus $K sub up 15 {n,m}$ and multipartite complete graphs [BoEr]
.IP (r)
Cycles versus generalized books and wheels [Shi5, Sur, SuBTB],
and versus other special graphs of the form
$K sub n +^G$ with small $n~<=~3$ and sparse $G~$ [Shi5].


.EQ
delim $$
define not= '= back 40 /^'
gsize 12
.EN
.nr PS 12
.nr VS 15
.ds CH
.ds CF - \\n% -
.nr LL 6.5i
.ds RH "\s10T\s-2HE\s0 E\s-2LECTRONIC\s0 J\s-2OURNAL OF\s0 C\s-2OMBINATORICS\s0 (2014), DS1\s-2.14
.bp

.LP
.NH
General Graph Numbers in Two Colors
.PP
This section includes data with respect to general graph
results. We tried to include all nontrivial values and identities
regarding exact results, or references to them,
but only those out of general bounds and
other results which, in our opinion, may have a direct connection
to the evaluation of specific numbers. If some small value cannot
be found below, it may be covered by the cumulative data gathered
in section 8, or be a special case of a general result listed in
this section. Note that
$P sub 2 ~=~K sub 2$,
$B sub 1 ~=~F sub 1 ~=~C sub 3 ~=~W sub 3 ~=~K sub 3$,
$B sub 2 ~=~K sub 4 ^-^e$,
$P sub 3 ~=~K sub 3 ^-^e$, $W sub 4 ~=~ K sub 4$ and $C sub 4 ~=~ K sub 2,2$
imply other identities not mentioned explicitly.
.sp
.NH 2
Paths
.RS
.LP
$R(P sub m ,^P sub n )~=~$
$n^+~ {down 10 \(lf} ^m/^2^  {down 10 \(rf} ~-^1~~$
for all $n^>=~m^>=^2~~$ [GeGy]
.LP
Stripes $mP sub 2$ [CocL1, CocL2, Lor]
.LP
Disjoint unions of paths (also called linear forests) [BuRo2, FS2]
.RE
.NH 2
Wheels
.RS
.LP
Note: In this survey the wheel graph
$W sub n ~=~ K sub 1 ^+^C sub n-1$ has $n$ vertices,
.br
while some authors use the definition
$W sub n ~=~ K sub 1 ^+^C sub n$ with $n^+^1$ vertices.
.RE
.nr PS 10
.nr VS 12
$gsize 8$
.LP
.TS
box center tab(,);
cp8 cp8 || rp8 | rp8 | rp8 | rp8 | rp8 .
,$n$,$~~~3$,4,5,6,7
$m$,
.sp .2
=
.sp .2
3,,6,9,11,11,13
\^,,,GG,Clan,BE3,BE3
_
4,,,18,17,19
\^,,,GG,He3,FM
_
5,,,,15,17
\^,,,,He2,FM
_
6,,,,,17
\^,,,,,FM
.TE
.nr PS 12
.nr VS 15
$gsize 12$
.DS C
Table VIII. Ramsey numbers $R(^W sub m ,^W sub n )~$ for $m^<=~n^<=~7$.
.DE
.sp
.IP (a)
$R(W sub 3 ,^W sub n )^=^2n-1$ for all $n^>=^6$ [BE3],
.br
All critical colorings for $R(W sub 3 ,^W sub n )$ for all $n^>=^3$ [RaJi].
.IP (b)
The value $R(W sub 5 ,^W sub 5 ^)^=^15$ was given in the Hendry's
table [He2] without a proof.
.br
Later the proof was published in [HaMe2].
.IP (c)
All critical colorings (2, 1 and 2) for $R(W sub n ,^W sub 6 ^)$,
for $n$ = 4, 5, 6 [FM].
.IP (d)
$R(W sub 6 ,^W sub 6 ^)~=~17$, $R(4,4)~=~18$ and $^chi (W sub 6 ^)~=~4$
give a counterexample $G^=^W sub 6$
.br
to the Erd\o'o\(hu's conjecture (Erd2, see also [GRS])
that $R(G,^G)~>=~R(K sub { chi (G) } ,^K sub { chi (G) } ^)$.

.NH 2
Books
.nr PS 10
.nr VS 12
$gsize 8$
.LP
.TS
box center tab(,);
cp8 cp8 || rp8 | rp8 | rp8 | rp8 | rp8 | rp8 | rp8 .
,$n$,$~~~~~1$,$~~~~~~~2$,$~~~~~~~3$,$~~~~~~~4$,$~~~~~~~5$,$~~~~~~~6$,$~~~~~~~~7$
$m$,
.sp .2
=
.sp .2
1,,6,7,9,11,13,15,17
\^,,,CH2,Clan,RS1,RS1,RS1,RS1
_
2,,,10,11,13,16,17,18
\^,,,CH1,Clan,Rou,RS1,Rou,BlLR
_
3,,,,14,15,17
\^,,,,RS1,Sh1+,RS1
_
4,,,,,18,$<=^20$,22
\^,,,,,RS1,RS1,RS1
_
5,,,,,,21
\^,,,,,,RS1
_
6,,,,,,,26
\^,,,,,,,RS1
.TE
.nr PS 12
.nr VS 15
$gsize 12$
.DS C
Table IX. Ramsey numbers $R(^B sub m ,^B sub n )~$ for $m,^n^<=~7$;
Sh1+ abbreviates ShaXBP.
.DE
.sp 2
.IP (a)
$254~<=~R(B sub 37 ,^B sub 88 ^)~<=~255^$ [Par6].
.IP (b)
Unpublished result $R(B sub 2 ,^B sub 6 ^)~=~17~$ [Rou]
was confirmed in [BlLR].
.IP (c)
There are 4 Ramsey-critical graphs for $R(B sub 2 ,^B sub 3 ^)$,
a unique graph for $R(B sub 3 ,^B sub 4 ^)~$ [ShaXBP],
3 for $R(B sub 2 ,^B sub 6 ^)$
and 65 for $R(B sub 2 ,^B sub 7 ^)~$ [BlLR].
.IP (d)
$R(B sub 1 ,^B sub n )^=^2n^+^3$ for all $n>1$ [RS1].
.IP (e)
$R(B sub n ,^B sub m ) ~=~ 2n^+^3$ for all $n^>=^cm$
for some $c^<^10 sup 6 ~$ [NiRo2, NiRo3].
.IP (f)
$R(B sub n ,^B sub n ) ~=~ (4^+^o(1))n$ [RS1, NiRS].
.IP (g)
In general, $R(B sub n ,^B sub n )~=~4n^+^2$ for $4n^+^1$
a prime power. Several other specific values
(like $R(B sub 62 ,^B sub 65 ^)~=~256$) and general
equalities and bounds for $R(B sub n ,^B sub m )$
can be found in [RS1, FRS8, Par6, NiRS, LiRZ2].

.NH 2
Trees and forests
.LP
In this subsection $T sub n$ and $F sub n$ denote
$n$-vertex tree and forest, respectively.
.sp 0.3
.IP (a)
$R(T sub n ,^T sub n ^)~<=~4n^+^1^$ [EG].
.IP (b)
$R(T sub n ,^T sub n ^)~>=~{down 8 \(lf} (4n^-^1) ^/^3 {down 8 \(rf}$ [BE2],
see also section 5.15.
.IP (c)
Conjecture that $R(T sub n ,^T sub n ^)$ is at most $2n^-^2^$
for even $n$ and $2n^-^3^$ for odd $n$ [BE2].
Note that this is the same as asking if
$R(T sub n ,^T sub n ^)~<=~R(K sub 1,n-1 ,^K sub 1,n-1 ^)$.
Zhao proved that $R(T sub n ,^T sub n ^)~<=~2n^-^2^$ and thus
confirmed the conjecture for even $n$. Independently,
Ajtai et al. [AjKSS] announced a full proof for large $n$.
This recent progress subsumes some of the results pointed
to in items (d)-(l) below.
.IP (d)
For general discussion of related problems see [Bu7, FSS1, ChGra2],
in particular of the conjecture that $R(T sub m ,^T sub n )~<=~n^+^m^-^2$
holds for all trees [FSS1].
.IP (e)
If $DELTA (T sub m )~=~m^-^2$ and $DELTA (T sub n )~=~n^-^2$ then
the exact values of $R(T sub m ,^T sub n )$ are known, and they
are between $n^+^m^-^5$ and $n^+^m^-^3$ depending on $n$ and $m$.
In particular, for $n^=~2k^+^1$ we have
$R(T sub 2k+1 ,^T sub 2k+1 ^)~=~2n^-^5^$ [GuoV].
.IP (f)
Examples of families $T sub m$ and $T sub n$ (including $P sub n$)
for which $R(T sub m ,^T sub n^)~=~n^+~m^-^c$, $c~=~3,~4,~5~$ [SunZ],
extending the results in [GuoV].
.IP (g)
View tree $T$ as a bipartite graph with parts
$t sub 1$ and $t sub 2$, $t sub 2 ~>=~t sub 1$. Define
$b(T)~=~max roman "{" ^2t sub 1^+^t sub 2^-^1,^2t sub 2 ^-^1 roman "}"$.
Then the bound $R(T,^T)~>=~b(T)$ holds always,
$R(T,^T)~=~b(T)$ holds for many classes of trees [EFRS3, GeGy],
and asymptotically [Ha\(L/T], but cases for nonequality have
been found [GHK].
.IP (h)
Comments in [BaLS] about some conjectures on Ramsey saturation of
non-star trees, which would imply that
$R(T sub n ,^T sub n ^)~<=~2n^-^2^$
holds for sufficiently large $n$.
.IP (i)
Formulas for $R(T sub m ,^T sub n )$ for some subcases of when
$T sub m$ and $T sub n$ satisfy
$DELTA (T sub m )~=~m^-^3$ and $DELTA (T sub n )~<=~n^-^3^$ [SunWW].
.sp 0.3
.IP (j)
$R(T sub m ,^K sub 1,n ^)~<=~m^+^n^-^1^$, with equality for
$(m^-^1)^|^(n^-^1)$ [Bu1].
.IP (k)
$R(T sub m ,^K sub 1,n ^)~=~m^+^n^-^1^$ for sufficiently large $n$
for almost all trees $T sub m$ [Bu1].
Many cases were identified for which $R(T sub m ,^K sub 1,n ^)~=~m^+^n^-^2^$
[Coc, ZZ1], see also [Bu1].
.IP (l)
$R(T sub m ,^K sub 1,n ^)~<=~m^+^n^$ if $T sub n$ is not a star
and $(m^-^1)^| back 43 /^ (n^-^1)$,
.br
some classes of trees and stars
for which the equality holds [GuoV].
.IP (m)
$R(F sub n ,^F sub n ^)^>^n^+^ roman log sub 2 n ^-^O( roman loglog ^n)^$ [BE2],
forests are tight for this bound [CsKo].
.IP (n) 
Forests, linear forests (unions of paths) $~$[BuRo2, FS3, CsKo].
.IP (o)
Paths versus trees [FSS1], see also other parts of this survey
involving special graphs,
.br
in particular sections 5.5, 5.6, 5.10, 5.12 and 5.15.
.NH 2
Stars, stars versus other graphs
.RS
.LP
$R(K sub 1,n ,^K sub 1,m )~=~ n^+^m^-^epsilon$, where $epsilon ^=^1$
for even $n$ and $m$, and $epsilon ^=^0$ otherwise [Har1].
This is also a special case of multicolor numbers for stars
6.6.e obtained in [BuRo1].
.sp .5
$R(K sub 1,n ,^K sub m )~=~ n(m^-^1)^+^1$ by Chv\o'a\(aa'tal's theorem [Chv].
.sp .5
.br
Stars versus $C sub 4 ~$ [Par3, Par4, Par5, BEFRS4, Chen, ChenJ, GoMC, MoCa, WuSZR]
.br
Stars versus $K sub up 20 2,n$ [Par4, GoMC]
.br
Stars versus $K sub up 20 {n,^m}$ [Stev, Par3, Par4]
.br
See also section 3.3
.sp .4
.LP
$R(K sub 1,4 ,^B sub 4 ^)~=~11^$ [RS2]
.br
$R(K sub 1,4 ,^K sub 1,2,3 ^)~=~R(K sub 1,4 ,^K sub 2,2,2 ^)^=^11^$ [GuSL]
.sp
.br
Stars versus paths [Par2, BEFRS2]
.br
Stars versus cycles [La1, Clark], see also [Par6] and section 4.1
.br
Stars versus $2K sub 2$ [MeO]
.br
Stars versus stripes $mP sub 2$ [CocL1, CocL2, Lor]
.sp .3
.br
Stars versus $W sub 5$ and $W sub 6$ [SuBa1]
.br
$nK sub 1,m$ versus $W sub 5$ [BaHA]
.br
Stars versus $W sub 9$ [Zhang2, ZhaCZ1]
.br
Stars versus wheels [HaBA1, ChenZZ2, Kor]
.br
Stars versus books [CRSPS, RS2]
.br
Stars versus trees [Bu1, Cheng, Coc, GuoV, SunZ, ZZ1]
.br
Stars versus $K sub n ^-~tK sub 2$ [Hua1, Hua2]
.br
Union of two stars [Gros2]
.br
Unions of stars versus $C sub 4$ and $W sub 5~$ [HaABS, Has]
.br
Unions of stars versus wheels [BaHA, HaBA2, SuBAU1]
.RE
.NH 2
Paths versus other graphs
.RS
Note: for cycles versus $P sub n$ see section 4.1.
.sp .3
.LP
$P sub 3$ versus all isolate-free graphs [CH2]
.br
Paths versus stars [Par2, BEFRS2]
.br
Paths versus trees [FS4, FSS1, SunZ]
.br
Paths versus books [RS2]
.br
Paths versus $K sub n ^$ [Par1]
.br
Paths versus $2K sub n ^$ [SuAM, SuAAM]
.br
Paths versus $K sub n,m ^$ [H\o'a\(:a'g]
.br
Paths versus some balanced complete multipartite graphs [Pokr]
.br
Paths versus $W sub 5$ and $W sub 6 ^$ [SuBa1]
.br
Paths versus $W sub 7$ and $W sub 8 ^$ [Bas]
.br
Paths versus wheels [BaSu, ChenZZ1, SaBr3, Zhang1]
.br
.sp .1
$R(P sub n ,^m W sub 4 )~=~2n^+^m^-^2^$ [Sudar]
.br
Paths versus beaded wheels [AliBT2]
.br
Paths versus powers of paths [Pokr, AllBS]
.br
Paths versus fans [SaBr2]
.br
Paths versus $K sub 1 ^+^ P sub m~$ [SaBr1, SaBr4]
.br
Paths and cycles versus trees [FSS1]
.sp .2
Powers of paths [AllBS]
.br
Unions of paths [BuRo2]
.br
Paths and unions of paths versus Jahangir graphs [AliBas, AliBT1, AliSur]
.br
Paths and unions of paths versus $K sub {2m} -~ mK sub 2~$ [AliBB]
.sp .2
Sparse graphs versus paths and cycles [BEFRS2]
.br
Graphs with long tails [Bu2, BG]
.br
Monotone paths and cycles [Lef]
.RE
.NH 2
Fans, fans versus other graphs
.RS
.LP
$R(F sub 1 ,^F sub n ^)~=~R(K sub 3 ,^F sub n ^)~=~4n^+^1~$ for
$n^>=~2^$, and bounds for $R(F sub m ,^F sub n ^)^$ [LiR2, GGS]
.sp .3
$R(F sub 2 ,^F sub n ^)~=~4n^+^1~$ for $n^>=~2$ and
$R(F sub m ,^F sub n ^)~<=~4n^+^2m$ for $n^>=~m^>=~2^$ [LinLi1]
.sp .3
$R(K sub 4 ,^F sub n ^)~=~6n^+^1$ for $n^>=~3^$ [SuBB3]
.sp .3
Fans versus paths, formulas for a number of cases including
$R(P sub 6 ,^F sub n^)~$ [SaBr2].
.br
Missing case $R(P sub 6 ,^F sub 4^)~=~12~$ solved in [Shao].
.sp .3
Fans versus cycles [Shi5]
.br
Fans versus $K sub n$ [LiR2]
.br
Lower bounds on $R(F sub 2 ,^K sub n ^)$
from cyclic graphs for $n^<=^9$ [Shao]
.RE
.NH 2
Wheels versus other graphs
.RS
.LP
Notes: In this survey the wheel graph
$W sub n ~=~ K sub 1 ^+^C sub n-1$ has $n$ vertices,
.br
while some authors use the definition
$W sub n ~=~ K sub 1 ^+^C sub n$ with $n^+^1$ vertices.
.br
For cycles versus $W sub n ^$ see section 4.3.
.sp .5
.LP
$R(W sub 5 ,^K sub 5 ^-^e)~=~17$ [He2][YH]
.br
$R(W sub 5 ,^K sub 5 ^)~=~27$ [He2][RST]
.br
$R(W sub 5 ,^K sub 6 ^)~>=~33$, $R(W sub 5 ,^K sub 7 ^)~>=~43^$ [Shao, ShaoWX]
.br
$W sub 5$ and $W sub 6$ versus stars and paths [SuBa1]
.br
$W sub 5$ versus $nK sub 1,m$ [BaHA]
.br
$W sub 5$ versus unions of stars [Has]
.br
$W sub 5$ and $W sub 6$ versus trees [BaSNM]
.br
$W sub 7$ and $W sub 8$ versus paths [Bas]
.sp .3
$W sub 7$ versus trees $T sub n$ with $DELTA (T sub n )~>=~n^-^3$,
other special trees $T$,
.br
and for $n^<=^8^$ [ChenZZ3, ChenZZ5, ChenZZ6]
.sp .3
$W sub 7$ and $W sub 8$ versus trees [ChenZZ4, ChenZZ5]
.br
$W sub 9$ versus stars [Zhang2, ZhaCZ1, ZhaCC2]
.br
$W sub 9$ versus trees of high degree [ZhaCZ2]
.sp .5
Wheels versus stars [HaBA1, ChenZZ2, Kor]
.br
Wheels $W sub n$, for even $n$, versus star-like trees [SuBB1]
.br
Wheels versus paths [BaSu, ChenZZ1, SaBr3, Zhang1]
.br
Wheels versus books [Zhou3]
.br
Wheels versus unions of stars [BaHA, HaBA2, SuBAU1]
.br
Wheels versus linear forests (disjoint unions of paths) [SuBa2]
.br
Generalized wheels versus cycles [Shi5]
.br
Upper asymptotics for $R(W sub n ,^K sub m )^$ [Song5, SonBL]
.br
Upper asymptotics for generalized wheels versus $K sub n$ [Song9]
.RE
.NH 2
Books versus other graphs
.RS
Note: for cycles versus $B sub n$ see section 4.4.
.sp .5
.LP
$R(B sub 3 ,^K sub 4 ^)^=^14$ [He3]
.br
$R(B sub 3 ,^K sub 5 ^)^=^20$ [He2][BaRT]
.br
$R(B sub 4 ,^K sub 1,4 ^)^=^11^$ [RS2]
.sp .2
Cyclic lower bounds for $R(B sub m ,^K sub n ^)$ for $m^<=^7,~n<=~9$
.br
and for $R(B sub 3 ,^K sub n ^-^e)$ for $n^<=~7^$ [Shao, ShaoWX]
.sp .2
Books versus paths [RS2]
.br
Books versus stars [CRSPS, RS2]
.br
Books versus trees [EFRS7]
.br
Books versus $K sub n$ [LiR1, Sud2]
.br
Books versus wheels [Zhou3]
.br
Books versus $K sub 2 ^+~ C sub n$ [Zhou3]
.br
Books and $(K sub 1 ^+~ tree)$ versus $K sub n$ [LiR1]
.br
Generalized books $K sub 3 ^+~qK sub 1$ versus cycles [Shi5]
.br
Generalized books $K sub r ^+~qK sub 1$ versus $K sub n$ [NiRo1, NiRo4]
.RE
.NH 2
Trees and forests versus other graphs
.LP
In this subsection $T sub n$ and $F sub n$ denote
$n$-vertex tree and forest, respectively.
.RS
.LP
$R(T sub n ,^K sub m )~=~ (n^-^1)(m^-^1)^+^1~$ [Chv]
.LP
$R(T sub n ,^C sub 2m+1 ^)~=~2n^-^1^$ for all $^n^>^1512m^+^756~$ [BEFRS2]
.LP
$R(T sub n ,^B sub m ^)~=~2n^-^1^$ for all $^n^>=^3m^-^3~$ [EFRS7]
.sp .2
.LP
$R(F sub nk ,^K sub m )~=~(n^-^1)(m^-^2)^+^nk~$
for all forests $F sub nk$ consisting of $k$ trees with
.br
$n$ vertices each,
also exact formula for all other cases of forests versus $K sub m ^$ [Stahl]
.sp .2
.LP
Exact results for almost all small ($n(G)^<=^5)$
connected graphs $G$ versus all trees [FRS4]
.sp .5
.br
Trees versus stars [Bu1, Cheng, Coc, GuoV, ZZ1]
.br
Trees versus paths [FS4, FSS1]
.br
Trees versus $C sub 4$ [EFRS4, Bu7, BEFRSS5, Chen]
.br
Trees versus cycles [FSS1, EFRS6]
.br
Trees versus books [EFRS7]
.br
Trees versus $W sub 5$ and $W sub 6$ [BaSNM]
.br
Trees versus $W sub 7$ and $W sub 8$ [ChenZZ4, ChenZZ5]
.sp .5
Trees $T sub n$ with $DELTA (T sub n )~>=~n^-^3$, other special trees $T$,
.br
and for $n^<=~8$ versus $W sub 7~$ [ChenZZ3, ChenZZ5, ChenZZ6]
.br
Trees $T sub n$ with $DELTA (T sub n )~>=~n^-^4$ versus $W sub 9~$ [ZhaCZ2]
.sp .5
Star-like trees versus odd wheels [SuBB1, ChenZZ3]
.br
Trees versus $K sub n ^+~K bar sub m$ [RS2, FSR]
.br
Trees versus bipartite graphs [BEFRS4, EFRS6]
.br
Trees versus almost complete graphs [GoJa2]
.br
Trees versus multipartite complete graphs [EFRS8, BEFRSGJ]
.sp .5
Linear forests versus $3K sub 3$ and $2K sub 4 ~$ [SuBAU2]
.br
Linear forests versus $2K sub m ^$ [SuAAM]
.br
Linear forests versus wheels [SuBa2]
.br
Forests versus almost complete graphs [ChGP]
.br
Forests versus complete graphs [BE1, Stahl, BaHA]
.sp .2
.LP
Study of graphs $G$ for which all or almost all trees are $G$-good [BF, BEFRSGJ],
.br
see also section 5.15 and 5.16, item [Bu2], for the definition and more pointers.
.LP
See also various parts of this survey for
special trees, and section 5.4.
.RE
.NH 2
Cases for $n(G),~n(H)~<=~5$
.RS
.LP
Clancy [Clan], in 1977, presented a table of $R(G,^H)$
for all isolate-free graphs $G$ with $n(G)~=~5$ and $H$
with $n(H)~<=~4$, except 5 entries.
All five of the open entries have been solved as follows:
.LP
.RS
$R(B sub 3 ,^K sub 4 ^)~=~14$						[He3]
.br
$R(K sub 5 ,^K sub 4 ^-^e )~=~16$					[BoH]
.br
$R(W sub 5 ,^K sub 4 ^)~=~17$						[He2]
.br
$R(K sub 5 ^-^e ,^K sub 4 ^)~=~19$					[EHM1]
.br
$R(K sub 5 ,^K sub 4 ^)~=~R(4,^5)~=~25$				[MR4]
.RE
.LP
An interesting case in [Clan] is
.LP
.RS
$R(K sub 4 ,^K sub 5 ^-^P sub 3 )~=~R(K sub 4 ,^K sub 4 ^+^e)~=~R(4,^4)~=~18.$
.RE

.LP
Hendry [He2], in 1989, presented a table of $R(G,^H)$
for all graphs $G$ and $H$ on 5
.br
vertices without isolates,
except 7 entries. Five of the open entries have been solved:
.LP
.RS
$R(K sub 5 ,^K sub 4 ^+^e)~=~R(4,^5)~=~25$				[Ka1][MR4]
.br
$R(K sub 5 ,^K sub 5 ^-~P sub 3^)~=~25$					[Ka1][Boza2, CalSR]
.br
$R(K sub 5 ,^B sub 3 ^)~=~20$						[He2][BaRT]
.br
$R(K sub 5 ,^W sub 5 ^)~=~27$						[He2][RST]
.br
$R(W sub 5 ,^K sub 5 ^-^e)~=~17$					[He2][YH]
.RE
.LP
The still open cases for $K sub 5$ versus
$K sub 5 ^-^e$ and $K sub 5$ are:
.LP
.RS
$30~<=~R(K sub 5 ,^K sub 5 ^-^e^)~<=~34$				[Ex6][Ex8]
.br
$43~<=~R(K sub 5 ,^K sub 5 ^)~<=~49$					[Ex4][MR5]
.RE
.sp .5
.LP
All critical colorings for the case
$R(C sub 5 ^+^e,^K sub 5 ^)~=~17$ were found by Hendry [He5].
.RE

.NH 2
Mixed cases
.RS
.LP
$12~<=~R(Q sub 3 ^,^Q sub 3 ^),~$ where $Q sub 3$ is the 8-vertex 3-dimensional cube graph,
.br
$19~<=~R(P,^P),~$ where $P$ is the 10-vertex Petersen graph,
.br
$30~<=~R(K sub 2,2,2 ^,^K sub 2,2,2 ^),~$ where $K sub 2,2,2$ is the octahedron [HaKr2].
.sp .2
.LP
Unicyclic graphs [Gros1, K\o'o\(:a'h, KrRod]
.br
$K sub 2,m$ and $C sub 2m$ versus $K sub n$ [CaLRZ]
.br
$K sub 2,n$ versus any graph [RoJa2]
.br
Union of two stars [Gros2]
.br
Double stars$up 15 \s10*\s0$ [GHK, BahS]
.FS
.sp 0.1
\s10* double star is a union of two stars with their centers
joined by an edge\s0
.FE
.br
Brooms$up 25 \s10+\s0$ [EFRS3]
.FS
\s10+ broom is a star with a path attached to its center\s0
.FE
.br
Graphs with bridge versus $K sub n$ [Li1]
.br
Multipartite complete graphs [BFRS, FRS3, Stev]
.br
Multipartite complete graphs versus trees [EFRS8, BEFRSGJ]
.br
Multipartite complete graphs versus sparse graphs [EFRS4]
.br
Graphs with long tails [Bu2, BG]
.RE
.NH 2
Multiple copies of graphs, disconnected graphs
.sp 0.3
.IP (a)
$2K sub 2$ versus all isolate-free graphs [CH2]
.IP (b)
$nK sub 2$ versus $mK sub 2$,
in particular $R(nK sub 2 ,^nK sub 2 ^)~=~3n^-^1$ for $n^>=^1$ [CocL1, CocL2, Lor]
.IP (c)
$nK sub 3$ versus $mK sub 3$,
in particular $R(nK sub 3 ,^nK sub 3 ^)~=~5n$ for $n^>=^2$ [BES], see also section 4.1
.IP (d)
$nK sub 3$ versus $mK sub 4$ [LorMu]
.IP (e)
$nK sub 1,m$ versus $W sub 5$ [BaHA]
.IP (f)
$R(nK sub 4 ,^nK sub 4 ^)~=~7n^+^4$ for large $n$ [Bu8]
.IP (g)
Stripes $mP sub 2$ [CocL1, CocL2, Lor]
.IP (h)
$R(G,^H)$ for all disconnected isolate-free graphs $H$ on at most
6 vertices versus all $G$ on at most 5 vertices, except 3 cases [LoM5].
Missing cases were completed in [KroMe].
.IP (i)
$R(F,^G up 20 {size 7 union} ^H)~<=~ roman max
roman "{" ^R(F,^G)^+^n(H),~R(F,^G)^ roman "}"~$ [Par6]
.IP (j)
$R(mG,^nH)~<=~(m^-^1) n(G)~+~(n^-^1) n(H)~+~R(G,^H)~$ [BES],
.br
Formulas for $R(nK sub 3 ,^mG)$ for all
isolate-free graphs $G$ on 4 vertices [Zeng],
.br
Variety of results for numbers $R(nG,^mH)$ [Bu1, BES, HaBA2, SuBAU1].
.IP (k)
Disjoint unions of paths (linear forests) [BuRo2, FS2]
.br
Linear forests versus $3K sub 3 ^up 20 {size 7 union} ^2K sub 4~$ [SuBAU2]
.IP (l)
Forests versus $K sub n ~$ [Stahl, BaHA] and $W sub n ~$ [BaHA].
Generalizations to forests versus other graphs $G$
in terms of $chi (G)$ and the chromatic surplus of $G~$ [Biel4],
and for linear forests versus $2K sub n~$ [SuAM].
.IP (m)
Disconnected graphs versus other graphs [BE1, GoJa1]
.IP (n)
See section 4.1 for cases involving unions of cycles
.IP (o)
See also [Bu9, BE1, LorMu, MiSa, Den2, Biel1, Biel2]

.NH 2
General results for special graphs
.sp 0.3
.IP (a)
$R(K sub m sup p ,^K sub n sup q )
~=~R(K sub m ,^K sub n )$ for $m,~n^>=~3$,
$m^+~n^>=~8$, $p^<=~m/(n^-^1)$ and $q^<=~n/(m^-^1)$,
where $K sub s sup t$ is a $K sub s$
with additional vertex connected to it by $t$ edges [BEFS].
Some applications can be found in [BlLR].
.IP (b)
$R(K sub 2,k ,^G)~<=~kq ^+^ 1$, for $k^>=^2$, for isolate-free graphs $G$
with $q^>=^2$ edges [RoJa2].
.IP (c)
$R(W sub 6 ,^W sub 6 ^)~=~17$ and $chi (W sub 6 ^)~=~4^$ [FM]. This gives a
counterexample $G^=^W sub 6$ to the Erd\o'o\(hu's conjecture (see [GRS])
$~R(G,G)~>=~R(K sub { chi (G) } ,^K sub { chi (G) } ^)$, since $R(4,4)~=~18$.
.IP (d)
$R(G^+^K sub 1 ,^H)~<=~R(K sub {1,^R(G,^H)} ,^H)^$ [BE1].
.IP (e)
$R( K bar sub 2 ^+^G,^K bar sub 2 ^+^G)~<=~ 4R(G,^K bar sub 2 ^+^G)~-~2^$ [LiShen].
.IP (f)
Study of $R(G^+^K sub 1 ,^nH^+^K sub 1 )^$ [LinLD].
.IP (g)
$R(K sub up 20 {p^+^1},^B sub up 20 q sup down 20 r ^)~=~p(q^+^r^-^1)~+~1$
for generalized books
$B sub up 20 q sup down 20 r ~=~K sub up 20 r ^+~qK sub up 20 1$,
for sufficiently large $q^$ [NiRo1].
.IP (h)
Study of the cases $R(K sub m ,^K sub n ^-^K sub 1,s )$
and $R(K sub m ^-^e ,^K sub n ^-^K sub 1,s )$, with several
exact values for special parameters [ChaMR].
.IP (i)
Study of $R(T^+^K sub 1 ,^K sub n )$ for trees $T^$ [LiR1].
Asymptotic upper bounds for $R(T^+^K sub 2 ,^K sub n )^$
[Song7], see also [SonGQ].
.IP (j)
Bounds on $R(H^+^K bar sub n ,^K sub n )$ for general $H^$ [LiR3].
Also, for fixed $k$ and $m$, as $n -> ~inf$,
$R(K sub k ^+^K bar sub m ,^K sub n )~<=~
(m^+^o(1))^n sup {down 20 k} /^( roman log ^n) sup {down 20 k-1}^$ [LiRZ1].
.IP (k)
Asymptotics of $R(H^+^K bar sub n ,^K sub n )$. In particular,
the order of magnitude of $R(K sub {m,^n} ,^K sub n )$ is
$n sup {down 20 m+1} /^( roman log ^n) sup {down 20 m}^$ [LiTZ].
Upper asymptotics for $R(K sub s ^+^ K sub {m,^n} ,^K sub k )^$ [Song9].
.IP (l)
Study of the largest $k$ such that if the star $K sub {1,k}$
is removed from $K sub r$, $r~=~R(G,^H)$, any edge 2-coloring
of the remaining part still contains monochromatic $G$ or $H$,
as for $K sub r$, for various special $G$ and $H^$ [HoIs].
.IP (m)
Let $G ''$ be a graph obtained from $G$ by deleting two vertices with
adjacent edges. Then $R(G,^H)~<=~A+^B+^2^+^2^
down 15 sqrt up 15 {(^A sup down 15 2 ^+~AB^+~B sup down 15 2 ^)^/^3^}$,
where $A^=~R(G '',^H)$ and $B^=~R(G,^H '')$ [LiRZ2].

.NH 2
General results for sparse graphs
.sp 0.3
.IP (a)
$R(K sub n ,^T sub m )~=~(n-1)(m-1)^+^1$ for any tree $T sub m$
on $m$ vertices [Chv].
.IP (b)
Graphs yielding $R(K sub n ,^G)~=~(n-1)(n(G)^-^1)^+^1$,
called Ramsey $n$-good [BE3], and related results [EFRS5].
An extensive survey and further study of $n$-goodness
appeared in [NiRo4].
.IP (c)
$R(C sub 2m+1 ,^G)~=~2n^-^1^$ for sufficiently large
sparse graphs $G$ on $n$ vertices, little more complicated formulas
for $P sub 2m+1$ instead of $C sub 2m+1^$ [BEFRS2].
.IP (d)
$R(G,G)~<=~c sub d n(G)$ for all $G$, where constant $c sub d$
depends only on the maximum degree $d$ in $G^$ [CRST].
The constant was improved in [GRR1, FoxSu1]. Tight lower and upper
bounds for bipartite $G$ [GRR2, Con2].
Further improvements of the constant $c sub d$ in general
were obtained in [ConFS4], and for graphs
with bounded bandwidth in [AllBS].
.IP (e)
Study of $L$-sets, which are sets of pairs of graphs whose
Ramsey numbers are linear in the number of vertices.
Conjecture that Ramsey numbers grow linearly for $d$-degenerate
graphs (graph is $d$-degenerate if all its subgraphs have minimum
degree at most $d$) [BE1].
Progress towards this conjecture was obtained by several authors,
including [KoR\o'o\(:a'1, KoR\o'o\(:a'2, KoSu, FoxSu1, FoxSu2].
.IP (f)
$R(G,G)~<=~c sub d n$ for all $d$-arrangeable graphs $G$
on $n$ vertices, in particular with the same constant for
all planar graphs [ChenS].
The constant $c sub d$ was improved in [Eaton].
An extension to graphs not containing a subdivision of $K sub d^$
[R\o'o\(:a'Th].
.IP (g)
Conjecture that $R(G,G)~<=~12 n(G)$ for all planar $G$,
for sufficiently large $n^$ [AllBS].
.IP (h)
Ramsey numbers grow linearly for degenerate graphs versus
some sparser graphs, arrangeable graphs, crowns, graphs with
bounded maximum degree, planar graphs, and graphs without
any topological minor of a fixed clique [Shi3].
.IP (i)
Discussion of various old and new classes of Ramsey
linear graphs [NeOs].
.IP (j)
Study of graphs $G$, called
.I
Ramsey size linear,
.R
for which there exists a constant $c sub G$ such that for all
$H$ with no isolates $R(G,^H)~<=~c sub G e(H)^$ [EFRS9].
An overview and further results were given in [BaSS].
.IP (k)
$R(G,^G)~<~6 n$ for all $n$-vertex graphs $G$, in which no two vertices
of degree at least 3 are adjacent [LiRS].
This improves the result
$R(G,^G)~<=~12 n$ in [Alon1]. In an early paper by Burr and Erd\o'o\(hu's
[BE1] it was proved that if any two points of degree at least 3
are at distance at least 3 then $R(G,^G)~<=~18 n$.
.IP (l)
$R(G sub a,b ,^G sub a,b )~=~(3/^2^+^o(1))ab$,
where $G sub a,b$ is the rectangular $a times ^b$ grid graph.
Other similar results follow for bipartite planar graphs with
bounded degree and grids of higher dimension [MoSST].
.sp 0.1
.IP (m)
$R(Q sub n ,^Q sub n )~<=~2 sup down 5 {(3^+^ sqrt{5})n/^2^+^o(n)}$,
for the $n$-dimensional hypercube $Q sub n$ with $2 sup down 20 n$
vertices [Shi1].
This bound can also be derived from a theorem in [KoR\o'o\(:a'1].
An improvement was obtained in [Shi4], and a further one to
$R(Q sub n ,^Q sub n )~<=~2 sup down 5 {2n+^5} n$ in [FoxSu1].
A lower bound construction for
$12~<=~R(Q sub 3 ,^Q sub 3 )^$ was presented in [HaKr2].
.IP (n)
$R(K sub m ,^Q sub n )~=~(m^-^1)(2 sup n ^-^1)^+^1^$
for every fixed $m$ and sufficiently large $n^$ [FizGMSS].
.IP (o)
Conjecture that $R(G,G)~=~2n(G)^-^1$ if $G$ is unicyclic
of odd girth [Gros1].
Further support for the conjecture was given in [K\o'o\(:a'h, KrRod].
.IP (p)
See also earlier subsections 5.* for various specific sparse graphs.

.NH 2
General results
.sp 0.5
.IP [CH2] 0.65i
$R(G,^H)~>=~ (^ chi (G)^-^1)(c(H)^-^1)^+^1$, where $chi (G)$ is the
chromatic number of $G$,
and $c(H)$ is the size of the largest connected component of $H$.
.IP [CH3] 0.65i
$R(G,^G)~>~ (s2 sup down 20 {^e(G)^-^1)}^) sup down 15 {^1^/^n(G)}^$,
where $s$ is the number of automorphisms of $G$. Hence
$R(K sub n,n ,^K sub n,n ^)~>~2 sup down 15 {^n}$,
see also item 6.7.i.
.IP [BE2]
$R(G,^G)~>=~^ {down 8 \(lf} (4n(G)^-^1) ^/^3 {down 8 \(rf}$
for any connected $G$, and $R(G,^G)~>=~2n^-^1$
for any connected nonbipartite $G$. These bounds can be achieved
for all $n^>=~4$.
.IP [Bu2]
Graphs $H$ yielding $R(G,^H)~=~( chi (G) ^-^1)(n(H)^-^1)^+^s(G)$,
where $s(G)$ is a chromatic surplus of $G$, defined as the minimum
number of vertices in some color class under all vertex colorings
in $chi (G)$ colors (such $H$'s are called $G$-good). This idea,
initiated in [Bu2], is a basis of a number of exact results for $R(G,^H)$
for large and sparse graphs $H$ [BG, BEFRS2, BEFRS3, Bu5, FS, EFRS4, FRS3,
BEFSRGJ, BF, LiR4, Biel2, SuBAU3, Song6, AllBS].
Surveys of this area appeared in [FRS5, NiRo4].
.IP [BaLS]
Graph $G$ is Ramsey saturated if $R(G^+^e,^G^+^e)~>~R(G,^G)$
for every edge $e$ in $G bar$. This paper contains several
theorems involving cycles, cycles
with chords and trees on Ramsey saturated and unsaturated graphs,
and also seven conjectures including one stating that
almost all graphs are Ramsey unsaturated.
Some classes of graphs were proved to be Ramsey unsaturated [Ho].
Special cases involving
cycles and Jahangir graphs were studied in [AliSur].
.IP [F\o'u\(:a'r]
Relations between $R(3,^k)$ and graphs with large $chi (G)$.
Further detailed study of the relation between $R(3,^k)$
and the chromatic gap [GySeT].
.IP [Bra3]
$R(G,^H) ~>~h(G,^d)^n(H)$ for all nonbipartite $G$ and almost
every $d$-regular $H$, for some $h$ unbounded in $d$.
.IP [DoLL1]
Lower asymptotics of $R(G,^H)$ depending on the average degree of $G$
and the size of $H$. This continues the study initiated in [EFRS5],
later much enhanced for both lower and upper bounds in [Sud3].
.IP [LiZa1]
Lower bound asymptotics of $R(G,^H)$ for large dense $H$.
.sp 0.3
.IP [Erd4]
A conjecture posed by Erd\o'o\(hu's in 1983 that
there exists a constant $c$ such that
$R(G,^G)~<=~2 sup down 5 {^c down 10 sqrt {^e(G)}} ~$
for all isolate-free graphs $G$.
Discussion of this conjecture and partial results,
proof for bipartite graphs and progress in other cases
are included in [AlKS].
In 2011, Sudakov [Sud4] completed the proof of this
conjecture. An extension of the latter to some off-diagonal
cases is presented in [MaOm], and an improvement of
the constant for bipartite graphs is given in [JoPe].
For the multicolor case see item 6.7.i.
.sp 0.3
.IP [Kriv]
Lower bound on $R(G,^K sub n )$ depending on the density of
subgraphs of $G$. This construction for $G^=~K sub m$
produces a bound similar to the best known probabilistic lower
bound by Spencer [Spe2]. Further lower and upper bounds on
$R(G,^K sub n )$ in terms of $n$ and
$e(G)^$ can be found in [Sud3].
.IP [Con3]
Upper bounds on $R(G,^K sub n )$ for dense graphs $G$.
.IP [BE1]
Relations between the cases of
$G$ or $G ^+^ K sub 1$ versus $H$ or $H ^+^ K sub 1$.
.IP [HaKr1]
Study of cyclic graphs yielding lower bounds for Ramsey numbers.
Exact formulas for paths and cycles, and values for
small complete graphs and for graphs with up to five vertices.
.sp .5
.IP [Par3]
Relations between some Ramsey graphs and block designs. See also [Par4].
.IP [Li2]
Relations between the Shannon capacity of noisy communication
channels and graph Ramsey numbers. See also section 6 in [Ros2], and [XuR3].
.IP [Bu6]
Given integer $m$ and graphs $G$ and $H$, determining whether
$R(G,^H)~<=~m$ holds is NP$^-^$hard. Further complexity results related
to Ramsey theory were presented in [Bu10].
.IP [Scha]
Ramsey arrowing is $PI sub {^2} sup up 20 p ^-^$complete,
a rare natural example
of a problem higher than NP in the polynomial hierarchy
of computational complexity theory.
.IP [-]
Special cases of multicolor results listed in section 6.
.IP [-]
See also surveys listed in section 8.

.EQ
delim $$
define not= '= back 40 /^'
gsize 12
.EN
.nr PS 12
.nr VS 15
.ds CH
.ds CF - \\n% -
.nr LL 6.5i
.ds RH "\s10T\s-2HE\s0 E\s-2LECTRONIC\s0 J\s-2OURNAL OF\s0 C\s-2OMBINATORICS\s0 (2014), DS1\s-2.14
.bp

.EQ
define not= '= back 38 /^'
.EN

.LP
.NH
Multicolor Ramsey Numbers
.sp
.DS L
The only known value of a multicolor classical Ramsey number:

	$R sub 3 (3) ~=~ R(3,3,3)~=~R(3,3,3^;^2)~=~17$					[GG]

	2 critical colorings (on 16 vertices)					[KaSt, LayMa]
	2 colorings on 15 vertices						[Hein]
	115 colorings on 14 vertices						[PR1]
.DE
.sp
.NH 2
Bounds for classical numbers
.sp
.LP
General upper bound, implicit in [GG]:
.EQ (a)
R(k sub 1 ,^. ..^,^k sub r )~^<=^~ 2 ~-~ r ~+~
up 8 sum from {up 30 {i^=^1}} to {down 1 r}
R(k sub 1 ,^. ..^,^k sub {i-^1} ,^k sub i ^-^1,^
k sub {i+^1} ,^. ..^,^k sub r )
.EN
.sp .5
.LP
Inequality in (a) is strict if the right hand side is even and
at least one of the terms in the summation is even.
It is suspected that this upper bound is never tight for
$r ^>=~3$ and $k sub i ^>=~3$, except for $r^=~k sub 1 ^=~k sub 2 ^=~k sub 3 ^=~3$.
However, only two cases are known to improve over (a), namely
$R sub 4 (3)~<=~62$ [FKR] and $R(3,3,4)~<=~31$ [PR1, PR2],
for which (a) produces the bounds of 66 and 34, respectively.
.sp
.LP
\fBDiagonal Cases\fP
.nr PS 10
.nr VS 12
.LP
.TS
box center tab(,);
cp8 cp8 || rp8 | rp8 | rp8 | rp8 | rp8 | rp8 | rp8 .
,$size 8 m$,$~ size 8 3$,4,5,6,7,8,9
\fIr\fP
=
3,,17,128,417,1070,3214,6079,13761
\^,,GG,HiIr,Ex16,Mat,XuR1,XSR2,XXER
_
4,,51,634,3049,15202,62017
\^,,Chu1,XXER,Xu,XXER,XXER
_
5,,162,3416,26912
\^,,Ex10,XXER,Xu
_
6,,538
\^,,FreSw
_
7,,1682
\^,,FreSw
.TE
.nr PS 12
.nr VS 15
.LP
.DS C
Table X. Known nontrivial lower bounds for diagonal multicolor
Ramsey numbers $R sub r (m)$, with references.
.DE
.sp
The best published bounds corresponding to the entries
in Table X marked as personal communications [Ex16] and [Xu]
are $415~<=~R sub 3 (5)$, $2721~<=~R sub 4 (5)$ and
$26082~<=~R sub 5 (5)$ [XXER].
.sp 2
The most studied and intriguing open case is
.DS L
			[Chu1]    $51~<=~R sub 4 (3)~=~R(3,3,3,3)~<=~62$    [FKR]
.DE
The construction for $51~<=~R sub 4 (3)$ as described in [Chu1] is correct,
but be warned of a typo found by Christopher Frederick in 2003
(there is a triangle (31,7,28) in color 1 in the displayed matrix).
The inequality 6.1.a implies $R sub 4 (3)~<=~66$, Folkman [Fol] in 1974
improved this bound to 65, and S\o'a\(aa'nchez-Flores [San] in 1995
proved $R sub 4 (3)~<=~64$.
.PP
The upper bounds in
$162~<=~R sub 5 (3)~<=~307$,
$538~<=~R sub 6 (3)~<=~1838$,
$1682~<=~R sub 7 (3)~<=~12861$,
$128~<=~R sub 3 (4)~<=~236$ and
$634~<=~R sub 4 (4)~<=~6474$
are implied by 6.1.a (we repeat lower bounds
from Table X just to see easily the ranges).
All the latter and other upper bounds obtainable from known smaller bounds
and 6.1.a can be computed with the help of a LISP program written
by Kerber and Rowat [KerRo].
.sp 2
\fBOff-Diagonal Cases\fP
.sp
.LP
Three colors:
.nr PS 10
.nr VS 12
.LP
.TS
box center tab(,);
cp8 cp8 || rp8 | rp8 | rp8 | rp8 | rp8 | rp8 | rp8 | rp8 | rp8 | rp8 | rp8 .
,$size 8 m$,$~ size 8 4$,5,6,7,8,9,10,11,12,13,14
\fIk\fP
=
3,,30,45,60,85,103,129,147,162,185,212,233
\^,,Ka2,Ex2,Rob3,Ex18,Ex18,Ex18,Ex18,Ex18,6.2.f,LSS2,6.2.f
_
4,,55,89,117,145,193,229
\^,,KLR,Ex17,Ex17,Ex17,6.2.f,6.2.f
_
5,,89,139,181,237
\^,,Ex17,Ex17,Ex17,6.2.f
.TE
.nr PS 12
.nr VS 15
.LP
.DS C
Table XI. Known nontrivial lower bounds for 3-color
Ramsey numbers of the form $R(3,^k,^m)$, with references.
.DE
.sp
In addition, the bounds $303~<=~R(3,6,6)$, $609~<=~R(3,7,7)$ and
$1689~<=~R(3,9,9)$ were derived in [XXER] (used there for building
other lower bounds for some diagonal cases).
.sp
.PP
The other most studied, and perhaps the only open case of a classical
multicolor Ramsey number, for which we can anticipate exact evaluation
in the not-too-distance future is
.DS L
			[Ka2]    $30~<=~R(3,3,4)~<=~31$    [PR1, PR2]
.DE
.PP
In [PR1] it is conjectured that $R(3,3,4)~=~30$, and the results in
[PR2] eliminate some cases which could give $R(3,3,4)~=~31$.
The upper bounds in
$45~<=~R(3,3,5)~<=~57$,
$55~<=~R(3,4,4)~<=~79$, and
$89~<=~R(3,4,5)~<=~160$
are implied by 6.1.a. We repeat lower bounds
from Table XI to show explicitly the current ranges.
.bp
.LP
Four colors:
.DS L
	$~^97~<=~R(3,3,3,4)~<=~~^153$					[Ex17], 6.1.a
	$171~<=~R(3,3,4,4)~<=~~^462$					[Ex15, XXER], 6.1.a
	$381~<=~R(3,4,4,4)~<=~1619$					6.2.j, 6.1.a

	$162~<=~R(3,3,3,5)$							[XXER]
	$565~<=~R(3,3,3,11)$							6.2.f
	$681~<=~R(3,4,5,5)$							[XXER]
.DE
.sp
.PP
Lower bounds for higher numbers can be obtained by
using general constructive results from section 6.2 below.
For example, the bounds $261~<=~R(3,3,15)$
and $247 ~<=~ R(3,3,3,7)$ were not published explicitly but are
implied by 6.2.f and 6.2.g, respectively.
.sp
.NH 2
General results for complete graphs
.sp
.IP (a) 0.35i
$R(k sub 1 ,^. ..^,^k sub r )~^<=^~ 2 ~-~ r ~+~
up 8 sum from {up 30 {i^=^1}} to {down 1 r}
R(k sub 1 ,^. ..^,^k sub {i-^1} ,^k sub i ^-^1,^
k sub {i+^1} ,^. ..^,^k sub r )~$ [GG].
.sp -.3
.IP (b) 0.35i
$R sub r (3)~>=~3R sub {r-^1} (3) ~^+~^R sub {r-^3} (3) ~-~3~$ [Chu1].
.sp .2
.IP (c)
$R sub up 5 r (m) ~>=~c sub up 5 m (2m^-^3) sup r$,
and some slight improvements of this bound for small values
of $m$ were described in [AbbH, Gi1, Gi2, Song2]. For $m~=~3$,
the best known lower bound is
$R sub r (3)~>=~(3.199 ...) sup {^r}^$ [XXER].
.IP (d)
$R sub r (3)~<=~r! (e^-~e sup {-^1}^+^3^)^/^2~approx ~2.67 r!~$ [Wan],
which improves the classical $3r!~$ [GRS].
.IP (e)
The limit $L~=~lim from {r -> ^inf} ~R sub r (3) sup {1/r}$ exists,
though it can be infinite [ChGri].
.br
It is known that
$3.199~<~L$, as implied by (c) above.
For more related results, mostly on the asymptotics
of $R sub r (3)^$, see [AbbH, Fre, Chu2, GRS, GrR\o'o\(:a'].
.sp .4
.IP (f) 0.35i
$R(3,^k,^l)~>=~ 4R(k,^l^-^1)~-~3^$ for $k^>=~3, ~l^>=~5$, and in general for
$r^>=~2$ and $k sub i ^>=~2$ it holds
.sp .2
$R(3,^k sub 1 ,^. ..^,^k sub r )~>=~ 4
R(k sub 1 ^-^1,^k sub 2 ,^. ..^,^k sub r ) ~-~3~$
for $^k sub 1 ^>=~5$, and
.sp .2
$R(k sub 1 ,^2k sub 2 ^-^1,^k sub 3 ,^. ..^,^k sub r )~>=~ 4
R(k sub 1 ^-^1,^k sub 2 ,^. ..^,^k sub r ) ~-~3~$ for
$^k sub 1 ^>=~5~$ [XX2, XXER].
.sp .2
.IP (g) 0.35i
$R(3,^3,^3,^k sub 1 ,^. ..^,^k sub r )~>=~ 3 R(3,^3,^k sub 1 ,^. ..^,^k sub r ) ~
+~ R(k sub 1 ,^. ..^,^k sub r ) ~-~3~$ [Rob2].
.IP (h)
For $r^+^1$ colors, avoiding $K sub 3$ in the first $r$ colors and
avoiding $K sub m$ in the last color,
$R(3,^. ..^,^3,^m )~<=~r!^m sup {r+^1} ^$ [S\o'a\(aa'r].
.sp .4
.IP (i) 0.35i
$R(k sub 1 ,^. ..^,^k sub r )~>=~ 
S(k sub 1 ,^. ..^,^k sub r )~+~2$,
where $S(k sub 1 ,^. ..^,^k sub r )$ is the generalized Schur number
[AbbH, Gi1, Gi2]. In particular, the special
case $k sub 1 ^=^ . ..^=^k sub r ^=^3$ has been widely studied
[Fre, FreSw, Ex10, Rob3].
.IP (j) 0.35i
$R(k sub 1 ,^. ..^,^k sub r )~>=~
L(k sub 1 ,^. ..^,^k sub r )~+~1$,
where $L(k sub 1 ,^. ..^,^k sub r )$
is the maximal order of any cyclic $(k sub 1 ,^. ..^,^k sub r )-$coloring,
which can be considered a special case of Schur partitions defining
(symmetric) Schur numbers. Many lower bounds for Ramsey numbers were
established by cyclic colorings. The following recurrence
can be used to derive lower bounds for higher parameters.
For $k sub i ~>= ~3^$ [Gi2],
.EQ
L(k sub 1 ,^. ..^,^k sub r ,^k sub {r+^1}^ )~>=~
(2k sub {r+^1} ^-~3)L(k sub 1 ,^. ..^,^k sub r ) ~-~k sub {r+^1} ~+~2.
.EN
.IP (k) 0.35i
$R sub r (m) ~>= ~^p^+^1$ and
$R sub r (m^+^1) ^>= ~r(^p^+^1)^+^1$ if there exists a $K sub m -$free
cyclotomic $r-^$class association scheme of order $p~$ [Mat].
.IP (l)
If the quadratic residues Paley graph $Q sub p$ of prime
order $p^=~4t^+^1$ contains no $K sub k$, then
$R(s,^k^+^1,^k^+^1) ~>=~4ps^-^6p^+^3~$ [XXER].
.IP (m)
$R sub r (^pq^+^1) ~>~ (R sub r (^p^+^1)^-^1)(R sub r (q^+^1)^-^1)~$ [Abb1]
.IP (n)
$R sub r (^pq^+^1) ~>~ R sub r (^p^+^1)(R sub r (q^+^1)^-^1)~~$ for $p~>=~q$  [XXER]
.IP (o)
$R(^p sub 1 q sub 1 +^1,^. ..^,^p sub r q sub r +^1)~>~
(R(^p sub 1 +^1,^. ..^,^p sub r +^1) ^-^1)
(R(q sub 1 +^1, ^. ..^,^q sub r +^1) ^-^1)$ [Song3]
.IP (p)
$R sub {r+^s} (m) ~>~ (R sub r (m)^-^1)(R sub s (m)^-^1)~$ [Song2]
.IP (q)
$R(k sub 1 ,^k sub 2 ,^. ..^,^k sub r )~>~
(R(k sub 1 ,^. ..^,^k sub i ) ~-~1)
(R(k sub i+1 ,^. ..^,^k sub r ) ~-~1)~$ in [Song1], see [XXER].
.IP (r)
$R(k sub 1 ,^k sub 2 ,^. ..^,^k sub r )~>~ (k sub 1 ~+~1)
(R(k sub 2 ~-~k sub 1 ~+~1,^k sub 3 ,^. ..^,^k sub r ) ~-~1)~$ [Rob4]
.IP (s)
Further lower bound constructions, though with more complicated
assumptions, were presented in [XX2, XXER].
.IP (t)
Grolmusz [Grol1] generalized the classical constructive lower
bound by Frankl and Wilson [FraWi] (item 2.3.6) to more colors
and to hypergraphs [Grol3] (item 7.4.k).
.IP (u)
Exact asymptotics of a very special but important case
is known, namely $R(3,^3,^n )~=~THETA (n sup 3 roman {^poly-log} ^n )~$
[AlR\o'o\(:a']. For general upper bounds and more asymptotics
see in particular [Chu4, ChGra2, ChGri, GRS, GrR\o'o\(:a'].
.sp .5
.PP
All lower bounds in (b) through (t) above are constructive.
Item (g) generalizes (b), (o) generalizes both (m) and (q), and (q) generalizes (p).
(n) is stronger than (m). Finally, we note
that the construction in (o) with
$q sub 1 ^=^. ..^=^q sub i ^=^1^=~p sub i+1 ^=^. ..^=~p sub r$
is the same as (q).
.sp .7
.NH 2
Cycles
.LP
Note:
The paper \fI Ramsey Numbers Involving Cycles\fP [Ra4]
is based on the revision #12 of this survey. It collects
and comments on the results involving cycles versus any
graphs, in two or more colors. It contains some more details
than this survey, but only until 2009.
.sp .3
.NH 3
Three colors
.IP (a)
One long cycle.
.sp .3
The first larger paper in this area by Erd\o'o\(hu's, Faudree, Rousseau
and Schelp [EFRS1] appeared in 1976. It gives several formulas and
bounds for $R(C sub m ,^C sub n ,^C sub k )$ and
$R(C sub m ,^C sub n ,^C sub k ,^C sub l )$ for large $m$.
For three colors [EFRS1] includes:
.sp .2
	$R(C sub m ,^C sub {2p+1} ,^C sub {2q+1} )~=~4m-~3~$ for $p^>=^2,~q^>=^1$,
.sp .1
	$R(C sub m ,^C sub {2p} ,^C sub {2q+1} )~=~2(m+~p)^-~3~$ and
.sp .1
	$R(C sub m ,^C sub {2p} ,^C sub {2q} )~=~m^+~p^+^q^-^2~$ for $p,~q^>=^1~$
and large $m$.

.nr PS 10
.nr VS 10
$gsize 8$
.LP
.TS
box center tab(;);
cp8 | cp8  rp8 | lp8 .
.sp .2
$m~n~k$;$R(C sub m ,^C sub n ,^C sub k )$;references;general results
.sp .2
=
.sp .2
\fB3 3 3;17\fP;GG;page 36
3 3 4;17;ExRe;
3 3 5;21;Sun1+/Tse3;$5k^-^4$ for $k^>=^5,~m^=^n^=^3~$ [Sun1+]
3 3 6;26;Sun1+;
3 3 7;31;Sun1+;
_
3 4 4;12;Schu;
3 4 5;13;Sun1+/Rao/Tse3;
3 4 6;13;Sun1+/Tse3;
3 4 7;15;Sun1+/Tse3;
_
3 5 5;$>=^17$;Tse3;
3 5 6;21;Sun1+;
3 5 7;25;Sun1+;
_
3 6 6;;;
3 6 7;21;Sun1+;
3 7 7;;;
.sp .2
=
.sp .2
\fB4 4 4;11\fP;BiaS;
4 4 5;12;Sun2+/Tse3;
4 4 6;12;Sun2+/Tse3;$k^+^2$ for $k^>=^11,~m^=^n^=^4~$ [Sun2+]
4 4 7;12;Sun2+/Tse3;values for $k^=^8,^9,^10$ are 12, 13, 13 [Sun2+]
_
4 5 5;13;Tse3;
4 5 6;13;Sun1+;
4 5 7;15;Sun1+;
_
4 6 6;11;Tse3;
4 6 7;13;Sun1+/Tse3;
4 7 7;
.sp .2
=
.sp .2
\fB5 5 5;17\fP;YR1;
5 5 6;21;Sun1+;
5 5 7;25;Sun1+;
5 6 6;;;
5 6 7;21;Sun1+;
5 7 7;
.sp .2
=
.sp .2
\fB6 6 6;12\fP;YR2;$R sub 3 ^(C sub 2q )~>=~4q$ for $q^>=~2~$ [DzNS]
6 6 7;15;Sun1+;see 6.3.1.a for larger parameters
6 7 7;;;see 6.3.1.a for larger parameters
\fB7 7 7;25\fP;FSS2;$R sub 3 ^(C sub 2q+1 ^)~=~8q^+^1$ for large $q~$ [KoSS1, KoSS2]
.sp .2
=
.sp .2
\fB8 8 8;16\fP;Sun/SunY;$R sub 3 ^(C sub 2q )~=~4q$ for large $q~$ [BenSk]
.TE
.nr PS 12
.nr VS 15
$gsize 12$
.DS C
Table XII. Ramsey numbers $R(C sub m ,^C sub n ,^C sub k )~$ for $m,^n,^k~<=~7$ and $m^=~n^=~k^=~8$;
Sun1+ abbreviates SunYWLX, Sun2+ abbreviates SunYLZ2,
the work in [SunYWLX] and [SunYLZ2] is independent from [Tse3].
.DE

.sp 1.5
.IP (b)
Triple even cycles.
.sp .3
$R sub 3 ^(C sub 2m )~>=~4m$ for all $m^>=~2~$ [DzNS], see also 6.3.2.d/e/f.
It was proven that
$R(C sub n ,^C sub n ,^C sub n )~=~(2^+^o(1))^n$ for even $n$ [Fi\(L/u1, GyRSS],
which was improved to exactly $2n$, for large $n$, by Benevides and Skokan [BenSk].
In 2005, Dzido [Dzi1] conjectured that
$R sub 3 (C sub 2m )~=~4m$ for all $m^>=~3$.
The first open case is for $R sub 3 (C sub 10 )$, known to be at least 20.
A more general result holds for slightly off-diagonal cases [Fi\(L/u1]:
.sp 2
.I
$~~R(C sub {2^ down 10 \(lf alpha sub 1 n down 10 \(rf}^ ,
^C sub {2^ down 10 \(lf alpha sub 2 n down 10 \(rf}^ ,
^C sub {2^ down 10 \(lf alpha sub 3 n down 10 \(rf}^ )~=~$
.br
                $(^ alpha sub 1 ~+~alpha sub 2 ~+~alpha sub 3
~+~max roman "{" alpha sub 1 ,^alpha sub 2 ,^alpha sub 3 roman "}" ~+~ o(1))^n,~$
for all $~alpha sub 1 ,^alpha sub 2 ,^alpha sub 3 ^>^0$.
.br
.R
.sp .5
The conjectured equality $R sub 3 (C sub 2m )~=~4m$,
whenever true, implies $R sub 3 (P sub 2m+1 )~=~4m^+^1~$ [DyDR]
(see also section 6.4).
.sp
.IP (c)
Triple odd cycles.
.sp .2
Bondy and Erd\o'o\(hu's conjectured that
$R(C sub n ,^C sub n ,^C sub n )~<=~4n^-^3$ for all
$n~>=~4$ (see for example [Erd2]).
If true, then for all odd $n~>=~5$ we have
$R(C sub n ,^C sub n ,^C sub n )~=~4n^-^3$.
The first open case is for $R sub 3 (C sub 9 )$,
known to be at least 33. Erd\o'o\(hu's [Erd3] and other
authors credit this conjecture to Bondy and Erd\o'o\(hu's,
often pointing to a 1973 paper [BoEr]. Interestingly, however,
the conjecture is not mentioned in this paper.
.sp .2
\(L/uczak proved that
$R(C sub n ,^C sub n ,^C sub n )~<=~(4^+^o(1))^n$,
with equality for odd $n$ [\(L/uc].
The result
$R sub 3 (C sub 2m+1 ^)~=~8m^+^1$ for all sufficiently
large $m$, or equivalently
$R(C sub n ,^C sub n ,^C sub n )~=~4n^-^3~$ for large odd $n$,
was announced with an outline of the proof by Kohayakawa,
Simonovits and Skokan [KoSS1], followed by the full proof in [KoSS2].
.sp .3
.IP (d)
$R(C sub 3 ,^C sub 3 ,^C sub k )~=~5k^-~4$
for $k^>=~5~$ [SunYWLX], and $R(C sub 4 ,^C sub 4 ,^C sub k )~=~k^+^2$
for $k^>=~11~$ [SunYLZ2]. All exceptions to these formulas for small
$k$ are listed in Table XII.
.IP (e)
Asymptotics for triples of cycles of mixed parity similar in form
to (b) [Fi\(L/u2].
.IP (f)
Almost all of the off-diagonal cases in Table XII required
the use of computers.

.NH 3
More colors
.nr PS 10
.nr VS 12
$gsize 8$
.LP
.TS
box center tab(,);
cp8 cp8 || rp8 | rp8 | rp8 | rp8 | rp8 | rp8 .
,$m$,3,$~~~4$,$~~~5$,$~~~6~$,$~~~7~$,$~~~8~$
$k$,
.sp .1
=
.sp .1
3,,17,11,17,12,25,16
\^,,\^,\^,\^,\^,\^,\^
_
4,,51,18,33,18,49,20
\^,,62,\^,158,20
_
5,,162,27,65,26,97,28
\^,,307,29,,\^
_
6,,538,32,129,,193
\^,,1838,43
.TE
.nr PS 12
.nr VS 15
$gsize 12$
.DS C
Table XIII. Known values and bounds for $R sub k (C sub m )$ for small $k,^m$;
.DE

.IP (a)
For the entries in the row $k~=~3$ and in the column $m~=~3$ in Table XIII,
more details and all corresponding references are
in sections 6.3.1 and 6.1, respectively. The lower bounds for $m~=~5,^7$
are implied by 6.3.2.k,
$R sub k (C sub m )~<=~158$ follows from 6.3.2.j,
and references to other cases with
$k,^m^>=~4$ can be found below in this section.

.DS L
		$R sub 4 (C sub 4 ^) ~=~ 18$						[Ex2] [SunYLZ1]
	$18 ^<=$	$R sub 4 (C sub 6 ^) ~<=~ 20$						[SunYJLS][ZhaSW]
	$27 ^<=$	$R sub 5 (C sub 4 ^) ~<=~ 29$						[LaWo1]
		$R sub 5 (C sub 6 ^) ~=~ 26$						[SunYJLS] [SunYW]
.DE
.sp -.6
.DS L
	$24~<=~R(C sub 3 ,^C sub 4 ,^C sub 4 ,^C sub 4 ^)~<=~27$					[DyDz1] [XuR2]
	$30~<=~R(C sub 3 ,^C sub 3 ,^C sub 4 ,^C sub 4 ^)~<=~36$					[DyDz1] [XuR2]
	$49~<=~R(C sub 3 ,^C sub 3 ,^C sub 3 ,^C sub 4 ^)$						6.7.e
.DE
.sp -.6
.DS L
	$18~<=~R(C sub 4 ,^C sub 6 ,^C sub 6 ,^C sub 6 ^)~<=~20$					[ZhaSW]
	$18~<=~R(C sub 4 ,^C sub 4 ,^C sub 6 ,^C sub 6 ^)~<=~20$					[ZhaSW]
	$~~~~~^~R(C sub 4 ,^C sub 4 ,^C sub 4 ,^C sub 6 ^)~=~19$					[ZhaSW]
.DE
.IP (b)
$R sub k (C sub 4 ^) ~<=~k sup {down 20 2} ^+~k^+^1$ for all $k~>=^1$,
$R sub k (C sub 4 ^) ~>=~k sup {down 20 2} ^-~k^+~2$ for all $k~-~1$ which is
a prime power [Ir, Chu2, ChGra1], and $R sub k (C sub 4 ^) ~>=~^k sup {down 20 2} ^+~2$
for odd prime power $k$ [LaWo1]. The latter was extended to any prime power
$k$ in [Ling, LaMu].
.IP (c)
Formulas for $R(C sub m ,^C sub n ,^C sub k ,^C sub l )$ for large $m~$ [EFRS1].
.sp .5
.LP
Bounds in (d) through (i) below cover different situations
and each is best in some respect.
.IP (d)
$R sub k (C sub 2m ^)~>=~(k^+^1)m^$ for odd $k$ and $m^>=~2$, and
.br
$R sub k (C sub 2m ^)~>=~(k^+^1)m^-^1^$ for even $k$ and $m^>=~2~$ [DzNS].
.IP (e)
$R sub k (C sub 2m ^)~>=~2(k^-^1)(m^-^1)~+~2~$ [SunYXL].
.IP (f)
$R sub k (C sub 2m ^)~>=~k sup 2 ~+~2m~-~k$
for $2m~>=~k^+^1$ and prime power $k~$ [SunYJLS].
.IP (g)
$R sub k (C sub 2m ^)~=~ THETA (k sup {m/(m^-^1)})~$
for fixed $m~=~2,^3$ and $5~$ [LiLih].
.IP (h)
$R sub k (C sub 2m ^)~<=~201km~$ for $^k~<=~10^ sup m / ^201m~$ [EG].
.IP (i)
$R sub k (C sub 2m ^)~<=~2km ~+~o(m)~$ for all fixed $k^>=~2~$ [\(L/ucSS].
.sp .4
.IP (j)
$R sub k (C sub 5 ^)~<~ down 10 sqrt {up 10 18 sup {down 5 k} up 5 k!}^/10~$ [Li4].
.IP (k)
$2 sup down 17 k m ~<~ R sub k (C sub {2m+1} ^)~<=~ (k^+^2)! (2m^+^1)~$ [BoEr].
.sp .1
Better upper bound $R sub k (C sub {2m+1} ^)~<~2(k^+^2)! m^$ was obtained in [EG].
.sp .1
Much better upper bound
$R sub k (C sub {2m+1} ^)~<=~ (c sup k k!) sup {1/m}$,
for some positive constant $c$,
.br
if all Ramsey-critical colorings for $C sub {2m+1}$
are not far from regular, was obtained in [Li4].
.IP (l)
Conjecture that
$R sub k (C sub {2m+1} ^)~=~2 sup k m ~+~1$ for all $m~>=~2$
was credited
by several authors to Bondy and Erd\o'o\(hu's [BoEr], though
only lower bound, not the conjecture, is in this paper.
.IP (m)
$R(C sub n ,^C sub {l sub 1} ,^. ..^,^C sub {l sub k} ^) ~=~
2 sup k (n^-^1) ~+~1~$
for all $l sub i$'s odd with $l sub i ~>~2 sup i$,
and sufficiently large $n$, and support for the conjecture that
$R sub k (C sub n )~=~2 sup {k-1} (n^-^1) ~+~1$ for large odd $n~$ [AllBS].
.IP (n)
$R sub k (C sub {2m+1} ^)~<=~k2 sup k (2m^+^1) ~+~o(m)~$
for all fixed $k^>=~4~$ [\(L/ucSS].
.sp .3
.IP (o)
Asymptotic bounds for $R sub k (C sub n ^)~$ [Bu1, GRS, ChGra2, Li4, LiLih, \(L/ucSS].
.IP (p)
Survey of multicolor cycle cases [Li3].
.sp .7
.NH 3
Cycles versus other graphs
.sp .2
.IP (a)
Some cases involving $C sub 4$:
.DS L
	$20~<=~R(C sub 4 ,^C sub 4 ,^K sub 4 ^)~<=~22$					[DyDz1] [XSR1]
	$27~<=~R(C sub 3 ,^C sub 4 ,^K sub 4 ^)~<=~32$					[DyDz1] [XSR1]
	$52~<=~R(C sub 4 ,^K sub 4 ,^K sub 4 ^)~<=~72$					[XSR1]
	$34~<=~R(C sub 4 ,^C sub 4 ,^C sub 4 ,^K sub 4 ^)~<=~50$					[DyDz1] [XSR1]
	$43~<=~R(C sub 3 ,^C sub 4 ,^C sub 4 ,^K sub 4 ^)~<=~76$					[DyDz1] [XSR1]
	$87~<=~R(C sub 4 ,^C sub 4 ,^K sub 4 ,^K sub 4 ^)~<=~179$					[XSR1]
.DE
.DS L
	$R(K sub 1,3 ,^C sub 4 ,^K sub 4 ^)~=~16$						[KlaM2]
	$R(C sub 4 ,^C sub 4 ,^K sub 4 ^-^e^)~=~16$						[DyDz1]
	$R(C sub 4 ,^C sub 4 ,^C sub 4 ,^T)~=~16^$ for $^T^=^P sub 4$ and $T^=^K sub 1,3$		[ExRe]
.DE
.sp .2
.IP (b)
Study of $R(C sub n ,^K sub {^t sub 1} ,^. ..^,^K sub {^t sub k})$ and
$R(C sub n ,^K sub {^t sub 1 ,^s sub 1} ,^. ..^,^K sub {^t sub k ,^s sub k})~$
for large $n~$ [EFRS1].
.IP (c)
$R(C sub n ,^K sub {^t sub 1} ,^. ..^,^K sub {^t sub k}) ~=~(n^-^1)(r^-~1)^$
for $n^>=~4r^+^2$, where
$r~=~R(K sub {^t sub 1} ,^. ..^,^K sub {^t sub k})^$ [OmRa2].
.IP (d)
Study of asymptotics for $R(C sub m ,^. ..^,^C sub m ,^K sub n )$,
in particular for any fixed number of colors $k~>=~4$ we have
$R(C sub 4 ,^C sub 4 ,^. ..^,^C sub 4 ,^K sub n )~=^$
$THETA (^n sup 2 ^/^ roman {log sup 2} n )^$
[AlR\o'o\(:a'].
.IP (e)
Study of asymptotics for $R(C sub 2m ,^C sub 2m ,^K sub n )~$
for fixed $m^$ [AlR\o'o\(:a', ShiuLL], in particular
$R(C sub 4 ,^C sub 4 ,^K sub n )~=~THETA (^n sup 2 roman {^poly-log} ^n )^$
[AlR\o'o\(:a'].
.IP (f)
Monotone paths and cycles [Lef].
.IP (g)
For combinations of $C sub 3$ and $K sub n$ see
sections 2.2, 3.2, 4.2, 6.1 and 6.2.

.NH 2
Paths, paths versus other graphs
.sp .2
.LP
In 2007, Gy\o'a\(aa'rf\o'a\(aa's, Ruszink\o'o\(aa',
S\o'a\(aa'rk\o'o\(:a'zy and Szemer\o'e\(aa'di [GyRSS] established
that for all $n$ large enough we have
.EQ
R(P sub n ,^P sub n ,^P sub n )~=~2n^-^2^+~(n^ roman mod ~2).
.EN
.sp .2
Faudree and Schelp [FS2] conjectured that the latter holds
for all $n ~>=~ 1$. It is true for $n ~<=~ 9$ (see (c) below),
and the first open case is that for $P sub 10$.
The conjectured equality $R(C sub 2m ,^C sub 2m ,^C sub 2m )~=~4m$
(see 6.3.1.a), whenever true, implies
the above for three paths $P sub 2m+1$ [DyDR].
.NH 3
Three color path and path-cycle cases
.sp .5
.IP (a)
$R(P sub m ,^P sub n ,^P sub k )~=~m^+~ {down 8 \(lf} ^n/^2^
{down 8 \(rf} ~+~ {down 8 \(lf} ^k/^2^  {down 8 \(rf} ~-^2~$
for $^m~>=~6(^n^+~k) sup {^2}~$ [FS2],
.sp .2
the equality holds asymptotically for
$m^>=^n^>=^k^$ with an extra term $o(^m)~$ [Fi\(L/u1],
.br
extensions of the range of $m,^n,^k$ for which (a)
holds were obtained in [Biel3].
.IP (b)
$R(P sub 3 ,^P sub m ,^P sub n )~=~
m^+~ {down 8 \(lf} ^n/^2^{down 8 \(rf} ~-^1~$
for $^m~>=~n$ and $(m,^n)~ not= ~(3,^3),^(4,^3)~$ [MaORS2].
.IP (c)
$R sub 3 (P sub 3 )~=~5^$ [Ea1],
$~R sub 3 (P sub 4 )~=~6^$ [Ir],
.br
$R(P sub m ,^P sub n ,^P sub k )~=~5^$
for other $m-n-k$ combinations with $3~<=~m,~n,~k~<=~4^$ [ArKM],
.br
$R sub 3 (P sub 5 )~=~9^$ [YR1],
$~R sub 3 (P sub 6 )~=~10^$ [YR1], and
$~R sub 3 (P sub 7 )~=~13^$ [YY],
.br
$R sub 3 (P sub 8 )~=~14$, $R sub 3 (P sub 9 )~=~17$ [DyDR].
.sp .2
.IP (d)
$R(P sub 4 ,^P sub 4 ,^P sub 2n ^)~=~2n^+^2~$ for $n^>=^2$,
.br
$R(P sub 5 ,^P sub 5 ,^P sub 5 ^)~=~$
$R(P sub 5 ,^P sub 5 ,^P sub 6 ^)~=~9$,
.br
$R(P sub 5 ,^P sub 5 ,^P sub n ^)~=~n~+~2^$ for $n~>=~7$,
.br
$R(P sub 5 ,^P sub 6 ,^P sub n ^)~=~
R(P sub 4 ,^P sub 6 ,^P sub n ^)~=~n~+~3^$ for $n~>=~6~$,
.br
$R(P sub 6 ,^P sub 6 ,^P sub 2n ^)~=~$
$R(P sub 4 ,^P sub 8 ,^P sub 2n ^)~=~2n~+~4^$ for $n~>=~14~$ [OmRa1].
.sp .5
.IP (e)
$R(P sub m ,^P sub n ,^C sub k ^)~=~2n^+~2^{down 8 \(lf} ^m/^2^ {down 8 \(rf}~-~3^$
for large $n$ and odd $m^>=^3~$ [DzFi2],
.br
improvements on the range of $m,^n,^k~$ [Biel3, Fid1].
.sp .2
.IP (f)
$R(P sub 3 ,^P sub 3 ,^C sub m ^)~=~$5, 6, 6, for
$m~=~3$, 4 [ArKM], 5,
.br
$R(P sub 3 ,^P sub 3 ,^C sub m ^)~=~m^$ for $m^>=~6~$ [Dzi2].
.sp .2
$R(P sub 3 ,^P sub 4 ,^C sub m ^)~=~7^$ for $m^=~3$, 4 [ArKM] and 5,
.br
$R(P sub 3 ,^P sub 4 ,^C sub m )~=~m^+~1~$ for $m ~>=~6~$ [Dzi2].
.sp .2
$R(P sub 4 ,^P sub 4 ,^C sub m ^)~=~9,$ 7, 9 for $m^=~3$, 4 [ArKM] and 5 [Dzi2],
.br
$R(P sub 4 ,^P sub 4 ,^C sub m )~=~m^+~2~$ for $m ~>=~6~$ [DzKP].
.sp .2
.IP (g)
$R(P sub 3 ,^P sub 5 ,^C sub m ^)^=~$9, 7, 9, 7, 9 for
$m~=~3$, 4, 5, 6, 7 [Dzi2, DzFi2],
.br
$R(P sub 3 ,^P sub 5 ,^C sub m )~=~m^+~1~$ for $m ~>=~8~$ [DzKP].
.sp .1
A table of $R(P sub 3 ,^P sub k ,^C sub m )$
for all $3~<=~k^<=~8$ and $3~<=~m^<=~9~$ [DzFi2].
.sp .2
.IP (h)
$R(P sub 4 ,^P sub 5 ,^C sub m ^)~=~11$, 7, 11, 11, and $m^+~2^$
for $m~=~3$, 4, 5, 7 and $m^>=^23~$,
.sp .1
$R(P sub 4 ,^P sub 6 ,^C sub m ^)~=~13$, 8, 13, 13, and $m^+~3^$
for $m~=~3$, 4, 5, 7 and $m^>=^18~$ [ShaXSP].
.sp .3
.IP (i)
$R(P sub 3 ,^P sub n ,^C sub 4 ^)~=~n^+~1$ for $n ~>=~6^$ [DzFi2],
.br
$R(P sub 3 ,^P sub n ,^C sub 6 ^)~=~n^+~2$ for $n ~>=~6^$,
.br
$R(P sub 3 ,^P sub n ,^C sub 8 ^)~=~n^+~3$ for $n ~>=~7^$ [Fid1],
.br
$R(P sub 3 ,^P sub n ,^C sub k ^)~=~2n^-~1$, and
.br
$R(P sub 4 ,^P sub n ,^C sub k ^)~=~2n^+~1$ for odd $k^>=~3$ and $n^>=~k^$ [DzFi2].
.sp .3
.IP (j)
$R(P sub 3 ,^P sub 6 ,^C sub m ^)~=~m~+~2~$ for $m~>=~23$,
.br
$R(P sub 6 ,^P sub 6 ,^C sub m ^)~=~
 R(P sub 4 ,^P sub 8 ,^C sub m ^)~=~m~+~4~$ for $m~>=~27$,
.br
$R(P sub 6 ,^P sub 7 ,^C sub m ^)~=~m~+~4~$ for $m~>=~57$,
.sp .2
$R(P sub 4 ,^P sub n ,^C sub 4 ^)~=~
 R(P sub 5 ,^P sub n ,^C sub 4 ^)~=~n~+~2~$ for $n~>=~5~$ [OmRa1].
.sp .5
.IP (k)
$R(P sub 3 ,^C sub 3 ,^C sub 3 ^)~=~11~$ [BE3],
$~R(P sub 3 ,^C sub 4 ,^C sub 4 ^)~=~8~$ [ArKM],
$~R(P sub 3 ,^C sub 6 ,^C sub 6 ^)~=~9~$ [Dzi2],
.sp .1
$R(P sub 3 ,^C sub m ,^C sub m )~=~R(C sub m ,^C sub m )~=~2m^-^1^$
for odd $m ~>=~5$ [DzKP] (for $m^=~5,~7^$ [Dzi2]),
.IP (l)
$R(P sub 3 ,^C sub n ,^C sub m )~=~R(C sub n ,^C sub m )~$
for $n~>=~7$ and odd $m$, $5~<=~m~<=~n$, and
.br
some values and bounds on $R(P sub 3 ,^C sub n ,^C sub m )$
in other cases [Fid1].
.sp .2
.IP (m)
$R(P sub 3 ,^C sub 3 ,^C sub 4 ^)~=~8~$ [ArKM],
$~~R(P sub 3 ,^C sub 3 ,^C sub 5 ^)~=~9$,
$~~R(P sub 3 ,^C sub 3 ,^C sub 6 ^)~=~11$,
.br
$R(P sub 3 ,^C sub 3 ,^C sub 7 ^)~=~13$,
$~~R(P sub 3 ,^C sub 4 ,^C sub 5 ^)~=~~8$,
$~~R(P sub 3 ,^C sub 4 ,^C sub 6 ^)~=~~8$,
.br
$R(P sub 3 ,^C sub 4 ,^C sub 7 ^)~=~~^8$,
$~~R(P sub 3 ,^C sub 5 ,^C sub 6 ^)~=~11$,
$~~R(P sub 3 ,^C sub 5 ,^C sub 7 ^)~=~13$ and
.br
$R(P sub 3 ,^C sub 6 ,^C sub 7 ^)~=~11~$ [Dzi2].
.sp .3
.IP (n)
Formulas for $R(^pP sub 3 ,^qP sub 3 ,^rP sub 3 ^)$ and
$R(^pP sub 4 ,^qP sub 4 ,^rP sub 4 ^)~$ [Scob].
.IP (o)
$R(P sub 3 ,^K sub 4 ^-^e,^K sub 4 ^-^e^)~=~11~$ [Ex7].
All colorings which can form any color neighborhood for
the open case $R sub 3 (K sub 4 ^-^e)~$ (see section 6.5)
were found in [Piw2].

.NH 3
More colors
.IP (a)
$R sub k (P sub 3 ^)~=~k^+^1^+^(^k^ roman mod ~2),~$
$~R sub k (2P sub 2 ^)~=~k^+~3^$
for all $k^>=^1~$ [Ir].
.IP (b)
$R sub k (P sub 4 ^)~=~2k^+^c sub k$ for all $k$
and some $0~<=~c sub k~<=~2$.
If $k$ is not divisible by 3 then
$c sub k~=~3^-~k^ roman mod ~3^$ [Ir].
Wallis [Wall] showed $R sub 6 (P sub 4 ^)~=~13$, which already
implied $R sub 3t (P sub 4 ^)~=~6t^+^1$, for all $t^>=~2$.
Independently, the case $R sub k (P sub 4 ^)$ for $k ^not= ^3 sup down 5 m$
was completed by Lindstr\o'o\(:a'm in [Lind], and later Bierbrauer proved
$R sub up 10 { 3 sup down 5 m } (P sub 4 ^)~=~2(3 sup down 5 m )~+~1$
for all $m^>^1$. $R sub 3 (P sub 4 )~=~6$ [Ir].
.sp .1
.IP (c)
Formula for $R(P sub {n sub 1} ,^. ..^,^P sub {n sub k} ^)$
for large $n sub 1^$ [FS2], and some extensions [Biel3].
.br
Conjectures about $R(P sub {n sub 1} ,^. ..^,^P sub {n sub k} ^)$
when all or all but one of $n sub i$'s are even [OmRa1].
.IP (d)
Formulas for $R(P sub {n sub 1} ,^. ..^,^P sub {n sub k} ,^C sub m ^)$
for some cases, for large $m$ [OmRa1].
.IP (e)
Formula for $R(n sub 1 P sub 2 ,^. ..^,^n sub k P sub 2 ^)$,
in particular $R(nP sub 2 ,^nP sub 2 ,^nP sub 2 ^)~=~4n^-~2~$ [CocL1].
.br
Note how close the latter is to $R(C sub 2n ,^C sub 2n ,^C sub 2n ^)~=~4n$,
see an earlier item 6.3.1b.
.IP (f)
Cockayne and Lorimer [CocL1] found the exact
formula for $R(n sub 1 P sub 2 ,^. ..^,^n sub k P sub 2 )$, and
later Lorimer [Lor] extended it to a more general case of
$R(K sub m ,^n sub 1 P sub 2 ,^. ..^,^n sub k P sub 2 )$.
More general cases of the latter, with multiple copies
of the complete graph, paths, stars and forests, were studied
in [Stahl, LorSe, LorSo, GyRSS]. A special 3-color case
$R(P sub 3 ,^mP sub 2 ,^nP sub 2 ^)~=~2m^+^n^-~1~$
for $~m~>=~n~>=~3$ is given in [MaORS2].
.IP (g)
Multicolor cases for one large path or cycle
involving small paths, cycles, complete and
complete bipartite graphs [EFRS1].
.IP (h)
See sections 6.5 and 8.2, especially [ArKM, BoDD], for a number of cases
for triples of small graphs.

.NH 2
Special cases
.LP
.DS L
	$R sub 3 (K sub 3 ^+^e)~=~R sub 3 (K sub 3 )~~[=^17]$				[YR3, ArKM], where $K sub 3 ^+^e~=~K sub 4 ^-~P sub 3$
	$R(K sub 3 ^+^e ,^K sub 3 ^+^e ,^K sub 4 ^-^e)~=~17$			[ShWR]
.DE
.DS L
	If $R sub 4 (K sub 3 )~=~51$ then $R sub 4 (K sub 3 ^+^e)~=~52$, and
	if $R sub 4 (K sub 3 )~>~51$ then $R sub 4 (K sub 3 ^+^e)~=~R sub 4 (K sub 3 )$		[ShWR]
.DE
.DS L
	$28~<=~R sub 3 (K sub 4 ^-^e)~<=~30$					[Ex7] [Piw2]
	$R(P sub 3 ,^K sub 4 ^-^e,^K sub 4 ^-^e^)~=~11$				[Ex7], all colorings [Piw2]

	$472~<=~R sub 3 (K sub 6 ^-^e)$						[HeDL]
	$1102~<=~R sub 3 (K sub 7 ^-^e)$					[HeDL]
.DE
.DS L
	$21~<=~R(K sub 3 ,^K sub 4 ^-^e,^K sub 4 ^-^e^)~<=~27$			[ShWR]
	$33~<=~R(K sub 4 ,^K sub 4 ^-^e,^K sub 4 ^-^e^)~<=~60$			[ShWR]
	$55~<=~R(K sub 4 ,^K sub 4 ,^K sub 4 ^-^e^)~<=~113$				[Ea1][BoDD]
.DE
.DS L
	$R(C sub 4 ,^P sub 4 ,^K sub 4 ^-^e^)~=~11$					[ArKM]
	$R(C sub 4 ,^P sub 4 ,^K sub 4 )~=~14$					[BoDD]
	$R(C sub 4 ,^C sub 4 ,^K sub 4 ^-^e^)~=~16$					[DyDz1]
	$R(C sub 4 ,^K sub 3 ,^K sub 4 ^-^e^)~=~17$					[BoDD]
	$R(C sub 4 ,^K sub 4 ^-^e,^K sub 4 ^-^e^)~=~19$				[BoDD]
.DE
.DS L
	$28~<=~R(C sub 4 ,^K sub 4 ,^K sub 4 ^-^e^)~<=~36$				[BoDD]
	$30~<=~R(K sub 3 ,^K sub 4 ,^K sub 4 ^-^e^)~<=~41$				[Ea1][BoDD]
	$33~<=~R(K sub 4 ,^K sub 4 ^-^e,^K sub 4 ^-^e^)~<=~59$			[Ea1][BoDD]
.DE
.LP
See also section 8.2 for pointers to cumulative data for three colors.

.NH 2
General results for special graphs
.sp .2
.IP (a)
Formulas for $R sub k (G)$, where $G$ is one of the graphs
$P sub 3$, $2K sub 2$ and $K sub 1,3$, for all $k$,
and for $P sub 4$ if $k$ is not divisible by 3 [Ir].
For some details see section 6.4.2b.
.sp .2
.IP (b)
$tk sup {down 20 2} ^+^1~<=~ R sub k (K sub {2,^t+1} ) ~<=~ tk sup {down 20 2} ^+^k ^+^2$,
where the upper bound is general, and the lower bound holds when both $t$ and $k$
are prime powers [ChGra1, LaMu].
.sp .2
.IP (c)
$(m^-^1)^ {down 8 \(lf} (k+1)^/^2 {down 8 \(rf} ~<~
R sub k (T sub m ^)~<=~2km^+1~$ for any tree $T sub m$ with $m$ edges [EG], see
also [GRS]. The lower bound can be improved for special large $k^$ [EG, GRS].
The upper bound was improved to
$R sub k (T sub m ^)^<^(m^-^1)(k ^+^ down 6 sqrt { up 6 {k(k^-^1)}} ^)^+^2~$ in [GyTu].
.sp .2
.IP (d)
$k( down 10 sqrt {up 10 m} ^-^1)^/^2 ^<^
R sub k (F sub m ^)^<^4km~$ for any forest $F sub m$ with $m$ edges
[EG], see [GRS].
See also pointers in items (p) and (r) below.
.IP (e)
$R(S sub 1 ,^. ..^,^S sub k )~=~n^+^epsilon$,
where $S sub i$'s are arbitrary stars,
$n~=~n(S sub 1 )^+^. ..^+^n(S sub k )~-~2k$, and we set
$epsilon ~=~1$ if $n$ is even and some $n(S sub i )$ is odd,
and $epsilon ~=~2$ otherwise [BuRo1]. See also [GauST, Par6].
.IP (f)
Formula for $R(S sub 1 ,^. ..^,^S sub k ,^K sub n )$,
where $S sub i$'s are arbitrary stars [Jac].
It was generalized to a formula for
$R(S sub 1 ,^. ..^,^S sub k ,^K sub {k sub 1} ,^. ..^,^K sub {k sub r})~$
expressed in terms of $R(k sub 1 ,^. ..^,^k sub r )^$ and star orders [BoCGR].
A much shorter proof of the latter was presented in [OmRa2].
.IP (g)
Formula for $R(S sub 1 ,^. ..^,^S sub k ,^nK sub 2 )$,
where $S sub i$'s are arbitrary stars [CocL2], and a formula for
$R(n sub 1 K sub 2 ,^. ..^,^n sub k K sub 2 )^$ [CocL1]. See
also cases involving $P sub 2$ in section 6.4.2.
.IP (h)
Formula for $R(S sub 1 ,^. ..^,^S sub k ,^T )$,
where $S sub i$'s are stars and $T$ is a tree [ZZ1].
.IP (i)
Formulas for $R(S sub 1 ,^. ..^,^S sub k ^)$,
where each $S sub i$'s is a star or $m sub i K sub 2 ~$ [ZZ2, EG],
.br
formula for the case $R(S,^mK sub 2 ,^n K sub 2 )~$ [GyS\o'a\(aa'2].
.IP (j)
Bounds on $R sub k (G)$ for unicyclic graphs $G$ of odd girth.
.br
Some exact values for special graphs $G$, for $k^=~3$ and $k^=~4~$ [KrRod].
.IP (k)
For prime $p~=~3q^+^1$,
if the cubic residues Paley graph $Q sub p$ contains no $K sub k ^-^e$,
then $R sub 3 (K sub k+1 ^-^e)~>~3p^$ [HeDL].
The cases $k~=~5,^6$ give two bounds listed in section 6.5.
.IP (l)
$R sub k (K sub {3,3} ^)~=~(1^+^o(1))^k sup 3~$ [AlR\o'o\(aa'S].
.IP (m)
Bounds on $R sub k (K sub {s,^t} ^)$, in particular
for $K sub 2,2 ^=^C sub 4$ and $K sub {2,^t}$ [ChGra1, AxFM].
Asymptotics of $R sub k (K sub {s,^t} ^)$ for fixed $k$ and $s~$
[DoLi, LiTZ].
Upper bounds on $R sub k (K sub {s,^t} ^)$ [SunLi].
.IP (n)
Exact asymptotics
$R(K sub t,s ,^K sub t,s ,^K sub t,s ,^K sub m )~=~
THETA (m sup t / roman {^log} sup t m )$, for any fixed $t^>^1$
and large $s^>=^(t^-^1)!^+^1~$ [AlR\o'o\(:a'].
.IP (o)
Bounds on $R sub k (G)$ for trees, forests, stars and cycles [Bu1].
.IP (p)
Bounds for trees $R sub k (T)$ and forests $R sub k (F)$
[EG, GRS, BierB, GyTu, Bra1, Bra2, SwPr].
.IP (q)
$R sub 3 (G sub a,b )~=~(2^+^o(1))ab$,
where $G sub a,b$ is the rectangular $a times ^b$ grid graph.
Lower and upper bounds on $R sub 3 (G)$ for graphs $G$ with
small bandwidth and bounded $DELTA (G)~$ [MoSST].
.sp .2
.IP (r)
Study of the case
$R(K sub m ,^n sub 1 P sub 2 ,^. ..^,^n sub k P sub 2 )~$ [Lor].
Other similar results include
$R(P sub 3 ,^mK sub 2 ,^nK sub 2 ^)~=~2m^+^n^-~1~$
for $~m~>=~n~>=~3^$ [MaORS2] and
$R(S sub n ,^nK sub 2 ,^nK sub 2 ^)~=~$ $3n-~1~$ [GyS\o'a\(aa'2].
More general cases, with multiple copies
of the complete graph, stars and forests, were investigated in
[Stahl, LorSe, LorSo, GyRSS]. See also section 6.4.2.
.IP (s)
See section 8.2, especially [ArKM, BoDD], for a number of cases
for other small graphs, similar to those listed in sections 6.3 and 6.4.

.NH 2
General results
.IP (a)
Szemer\o'e\(aa'di's Regularity Lemma [Szem] states
that the vertices of every large graph can be partitioned
into similar size parts so that the edges between these
parts behave almost randomly. This lemma has been used
extensively in various forms to prove the upper bounds,
including those studied in
[BenSk, GyRSS, GySS1, Ha\(L/P1+, Ha\(L/P2+, KoSS1, KoSS2].
.sp .1
.IP (b)
$R(m sub 1 G sub 1 ,^. ..^,^m sub k G sub k )~<=~
R(G sub 1 ,^. ..^,^G sub k )~+~
up 8 sum from {up 30 {i^=^1}} to {down 1 k}
n(G sub i )(m sub i ^-~1 )$, exercise 8.3.28 in [West].
.IP (c)
If $G$ is connected and $R(K sub k ,^G)~=~(k^-^1)(n(G)^-^1)^+^1$,
in particular if $G$ is any $n$-vertex tree, then
$R(K sub {k sub 1} ,^. ..^,^K sub {k sub r},^G )$ = 
$(R(k sub 1 ,^. ..^,^k sub r )~-~1)(n~-~1)~+~1$ [BE3].
A generalization for connected $G sub 1 ,^. ..^,^G sub n$ in place
of $G$ appeared in [Jac].
.sp .2
.IP (d)
If $F,^G,^H$ are connected graphs then
$R(F,^G,^H)~>=$$~(R(F,^G)^-^1)$$( chi (H)^-^1)^+^$
$roman min roman "{"^R(F,^G),^s(H)^roman "}"$, where
$s(G)$ is the chromatic surplus of $G$ (see item [Bu2] in section 5.16).
This leads to several formulas and bounds for $F$ and $G$ being
stars and/or trees when $H~=~K sub n$ [ShiuLL].
.sp .1
.IP (e)
$R(K sub {k sub 1} ,^. ..^,^K sub {k sub r} ,^G sub 1 ,^. ..^,^G sub s )~>=~
(R(k sub 1 ,^. ..^,^k sub r )^-^1)
(R(G sub 1 ,^. ..^,^G sub s )^-^1)~+^1~$
for arbitrary graphs $G sub 1 ,$$. ..^,$$G sub s ~$ [Bev].
This generalizes 6.2.q.
.IP (f)
Constructive bound
$R(G sub up 15 1 ,^...,^G sub up 20 { t sup {down 20 {n-1}} }^)~>=~t sup {down 20 n} +^1$
for decompositions of
$K sub { up 20 t sup n }$ [LaWo1, LaWo2].
.IP (g)
$R(G sub 1 ,^. ..^,^G sub k ) ~<=~ 32 DELTA ^k sup DELTA ^n$, where
$n~>=~n(G sub i )$ and $DELTA~>=~DELTA (G sub i )$
for all $1^<=~i^<=~k$,
.br
$R(G sub 1 ,^. ..^,^G sub k ) ~<=~ k sup { 2^k DELTA ^q} n$, where
$q^>=~chi (G sub i )$
for all $1^<=~i^<=~k~$ [FoxSu1].
.sp .1
.IP (h)
$R sub k (G)~<=~k sup {6e(G) sup {2/^3} k}$ for all isolate-free graphs
$G$ and $k^>=~3^$ [JoPe].
.br
For the original two-color conjecture,
now a theorem, see item [Erd4] in section 5.16.
.IP (i)
$R sub k (G)~>~ (sk sup down 20 {^e(G)^-^1)}^) sup down 15 {^1^/^n(G)}^$,
where $s$ is the number of automorphisms of $G~$ [CH3]. Other
general bounds for $R sub k (G)~$ [CH3, Par6].
.IP (j)
Study of $R(G sub 1 ,^. ..^,^G sub k ,^G )$ for large sparse $G$
[EFRS1, Bu3].
.IP (k)
Study of asymptotics for $R(C sub n ,^. ..^,^C sub n ,^K sub m )~$ [AlR\o'o\(:a'].
See also sections 6.3.3.d/e.
.IP (l)
Relations between the Shannon capacity of noisy communication
channels and graph Ramsey numbers. A lower bound construction
for $R sub k (m)$ implying that supremum of
the Shannon capacity over all graphs with bounded
independence cannot be achieved by any finite graph power [XuR3].
For some other links between Shannon capacity and Ramsey numbers
see section 6 in [Ros2], and [Li2].
.IP (m)
See surveys listed in section 8.

.bp
.NH
Hypergraph Numbers
.NH 2
Values and bounds for numbers
.DS L
The only known value of a classical Ramsey number for hypergraphs:
	$R(4,4^;^3)~=~13$,
	more than 200000 critical colorings			[MR1]
.DE
.sp -.3
.LP
The computer evaluation of $R(4,4^;^3)$ in 1991 consisted of an
improvement of the upper bound from 15 to 13. This result followed an
extensive theoretical study of this number by several authors
[Gi4, Isb1, Sid1].
.LP
.DS L
(a)	$33~<=~R(4,^5^;^3)$						[Ex13]
	$58~<=~R(4,^6^;^3)$						[Ex18]
	$82~<=~R(5,^5^;^3)$						[Ex18]
	$56~<=~R(4,4,4^;^3)$						[Ex8]
	$34~<=~R(5,^5^;^4)$						[Ex11]
.DE
.sp -.6
.DS L
(b)	$R(K sub 4 ^-^t,^K sub 4 ^-^t^;^3)~=^7$					[Ea2]
	$R(K sub 4 ^-^t,^K sub 4 ^;^3)~=^8$					[Sob, Ex1, MR1]
	$14~<=~R(K sub 4 ^-^t,^K sub 5 ^;^3)$					[Ex1]
	$13~<=~R(K sub 4 ^-^t,^K sub 4 ^-^t,^K sub 4 ^-^t^;^3)~<=~16$		[Ex1] [Ea3]
.DE
.IP (c)
The first bound on $R(4,^5^;^3)~>=~24$ was obtained by Isbell [Isb2].
Shastri [Shas] gave a weak bound $R(5,^5^;^4)~>=~19$ (now 34 in [Ex11]),
nevertheless his lemmas, the stepping-up lemmas by
Erd\o'o\(hu's and Hajnal (see [GRS, GrR\o'o\(:a'], also 7.4.a below),
and others in [Ka3, Abb2, GRS, GrR\o'o\(:a', HuSo, SonYL] can be used to
derive better lower bounds for higher numbers.
.IP (d)
Several lower bound constructions for 3-uniform hypergraphs
were presented in [HuSo]. Study of lower bounds on $R(^p,^q;^4)$ can be
found in [Song3] and [SonYL, Song4] (the latter two papers are almost the same
in contents). Most of the concrete lower bounds in these papers can be
easily improved by using the same techniques, but starting with better
constructions for small parameters as listed above.
.IP (e)
$R(^p,^q;^4)~>=~2R(^p^-^1,^q;^4)~-~1^$ for $p,^q^>^4$, and
.br
$R(^p,^q;^4)~>=~(^p^-^1)R(^p^-^1,^q;^4)~-~p^+^2^$ for $p^>=^5,~q^>=^7^$ [SonYL].
.br
Lower bound asymptotics for $R(^p,^q;^4)~$ [SonLi].
.IP (f)
$R(K sub 1,1,c ,^K sub 1,1,c ;^3)~=~c^+^2~$ for $2~<=~c~<=~4$, and
.br
a conjecture that this equality also holds for all $c~>=~5~$ [MiPal].

.NH 2
Cycles and paths
.sp .5
.LP
\fBDefinitions\fP. $P sub n sup {r,^s}$ is called an $s$-$path$
in an $r$-uniform hypergraph $H$, if it consists of $n$
hyperedges {$e sub 1 ,^. ..,^e sub n$} in $E(H)$, such
that $|e sub i up 25 {size 7 inter} ^e sub i+1 |^=~s$
for all $1^<=~i^<^n$,
and all other vertices in $e sub j$'s are distinct [Peng].
An $s$-$cycle$ $C sub n sup {r,^s}$ is defined analogously.
Several authors use the terms of $loose$ paths and $loose$
cycles, which are 1-path and 1-cycles, and $tight$ paths
and $tight$ cycles, the latter most often for 3-uniform
hypergraphs when they are 2-paths and 2-cycles, respectively.
A 3-uniform $Berge$ cycle is formed by $n$ distinct vertices,
such that all consecutive pairs of vertices are
in an edge of the cycle, and all of the cycle edges are distinct.
Berge cycles are not determined uniquely.
.sp .5
In the following items (b) to (i), when $r~=~3$ or $r$ is
implied by the context, we write $C sub n$ and $P sub n$
for the $r$-uniform loose cycles and paths,
$C sub n sup {r,^1}$ and $P sub n sup {r,^1}$,
respectively. In other cases special comments are added.

.IP (a)
Tetrahedron is formed by four triples on the set of four points.
The Ramsey number of tetrahedron is $R(4,^4^;^3)~=~13$ [MR1].
.IP (b)
For loose cycles and paths,
$R(C sub 3 ,^C sub 3 ^;^3)~=~7$,
$R(C sub 4 ,^C sub 4 ^;^3)~=~9$,
and for the $r$-uniform case we have in general
$R(P sub 3 ,^P sub 3 ^;^r)~=$
$R(P sub 3 ,^C sub 3 ^;^r)~=$
$R(C sub 3 ,^C sub 3 ^;^r)~+^1~=~3r~-~1$ and
$R(P sub 4 ,^P sub 4 ^;^r)~=$
$R(P sub 4 ,^C sub 4 ^;^r)~=$
$R(C sub 4 ,^C sub 4 ^;^r)~+^1~=$ $4r~-~2$, for $r~>=~3$.
These results and discussion of several related cases
were presented in [GyRa].
.IP (c)
$R(P sub m ,^P sub n ^;^3) ~=~
R(C sub m ,^C sub n ^;^3)~+~1~=~
R(P sub m ,^C sub n ^;^3)~=~ 2m^+~
{down 15 \(lf} (n^+^1)/^2 {down 15 \(rf},~$
for all $m^>=~n$, and
$R(C sub m ,^P sub n ^;^3)~=~2m^+~
{down 15 \(lf} (n^-^1)/^2 {down 15 \(rf},~$
for $m^>~n~$ [MaORS1, OmSh].
.IP (d)
For loose cycles,
$R(C sub 2n ,^C sub 2n ;^3)~>~5n^-^2$ and
$R(C sub 2n+1 ,^C sub 2n+1 ;^3)~>~5n^+^1$, and asymptotically
these lower bounds are tight [Ha\(L/P1+]. Generalizations to $r$-uniform
hypergraphs and graphs other than cycles
appeared in [GySS1].
.IP (e)
For tight cycles,
$R(C sub 3n ,^C sub 3n ;^3)~approx~4n$ and
$R(C sub {3n+^i},^C sub {3n+^i};^3)~approx~6n$ for $i^=^1$ or 2,
and for tight paths $R(P sub n ,^P sub n ;^3)~approx~4n/^3~$
[Ha\(L/P2+]. Some related results are discussed in [PoRRS].
.IP (f)
Exact values for Ramsey numbers
involving $s$-paths for even $r$ and $s^=~r/^2~$, in
particular for $P sub n sup {r,^s}$ versus
$P sub 3 sup {r,^s}$ and $P sub 4 sup {r,^s}$,
when this value is $(n^+^1)s^+^1^$ [Peng].
.IP (g)
For 3-uniform Berge cycles and two colors,
$R(C sub n ,^C sub n ^;^3)~=~n~$ for $n~>=~5~$ [GyLSS].
.IP (h)
For loose cycles,
$R(C sub 3 ,^C sub 3 ,^C sub 3 ^;^3)~=~8$,
and in general for $k~>=~4$ colors
Gy\o'a\(aa'rf\o'a\(aa's and Raeisi established the bounds
$k^+^5~<=~R sub k (C sub 3 ^;^3)~<=~3k~$ [GyRa].
.IP (i)
For 3-uniform Berge cycles,
$R sub 3 (C sub n ^;^3)~=~(1^+^o(1))5n/4~$ 
[GyS\o'a\(aa'1].
.IP (j)
Lower and upper asymptotic bounds for
$R(C sub 3 sup 3,1 ,^K sub m ;^3)$ and
$R(C sub 3 sup r,1 ,^K sub m ;^r)^$ [KosMV2].
.IP (k)
Gy\o'a\(aa'rf\o'a\(aa's, S\o'a\(aa'rk\o'o\(:a'zy
and Szemer\o'e\(aa'di proved that,
for sufficiently large $n$,
every 2-coloring of the edges of the complete
4-uniform hypergraph $K sub n$ contains a monochromatic
3-tight Berge cycle $C sub n~$ [GySS2].
Special multicolor cases for $r$-uniform hypergraphs
were studied in [GyLSS].
.IP (l)
Study of $R(G,^nH;^r)$ and $R(mG,^nH;^r)$ for loose/tight
path, cycles and stars, including several exact results
for large $m$ or $n~$ [OmRa3].

.NH 2
General results for 3-uniform hypergraphs
.sp .5
.IP (a)
$2 sup down 5 { cn sup down 10 2 } ^<~ R(^n,^n;^3) ^<~
2 sup down 5 { 2 sup down 10 n}~$ is credited to
Erd\o'o\(hu's, Hajnal and Rado (see [ChGra2] p. 30).
.IP (b)
For some $a,^b$ the numbers $R(^m,^a,^b;^3)$
are at least exponential in $m~$ [AbbS].
.IP (c)
Improved lower and upper asymptotics for $R(s,^n;^3)$
for fixed $s$ and large $n$, proof of related
Erd\o'o\(hu's and Hajnal conjecture on the growth of
$R(4,^n;^3)$, and the lower bound
$2 sup down 5 { n sup down 10 {c roman ln ^n} } ^<~ R(n,^n,^n;^3)~$
[ConFS2].
.IP (d)
$R (G,^G^;^3)~<=~cn(H)$ for some constant $c$ depending
only on the maximum degree of a 3-uniform hypergraph $H~$ [CooFKO1, NaORS].
Similar results were proved for $r$-uniform hypergraphs in [K\o'u\(:a'CFO,
Ishi, CooFKO2, ConFS1], see also item 7.4.g.
.IP (e)
Asymptotic lower bounds for $R(K sub a,b,c ,^K sub a,b,c ;^3)$,
where $K sub a,b,c$ is formed by all $abc$ triples on sets of
orders $a,~b,~c~$ [MiPal].
.IP (f)
If $G$ is a 3-uniform $H$-free hypergraph, then $G$ contains
a complete or empty tripartite subgraph with parts of order
$( log^n(H)) sup {c+^1/^2}$, where $c^>~0$ depends only on $H$.
Furthermore, for $k^>=~4$ no analogue of it can hold
for $k$-uniform hypergraphs [ConFS5].
.IP (g)
Asymptotic or exact values of $R sub k (H;^3)$ when $H$ is a bow
{$abc,^ade$}, kite {$abc,^abd$}, tight path
$P sub 3 sup 3,2 ~=~roman "{" abc,^bcd,^cde$},
or windmill {$abc,^bde,^cef,~bce$}, and, among others,
a special case $R sub 6 (kite;^3) ~=~8^$ [AxGLM].
.IP (h)
$R sub k (K sub 3^)~<=~
R sub 4k (K sub 4 ^-^t;^3) ~<=~ R sub 4k (K sub 3^)~+^1~$ [AxGLM].
.IP (i)
Upper bounds on $R sub k (H;^3)$
for complete multipartite 3-uniform hypergraphs $H,$ a 4-color
case, and some other general and special cases [ConFS1, ConFS2, ConFS3].
$R sub k (H;^3)$ ranges from $sqrt {6k} (1^+^o(1))$ to
double exponential in $k^$ [AxGLM].

.NH 2
General results
.sp .5
.IP (a)
If $R(^n,^n;^r)^>~m$ then $R(2n^+^r^-~4,^2n^+^r^-~4^;^r^+^1)^>~2 sup m$,
for $n^>^r^>=~3~$ (see [GRS] p. 106).
This is the so-called stepping-up lemma,
usually credited to Erd\o'o\(hu's and Hajnal.
An improvement of the stepping-up lemma implying better lower
bounds for a few types of hypergraph Ramsey numbers were
obtained by Conlon, Fox and Sudakov [ConFS6].
.IP (b)
Lower bounds on $R sub k (^n;^r)$ are discussed in [AbbW, DLR].
.IP (c)
General lower bounds for large number of colors were given in
an early paper by Hirschfeld [Hir],
and some of them were later improved in [AbbL].
.IP (d)
Lower and upper asymptotics of $R(s,^n;^k)$ for fixed $s~$ [ConFS2].
.IP (e)
Exact and asymptotic results generalizing 7.2.d to $r$-uniform
case for cycles, and 2- and 3-color cases for all $r$-uniform
diamond matchings [GySS1].
.IP (f)
Study of $R(G,^nH;^r)$ and $R(mG,^nH;^r)$ for loose/tight
path and cycles (possibly with some additions), stars,
$r$-partite hypergraphs, including several exact results
for large $m$ or $n~$ [OmRa3].
.IP (g)
$R(H,^H;^r)~<=~cn(H) sup down 20 {1+ ^epsilon}~$,
for some constant
$c~=~c( DELTA ,^r,^epsilon ^)$ depending
only on the maximum degree of $H$, $r$ and $epsilon ^>^0~$
[KoR\o'o\(:a'3]. The proofs of the linear bound $cn(H)$ were
obtained independently in [K\o'u\(:a'CFO] and [Ishi],
the latter including the multicolor case, and then
without regularity lemma in [ConFS1]. More discussion
of lower and upper bounds for various cases can be found
in [ConFS1, ConFS2, ConFS3, CooFKO2].
.IP (h)
Let $T sub r$ be an $r$-uniform hypergraph with $r$ edges
containing a fixed $(r^-^1)$-vertex set $S$ and the $(r^+^1)$-st
edge intersecting all former edges in one vertex outside $S$.
Then $R(T sub r ,^K sub t ;^r)~=~O(t sup r /^ roman log ^t)~$ [KosMV1].
.IP (i)
Let $H sup {down 5 ^r} (s,^t)$ be the complete $r$-partite $r$-uniform hypergraph
with $r^-^2$ parts of size 1, one part of size $s$, and one part of size $t$
(for example, for $r^=^2$ it is the same as $K sub {s,^t}^$).
For the multicolor numbers, Lazebnik and Mubayi [LaMu] proved that
.sp .3
.EQ
tk sup {down 5 2} ^-~k^+^1 ~<=~ R sub k (H sup {down 5 ^r} (2,^t+1)^;^r) ~<=~
tk sup {down 5 2} ^+^k^+^r,
.EN
where the lower bound holds when both $t$ and $k$ are prime powers.
For the general case of
$H sup {down 5 ^r} (s,^t)$, more bounds are presented in [LaMu].
.IP (j)
$R sub k (H;^r)$ is polynomial in $k$ when a fixed
$r$-uniform $H$ is $r$-partite,
otherwise it is at least exponential in $k^$ [AxGLM].
.IP (k)
Grolmusz [Grol1] generalized the classical constructive lower
bound by Frankl and Wilson [FraWi] (item 2.3.6) to more colors
and to hypergraphs [Grol3].
.IP (l)
Lower and upper asymptotics, and
other theoretical results on hypergraph numbers, are gathered
in [GrR\o'o\(:a', GRS, ConFS1, ConFS2, ConFS3, Song8].

.NH
Cumulative Data and Surveys
.NH 2
Cumulative data for two colors

.IP [CH1] .65i
$R(G,^G)$ for all graphs $G$ without isolates on at most 4 vertices.
.IP [CH2]
$R(G,^H)$ for all graphs $G$ and $H$ without isolates on at most
4 vertices.
.IP [Clan]
$R(G,^H)$ for all graphs $G$ on at most 4 vertices and $H$ on 5 vertices,
except five entries (now all solved, see section 5.11).
All critical colorings for the isolate-free graphs $G$ and $H$
studied in [Clan] were found in [He4].
.IP [Bu4]
$R(G,^G)$ for all graphs $G$ without isolates and with at most 6 edges.
.IP [He1]
$R(G,^G)$ for all graphs $G$ without isolates and with at most 7 edges.
.IP [HaMe2]
$R(G,^G)$ for all graphs $G$ on 5 vertices and with 7 or 8 edges.
.IP [He2]
$R(G,^H)$ for all graphs $G$ and $H$ on 5 vertices without
isolates, except 7 entries (2 still open, see 5.11 and
the paragraph at the end of this section).
.IP [LoM5]
$R(G,^H)$ for all disconnected isolate-free graphs $H$ on at most
6 vertices versus all $G$ on at most 5 vertices, except 3 cases.
Missing cases were completed in [KroMe].
.IP [HoMe]
$R(G,^H)$ for $G^=^K sub 1,3 ^+^e$ and $G^=^K sub 4 ^-^e$ versus
all connected graphs $H$ on 6 vertices, except $R(K sub 4 ^-^e,^K sub 6 ^)$.
The result $R(K sub 4 ^-^e,^K sub 6 ^)^=^21$ was claimed by McNamara
[McN, unpublished], now confirmed in [ShWR].
.IP [Boza4]
$R(G,^H)$ for some graphs $G$ with 4 vertices versus
all graphs $H$ with 7 vertices.
.IP [FRS4]
$R(G,^T)$ for all connected graphs $G$ with $n(G)^<=^5$,
and almost all trees $T$.
.IP [FRS1]
$R(K sub 3 ,^G)$ for all connected graphs $G$ on 6 vertices.
.IP [Jin]
$R(K sub 3 ,^G)$ for all connected graphs $G$ on 7 vertices.
.br
Some errors in [Jin] were found [SchSch1].
.IP [Zeng]
Formulas for $R(nK sub 3 ,^mG)$ for all $G$ of order 4
without isolates.
.IP [Brin]
$R(K sub 3 ,^G)$ for all connected graphs $G$ on at most 8 vertices.
The numbers for $K sub 3$ versus sets of graphs with fixed number
of edges, on at most 8 vertices, were presented in [KlaM1].
.IP [BBH1]
$R(K sub 3 ,^G)$ for all connected graphs $G$ on 9 vertices.
See also [BBH2].
.IP [BrGS]
$R(K sub 3 ,^G)$ for all graphs $G$ on 10 vertices,
except 10 cases (three of which, including $G^=^K sub 10 ^-^e$,
were solved [GoR2]).
.IP [JR3]
$R(C sub 4 ,^G)$ for all graphs $G$ on at most 6 vertices.
.IP [JR4]
$R(C sub 5 ,^G)$ for all graphs $G$ on at most 6 vertices.
.IP [JR2]
$R(C sub 6 ,^G)$ for all graphs $G$ on at most 5 vertices.
.IP [LoM3]
$R(K sub 2,n ,^K sub 2,m )$ for all $2~<=~n,~m^<=~10$
except 8 cases, for which lower and upper bounds are given.
Further data for other complete bipartite graphs are
gathered in section 3.3 and [LoMe4].
.IP [HaKr1]
All best lower bounds up to 102 from cyclic graphs.
Formulas for best cyclic lower bounds for paths and cycles,
and values for small complete graphs
and for graphs with up to five vertices.

.LP
Chv\o'a\(aa'tal and Harary [CH1, CH2] formulated several simple
but very useful observations on how to discover values of some
numbers. All five missing entries in the tables of Clancy
[Clan] have been solved (section 5.11). Out of 7 open cases in [He2] 5
have been solved, including $R(4,^5)~=~$$R(G sub 19 ,^G sub 23 ^)~=~25$
and other cases listed in section 5.11.
The 2 cases still open are for $K sub 5$ versus
$K sub 5$ (section 2.1) and $K sub 5$ versus
$K sub 5 ^-^e$ (section 3.1).
Many extremal and other Ramsey graphs for various
parameters are available at [BrCGM, McK, Ex18, Fid2, Fuj1],
see section 8.3 below.

.NH 2
Cumulative data for three colors

.IP [YR3] .65i
$R sub 3 (G)$ for all graphs $G$ with at most 4 edges and no isolates.
.IP [YR1]
$R sub 3 (G)$ for all graphs $G$ with 5 edges and no isolates,
except $K sub 4 ^-^e$.
.br
The case of $R sub 3 (K sub 4 ^-^e)$ remains open (see section 6.5).
.IP [YY]
$R sub 3 (G)$ for all graphs $G$ with 6 edges and no isolates,
except 10 cases.
.IP [ArKM]
$R(F,^G,^H)$ for many triples of isolate-free graphs with at most 4 vertices.
.br
Some of the missing cases completed in [KlaM2].
.IP [BoDD]
Extension of [ArKM] to most triples of graphs with at most 4 vertices.
.IP [DzFi2]
$R(P sub 3 ,^P sub k ,^C sub m )$ for all $3~<=~k^<=~8$ and $3~<=~m^<=~9$.

.NH 2
Electronic Resources

.IP (a)
W. Gasarch [Gas] maintains a website gathering over 60 pointers
to literature on applications of Ramsey theory in computer science,
\s-2\fHhttp://www.cs.umd.edu/~gasarch/ramsey/ ramsey.html\fP\s0.
.IP (b)
Many of the Ramsey graph constructions found by G. Exoo [Ex1-Ex20]
are posted at \s-2\fHhttp://ginger.indstate.edu/ge/RAMSEY\fP\s0.
.IP (c)
G. Brinkmann, K. Coolsaet, J. Goedgebeur and H. M\o'e\(aa'lot,
.I
House of Graphs: A database of interesting graphs
.R
[BrCGM],
\s-2\fHhttp://hog.grinvin.org\fP\s0.
.IP (d)
B.D. McKay, presents some graphs related to classical
Ramsey numbers [McK],
\s-2\fHhttp:// cs.anu.edu.au/people/bdm/data/ramsey.html\fP\s0.
.IP (e)
R. Fidytek, presents some Ramsey graphs of type
$(K sub n ,^K sub m ^-^e)$ [Fid2], see also 3.1.f,
\s-2\fHhttp://fidytek.inf.ug.edu.pl/ramsey\fP\s0.
.IP (f)
H. Fujita, some Ramsey graphs [Fuj1],
\s-2\fHhttp://opal.inf.kyushu-u.ac.jp/~fujita/ramsey.html\fP\s0.
.IP (g)
Ramsey@Home [RaHo] is a distributed computing project at
the University of Wisconsin-Oshkosh designed to find new
lower bounds for various Ramsey numbers. Join and help!
\s-2\fHhttp://www.ramseyathome.com/ramsey\fP\s0.

.sp .5
.NH 2
Surveys

.IP (1974) .65i
A general survey of results in Ramsey graph theory by S.A. Burr [Bu1]
.IP (1978)
A general survey of results in Ramsey graph theory by T.D. Parsons [Par6]
.IP (1980)
Survey of results and new problems on multiplicities and
Ramsey multiplicities by S.A. Burr and V. Rosta [BuRo3]
.IP (1981)
Summary of progress by Frank Harary [Har2]
.IP (1983)
A survey of bounds and values by F.R.K. Chung and
C.M. Grinstead [ChGri]
.IP (1983)
Special volume of the \fIJournal of Graph Theory\fP [JGT]
.IP (1984)
A review of Ramsey graph theory for newcomers
by F.S. Roberts [Rob1]
.IP (1987)
What can we hope to accomplish in generalized Ramsey Theory? [Bu7]
.IP (1987)
Survey of asymptotic problems by R.L. Graham and V. R\o'o\(:a'dl
[GrR\o'o\(:a']
.IP (1990)
.I
Ramsey Theory
.R
by R.L. Graham, B.L. Rothschild and J.H. Spencer [GRS]
.IP (1991)
Survey by R.J. Faudree, C.C. Rousseau and R.H. Schelp
of graph goodness results, i.e. conditions for the formula
$R(G,^H)~=~$$( ^chi (G) ^-^1^)^(^n(H)^-^1^)^+^s(G)^$ [FRS5]
.IP (1996)
A chapter in \fIHandbook of Combinatorics\fP
by J. Ne\o's\(be'et\o'r\(be'il [Ne\o's\(be']
.IP (1996)
Survey of zero-sum Ramsey theory by Y. Caro [Caro]
.IP (1997)
Among 114 open problems and conjectures of Paul Erd\o'o\(hu's,
presented and commented by F.R.K. Chung, 31 are concerned
directly with Ramsey numbers [Chu4]. 216 references are given.
An extended version of this work was prepared jointly with
R.L. Graham [ChGra2] in 1998.
.IP (2001)
An extensive chapter on Ramsey theory in a widely used
student textbook and researcher's guide of graph theory by D. West [West]
.IP (2002)
.I
Ramsey Theory and Paul Erd\o'o\(hu's 
.R
by R.L. Graham and J. Ne\o's\(be'et\o'r\(be'il [GrNe]
.IP (2003)
Special issue of \fICombinatorics, Probability and Computing\fP [CoPC]
.IP (2004)
Dynamic survey of Ramsey theory applications by V. Rosta [Ros2].
A website maintained by W. Gasarch [Gas] gathers over 60 pointers
to literature on applications of Ramsey theory in computer science.
.IP (2009)
History, results and people of Ramsey theory. The mathematical coloring
book, mathematics of coloring and the colorful life of its creators
by A. Soifer [Soi1].
.IP (2011)
.I
Ramsey Theory. Yesterday, Today and Tomorrow,
.R
a special volume in the series
\fIProgress in Mathematics\fP [Soi2].
A survey of Ramsey numbers involving
cycles by the author is included in this volume [Ra4].
.IP (2013)
.I
Problems in Graph Theory from Memphis,
.R
"a summary of problems
and results coming out of the 20 year collaboration between
Paul Erd\o'o\(hu's and the authors", by
R.J. Faudree, C.C. Rousseau and R.H. Schelp [FRS6].

.sp
.PP
The surveys by S.A. Burr [Bu1] and T.D. Parsons [Par6] contain
extensive chapters on general exact results in graph Ramsey theory.
F. Harary presented the state
of the theory in 1981 in [Har2], where he also gathered many
references including seven to other early surveys of this area.
More than two decades ago, Chung and Grinstead in their survey
paper [ChGri] gave less data than in this work, but
included  a broad discussion of different methods used
in Ramsey computations in the classical case.
S. A. Burr, one of the most experienced researchers in Ramsey
graph theory, formulated in [Bu7] seven conjectures on Ramsey
numbers for sufficiently large and sparse graphs, and reviewed
the evidence for them found in the literature. Three
of them have been refuted in [Bra3].
.PP
For newer extensive presentations see
[GRS, GrR\o'o\(:a', FRS5, Ne\o's\(be', Chu4, ChGra2],
though these focus on asymptotic theory not on the numbers themselves.
A very welcome addition is the 2004 compilation of applications
of Ramsey theory by V. Rosta [Ros2]. This survey could
not be complete without recommending special volumes of the
\fIJournal of Graph Theory\fP [JGT, 1983] and
\fICombinatorics, Probability and Computing\fP [CoPC, 2003],
which, besides a number of research papers, include
historical notes and present to us Frank P. Ramsey (1903-1930)
as a person. Finally, read a colorful book by A. Soifer [Soi1, 2009]
on history and results in Ramsey theory, followed by a collection
of essays and technical papers based on presentations from the
2009 Ramsey theory workshop at DIMACS [Soi2, 2011].
.PP
The historical perspective and, in particular, the timeline of
progress on prior best bounds, can be obtained by checking all
the previous versions of this survey since 1994 at
\s-2\fHhttp://www.cs.rit.edu/~spr/ElJC/eline.html\fP\s0.

.NH
Concluding Remarks
.PP
This compilation does not include information on numerous
variations of Ramsey numbers, nor related topics, like
size Ramsey numbers, zero-sum Ramsey numbers, irredundant Ramsey
numbers, induced Ramsey numbers, planar Ramsey numbers,
bipartite Ramsey numbers, on-line Ramsey numbers, mixed Ramsey numbers,
local Ramsey numbers, rainbow Ramsey numbers,
connected Ramsey numbers, chromatic Ramsey numbers,
avoiding sets of graphs in some colors, coloring graphs
other than complete, or the so called Ramsey multiplicities.
Interested readers can find such information in
some of the surveys listed in section 8 here.
.PP
Readers may be interested in knowing that the US patent
6965854 B2 issued on November 15, 2005 claims a method
of using Ramsey numbers in "Methods, Systems and Computer Program
Products for Screening Simulated Traffic for Randomness." Check
the original document at \s-2\fHhttp://www.uspto.gov/patft\fP\s0
if you wish to find out whether your usage of Ramsey
numbers is covered by this patent.

.SH
Acknowledgements
.PP
In addition to the many individuals who helped to improve consecutive
versions of this survey, the author would like to specially thank
Brendan McKay, Geoffrey Exoo and Heiko Harborth for their help
in gathering data for the first versions. Thanks to many other
individuals who over the years have helped me in the development
and improvement of new revisions.
.PP
The author apologizes for any omissions or other errors
in reporting results belonging to the scope of this work.
Suggestions for any kind of corrections or additions
will be greatly appreciated and considered for inclusion
in the next revision of this survey.

.bp
.ds CH
.ds CF - \\n% -
.ds RH "\s10T\s-2HE\s0 E\s-2LECTRONIC\s0 J\s-2OURNAL OF\s0 C\s-2OMBINATORICS\s0 (2014), DS1\s-2.14
.EQ
delim $$
gsize 12
.EN
.nr LL 6.5i
.nr LT 6.5i
.nr PS 12
.nr VS 14
.SH
References
.sp .5
.PP
Out of 661 references gathered below, most appeared in about
100 different periodicals, among which most articles were
published in:
.I
Discrete Mathematics
.R
68,
.I
Journal of Combinatorial Theory
.R
(old, Series A and B) 55,
.I
Journal of Graph Theory
.R
50,
.I
Electronic Journal of Combinatorics
.R
32,
.I
Ars Combinatoria
.R
28,
.I
Journal of Combinatorial Mathematics and Combinatorial Computing
.R
27,
.I
European Journal of Combinatorics
.R
20,
.I
Utilitas Mathematica
.R
18,
.I
Combinatorica
.R
15,
.I
Graphs and Combinatorics
.R
14,
.I
Australasian Journal of Combinatorics
.R
14,
.I
Discrete Applied Mathematics
.R
12,
.I
Congressus Numerantium
.R
12,
and
.I
Combinatorics, Probability and Computing
.R
11.
The results of 143 references depend on computer algorithms.
.PP
The references are ordered alphabetically by the last name
of the first author, and where multiple papers have the same
first author they are ordered by the last
name of the second author, etc. We preferred that all work
by the same author be in consecutive positions. Unfortunately,
this causes that some of the abbreviations are not in alphabetical
order. For example, [BaRT] is earlier on the list than [BaLS].
We also wish to explain a possible confusion with respect to
the order of parts and spelling of Chinese names. We put them
without any abbreviations, often with the last name written
first as is customary in original. Sometimes this is different
from the citations in other sources. One can obtain all variations
of writing any specific name by consulting the authors database of
\fIMathematical Reviews\fP at
\s-2\fHhttp://www.ams.org/mathscinet/search\fP\s0,
or \fIzbMATH\fP (formerly \fIZentralblatt f\o'u\(:a'r Mathematik\fP) at
\s-2\fHhttp://www.zbmath.org/authors\fP\s0.
.PP
Papers containing results obtained with the help of
computer algorithms have been marked with stars.
We identify two such categories of papers: those
marked with * involving some use of computers
where the results are easily verifiable with some computations,
and those marked with ** where cpu intensive algorithms have
to be implemented to replicate or verify the results.
The first category contains mostly constructions done by algorithms,
while the second mostly nonexistence results or claims of
complete enumerations of special classes of graphs.
.nr PS 10
.nr VS 12
$gsize 10$
.LP
.DS B
	A, Ba, Br				page 57
	Ca, Cl, D, E				page 62
	F, Ga, Gu, H				page 68
	I, J, K, La, Lo				page 74
	M, N, O, P, Q, R			page 79
	Sa, Si, Su				page 84
	T, U, V, W, X, Y, Z			page 90 - page 94
.DE
.sp
.nr PS 12

.DS C
\fBA\fP
.DE
.nr PS 10
.IP [Abb1] 0.65i
H.L. Abbott,
Some Problems in Combinatorial Analysis,
.I
Ph.D. thesis,
.R
Department of Mathematical and Statistical Sciences,
University of Alberta, Edmonton, 1965.
.IP [Abb2]
H.L. Abbott, A Theorem Concerning Higher Ramsey Numbers, in
.I
Infinite and Finite Sets,
.R
(A. Hajnal, R. Rado and V.T. S\o'o\(aa's eds.)
Vol. 1, 25-28, Colloq. Math. Soc. Janos Bolyai, Vol. 10,
North-Holland, Amsterdam, 1975.
.IP [AbbH]
H.L. Abbott and D. Hanson,
A Problem of Schur and Its Generalizations,
.I
Acta Arithmetica,
.R
\fB20\fP (1972) 175-187.
.IP [AbbL]
H.L. Abbott and Andy Liu,
Remarks on a Paper of Hirschfeld Concerning Ramsey Numbers,
.I
Discrete Mathematics,
.R
\fB39\fP (1982) 327-328.
.IP [AbbS]
H.L. Abbott and M.J. Smuga-Otto,
Lower Bounds for Hypergraph Ramsey Numbers,
.I
Discrete Applied Mathematics,
.R
\fB61\fP (1995) 177-180.
.IP [AbbW]
H.L. Abbott and E.R. Williams,
Lower Bounds for Some Ramsey Numbers,
.I
Journal of Combinatorial Theory,
.R
Series A, \fB16\fP (1974) 12-17.
.IP [-]
Adiwijaya, see [SuAM, SuAAM].
.IP [AjKS]
M. Ajtai, J. Koml\o'o\(aa's and E. Szemer\o'e\(aa'di, A Note on Ramsey Numbers,
.I
Journal of Combinatorial Theory,
.R
Series A, \fB29\fP (1980) 354-360.
.IP [AjKSS]
M. Ajtai, J. Koml\o'o\(aa's, M. Simonovits and E. Szemer\o'e\(aa'di,
Erd\o'o\(hu's-S\o'o\(aa's Conjecture,
.I
in preparation
.R
(2013).
.IP [AliBB]
K. Ali, A.Q. Baig and E.T. Baskoro,
On the Ramsey Number for a Linear Forest versus a Coctail Party Graph,
.I
Journal of Combinatorial Mathematics and Combinatorial Computing,
.R
\fB71\fP (2009) 173-177.
.IP [AliBas]
K. Ali and E.T. Baskoro,
On the Ramsey Numbers for a Combination of Paths and Jahangirs,
.I
Journal of Combinatorial Mathematics and Combinatorial Computing,
.R
\fB65\fP (2008) 113-119.
.IP [AliBT1]
K. Ali, E.T. Baskoro and I. Tomescu,
On the Ramsey Numbers for Paths and Generalized Jahangir Graphs $~J sub {s,^m}$,
.I
Bull. Math. Soc. Sci. Math. R. S. Roumanie (N.S.),
.R
\fB51(99)\fP (2008) 177-182.
.IP [AliBT2]
K. Ali, E.T. Baskoro and I. Tomescu,
On the Ramsey Number for Paths and Beaded Wheels,
.I
Journal of Prime Research in Mathematics,
.R
\fB5\fP (2009) 133-138.
.IP [AliSur]
K. Ali and Surahmat,
A Cycle or Jahangir Ramsey Unsaturated Graphs,
.I
Journal of Prime Research in Mathematics,
.R
\fB2\fP (2006) 187-193.
.IP [AllBS]
P. Allen, G. Brightwell and J. Skokan,
Ramsey-Goodness - and Otherwise,
.I
Combinatorica,
.R
\fB33\fP (2013) 125-160.
.IP [Alon1]
N. Alon, Subdivided Graphs Have Linear Ramsey Numbers,
.I
Journal of Graph Theory,
.R
\fB18\fP (1994) 343-347.
.IP [Alon2]
N. Alon, Explicit Ramsey Graphs and Orthonormal Labelings,
.I
Electronic Journal of Combinatorics,
.R
\s-1\fHhttp://www.combinatorics.org\fP\s0, #R12,
\fB1\fP (1994), 8 pages.
.IP [AlBK]
N. Alon, S. Ben-Shimon and M. Krivelevich,
A Note on Regular Ramsey Graphs,
.I
Journal of Graph Theory,
.R
\fB64\fP (2010) 244-249.
.IP [AlKS]
N. Alon, M. Krivelevich and B. Sudakov,
Tur\o'a\(aa'n Numbers of Bipartite Graphs and Related
Ramsey-Type Questions,
.I
Combinatorics, Probability and Computing,
.R
\fB12\fP (2003) 477-494.
.IP [AlPu]
N. Alon and P. Pudl\o'a\(aa'k,
Constructive Lower Bounds for off-diagonal Ramsey Numbers,
.I
Israel Journal of Mathematics,
.R
\fB122\fP (2001) 243-251.
.IP [AlR\o'o\(:a']
N. Alon and V. R\o'o\(:a'dl,
Sharp Bounds for Some Multicolor Ramsey Numbers,
.I
Combinatorica,
.R
\fB25\fP (2005) 125-141.
.IP [AlR\o'o\(aa'S]
N. Alon, L. R\o'o\(aa'nyai and T. Szab\o'o\(aa',
Norm-Graphs: Variations and Applications,
.I
Journal of Combinatorial Theory,
.R
Series B, \fB76\fP (1999) 280-290.
.IP [-]
B.M.N. Alzaleq, see [BatJA, JaAl1, JaAl2].
.IP [ArKM]
J. Arste, K. Klamroth and I. Mengersen, Three Color Ramsey Numbers
for Small Graphs,
.I
Utilitas Mathematica,
.R
\fB49\fP (1996) 85-96.
.IP [-]
H. Assiyatun, see [HaABS, HaBA1, HaBA2, BaHA, SuAAM, SuBAU1, SuBAU2, SuBAU3].
.IP [AxFM]
M. Axenovich, Z. F\o'u\(:a'redi and D. Mubayi,
On Generalized Ramsey Theory: the Bipartite Case,
.I
Journal of Combinatorial Theory,
.R
Series B, \fB79\fP (2000) 66-86.
.IP [AxGLM]
M. Axenovich, A. Gy\o'a\(aa'rf\o'a\(aa's, Homg Liu and D. Mubayi,
Multicolor Ramsey Numbers for Triple Systems,
.I
preprint,
.R
arXiv,
\s-1\fHhttp://arxiv.org/abs/1302.5304\fP\s0
(2013).
.nr PS 12

.DS C
\fBBa - Bo\fP
.DE
.nr PS 10
.IP [BaRT]*
A. Babak, S.P. Radziszowski and Kung-Kuen Tse,
Computation of the Ramsey Number $R(B sub 3 ,^K sub 5 )$,
.I
Bulletin of the Institute of Combinatorics and its Applications,
.R
\fB41\fP (2004) 71-76.
.IP [Back1]
J. Backelin, Contributions to a Ramsey Calculus,
.I
manuscript
.R
2000-2012.
.IP [Back2]
J. Backelin,
.I
personal communication
.R
(2013).
.IP [BahS]
P. Bahls and T.S. Spencer,
On the Ramsey Numbers of Trees with Small Diameter,
.I
Graphs and Combinatorics,
.R
\fB29\fP (2013) 39-44.
.IP [BaiLi]
Bai Lufeng and Li Yusheng,
Algebraic Constructions and Applications in Ramsey Theory,
.I
Advances in Mathematics,
.R
\fB35\fP (2006) 167-170.
.IP [BaLX]
Bai Lufeng, Li Yusheng and Xu Zhiqiang,
Algebraic Constructions and Applications in Ramsey Theory,
.I
Journal of Mathematical Study (China),
.R
\fB37\fP (2004) 245-249.
.IP [-]
Bai Lufeng, see also [SonBL].
.IP [-]
A.Q. Baig, see [AliBB].
.IP [BaLS]
P.N. Balister, J. Lehel and R.H. Schelp,
Ramsey Unsaturated and Saturated Graphs,
.I
Journal of Graph Theory,
.R
\fB51\fP (2006) 22-32.
.IP [BaSS]
P.N. Balister, R.H. Schelp and M. Simonovits,
A Note on Ramsey Size-Linear Graphs,
.I
Journal of Graph Theory,
.R
\fB39\fP (2002) 1-5.
.IP [-]
A.M.M. Baniabedalruhman, see [JaBa].
.IP [-]
Qiquan Bao, see [ShaXB, ShaXBP].
.IP [BarRSW]
B. Barak, A. Rao, R. Shaltiel and A. Widgerson,
2-Source Dispersers for $n sup o(1)$ Entropy, and Ramsey Graphs
Beating the Frankl-Wilson Construction,
.I
Annals of Mathematics
.R
(2), \fB176\fP (2012) 1483-1544.
.IP [Bas]
E.T. Baskoro,
The Ramsey Number of Paths and Small Wheels,
.I
Majalah Ilmiah Himpunan Matematika Indonesia,
.R
MIHMI, \fB8\fP (2002) 13-16.
.IP [BaHA]
E.T. Baskoro, Hasmawati and H. Assiyatun,
The Ramsey Numbers for Disjoint Unions of Trees,
.I
Discrete Mathematics,
.R
\fB306\fP (2006) 3297-3301.
.IP [BaSu]
E.T. Baskoro and Surahmat,
The Ramsey Number of Paths with respect to Wheels,
.I
Discrete Mathematics,
.R
\fB294\fP (2005) 275-277.
.IP [BaSNM]
E.T. Baskoro, Surahmat, S.M. Nababan and M. Miller,
On Ramsey Graph Numbers for Trees versus Wheels of Five or Six Vertices,
.I
Graphs and Combinatorics,
.R
\fB18\fP (2002) 717-721.
.IP [-]
E.T. Baskoro, see also [AliBB, AliBas, AliBT1, AliBT2, HaABS, HaBA1,
HaBA2, SuBa1, SuBa2, SuBAU1, SuBAU2, SuBAU3, SuBB1, SuBB2, SuBB3,
SuBB4, SuBT1, SuBT2, SuBTB, SuBUB].
.IP [BatJA]
M.S.A. Bataineh, M.M.M. Jaradat and L.M.N. Al-Zaleq,
The Cycle-Complete Graph Ramsey Number $r(C sub 9 ,^K sub 8 )$,
.I
International Scholarly Research Network - Algebra,
.R
Article ID 926191, (2011), 10 pages. 
.IP [BenSk]
F.S. Benevides and J. Skokan,
The 3-Colored Ramsey Number of Even Cycles,
.I
Journal of Combinatorial Theory,
.R
Series B, \fB99\fP (2009) 690-708.
.IP [-]
S. Ben-Shimon, see [AlBK].
.IP [Bev]
D. Bevan,
.I
personal communication
.R
(2002).
.IP [BePi]
A. Beveridge and O. Pikhurko,
On the Connectivity of Extremal Ramsey Graphs,
.I
Australasian Journal of Combinatorics,
.R
\fB41\fP (2008) 57-61.
.IP [BiaS]
A. Bialostocki and J. Sch\o'o\(:a'nheim, On Some Tur\o'a\(aa'n and
Ramsey Numbers for $C sub 4$, in
.I
Graph Theory and Combinatorics
.R
(ed. B. Bollob\o'a\(aa's), Academic Press, London, (1984) 29-33.
.IP [Biel1]
H. Bielak,
Ramsey and 2-local Ramsey Numbers for Disjoint Unions of Cycles,
.I
Discrete Mathematics,
.R
\fB307\fP (2007) 319-330.
.IP [Biel2]
H. Bielak,
Ramsey Numbers for a Disjoint Union of Some Graphs,
.I
Applied Mathematics Letters,
.R
\fB22\fP (2009) 475-477.
.IP [Biel3]
H. Bielak,
Multicolor Ramsey Numbers for Some Paths and Cycles,
.I
Discussiones Mathematicae Graph Theory,
.R
\fB29\fP (2009) 209-218.
.IP [Biel4]
H. Bielak,
Ramsey Numbers for a Disjoint Union of Good Graphs,
.I
Discrete Mathematics,
.R
\fB310\fP (2010) 1501-1505.
.IP [Bier]
J. Bierbrauer, Ramsey Numbers for the Path with Three Edges,
.I
European Journal of Combinatorics,
.R
\fB7\fP (1986) 205-206.
.IP [BierB]
J. Bierbrauer and A. Brandis, On Generalized Ramsey Numbers
for Trees,
.I
Combinatorica,
.R
\fB5\fP (1985) 95-107.
.IP [BlLR]*
K. Black, D. Leven and S.P. Radziszowski,
New Bounds on Some Ramsey Numbers,
.I
Journal of Combinatorial Mathematics and Combinatorial Computing,
.R
\fB78\fP (2011) 213-222.
.IP [Boh]
T. Bohman,
The Triangle-Free Process,
.I
Advances in Mathematics,
.R
\fB221\fP (2009) 1653-1677.
.IP [BohK1]
T. Bohman and P. Keevash,
The Early Evolution of the $H$-Free Process,
.I
Inventiones Mathematicae,
.R
\fB181\fP (2010) 291-336.
.IP [BohK2]
T. Bohman and P. Keevash,
Dynamic Concentration of the Triangle-Free Process,
.I
preprint,
.R
arXiv,
\s-1\fHhttp://arxiv.org/abs/1302.5963\fP\s0
(2013).
.IP [BolJY+]
B. Bollob\o'a\(aa's, C.J. Jayawardene,
Yang Jian Sheng, Huang Yi Ru, C.C. Rousseau, and Zhang Ke Min,
On a Conjecture Involving Cycle-Complete Graph Ramsey Numbers,
.I
Australasian Journal of Combinatorics,
.R
\fB22\fP (2000) 63-71.
.IP [BoH]
R. Bolze and H. Harborth, The Ramsey Number
$r(K sub 4 ^-^x,^K sub 5 )$, in
.I
The Theory and Applications of Graphs,
.R
(Kalamazoo, MI, 1980), John Wiley & Sons, New York, (1981) 109-116.
.IP [BoEr]
J.A. Bondy and P. Erd\o'o\(hu's, Ramsey Numbers for Cycles in Graphs,
.I
Journal of Combinatorial Theory,
.R
Series B, \fB14\fP (1973) 46-54.
.IP [Boza1]
L. Boza,
Nuevas Cotas Superiores de Algunos N\o'u\(aa'meros
de Ramsey del Tipo $r(K sub m ,^K sub n^-^e)$,
in proceedings of the
.I
VII Jornada de Matem\o'a\(aa'tica Discreta y Algoritmica,
.R
JMDA 2010, Castro Urdiales, Spain, July 2010.
.IP [Boza2]
L. Boza,
The Ramsey Number $r(K sub 5 ^-^P sub 3 ,^K sub 5 )$,
.I
Electronic Journal of Combinatorics,
.R
\s-1\fHhttp:// www.combinatorics.org\fP\s0, #P90,
\fB18\fP(1) (2011), 10 pages.
.IP [Boza3]*
L. Boza,
Upper Bounds for Some Ramsey Numbers of
$K sub n ^-^e$ versus $K sub m$,
.I
manuscript
.R
(2012).
.IP [Boza4]*
L. Boza,
N\o'u\(aa'meros de Ramsey de Algunos Grafos de
4 V\o'e\(aa'rtices y Todods los Grafos de 7 V\o'e\(aa'rtices,
in proceedings of the
.I
VIII Jornada de Matem\o'a\(aa'tica Discreta y Algoritmica,
.R
JMDA 2012, Almeria, Spain, July 2012.
.IP [Boza5]*
L. Boza,
.I
personal communication
.R
(2013).
.IP [Boza6]*
L. Boza,
Sobre el N\o'u\(aa'mero de Ramsey $R(K sub 4 ,^K sub 6 ^-^e )$,
.I
VIII Encuentro Andaluz de Matem\o'a\(aa'tica Discreta,
.R
Sevilla, Spain, October 2013.
.IP [BoCGR]
L. Boza, M. Cera, P. Garcia-V\o'a\(aa'zquez and M.P. Revuelta,
On the Ramsey Numbers for Stars versus Complete Graphs,
.I
European Journal of Combinatorics,
.R
\fB31\fP (2010) 1680-1688.
.IP [BoDD]*
L. Boza, J. Dybizba\o'n\(aa'ski and T. Dzido,
Three Color Ramsey Numbers for  Graphs With at Most 4 Vertices,
.I
Electronic Journal of Combinatorics,
.R
\s-1\fHhttp://www.combinatorics.org\fP\s0, #P47,
\fB19\fP(4) (2012), 16 pages.
.IP [BoPo]*
L. Boza and J.R. Portillo,
Sobre el N\o'u\(aa'mero de Ramsey $R(K sub 4 ^-^e ,^K sub 7 )$,
in proceedings of the
.I
VIII Jornada de Matem\o'a\(aa'tica Discreta y Algoritmica,
.R
JMDA 2012, Almeria, Spain, July 2012.

.nr PS 12

.DS C
\fBBr - Bu\fP
.DE
.nr PS 10
.IP [-]
A. Brandis, see [BierB].
.IP [Bra1]
S. Brandt, Subtrees and Subforests in Graphs,
.I
Journal of Combinatorial Theory,
.R
Series B, \fB61\fP (1994) 63-70.
.IP [Bra2]
S. Brandt, Sufficient Conditions for Graphs to Contain All
Subgraphs of a Given Type,
.I
Ph.D. thesis,
.R
Freie Universit\o'a\(:a't Berlin, 1994.
.IP [Bra3]
S. Brandt, Expanding Graphs and Ramsey Numbers,
.I
preprint No. A 96-24,
.R
ftp://ftp.math.fu-berlin.de/pub/math/publ/pre/1996 
(1996).
.R
.IP [BBH1]**
S. Brandt, G. Brinkmann and T. Harmuth, All Ramsey Numbers
$r(K sub 3 ,^G)$ for Connected Graphs of Order 9,
.I
Electronic Journal of Combinatorics,
.R
\s-1\fHhttp://www.combinatorics.org\fP\s0, #R7,
\fB5\fP (1998), 20 pages.
.IP [BBH2]**
S. Brandt, G. Brinkmann and T. Harmuth,
The Generation of Maximal Triangle-Free Graphs,
.I
Graphs and Combinatorics,
.R
\fB16\fP (2000) 149-157.
.IP [-]
G. Brightwell. see [AllBS].
.IP [Brin]**
G. Brinkmann, All Ramsey Numbers $r(K sub 3 ,^G)$ for Connected
Graphs of Order 7 and 8,
.I
Combinatorics, Probability and Computing,
.R
\fB7\fP (1998) 129-140.
.IP [BrCGM]*
G. Brinkmann, K. Coolsaet, J. Goedgebeur and H. M\o'e\(aa'lot,
House of Graphs: A database of interesting graphs,
.I
Discrete Applied Mathematics,
.R
\fB161\fP (2013) 311-314.
.IP [BrGS]**
G. Brinkmann, J. Goedgebeur and J.C. Schlage-Puchta,
Ramsey Numbers $R(K sub 3 ,^G)$ for Graphs of Order 10,
.I
Electronic Journal of Combinatorics,
.R
\s-1\fHhttp://www.combinatorics.org\fP\s0, #P36,
\fB19\fP(4) (2012), 23 pages.
.IP [-]
G. Brinkmann, see also [BBH1, BBH2].
.IP [-]
H.J. Broersma, see [SaBr1, SaBr2, SaBr3, SaBr4, SuBB1, SuBB2, SuBB3, SuBB4, SuBTB, SuBUB].
.IP [BR]*
J.P. Burling and S.W. Reyner, Some Lower Bounds of the Ramsey Numbers
$n(k,^k)$,
.I
Journal of Combinatorial Theory,
.R
Series B, \fB13\fP (1972) 168-169.
.IP [Bu1]
S.A. Burr, Generalized Ramsey Theory for Graphs - a Survey, in
.I
Graphs and Combinatorics
.R
(R. Bari and F. Harary eds.), Springer LNM \fB406\fP, Berlin, (1974) 52-75.
.IP [Bu2]
S.A. Burr, Ramsey Numbers Involving Graphs with Long
Suspended Paths,
.I
Journal of the London Mathematical Society
.R
(2), \fB24\fP (1981) 405-413.
.IP [Bu3]
S.A. Burr, Multicolor Ramsey Numbers Involving Graphs with Long
Suspended Path,
.I
Discrete Mathematics,
.R
\fB40\fP (1982) 11-20.
.IP [Bu4]
S.A. Burr, Diagonal Ramsey Numbers for Small Graphs,
.I
Journal of Graph Theory,
.R
\fB7\fP (1983) 57-69.
.IP [Bu5]
S.A. Burr, Ramsey Numbers Involving Powers of Sparse Graphs,
.I
Ars Combinatoria,
.R
\fB15\fP (1983) 163-168.
.IP [Bu6]
S.A. Burr,
Determining Generalized Ramsey Numbers is NP-Hard,
.I
Ars Combinatoria,
.R
\fB17\fP (1984) 21-25.
.IP [Bu7]
S.A. Burr, What Can We Hope to Accomplish in Generalized
Ramsey Theory?,
.I
Discrete Mathematics,
.R
\fB67\fP (1987) 215-225.
.IP [Bu8]
S.A. Burr, On the Ramsey Numbers $r(G,^nH)$ and $r(nG,^nH)$
When $n$ Is Large,
.I
Discrete Mathematics,
.R
\fB65\fP (1987) 215-229.
.IP [Bu9]
S.A. Burr, On Ramsey Numbers for Large Disjoint Unions of Graphs,
.I
Discrete Mathematics,
.R
\fB70\fP (1988) 277-293.
.IP [Bu10]
S.A. Burr,
On the Computational Complexity of Ramsey-type Problems,
Mathematics of Ramsey Theory,
.I
Algorithms and Combinatorics,
.R
\fB5\fP, Springer, Berlin, 1990, 46-52.
.IP [BE1]
S.A. Burr and P. Erd\o'o\(hu's,
On the Magnitude of Generalized Ramsey Numbers for Graphs, in
.I
Infinite and Finite Sets,
.R
(A. Hajnal, R. Rado and V.T. S\o'o\(aa's eds., Keszthely 1973)
Vol. 1, 215-240, Colloq. Math. Soc. Janos Bolyai, Vol. 10,
North-Holland, Amsterdam, 1975.
.IP [BE2]
S.A. Burr and P. Erd\o'o\(hu's, Extremal Ramsey Theory for Graphs,
.I
Utilitas Mathematica,
.R
\fB9\fP (1976) 247-258.
.IP [BE3]
S.A. Burr and P. Erd\o'o\(hu's, Generalizations of a Ramsey-Theoretic Result
of Chv\o'a\(aa'tal,
.I
Journal of Graph Theory,
.R
\fB7\fP (1983) 39-51.
.IP [BEFRS1]
S.A. Burr, P. Erd\o'o\(hu's, R.J. Faudree, C.C. Rousseau and R.H. Schelp,
An Extremal Problem in Generalized Ramsey Theory,
.I
Ars Combinatoria,
.R
\fB10\fP (1980) 193-203.
.IP [BEFRS2]
S.A. Burr, P. Erd\o'o\(hu's, R.J. Faudree, C.C. Rousseau and R.H. Schelp,
Ramsey Numbers for the Pair Sparse Graph-Path or Cycle,
.I
Transactions of the American Mathematical Society,
.R
\fB269\fP (1982) 501-512.
.IP [BEFRS3]
S.A. Burr, P. Erd\o'o\(hu's, R.J. Faudree, C.C. Rousseau and R.H. Schelp,
The Ramsey Number for the Pair Complete Bipartite Graph-Graph of
Limited Degree, in
.I
Graph Theory with Applications to Algorithms and Computer
Science,
.R
(Y. Alavi et al. eds.), John Wiley & Sons, New York, (1985) 163-174.
.IP [BEFRS4]
S.A. Burr, P. Erd\o'o\(hu's, R.J. Faudree, C.C. Rousseau and R.H. Schelp,
Some Complete Bipartite Graph-Tree Ramsey Numbers,
.I
Annals of Discrete Mathematics,
.R
\fB41\fP (1989) 79-89.
.IP [BEFRSGJ]
$~$
S.A. Burr, P. Erd\o'o\(hu's, R.J. Faudree, C.C. Rousseau, R.H. Schelp,
R.J. Gould and M.S. Jacobson,
Goodness of Trees for Generalized Books,
.I
Graphs and Combinatorics,
.R
\fB3\fP (1987) 1-6.
.IP [BEFS]
S.A. Burr, P. Erd\o'o\(hu's, R.J. Faudree and R.H. Schelp,
On the Difference between Consecutive Ramsey Numbers,
.I
Utilitas Mathematica,
.R
\fB35\fP (1989) 115-118.
.IP [BES]
S.A. Burr, P. Erd\o'o\(hu's and J.H. Spencer, Ramsey Theorems for Multiple
Copies of Graphs,
.I
Transactions of the American Mathematical Society,
.R
\fB209\fP (1975) 87-99.
.IP [BF]
S.A. Burr and R.J. Faudree,
On Graphs $G$ for Which All Large Trees Are $G$-good,
.I
Graphs and Combinatorics,
.R
\fB9\fP (1993) 305-313.
.IP [BFRS]
S.A. Burr, R.J. Faudree, C.C. Rousseau and R.H. Schelp,
On Ramsey Numbers Involving Starlike Multipartite Graphs,
.I
Journal of Graph Theory,
.R
\fB7\fP (1983) 395-409.
.IP [BG]
S.A. Burr and J.W. Grossman, Ramsey Numbers of Graphs
with Long Tails,
.I
Discrete Mathematics,
.R
\fB41\fP (1982) 223-227.
.IP [BuRo1]
S.A. Burr and J.A. Roberts, On Ramsey Numbers for Stars,
.I
Utilitas Mathematica,
.R
\fB4\fP (1973) 217-220.
.IP [BuRo2]
S.A. Burr and J.A. Roberts, On Ramsey Numbers for Linear Forests,
.I
Discrete Mathematics,
.R
\fB8\fP (1974) 245-250.
.IP [BuRo3]
S.A. Burr and V. Rosta,
On the Ramsey Multiplicities of Graphs - Problems and Recent Results,
.I
Journal of Graph Theory,
.R
\fB4\fP (1980) 347-361.
.IP [Bush]
L.E. Bush, The William Lowell Putnam Mathematical Competition
(question #2 in Part I asks for the proof of $R(3,3)~<=~6^$),
.I
American Mathematical Monthly,
.R
\fB60\fP (1953) 539-542.

.nr PS 12

.DS C
\fBCa - Ch\fP
.DE
.nr PS 10
.IP [CaET]*
N.J. Calkin, P. Erd\o'o\(hu's and C.A. Tovey, New Ramsey Bounds
from Cyclic Graphs of Prime Order,
.I
SIAM Journal of Discrete Mathematics,
.R
\fB10\fP (1997) 381-387.
.IP [CalSR]*
J.A. Calvert and M.J. Schuster and S.P. Radziszowski,
Computing the Ramsey Number $R(K sub 5 ^-^P sub 3 ,^K sub 5 )$,
.I
Journal of Combinatorial Mathematics and Combinatorial Computing,
.R
\fB82\fP (2012) 131-140.
.IP [Car]
D. Cariolaro, On the Ramsey Number $R(3,^6)$,
.I
Australasian J. of Combinatorics,
.R
\fB37\fP (2007) 301-304.
.IP [Caro]
Y. Caro, Zero-Sum Problems - A Survey,
.I
Discrete Mathematics,
.R
\fB152\fP (1996) 93-113.
.IP [CaLRZ]
Y. Caro, Li Yusheng, C.C. Rousseau and Zhang Yuming,
Asymptotic Bounds for Some Bipartite Graph - Complete Graph
Ramsey Numbers,
.I
Discrete Mathematics,
.R
\fB220\fP (2000) 51-56.
.IP [-]
M. Cera, see [BoCGR].
.IP [ChaMR]
J. Chapppelon, L.P. Montejano and J.L. Ramirez Alfonsin,
Upper Bounds and Values for $r(K sub m ,^K sub n ^-^K sub 1,s )$
and $r(K sub m ^-^e ,^K sub n ^-^K sub 1,s )$,
.I
preprint,
.R
arXiv,
\s-1\fHhttp://arxiv.org/abs/1310.3786\fP\s0
(2013).
.IP [ChGP]
G. Chartrand, R.J. Gould and A.D. Polimeni, On Ramsey Numbers
of Forests versus Nearly Complete Graphs,
.I
Journal of Graph Theory,
.R
\fB4\fP (1980) 233-239.
.IP [CRSPS]
G. Chartrand, C.C. Rousseau, M.J. Stewart, A.D. Polimeni and
J. Sheehan, On Star-Book Ramsey Numbers, in
.I
Proceedings of the Fourth International Conference on the Theory
and Applications of Graphs,
.R
(Kalamazoo, MI 1980), John Wiley & Sons, (1981) 203-214.
.IP [ChaS]
G. Chartrand and S. Schuster,
On the Existence of Specified Cycles in Complementary Graphs,
.I
Bulletin of the American Mathematical Society,
.R
\fB77\fP (1971) 995-998.
.IP [Chen]
Chen Guantao, A Result on $C sub 4$-Star Ramsey Numbers,
.I
Discrete Mathematics,
.R
\fB163\fP (1997) 243-246.
.IP [ChenS]
Chen Guantao and R.H. Schelp, Graphs with Linearly Bounded
Ramsey Numbers,
.I
Journal of Combinatorial Theory,
.R
Series B, \fB57\fP (1993) 138-149.
.IP [ChWXSL]*
$~^$Chen Hong, Wu Kang, Xu Xiaodong, Su Wenlong and Liang Wenzhong,
New Lower Bound for Nine Classical Ramsey Numbers $R(3,^t)$
(in Chinese),
.I
Journal of Mathematics,
.R
\fB31\fP (2011) 582-586.
.IP [-]
Chen Hong, see also [LiaWXCS, XWCS].
.IP [ChenJ]
Chen Jie,
The Lower Bound of Some Ramsey Numbers (in Chinese),
.I
Journal of Liaoning Normal University, Natural Science,
.R
\fB25\fP (2002) 244-246.
.IP [ChenCMN]
$^$ Yaojun Chen, T.C. Edwin Cheng, Zhengke Miao and C.T. Ng,
The Ramsey Numbers for Cycles versus Wheels of Odd Order,
.I
Applied Mathematics Letters,
.R
\fB22\fP (2009) 1875-1876.
.IP [ChenCNZ]
$^$ Yaojun Chen, T.C. Edwin Cheng, C.T. Ng and Yunqing Zhang,
A Theorem on Cycle-Wheel Ramsey Number,
.I
Discrete Mathematics,
.R
\fB312\fP (2012) 1059-1061.
.IP [ChenCX]
Yaojun Chen, T.C. Edwin Cheng and Ran Xu,
The Ramsey Number for a Cycle of Length Six versus
a Clique of Order Eight,
.I
Discrete Applied Mathematics,
.R
\fB157\fP (2009) 8-12.
.IP [ChenCZ1]
$~$ Yaojun Chen, T.C. Edwin Cheng and Yunqing Zhang,
The Ramsey Numbers $R(C sub m ,^K sub 7 )$ and $R(C sub 7 ,^K sub 8 )$,
.I
European Journal of Combinatorics,
.R
\fB29\fP (2008) 1337-1352.
.IP [ChenZZ1]
$~$
Chen Yaojun, Zhang Yunqing and Zhang Ke Min,
The Ramsey Numbers of Paths versus Wheels,
.I
Discrete Mathematics,
.R
\fB290\fP (2005) 85-87.
.IP [ChenZZ2]
$~$
Chen Yaojun, Zhang Yunqing and Zhang Ke Min,
The Ramsey Numbers of Stars versus Wheels,
.I
European Journal of Combinatorics,
.R
\fB25\fP (2004) 1067-1075.
.IP [ChenZZ3]
$~$
Chen Yaojun, Zhang Yunqing and Zhang Ke Min,
The Ramsey Numbers $R(T sub n ,^W sub 6 ^)$ for $DELTA (T sub n )~>=~n^-^3$,
.I
Applied Mathematics Letters,
.R
\fB17\fP (2004) 281-285.
.IP [ChenZZ4]
$~$
Chen Yaojun, Zhang Yunqing and Zhang Ke Min,
The Ramsey Numbers of Trees versus $W sub 6$ or $W sub 7$,
.I
European Journal of Combinatorics,
.R
\fB27\fP (2006) 558-564.
.IP [ChenZZ5]
$~$
Chen Yaojun, Zhang Yunqing and Zhang Ke Min,
The Ramsey Numbers $R(T sub n ,^W sub 6^)$ for Small $n$,
.I
Utilitas Mathematica,
.R
\fB67\fP (2005) 269-284.
.IP [ChenZZ6]
$~$
Chen Yaojun, Zhang Yunqing and Zhang Ke Min,
The Ramsey Numbers $R(T sub n ,^W sub 6^)$ for
$T sub n$ without Certain Deletable Sets,
.I
Journal of Systems Science and Complexity,
.R
\fB18\fP (2005) 95-101.
.IP [-]
Chen Yaojun, see also [CheCZN, ZhaCC1, ZhaCC2, ZhaCZ1, ZhaCZ2].
.IP [Cheng]
Cheng Ying, On Graphs Which Do Not Contain Certain Trees,
.I
Ars Combinatoria,
.R
\fB19\fP (1985) 119-151.
.IP [CheCZN]
$~$
T.C. Edwin Cheng, Yaojun Chen, Yunqing Zhang and C.T. Ng,
The Ramsey Numbers for a Cycle of Length Six or Seven versus
a Clique of Order Seven,
.I
Discrete Mathematics,
.R
\fB307\fP (2007) 1047-1053.
.IP [-]
T.C. Edwin Cheng, see also [ChenCMN, ChenCNZ, ChenCX, ChenCZ1, ZhaCC1, ZhaCC2].
.IP [Chu1]
F.R.K. Chung, On the Ramsey Numbers $N(3,3,...,3^;^2)$,
.I
Discrete Mathematics,
.R
\fB5\fP (1973) 317-321.
.IP [Chu2]
F.R.K. Chung, On Triangular and Cyclic Ramsey Numbers with $k$
Colors, in
.I
Graphs and Combinatorics
.R
(R. Bari and F. Harary eds.), Springer LNM \fB406\fP, Berlin, (1974) 236-241.
.IP [Chu3]
F.R.K. Chung, A Note on Constructive Methods for Ramsey Numbers,
.I
Journal of Graph Theory,
.R
\fB5\fP (1981) 109-113.
.IP [Chu4]
F.R.K. Chung,
Open problems of Paul Erd\o'o\(hu's in Graph Theory,
.I
Journal of Graph Theory,
.R
\fB25\fP (1997) 3-36.
.IP [ChCD]
F.R.K. Chung, R. Cleve and P. Dagum, A Note on Constructive Lower
Bounds for the Ramsey Numbers $R(3,^t)$,
.I
Journal of Combinatorial Theory,
.R
Series B, \fB57\fP (1993) 150-155.
.IP [ChGra1]
F.R.K. Chung and R.L. Graham, On Multicolor Ramsey Numbers for
Complete Bipartite Graphs,
.I
Journal of Combinatorial Theory,
.R
Series B, \fB18\fP (1975) 164-169.
.IP [ChGra2]
F.R.K. Chung and R.L. Graham,
.I
Erd\o'o\(hu's on Graphs, His Legacy of Unsolved Problems,
.R
A K Peters, Wellesley, Massachusetts (1998).
.IP [ChGri]
F.R.K. Chung and C.M. Grinstead, A Survey of Bounds for Classical Ramsey
Numbers,
.I
Journal of Graph Theory,
.R
\fB7\fP (1983) 25-37.
.IP [Chv]
V. Chv\o'a\(aa'tal, Tree-Complete Graph Ramsey Numbers,
.I
Journal of Graph Theory,
.R
\fB1\fP (1977) 93.
.IP [CH1]
V. Chv\o'a\(aa'tal and F. Harary, Generalized Ramsey Theory for Graphs, II.
Small Diagonal Numbers,
.I
Proceedings of the American Mathematical Society,
.R
\fB32\fP (1972) 389-394.
.IP [CH2]
V. Chv\o'a\(aa'tal and F. Harary, Generalized Ramsey Theory for Graphs, III.
Small Off-Diagonal Numbers,
.I
Pacific Journal of Mathematics,
.R
\fB41\fP (1972) 335-345.
.IP [CH3]
V. Chv\o'a\(aa'tal and F. Harary, Generalized Ramsey Theory for Graphs, I.
Diagonal Numbers,
.I
Periodica Mathematica Hungarica,
.R
\fB3\fP (1973) 115-124.
.IP [CRST]
V. Chv\o'a\(aa'tal, V. R\o'o\(:a'dl, E. Szemer\o'e\(aa'di and
W.T. Trotter Jr., The Ramsey Number of a Graph with Bounded
Maximum Degree,
.I
Journal of Combinatorial Theory,
.R
Series B, \fB34\fP (1983) 239-243.
.IP [ChvS]
V. Chv\o'a\(aa'tal and A. Schwenk, On the Ramsey Number
of the Five-Spoked Wheel, in
.I
Graphs and Combinatorics
.R
(R. Bari and F. Harary eds.), Springer LNM \fB406\fP, Berlin, (1974) 247-261.
.nr PS 12

.DS C
\fBCl - Cs\fP
.DE
.nr PS 10
.IP [Clan]
M. Clancy, Some Small Ramsey Numbers,
.I
Journal of Graph Theory,
.R
\fB1\fP (1977) 89-91.
.IP [Clap]
C. Clapham, The Ramsey Number
$r(C sub 4 ,^C sub 4 ,^C sub 4 )$,
.I
Periodica Mathematica Hungarica,
.R
\fB18\fP (1987) 317-318.
.IP [CEHMS]
C. Clapham, G. Exoo, H. Harborth, I. Mengersen and J. Sheehan,
The Ramsey Number of $K sub 5 ^-^e$,
.I
Journal of Graph Theory,
.R
\fB13\fP (1989) 7-15.
.IP [Clark]
L. Clark, On Cycle-Star Graph Ramsey Numbers,
.I
Congressus Numerantium,
.R
\fB50\fP (1985) 187-192.
.IP [CleDa]
R. Cleve and P. Dagum,
A Constructive $OMEGA (t sup 1.26 )$ Lower Bound
for the Ramsey Number $R(3,t)$,
.I
International Computer Science Institute,
.R
TR-89-009, Berkeley, CA, 1989.
.IP [-]
R. Cleve, see also [ChCD].
.IP [Coc]
E.J. Cockayne,
Some Tree-Star Ramsey Numbers,
.I
Journal of Combinatorial Theory,
.R
Series B, \fB17\fP (1974) 183-187.
.IP [CocL1]
E.J. Cockayne and P.J. Lorimer, The Ramsey Number for Stripes,
.I
Journal of the Australian Mathematical Society,
.R
Series A, \fB19\fP (1975) 252-256.
.IP [CocL2]
E.J. Cockayne and P.J. Lorimer, On Ramsey Graph Numbers
for Stars and Stripes,
.I
Canadian Mathematical Bulletin,
.R
\fB18\fP (1975) 31-34.
.IP [CPR]
B. Codenotti, P. Pudl\o'a\(aa'k and G. Resta,
Some Structural Properties of Low-Rank Matrices Related to
Computational Complexity,
.I
Theoretical Computer Science,
.R
\fB235\fP (2000) 89-107.
.IP [CoPC]
Special issue on Ramsey theory of
.I
Combinatorics, Probability and Computing,
.R
\fB12\fP (2003), Numbers 5 and 6.
.IP [Con1]
D. Conlon, A New Upper Bound for Diagonal Ramsey Numbers,
.I
Annals of Mathematics,
.R
\fB170\fP (2009) 941-960.
.IP [Con2]
D. Conlon, Hypergraph Packing and Sparse Bipartite Ramsey Numbers,
.I
Combinatorics, Probability and Computing,
.R
\fB18\fP (2009) 913-923.
.IP [Con3]
D. Conlon,
The Ramsey Number of Dense Graphs,
.I
Bulletin of the London Mathematical Society
.R
\fB45\fP (2013) 483-496.
.IP [ConFS1]
D. Conlon, J. Fox and B. Sudakov,
Ramsey Numbers of Sparse Hypergraphs,
.I
Random Structures and Algorithms,
.R
\fB35\fP (2009) 1-14.
.IP [ConFS2]
D. Conlon, J. Fox and B. Sudakov,
Hypergraph Ramsey Numbers,
.I
Journal of the American Mathematical Society,
.R
\fB23\fP (2010) 247-266.
.IP [ConFS3]
D. Conlon, J. Fox and B. Sudakov,
Large Almost Monochromatic Subsets in Hypergraphs,
.I
Israel Journal of Mathematics,
.R
\fB181\fP (2011) 423-432.
.IP [ConFS4]
D. Conlon, J. Fox and B. Sudakov,
On Two Problems in Graph Ramsey Theory,
.I
Combinatorica,
.R
\fB32\fP (2012) 513-535.
.IP [ConFS5]
D. Conlon, J. Fox and B. Sudakov,
Erd\o'o\(hu's-Hajnal-type Theorems in Hypergraphs,
.I
Journal of Combinatorial Theory,
.R
Series B, \fB102\fP (2012) 1142-1154.
.IP [ConFS6]
D. Conlon, J. Fox and B. Sudakov,
An Improved Bound for the Stepping-Up Lemma,
.I
Discrete Applied Mathematics,
.R
\fB161\fP (2013) 1191-1196.
.IP [CooFKO1]
$~$O. Cooley, N. Fountoulakis, D. K\o'u\(:a'hn and D. Osthus,
3-Uniform Hypergraphs of Bounded Degree Have Linear Ramsey Numbers,
.I
Journal of Combinatorial Theory,
.R
Series B, \fB98\fP (2008) 484-505.
.IP [CooFKO2]
$~$O. Cooley, N. Fountoulakis, D. K\o'u\(:a'hn and D. Osthus,
Embeddings and Ramsey Numbers of Sparse $k$-uniform Hypergraphs,
.I
Combinatorica,
.R
\fB29\fP (2009) 263-297.
.IP [-]
O. Cooley, see also [K\o'u\(:a'CFO].
.IP [-]
K. Coolsaet, see [BrCGM].
.IP [CsKo]
R. Cs\o'a\(aa'k\o'a\(aa'ny and J. Koml\o'o\(aa's,
The Smallest Ramsey Numbers,
.I
Discrete Mathematics,
.R
\fB199\fP (1999) 193-199.
.nr PS 12

.DS C
\fBD\fP
.DE
.nr PS 10
.IP [-]
P. Dagum, see [ChCD, CleDa].
.IP [Den1]
T. Denley, The Independence Number of Graphs with Large Odd Girth,
.I
Electronic Journal of Combinatorics,
.R
\s-1\fHhttp://www.combinatorics.org\fP\s0, #R9,
\fB1\fP (1994), 12 pages.
.IP [Den2]
T. Denley, The Ramsey Numbers for Disjoint Unions of Cycles,
.I
Discrete Mathematics,
.R
\fB149\fP (1996) 31-44.
.IP [Dong]
Dong Lin,
A Note on a Lower Bound for $r(K sub {m,n})$,
.I
Journal of Tongji University
(Natural Science),
.R
\fB38\fP (2010) 776,778.
.IP [DoLi]
Lin Dong and Yusheng Li,
A Construction for Ramsey Numbers for $K sub {m,n}$,
.I
European Journal of Combinatorics,
.R
\fB31\fP (2010) 1667-1670.
.IP [DoLL1]
Lin Dong, Yusheng Li and Qizhong Lin,
Ramsey Numbers Involving Graphs with Large Degrees,
.I
Applied Mathematics Letters,
.R
\fB22\fP (2009) 1577-1580.
.IP [DoLL2]
Dong Lin, Li Yusheng and Lin Qizhong,
Ramsey Numbers of Cycles vs. Large Complete Graph,
.I
Advances in Mathematics (China),
.R
\fB39\fP (2010) 700-702.
.IP [-]
Dong Lin, see also [HeLD, LinLD].
.IP [DuHu]
Duan Chanlun and Huang Wenke,
Lower Bound of Ramsey Number $r(3,^10)$ (in Chinese),
.I
Acta Scientiarum Naturalium Universitatis Nei Mongol,
.R
\fB31\fP (2000) 468-470.
.IP [DLR]
D. Duffus, H. Lefmann and V. R\o'o\(:a'dl, Shift Graphs and Lower
Bounds on Ramsey Numbers $r sub k ^(l^;^r)$,
.I
Discrete Mathematics,
.R
\fB137\fP (1995) 177-187.
.IP [Dyb]*
J. Dybizba\o'n\(aa'ski,
On Some Ramsey Numbers of $C sub 4$ versus $K sub 2,n$,
.I
Journal of Combinatorial Mathematics and Combinatorial Computing.
.R
\fB87\fP (2013) 137-145.
.IP [DyDz1]*
J. Dybizba\o'n\(aa'ski and T. Dzido,
On Some Ramsey Numbers for Quadrilaterals,
.I
Electronic Journal of Combinatorics,
.R
\s-1\fHhttp:// www.combinatorics.org\fP\s0, #P154,
\fB18\fP(1) (2011), 12 pages.
.IP [DyDz2]
J. Dybizba\o'n\(aa'ski and T. Dzido,
On Some Ramsey Numbers for Quadrilaterals versus Wheels,
to appear in
.I
Graphs and Combinatorics,
.R
published online 28 Feb 2013.
.IP [DyDR]
J. Dybizba\o'n\(aa'ski, T. Dzido and S.P. Radziszowski,
On Some Three-Color Ramsey Numbers for Paths,
.I
manuscript
.R
(2013).
.IP [-]
J. Dybizba\o'n\(aa'ski, see also [BoDD].
.IP [Dzi1]*
T. Dzido, Ramsey Numbers for Various Graph Classes (in Polish),
.I
Ph.D. thesis,
.R
University of Gda\o'n\(aa'sk, Poland, November 2005.
.IP [Dzi2]*
T. Dzido, Multicolor Ramsey Numbers for Paths and Cycles,
.I
Discussiones Mathematicae Graph Theory,
.R
\fB25\fP (2005) 57-65.
.IP [DzFi1]*
T. Dzido and R. Fidytek,
The Number of Critical Colorings for Some Ramsey Numbers,
.I
International Journal of Pure and Applied Mathematics,
.R
ISSN 1311-8080,
\fB38\fP (2007) 433-444.
.IP [DzFi2]*
T. Dzido and R. Fidytek,
On Some Three Color Ramsey Numbers for Paths and Cycles,
.I
Discrete Mathematics,
.R
\fB309\fP (2009) 4955-4958.
.IP [DzKP]
T. Dzido, M. Kubale and K. Piwakowski,
On Some Ramsey and Tur\o'a\(aa'n-type Numbers for Paths and Cycles,
.I
Electronic Journal of Combinatorics,
.R
\s-1\fHhttp://www.combinatorics.org\fP\s0, #R55,
\fB13\fP (2006), 9 pages.
.IP [DzNS]
T. Dzido, A. Nowik and P. Szuca,
New Lower Bound for Multicolor Ramsey Numbers for Even Cycles,
.I
Electronic Journal of Combinatorics,
.R
\s-1\fHhttp://www.combinatorics.org\fP\s0, #N13,
\fB12\fP (2005), 5 pages.
.IP [-]
T. Dzido, see also [BoDD, DyDz1, DyDz2, DyDR].
.nr PS 12

.DS C
\fBE\fP
.DE
.nr PS 10
.IP [Ea1]
Easy to obtain by simple combinatorics from other results,
in particular by using graphs establishing
lower bounds with smaller parameters.
.IP [Ea2]
Unique 2-(6,3,2) design gives lower bound 7, upper bound is easy.
.IP [Ea3]
Every edge $(3,3,3;2)$-coloring of $K sub 15$
has 35 edges in each color [Hein], and since
the number of triangles in $K sub 16$ is not divisible by 3,
hence no required triangle-coloring of $K sub 16$ exists.
.IP [Eaton]
N. Eaton, Ramsey Numbers for Sparse Graphs,
.I
Discrete Mathematics,
.R
\fB185\fP (1998) 63-75.
.IP [Erd1]
P. Erd\o'o\(hu's,
Some Remarks on the Theory of Graphs,
.I
Bulletin of the American Mathematical Society,
.R
\fB53\fP (1947) 292-294.
.IP [Erd2]
P. Erd\o'o\(hu's,
Some New Problems and Results in Graph Theory and
Other Branches of Combinatorial Mathematics,
.I
Combinatorics and Graph Theory
.R
(Calcutta 1980),
Berlin-NY Springer, LNM \fB885\fP (1981) 9-17.
.IP [Erd3]
P. Erd\o'o\(hu's,
On the Combinatorial Problems Which I Would Most Like to See Solved,
.I
Combinatorica,
.R
\fB1\fP (1981) 25-42.
.IP [Erd4]
P. Erd\o'o\(hu's,
On Some Problems in Graph Theory, Combinatorial Analysis and Combinatorial Number Theory,
.I
Graph Theory and Combinatorics,
.R
(Cambridge 1983), 1-17, Academic Press, London-New York, 1984.
.IP [EFRS1]
P. Erd\o'o\(hu's, R.J. Faudree, C.C. Rousseau and R.H. Schelp,
Generalized Ramsey Theory for Multiple Colors,
.I
Journal of Combinatorial Theory,
.R
Series B, \fB20\fP (1976) 250-264.
.IP [EFRS2]
P. Erd\o'o\(hu's, R.J. Faudree, C.C. Rousseau and R.H. Schelp,
On Cycle-Complete Graph Ramsey Numbers,
.I
Journal of Graph Theory,
.R
\fB2\fP (1978) 53-64.
.IP [EFRS3]
P. Erd\o'o\(hu's, R.J. Faudree, C.C. Rousseau and R.H. Schelp,
Ramsey Numbers for Brooms,
.I
Congressus Numerantium,
.R
\fB35\fP (1982) 283-293.
.IP [EFRS4]
P. Erd\o'o\(hu's, R.J. Faudree, C.C. Rousseau and R.H. Schelp,
Multipartite Graph-Sparse Graph Ramsey Numbers,
.I
Combinatorica,
.R
\fB5\fP (1985) 311-318.
.IP [EFRS5]
P. Erd\o'o\(hu's, R.J. Faudree, C.C. Rousseau and R.H. Schelp,
A Ramsey Problem of Harary on Graphs with Prescribed Size,
.I
Discrete Mathematics,
.R
\fB67\fP (1987) 227-233.
.IP [EFRS6]
P. Erd\o'o\(hu's, R.J. Faudree, C.C. Rousseau and R.H. Schelp,
Extremal Theory and Bipartite Graph-Tree Ramsey Numbers,
.I
Discrete Mathematics,
.R
\fB72\fP (1988) 103-112.
.IP [EFRS7]
P. Erd\o'o\(hu's, R.J. Faudree, C.C. Rousseau and R.H. Schelp,
The Book-Tree Ramsey Numbers,
.I
Scientia,
.R
Series A: Mathematical Sciences, Valpara\o'\(dl\(aa'so, Chile,
\fB1\fP (1988) 111-117.
.IP [EFRS8]
P. Erd\o'o\(hu's, R.J. Faudree, C.C. Rousseau and R.H. Schelp,
Multipartite Graph-Tree Graph Ramsey Numbers, in
.I
Graph Theory and Its Applications: East and West,
Proceedings of the First China-USA International
Graph Theory Conference,
.R
Annals of the New York Academy of Sciences,
\fB576\fP (1989) 146-154.
.IP [EFRS9]
P. Erd\o'o\(hu's, R.J. Faudree, C.C. Rousseau and R.H. Schelp,
Ramsey Size Linear Graphs,
.I
Combinatorics, Probability and Computing,
.R
\fB2\fP (1993) 389-399.
.IP [EG]
P. Erd\o'o\(hu's and R.L. Graham, On Partition Theorems for
Finite Sets, in
.I
Infinite and Finite Sets,
.R
(A. Hajnal, R. Rado and V.T. S\o'o\(aa's eds.)
Vol. 1, 515--527, Colloq. Math. Soc. Janos Bolyai, Vol. 10,
North Holland, 1975.
.IP [-]
P. Erd\o'o\(hu's, see also [BoEr, BE1, BE2, BE3, BEFRS1, BEFRS2, BEFRS3,
BEFRS4, BEFRSGJ, BEFS, BES, CaET].
.IP [Ex1]*
G. Exoo, Ramsey Numbers of Hypergraphs,
.I
Journal of Combinatorial Mathematics and Combinatorial Computing,
.R
\fB2\fP (1987) 5-11.
.IP [Ex2]*
G. Exoo, Constructing Ramsey Graphs with a Computer,
.I
Congressus Numerantium,
.R
\fB59\fP (1987) 31-36.
.IP [Ex3]*
G. Exoo, Applying Optimization Algorithm to Ramsey Problems, in
.I
Graph Theory, Combinatorics, Algorithms, and Applications
.R
(Y. Alavi ed.), SIAM Philadelphia, (1989) 175-179.
.IP [Ex4]*
G. Exoo, A Lower Bound for $R(5,^5)$,
.I
Journal of Graph Theory,
.R
\fB13\fP (1989) 97-98.
.IP [Ex5]*
G. Exoo, On Two Classical Ramsey Numbers of the Form $R(3,^n)$,
.I
SIAM Journal of Discrete Mathematics,
.R
\fB2\fP (1989) 488-490.
.IP [Ex6]*
G. Exoo, A Lower Bound for $r(K sub 5 ^-^e,^K sub 5 )$,
.I
Utilitas Mathematica,
.R
\fB38\fP (1990) 187-188.
.IP [Ex7]*
G. Exoo, Three Color Ramsey Number of $K sub 4 ^-^ e,$
.I
Discrete Mathematics,
.R
\fB89\fP (1991) 301-305.
.IP [Ex8]*
G. Exoo, Indiana State University,
.I
personal communication
.R
(1992).
.IP [Ex9]*
G. Exoo, Announcement: On the Ramsey Numbers
$R(4,^6)$, $R(5,^6)$ and $R(3,12)$,
.I
Ars Combinatoria,
.R
\fB35\fP (1993) 85. The construction of a graph proving $R(4,^6) ^>=^ 35$
is presented in detail at \s-1\fHhttp://ginger.indstate.edu/ge/RAMSEY\fP\s0 (2001).
.IP [Ex10]*
G. Exoo, A Lower Bound for Schur Numbers and Multicolor
Ramsey Numbers of $K sub 3$,
.I
Electronic Journal of Combinatorics,
.R
\s-1\fHhttp://www.combinatorics.org\fP\s0, #R8,
\fB1\fP (1994), 3 pages.
.IP [Ex11]*
G. Exoo, Indiana State University,
.I
personal communication
.R
(1997).
.IP [Ex12]*
G. Exoo, Some New Ramsey Colorings,
.I
Electronic Journal of Combinatorics,
.R
\s-1\fHhttp://www.combinatorics.org\fP\s0, #R29,
\fB5\fP (1998), 5 pages. The constructions
are available electronically from \s-1\fHhttp://ginger.indstate.edu/ge/RAMSEY\fP\s0.
.IP [Ex13]*
G. Exoo, Indiana State University,
.I
personal communication
.R
(1998). Constructions available at
\s-1\fHhttp://ginger.indstate.edu/ge/RAMSEY\fP\s0.
.IP [Ex14]*
G. Exoo, Indiana State University,
.I
New Lower Bounds for Table III,
.R
(2000). Constructions available at
\s-1\fHhttp://ginger.indstate.edu/ge/RAMSEY\fP\s0.
.IP [Ex15]*
G. Exoo, Indiana State University,
.I
personal communication
.R
(2002-2004).
Constructions available at
\s-1\fHhttp://ginger.indstate.edu/ge/RAMSEY\fP\s0.
.IP [Ex16]*
G. Exoo, Indiana State University,
.I
personal communication
.R
(2005-2006). Constructions available at
\s-1\fHhttp://ginger.indstate.edu/ge/RAMSEY\fP\s0.
.IP [Ex17]*
G. Exoo, Indiana State University,
.I
personal communication
.R
(2010-2011).
Constructions available at
\s-1\fHhttp://ginger.indstate.edu/ge/RAMSEY\fP\s0.
.IP [Ex18]*
G. Exoo, Indiana State University,
.I
personal communication
.R
(2012-2013).
Constructions available at
\s-1\fHhttp://ginger.indstate.edu/ge/RAMSEY\fP\s0.
.IP [Ex19]*
G. Exoo,
On the Ramsey Number $R(4,^6)$,
.I
Electronic Journal of Combinatorics,
.R
\s-1\fHhttp://www. combinatorics.org\fP\s0, #P66,
\fB19\fP(1) (2012), 5 pages.
.IP [Ex20]*
G. Exoo,
On Some Small Classical Ramsey Numbers,
.I
Electronic Journal of Combinatorics,
.R
\s-1\fHhttp:// www.combinatorics.org\fP\s0, #P68,
\fB20\fP(1) (2013), 6 pages.
.IP [Ex21]*
G. Exoo,
Ramsey Colorings from $p$-Groups,
.I
in preparation,
.R
(2013).
.IP [EHM1]
G. Exoo, H. Harborth and I. Mengersen, The Ramsey Number
of $K sub 4$ versus $K sub 5 ^-^e$,
.I
Ars Combinatoria,
.R
\fB25A\fP (1988) 277-286.
.IP [EHM2]
G. Exoo, H. Harborth and I. Mengersen,
On Ramsey Number of $K sub 2,n$, in
.I
Graph Theory, Combinatorics, Algorithms, and Applications
.R
(Y. Alavi, F.R.K. Chung, R.L. Graham and D.F. Hsu eds.),
SIAM Philadelphia, (1989) 207-211.
.IP [ExRe]*
G. Exoo and D.F. Reynolds, Ramsey Numbers Based on
$C sub 5$-Decompositions,
.I
Discrete Mathematics,
.R
\fB71\fP (1988) 119-127.
.IP [-]
G. Exoo, see also [CEHMS, XXER].

.nr PS 12

.DS C
\fBF\fP
.DE
.nr PS 10
.IP [FLPS]
R.J. Faudree, S.L. Lawrence, T.D. Parsons and R.H. Schelp,
Path-Cycle Ramsey Numbers,
.I
Discrete Mathematics,
.R
\fB10\fP (1974) 269-277.
.IP [FM]**
R.J. Faudree and B.D. McKay, A Conjecture of Erd\o'o\(hu's and the
Ramsey Number $r(W sub 6 ^)$,
.I
Journal of Combinatorial Mathematics and Combinatorial Computing,
.R
\fB13\fP (1993) 23-31.
.IP [FRS1]
R.J. Faudree, C.C. Rousseau and R.H. Schelp, All Triangle-Graph Ramsey
Numbers for Connected Graphs of Order Six,
.I
Journal of Graph Theory,
.R
\fB4\fP (1980) 293-300.
.IP [FRS2]
R.J. Faudree, C.C. Rousseau and R.H. Schelp, Studies Related to the
Ramsey Number $r(K sub 5 ^-^e)$, in
.I
Graph Theory and Its Applications to Algorithms and Computer Science,
.R
(Y. Alavi et al. eds.), John Wiley and Sons, New York, (1985) 251-271.
.IP [FRS3]
R.J. Faudree, C.C. Rousseau and R.H. Schelp,
Generalizations of the Tree-Complete Graph Ramsey Number, in
.I
Graphs and Applications,
.R
(F. Harary and J.S. Maybee eds.), John Wiley and Sons,
New York, (1985) 117-126.
.IP [FRS4]
R.J. Faudree, C.C. Rousseau and R.H. Schelp, Small Order
Graph-Tree Ramsey Numbers,
.I
Discrete Mathematics,
.R
\fB72\fP (1988) 119-127.
.IP [FRS5]
R.J. Faudree, C.C. Rousseau and R.H. Schelp, A Good Idea in
Ramsey Theory, in
.I
Graph Theory, Combinatorics, Algorithms, and Applications
.R
(San Francisco, CA 1989), SIAM Philadelphia, PA (1991) 180-189.
.IP [FRS6]
R.J. Faudree, C.C. Rousseau and R.H. Schelp,
Problems in Graph Theory from Memphis, in
.I
The Mathematics of Paul Erd\o'o\(hu's II,
.R
R.L. Graham et al. (eds.), Springer, New York, (2013) 95-118.
.IP [FRS7]
R.J. Faudree, C.C. Rousseau and J. Sheehan,
More from the Good Book, in
.I
Proceedings of the Ninth Southeastern Conference on Combinatorics,
Graph Theory, and Computing,
.R
Utilitas Mathematica Publ.,
.I
Congressus Numerantium,
.R
\fBXXI\fP (1978) 289-299.
.IP [FRS8]
R.J. Faudree, C.C. Rousseau and J. Sheehan,
Strongly Regular Graphs and Finite Ramsey Theory,
.I
Linear Algebra and its Applications,
.R
\fB46\fP (1982) 221-241.
.IP [FRS9]
R.J. Faudree, C.C. Rousseau and J. Sheehan, Cycle-Book Ramsey Numbers,
.I
Ars Combinatoria,
.R
\fB31\fP (1991) 239-248.
.IP [FS1]
R.J. Faudree and R.H. Schelp, All Ramsey Numbers for Cycles in Graphs,
.I
Discrete Mathematics,
.R
\fB8\fP (1974) 313-329.
.IP [FS2]
R.J. Faudree and R.H. Schelp, Path Ramsey Numbers in Multicolorings,
.I
Journal of Combinatorial Theory,
.R
Series B, \fB19\fP (1975) 150-160.
.IP [FS3]
R.J. Faudree and R.H. Schelp, Ramsey Numbers for All Linear Forests,
.I
Discrete Mathematics,
.R
\fB16\fP (1976) 149-155.
.IP [FS4]
R.J. Faudree and R.H. Schelp,
Some Problems in Ramsey Theory, in
.I
Theory and Applications of Graphs,
.R
(conference proceedings, Kalamazoo, MI 1976),
Lecture Notes in Mathematics \fB642\fP,
Springer, Berlin, (1978) 500-515.
.IP [FSR]
R.J. Faudree, R.H. Schelp and C.C. Rousseau,
Generalizations of a Ramsey Result of Chv\o'a\(aa'tal, in
.I
Proceedings of the Fourth International Conference on the Theory
and Applications of Graphs,
.R
(Kalamazoo, MI 1980), John Wiley & Sons, (1981) 351-361.
.IP [FSS1]
R.J. Faudree, R.H. Schelp and M. Simonovits, On Some Ramsey Type
Problems Connected with Paths, Cycles and Trees,
.I
Ars Combinatoria,
.R
\fB29A\fP (1990) 97-106.
.IP [FSS2]
R.J. Faudree, A. Schelten and I. Schiermeyer,
The Ramsey Number $r(C sub 7 ,^C sub 7 ,^C sub 7 )$,
.I
Discussiones Mathematicae Graph Theory,
.R
\fB23\fP (2003) 141-158.
.IP [FS]
R.J. Faudree and M. Simonovits, Ramsey Problems and Their
Connection to Tur\o'a\(aa'n-Type Extremal Problems,
.I
Journal of Graph Theory,
.R
\fB16\fP (1992) 25-50.
.IP [-]
R.J. Faudree, see also [BEFRS1, BEFRS2, BEFRS3, BEFRS4, BEFRSGJ,
BEFS, BF, BFRS, EFRS1, EFRS2, EFRS3, EFRS4, EFRS5, EFRS6, EFRS7, EFRS8, EFRS9].
.IP [FKR]**
S. Fettes, R.L. Kramer and S.P. Radziszowski,
An Upper Bound of 62 on the Classical Ramsey Number $R(3,3,3,3)$,
.I
Ars Combinatoria,
.R
\fB72\fP (2004) 41-63.
.IP [Fid1]*
R. Fidytek,
Two- and Three-Color Ramsey Numbers for Paths and Cycles,
.I
manuscript
.R
(2010).
.IP [Fid2]*
R. Fidytek,
Ramsey Graphs $R(K sub n ,^K sub m ^-^e)$,
\s-1\fHhttp://fidytek.inf.ug.edu.pl/ramsey\fP\s0 (2010).
.IP [-]
R. Fidytek, see also [DzFi1, DzFi2].
.IP [Fi\(L/u1]
A. Figaj and T. \(L/uczak,
The Ramsey Number for a Triple of Long Even Cycles,
.I
Journal of Combinatorial Theory,
.R
Series B, \fB97\fP (2007) 584-596.
.IP [Fi\(L/u2]
A. Figaj and T. \(L/uczak,
The Ramsey Numbers for a Triple of Long Cycles,
.I
preprint,
.R
arXiv,
\s-1\fHhttp://front.math.ucdavis.edu/0709.0048\fP\s0
(2007).
.IP [FizGM]
G. Fiz Pontiveros, S. Griffiths and R. Morris,
The Triangle-Free Process and $R(3,^k)$,
.I
preprint,
.R
arXiv,
\s-1\fHhttp://arxiv.org/abs/1302.6279\fP\s0
(2013).
.IP [FizGMSS]
$~$ G. Fiz Pontiveros, S. Griffiths, R. Morris, D. Saxton and J. Skokan,
The Ramsey Number of the Clique and the Hypercube,
.I
preprint,
.R
arXiv,
\s-1\fHhttp://arxiv.org/abs/1306.0461\fP\s0
(2013).
.IP [Fol]
J. Folkman, Notes on the Ramsey Number $N(3,3,3,3)$,
.I
Journal of Combinatorial Theory,
.R
Series A, \fB16\fP (1974) 371-379.
.IP [-]
N. Fountoulakis, see [CooFKO1, CooFKO2, K\o'u\(:a'CFO].
.IP [FoxSu1]
J. Fox and B. Sudakov,
Density Theorems for Bipartite Graphs and Related Ramsey-type Results,
.I
Combinatorica,
.R
\fB29\fP (2009) 153-196.
.IP [FoxSu2]
J. Fox and B. Sudakov,
Two Remarks on the Burr-Erd\o'o\(hu's Conjecture,
.I
European Journal of Combinatorics,
.R
\fB30\fP (2009) 1630-1645.
.IP [-]
J. Fox, see also [ConFS1, ConFS2, ConFS3, ConFS4, ConFS5, ConFS6].
.IP [FraWi]
P. Frankl and R.M. Wilson,
Intersection Theorems with Geometric Consequences,
.I
Combinatorica,
.R
\fB1\fP (1981) 357-368.
.IP [Fra1]
K. Fraughnaugh Jones, Independence in Graphs with Maximum Degree Four,
.I
Journal of Combinatorial Theory,
.R
Series B, \fB37\fP (1984) 254-269.
.IP [Fra2]
K. Fraughnaugh Jones, Size and Independence in Triangle-Free Graphs
with Maximum Degree Three,
.I
Journal of Graph Theory,
.R
\fB14\fP (1990) 525-535.
.IP [FrLo]
K. Fraughnaugh and S.C. Locke,
Finding Independent Sets in Triangle-Free Graphs,
.I
SIAM Journal of Discrete Mathematics,
.R
\fB9\fP (1996) 674-681.
.IP [Fre]
H. Fredricksen, Schur Numbers and the Ramsey Numbers $N(3,3,...,3^;^2)$,
.I
Journal of Combinatorial Theory,
.R
Series A, \fB27\fP (1979) 376-377.
.IP [FreSw]*
H. Fredricksen and M.M. Sweet,
Symmetric Sum-Free Partitions and Lower Bounds for Schur Numbers,
.I
Electronic Journal of Combinatorics,
.R
\s-1\fHhttp://www.combinatorics.org\fP\s0, #R32, \fB7\fP (2000), 9 pages.
.IP [Fuj1]*
H. Fujita, Ramsey Numbers and Ramsey Graphs, website,
\s-1\fHhttp://opal.inf.kyushu-u.ac.jp/~fujita/ ramsey.html\fP\s0.
.IP [Fuj2]
S. Fujita,
Generalized Ramsey Numbers for Graphs with Three Disjoint Cycles versus a Complete Graph,
.I
Electronic Journal of Combinatorics,
.R
\s-1\fHhttp://www.combinatorics.org\fP\s0,
#P14, \fB19\fP(2) (2012), 11 pages.
.IP [F\o'u\(:a'r]
Z. F\o'u\(:a'redi,
Large Chromatic Number and Ramsey Graphs,
.I
preprint,
.R
arXiv,
\s-1\fHhttp://arxiv.org/abs/ 1103.3917\fP\s0
(2011).
.IP [-]
Z. F\o'u\(:a'redi, see also [AxFM].
.nr PS 12

.DS C
\fBGa - Gr\fP
.DE
.nr PS 10
.IP [-] 0.65i
P. Garcia-V\o'a\(aa'zquez, see [BoCGR].
.IP [Gas]
W. Gasarch, Applications of Ramsey Theory to Computer Science,
collection of pointers to papers,
\s-1\fHhttp://www.cs.umd.edu/~gasarch/ramsey/ramsey.html\fP\s0
(2009, 2011).
.IP [GauST]
S. Gautam, A.K. Srivastava and A. Tripathi,
On Multicolour Noncomplete Ramsey Graphs of Star Graphs,
.I
Discrete Applied Mathematics,
.R
\fB156\fP (2008) 2423-2428.
.IP [Gerb]*
R. Gerbicz,
New Lower Bounds for Two Color and Multicolor Ramsey Numbers,
.I
preprint,
.R
arXiv,
\s-1\fHhttp://arxiv.org/abs/1004.4374\fP\s0
(2010).
.IP [GeGy] 0.65i
L. Gerencs\o'e\(aa'r and A. Gy\o'a\(aa'rf\o'a\(aa's, On Ramsey-Type
Problems,
.I
Annales Universitatis Scientiarum Budapestinensis, E\o'o\(:a'tv\o'o\(:a's Sect. Math.,
.R
\fB10\fP (1967) 167-170.
.IP [Gi1]
G. Giraud,
Une g\o'e\(aa'n\o'e\(aa'ralisation des nombres et de
l'in\o'e\(aa'galit\o'e\(aa' de Schur,
.I
C.R. Acad. Sc. Paris,
.R
S\o'e\(aa'ries A-B, \fB266\fP (1968)  A437-A440.
.IP [Gi2]
G. Giraud, Minoration de certains nombres de Ramsey binaires par les
nombres de Schur g\o'e\(aa'n\o'e\(aa'ralis\o'e\(aa's,
.I
C.R. Acad. Sc. Paris,
.R
S\o'e\(aa'ries A-B, \fB266\fP (1968)  A481-A483.
.IP [Gi3]
G. Giraud, Nouvelles majorations des nombres de Ramsey binaires-bicolores,
.I
C.R. Acad. Sc. Paris,
.R
S\o'e\(aa'ries A-B, \fB268\fP (1969)  A5-A7.
.IP [Gi4]
G. Giraud, Majoration du nombre de Ramsey ternaire-bicolore en (4,4),
.I
C.R. Acad. Sc. Paris,
.R
S\o'e\(aa'ries A-B, \fB269\fP (1969) A620-A622.
.IP [Gi5]
G. Giraud,
Une minoration du nombre de quadrangles unicolores et son application \o'a\(ga'
la majoration des nombres de Ramsey binaires-bicolores,
.I
C.R. Acad. Sc. Paris,
.R
S\o'e\(aa'ries A-B, \fB276\fP (1973) A1173-A1175.
.IP [Gi6]
G. Giraud,
Sur le probl\o'e\(ga'me de Goodman pour les quadrangles et
la majoration des nombres de Ramsey,
.I
Journal of Combinatorial Theory,
.R
Series B, \fB27\fP (1979) 237-253.
.IP [-]
A.M. Gleason, see [GG].
.IP [GoK]
W. Goddard and D.J. Kleitman,
An Upper Bound for the Ramsey Numbers $r(K sub 3 ,^G)$,
.I
Discrete Mathematics,
.R
\fB125\fP (1994) 177-182.
.IP [GoR1]**
J. Goedgebeur and S.P. Radziszowski,
New Computational Upper Bounds for Ramsey Numbers $R(3,^k)$,
.I
Electronic Journal of Combinatorics,
.R
\s-1\fHhttp://www.combinatorics.org\fP\s0, #P30,
\fB20\fP(1) (2013), 28 pages.
.IP [GoR2]**
J. Goedgebeur and S.P. Radziszowski,
The Ramsey Number $R(3,^K sub 10 ^-^e)$
and Computational Bounds for $R(3,^G)$,
.I
Electronic Journal of Combinatorics,
.R
\s-1\fHhttp://www.combinatorics.org\fP\s0, #P19,
\fB20\fP(4) (2013), 25 pages.
.IP [-]
J. Goedgebeur, see also [BrCGM, BrGS].
.IP [GoMC]
A. Gon\o'c\(ce'alves and E.L. Monte Carmelo,
Some Geometric Structures and Bounds for Ramsey Numbers,
.I
Discrete Mathematics,
.R
\fB280\fP (2004) 29-38.
.IP [GoJa1]
R.J. Gould and M.S. Jacobson, Bounds for the Ramsey Number of
a Disconnected Graph versus Any Graph,
.I
Journal of Graph Theory,
.R
\fB6\fP (1982) 413-417.
.IP [GoJa2]
R.J. Gould and M.S. Jacobson, On the Ramsey Number of Trees versus
Graphs with Large Clique Number,
.I
Journal of Graph Theory,
.R
\fB7\fP (1983) 71-78.
.IP [-]
R.J. Gould, see also [BEFRSGJ, ChGP].
.IP [GrNe]
R.L. Graham and J. Ne\o's\(be'et\o'r\(be'il,
Ramsey Theory and Paul Erd\o'o\(hu's (Recent Results from a Historical Perspective),
.I
Bolyai Society Mathematical Studies,
.R
\fB11\fP, Budapest (2002) 339-365.
.IP [GrR\o'o\(:a']
R.L. Graham and V. R\o'o\(:a'dl, Numbers in Ramsey Theory, in
.I
Surveys in Combinatorics,
.R
(ed. C. Whitehead), Cambridge University Press, 1987, 111-153.
.IP [GRR1]
R.L. Graham, V. R\o'o\(:a'dl and A. Ruci\o'n\(aa'ski,
On Graphs with Linear Ramsey Numbers,
.I
Journal of Graph Theory,
.R
\fB35\fP (2000) 176-192.
.IP [GRR2]
R.L. Graham, V. R\o'o\(:a'dl and A. Ruci\o'n\(aa'ski,
On Bipartite Graphs with Linear Ramsey Numbers,
Paul Erd\o'o\(hu's and his mathematics,
.I
Combinatorica,
.R
\fB21\fP (2001) 199-209.
.IP [GRS]
R.L. Graham, B.L. Rothschild and J.H. Spencer,
.I
Ramsey Theory,
.R
John Wiley & Sons, second edition 1990.
.IP [-]
R.L. Graham, see also [ChGra1, ChGra2, EG].
.IP [GrY]
J.E. Graver and J. Yackel, Some Graph Theoretic Results Associated with
Ramsey's Theorem,
.I
Journal of Combinatorial Theory,
.R
\fB4\fP (1968) 125-175.
.IP [GG]
R.E. Greenwood and A.M. Gleason, Combinatorial Relations and
Chromatic Graphs,
.I
Canadian Journal of Mathematics,
.R
\fB7\fP (1955) 1-7.
.IP [GH]
U. Grenda and H. Harborth, The Ramsey Number $r(K sub 3 ,^K sub 7 ^-^e)$,
.I
Journal of Combinatorics, Information & System Sciences,
.R
\fB7\fP (1982) 166-169.
.IP [-]
S. Griffiths, see [FizGM, FizGMSS].
.IP [Gri]
J.R. Griggs, An Upper Bound on the Ramsey Numbers $R(3,k)$,
.I
Journal of Combinatorial Theory,
.R
Series A, \fB35\fP (1983) 145-153.
.IP [GR]**
C. Grinstead and S. Roberts, On the Ramsey Numbers $R(3,8)$ and $R(3,9)$,
.I
Journal of Combinatorial Theory,
.R
Series B, \fB33\fP (1982) 27-51.
.IP [-]
C. Grinstead, see also [ChGri].
.IP [Grol1]
V. Grolmusz,
Superpolynomial Size Set-Systems with Restricted Intersections mod 6
and Explicit Ramsey Graphs,
.I
Combinatorica,
.R
\fB20\fP (2000) 73-88.
.IP [Grol2]
V. Grolmusz,
Low Rank Co-Diagonal Matrices and Ramsey Graphs,
.I
Electronic Journal of Combinatorics,
.R
\s-1\fHhttp://www.combinatorics.org\fP\s0, #R15,
\fB7\fP (2000), 7 pages.
.IP [Grol3]
V. Grolmusz,
Set-Systems with Restricted Multiple Intersections,
.I
Electronic Journal of Combinatorics,
.R
\s-1\fHhttp://www.combinatorics.org\fP\s0, #R8,
\fB9\fP (2002), 10 pages.
.IP [Gros1]
J.W. Grossman, Some Ramsey Numbers of Unicyclic Graphs,
.I
Ars Combinatoria,
.R
\fB8\fP (1979) 59-63.
.IP [Gros2]
J.W. Grossman, The Ramsey Numbers of the Union of Two Stars,
.I
Utilitas Mathematica,
.R
\fB16\fP (1979) 271-279.
.IP [GHK]
J.W. Grossman, F. Harary and M. Klawe, Generalized Ramsey Theory
for Graphs, X: Double Stars,
.I
Discrete Mathematics,
.R
\fB28\fP (1979) 247-254.
.IP [-]
J.W. Grossman, see also [BG].
.nr PS 12

.DS C
\fBGu - Gy\fP
.DE
.nr PS 10
.IP [GuLi]
Gu Hua and Li Yusheng,
On Ramsey Number of $K sub 2,t+1 $ vs $K sub 1,n$,
.I
Journal of Nanjing University Mathematical Biquarterly,
.R
\fB19\fP (2002) 150-153.
.IP [GuSL]
Gu Hua, Song Hongxue and Liu Xiangyang,
Ramsey Numbers $r(K sub up 10 {1,4} ,^G^)$ for
All Three-Partite Graphs $G$ of Order Six,
.I
Journal of Southeast University,
.R
(English Edition), \fB20\fP (2004) 378-380.
.IP [-]
Gu Hua, see also [SonGQ].
.IP [GuoV]
Guo Yubao and L. Volkmann, Tree-Ramsey Numbers,
.I
Australasian Journal of Combinatorics,
.R
\fB11\fP (1995) 169-175.
.IP [-]
L. Gupta, see [GGS].
.IP [GGS]
S.K. Gupta, L. Gupta and A. Sudan,
On Ramsey Numbers for Fan-Fan Graphs,
.I
Journal of Combinatorics, Information & System Sciences,
.R
\fB22\fP (1997) 85-93.
.IP [GyLSS]
A. Gy\o'a\(aa'rf\o'a\(aa's, J. Lehel, G.N. S\o'a\(aa'rk\o'o\(:a'zy and R.H. Schelp,
Monochromatic Hamiltonian Berge-Cycles in Colored Complete Uniform Hypergraphs,
.I
Journal of Combinatorial Theory,
.R
Series B, \fB98\fP (2008) 342-358.
.IP [GyRa]
A. Gy\o'a\(aa'rf\o'a\(aa's and G. Raeisi,
The Ramsey Number of Loose Triangles and Quadrangles in Hypergraphs,
.I
Electronic Journal of Combinatorics,
.R
\s-1\fHhttp://www.combinatorics.org\fP\s0, #P30,
\fB19\fP(2) (2012), 9 pages.
.IP [GyRSS]
A. Gy\o'a\(aa'rf\o'a\(aa's, M. Ruszink\o'o\(aa',
G.N. S\o'a\(aa'rk\o'o\(:a'zy and E. Szemer\o'e\(aa'di,
Three-color Ramsey Numbers for Paths,
.I
Combinatorica,
.R
\fB27\fP (2007) 35-69. \fICorrigendum\fP in
\fB28\fP (2008) 499-502.
.IP [GyS\o'a\(aa'1]
A. Gy\o'a\(aa'rf\o'a\(aa's and G.N. S\o'a\(aa'rk\o'o\(:a'zy,
The 3-Colour Ramsey Number of a 3-Uniform Berge Cycle,
.I
Combinatorics, Probability and Computing,
.R
\fB20\fP (2011) 53-71.
.IP [GyS\o'a\(aa'2]
A. Gy\o'a\(aa'rf\o'a\(aa's and G.N. S\o'a\(aa'rk\o'o\(:a'zy,
Star versus Two Stripes Ramsey Numbers and a Conjecture of Schelp,
.I
Combinatorics, Probability and Computing,
.R
\fB21\fP (2012) 179-186.
.IP [GySS1]
A. Gy\o'a\(aa'rf\o'a\(aa's,
G.N. S\o'a\(aa'rk\o'o\(:a'zy and E. Szemer\o'e\(aa'di,
The Ramsey Number of Diamond-Matchings and Loose Cycles in Hypergraphs,
.I
Electronic Journal of Combinatorics,
.R
\s-1\fHhttp://www.combinatorics.org\fP\s0, #R126,
\fB15\fP (2008), 14 pages.
.IP [GySS2]
A. Gy\o'a\(aa'rf\o'a\(aa's,
G.N. S\o'a\(aa'rk\o'o\(:a'zy and E. Szemer\o'e\(aa'di,
Monochromatic Hamiltonian 3-Tight Berge Cycles
in 2-Colored 4-Uniform Hypergraphs,
.I
Journal of Graph Theory,
.R
\fB63\fP (2010) 288-299.
.IP [GySeT]
A. Gy\o'a\(aa'rf\o'a\(aa's, A. Seb\o'o\(hu' and N. Trotignon,
The Chromatic Gap and Its Extremes,
.I
Journal of Combinatorial Theory,
.R
Series B, \fB102\fP (2012) 1155-1178.
.IP [GyTu]
A. Gy\o'a\(aa'rf\o'a\(aa's and Z. Tuza, An Upper Bound on the
Ramsey Number of Trees,
.I
Discrete Mathematics,
.R
\fB66\fP (1987) 309-310.
.IP [-]
A. Gy\o'a\(aa'rf\o'a\(aa's, see also [AxGLM, GeGy].

.nr PS 12

.DS C
\fBH\fP
.DE
.nr PS 10
.IP [H\o'a\(:a'g]
R. H\o'a\(:a'ggkvist, On the Path-Complete Bipartite Ramsey Number,
.I
Discrete Mathematics,
.R
\fB75\fP (1989) 243-245.
.IP [Han]*
D. Hanson,
Sum-Free Sets and Ramsey Numbers,
.I
Discrete Mathematics,
.R
\fB14\fP (1976) 57-61.
.IP [-]
D. Hanson, see also [AbbH].
.IP [Hans]
M. Hansson,
On Generalized Ramsey Numbers for Two Sets of Cycles,
.I
Sj\o'a\(:a'lvst\o'a\(:a'ndiga Arbeten i Matematik,
.R
Matematiska Institutionen, Stockholms Universitet, \fB28\fP (2012).
.IP [Har1]
F. Harary, Recent Results on Generalized Ramsey Theory for Graphs, in
.I
Graph Theory and Applications,
.R
(Y. Alavi et al. eds.) Springer, Berlin (1972) 125-138.
.IP [Har2]
F. Harary, Generalized Ramsey Theory I to XIII: Achievement
and Avoidance Numbers, in
.I
Proceedings of the Fourth International Conference on the Theory
and Applications of Graphs,
.R
(Kalamazoo, MI 1980), John Wiley & Sons, (1981) 373-390.
.IP [-]
F. Harary, see also [CH1, CH2, CH3, GHK].
.IP [HaKr1]**
H. Harborth and S. Krause,
Ramsey Numbers for Circulant Colorings,
.I
Congressus Numerantium,
.R
\fB161\fP (2003) 139-150.
.IP [HaKr2]**
H. Harborth and S. Krause,
Distance Ramsey Numbers,
.I
Utilitas Mathematica,
.R
\fB70\fP (2006) 197-200.
.IP [HaMe1]
H. Harborth and I. Mengersen, An Upper Bound for the Ramsey Number
$r(K sub 5 ^-^e)$,
.I
Journal of Graph Theory,
.R
\fB9\fP (1985) 483-485.
.IP [HaMe2]
H. Harborth and I. Mengersen, All Ramsey Numbers for Five Vertices
and Seven or Eight Edges,
.I
Discrete Mathematics,
.R
\fB73\fP (1988/89) 91-98.
.IP [HaMe3]
H. Harborth and I. Mengersen, The Ramsey Number of $K sub 3,3$, in
.I
Combinatorics, Graph Theory, and Applications,
.R
Vol. \fB2\fP (Y. Alavi, G. Chartrand, O.R. Oellermann and J. Schwenk eds.),
John Wiley & Sons, (1991) 639-644.
.IP [-]
H. Harborth, see also [BoH, CEHMS, EHM1, EHM2, GH].
.IP [HaMe4]
M. Harborth and I. Mengersen, Some Ramsey Numbers for
Complete Bipartite Graphs,
.I
Australasian Journal of Combinatorics,
.R
\fB13\fP (1996) 119-128.
.IP [-]
T. Harmuth, see [BBH1, BBH2].
.IP [Has]
Hasmawati,
The Ramsey Numbers for Disjoint Union of Stars,
.I
Journal of the Indonesian Mathematical Society,
.R
\fB16\fP (2010) 133-138.
.IP [HaABS]
Hasmawati, H. Assiyatun, E.T. Baskoro and A.N.M. Salman,
Ramsey Numbers on a Union of Identical Stars versus a Small Cycle, in
Computational Geometry and Graph Theory, Kyoto CGGT 2007,
.I
LNCS
.R
4535, Springer, Berlin (2008) 85-89.
.IP [HaBA1]
Hasmawati, E.T. Baskoro and H. Assiyatun,
Star-Wheel Ramsey Numbers,
.I
Journal of Combinatorial Mathematics and Combinatorial Computing,
.R
\fB55\fP (2005) 123-128.
.IP [HaBA2]
Hasmawati, E.T. Baskoro and H. Assiyatun,
The Ramsey Numbers for Disjoint Unions of Graphs,
.I
Discrete Mathematics,
.R
\fB308\fP (2008) 2046-2049.
.IP [-]
Hasmawati, see also [BaHA].
.IP [Ha\(L/P1+]
P.E. Haxell, T. \(L/uczak, Y. Peng, V. R\o'o\(:a'dl,
A. Ruci\o'n\(aa'ski, M. Simonovits and J. Skokan,
The Ramsey Number for Hypergraph Cycles I,
.I
Journal of Combinatorial Theory,
.R
Series A, \fB113\fP (2006) 67-83.
.IP [Ha\(L/P2+]
P.E. Haxell, T. \(L/uczak, Y. Peng, V. R\o'o\(:a'dl,
A. Ruci\o'n\(aa'ski and J. Skokan,
The Ramsey Number for 3-Uniform  Tight Hypergraph Cycles,
.I
Combinatorics, Probability and Computing,
.R
\fB18\fP (2009) 165-203.
.IP [Ha\(L/T]
P.E. Haxell, T. \(L/uczak and P.W. Tingley,
Ramsey Numbers for Trees of Small Maximum Degree,
.I
Combinatorica,
.R
\fB22\fP (2002) 287-320.
.IP [HeLD]*
Changxiang He, Yusheng Li and Lin Dong,
Three-Color Ramsey Numbers of $K sub n$ Dropping an Edge,
.I
Graphs and Combinatorics,
.R
\fB28\fP (2012) 663-669.
.IP [Hein]
K. Heinrich, Proper Colourings of $K sub 15$,
.I
Journal of the Australian Mathematical Society,
.R
Series A, \fB24\fP (1977) 465-495.
.IP [He1]
G.R.T. Hendry, Diagonal Ramsey Numbers for Graphs with Seven Edges,
.I
Utilitas Mathematica,
.R
\fB32\fP (1987) 11-34.
.IP [He2]
G.R.T. Hendry, Ramsey Numbers for Graphs with Five Vertices,
.I
Journal of Graph Theory,
.R
\fB13\fP (1989) 245-248.
.IP [He3]
G.R.T. Hendry, The Ramsey Numbers $r(K sub 2 ^+^K bar sub 3 ,^K sub 4 )$
and $r(K sub 1 ^+^C sub 4 ,^K sub 4 )$,
.I
Utilitas Mathematica,
.R
\fB35\fP (1989) 40-54, addendum in \fB36\fP (1989) 25-32.
.IP [He4]
G.R.T. Hendry, Critical Colorings for Clancy's Ramsey Numbers,
.I
Utilitas Mathematica,
.R
\fB41\fP (1992) 181-203.
.IP [He5]
G.R.T. Hendry, Small Ramsey Numbers II. Critical Colorings
for $r(C sub 5 ^+^e,^K sub 5 )$,
.I
Quaestiones Mathematica,
.R
\fB17\fP (1994) 249-258.
.IP [-]
G.R.T. Hendry, see also [YH].
.IP [HiIr]*
R. Hill and R.W. Irving, On Group Partitions Associated with Lower Bounds
for Symmetric Ramsey Numbers,
.I
European Journal of Combinatorics,
.R
\fB3\fP (1982) 35-50.
.IP [Hir]
J. Hirschfeld,
A Lower Bound for Ramsey's Theorem,
.I
Discrete Mathematics,
.R
\fB32\fP (1980) 89-91.
.IP [Ho]
Pak Tung Ho,
On Ramsey Unsaturated and Saturated Graphs,
.I
Australasian Journal of Combinatorics,
.R
\fB46\fP (2010) 13-18.
.IP [HoMe]
M. Hoeth and I. Mengersen,
Ramsey Numbers for Graphs of Order Four versus Connected
Graphs of Order Six,
.I
Utilitas Mathematica,
.R
\fB57\fP (2000) 3-19.
.IP [HoIs]
J. Hook and G. Isaak,
Star-Critical Ramsey Numbers,
.I
Discrete Applied Mathematics,
.R
\fB159\fP (2011) 328-334.
.IP [HuSo]
Huang Da Ming and Song En Min,
Properties and Lower Bounds of the Third Order Ramsey Numbers (in Chinese),
.I
Mathematica Applicata,
.R
\fB9\fP (1996) 105-107.
.IP [Hua1]
Huang Guotai, Some Generalized Ramsey Numbers (in Chinese),
.I
Mathematica Applicata,
.R
\fB1\fP (1988) 97-101.
.IP [Hua2]
Huang Guotai, An Unsolved Problem of Gould and Jacobson (in Chinese),
.I
Mathematica Applicata,
.R
\fB9\fP (1996) 234-236.
.IP [-]
Huang Jian, see [HWSYZH].
.IP [-]
Huang Wenke, see [DuHu].
.IP [HWSYZH]
$^$ (also abbreviated by HW+)
Huang Yi Ru, Wang Yuandi, Sheng Wancheng, Yang Jiansheng, Zhang Ke Min and Huang Jian,
New Upper Bound Formulas with Parameters for Ramsey Numbers,
.I
Discrete Mathematics,
.R
\fB307\fP (2007) 760-763.
.IP [HZ1]
Huang Yi Ru and Zhang Ke Min, An New Upper Bound Formula for
Two Color Classical Ramsey Numbers,
.I
Journal of Combinatorial Mathematics and Combinatorial Computing,
.R
\fB28\fP (1998) 347-350.
.IP [HZ2]
Huang Yi Ru and Zhang Ke Min, New Upper Bounds for Ramsey Numbers,
.I
European Journal of Combinatorics,
.R
\fB19\fP (1998) 391-394.
.IP [-]
Huang Yi Ru, see also [BolJY+, YHZ1, YHZ2].
.nr PS 12

.DS C
\fBI\fP
.DE
.nr PS 10
.IP [Ir]
R.W. Irving, Generalised Ramsey Numbers for Small Graphs,
.I
Discrete Mathematics,
.R
\fB9\fP (1974) 251-264.
.IP [-]
R.W. Irving, see also [HiIr].
.IP [-]
G. Isaak, see [HoIs].
.IP [Isb1]
J.R. Isbell, $N(4,4^;^3)^>=^13$,
.I
Journal of Combinatorial Theory,
.R
\fB6\fP (1969) 210.
.IP [Isb2]
J.R. Isbell, $N(5,4^;^3)^>=^24$,
.I
Journal of Combinatorial Theory,
.R
Series A, \fB34\fP (1983) 379-380.
.IP [Ishi]
Y. Ishigami,
Linear Ramsey Numbers for Bounded-Degree Hypergraphs,
.I
Electronic Notes in Discrete Mathematics,
.R
\fB29\fP (2007) 47-51.

.nr PS 12
.DS C
\fBJ\fP
.DE
.nr PS 10
.IP [Jac]
M.S. Jacobson, On the Ramsey Number for Stars and a Complete Graph,
.I
Ars Combinatoria,
.R
\fB17\fP (1984) 167-172.
.IP [-]
M.S. Jacobson, see also [BEFRSGJ, GoJa1, GoJa2].
.IP [JaAl1]
M.M.M. Jaradat and B.M.N. Alzaleq,
The Cycle-Complete Graph Ramsey Number $r(C sub 8 ,^K sub 8 )$,
.I
SUT Journal of Mathematics,
.R
\fB43\fP (2007) 85-98.
.IP [JaAl2]
M.M.M. Jaradat and B.M.N. Alzaleq,
Cycle-Complete Graph Ramsey Numbers
$r(C sub 4 ,^K sub 9 )$,  $r(C sub 5 ,^K sub 8 ) ~<=~33$,
.I
International Journal of Mathematical Combinatorics,
.R
\fB1\fP (2009) 42-45.
.IP [JaBa]
M.M.M. Jaradat and A.M.M. Baniabedalruhman,
The Cycle-Complete Graph Ramsey Number $r(C sub 8 ,^K sub 7 )$,
.I
International Journal of Pure and Applied Mathematics,
.R
\fB41\fP (2007) 667-677.
.IP [-]
M.M.M. Jaradat, see also [BatJA].
.IP [JR1]
C.J. Jayawardene and C.C. Rousseau,
An Upper Bound for the Ramsey Number of a Quadrilateral versus a
Complete Graph on Seven Vertices,
.I
Congressus Numerantium,
.R
\fB130\fP (1998) 175-188.
.IP [JR2]
C.J. Jayawardene and C.C. Rousseau,
Ramsey Numbers $r(C sub 6 ,^G)$ for All Graphs $G$ of Order Less than Six,
.I
Congressus Numerantium,
.R
\fB136\fP (1999) 147-159.
.IP [JR3]
C.J. Jayawardene and C.C. Rousseau,
The Ramsey Numbers for a Quadrilateral vs. All Graphs
on Six Vertices,
.I
Journal of Combinatorial Mathematics and Combinatorial Computing,
.R
\fB35\fP (2000) 71-87. Erratum in \fB51\fP (2004) 221.
.IP [JR4]
C.J. Jayawardene and C.C. Rousseau,
Ramsey Numbers $r(C sub 5 ,^G)$ for All Graphs $G$ of Order Six,
.I
Ars Combinatoria,
.R
\fB57\fP (2000) 163-173.
.IP [JR5]
C.J. Jayawardene and C.C. Rousseau,
The Ramsey Number for a Cycle of Length Five vs.
a Complete Graph of Order Six,
.I
Journal of Graph Theory,
.R
\fB35\fP (2000) 99-108.
.IP [-]
C.J. Jayawardene, see also [BolJY+, RoJa1, RoJa2].
.IP [-]
Jiang Baoqi, see [SunYJLS].
.IP [JiSa]
Tao Jiang and M. Salerno,
Ramsey Numbers of Some Bipartite Graphs versus Complete Graphs,
.I
Graphs and Combinatorics,
.R
\fB27\fP (2011) 121-128.
.IP [Jin]**
Jin Xia, Ramsey Numbers Involving a Triangle: Theory & Applications,
.I
Technical Report RIT-TR-93-019,
.R
MS thesis, Department of Computer Science, Rochester Institute of
Technology, 1993.
.IP [-]
Jin Xia, see also [RaJi].
.IP [JoPe]
K. Johst and Y. Person,
On the Multicolor Ramsey Number of a Graph with $m$ Edges,
.I
preprint,
.R
arXiv,
\s-1\fHhttp://arxiv.org/abs/1311.5471\fP\s0
(2013).
.IP [JGT]
.I
Journal of Graph Theory,
.R
special volume on Ramsey theory,
\fB7\fP, Number 1, (1983).
.nr PS 12

.DS C
\fBK\fP
.DE
.nr PS 10
.IP [Ka1] 0.65i
J.G. Kalbfleisch, Construction of Special Edge-Chromatic Graphs,
.I
Canadian Mathematical Bulletin,
.R
\fB8\fP (1965) 575-584.
.IP [Ka2]*
J.G. Kalbfleisch, Chromatic Graphs and Ramsey's Theorem,
.I
Ph.D. thesis,
.R
University of Waterloo, January 1966.
.IP [Ka3]
J.G. Kalbfleisch, On Robillard's Bounds for Ramsey Numbers,
.I
Canadian Mathematical Bulletin,
.R
\fB14\fP (1971) 437-440.
.IP [KaSt]
J.G. Kalbfleisch and R.G. Stanton, On the Maximal Triangle-Free
Edge-Chromatic Graphs in Three Colors,
.I
Journal of Combinatorial Theory,
.R
\fB5\fP (1968) 9-20.
.IP [K\o'a\(aa'Ros]
G. K\o'a\(aa'rolyi and V. Rosta,
Generalized and Geometric Ramsey Numbers for Cycles,
.I
Theoretical Computer Science,
.R
\fB263\fP (2001) 87-98.
.IP [-]
P. Keevash, see [BohK1, BohK2].
.IP [KerRo]
M. Kerber and C. Rowan,
CommonLisp program for computing upper bounds on classical Ramsey numbers,
\s-1\fHhttp://www.cs.bham.ac.uk/~mmk/demos/ramsey-upper-limit.lisp\fP\s0
(2009).
.IP [K\o'e\(aa'ry]
G. K\o'e\(aa'ry,
On a Theorem of Ramsey (in Hungarian),
.I
Matematikai Lapok,
.R
\fB15\fP (1964) 204-224.
.IP [Kim]
J.H. Kim, The Ramsey Number $R(3,^t)$ Has Order of
Magnitude $t sup 2 /^log^t$,
.I
Random Structures and Algorithms,
.R
\fB7\fP (1995) 173-207.
.IP [KlaM1]
K. Klamroth and I. Mengersen,
Ramsey Numbers of $K sub 3$ versus $(p,^q)$-Graphs,
.I
Ars Combinatoria,
.R
\fB43\fP (1996) 107-120.
.IP [KlaM2]
K. Klamroth and I. Mengersen,
The Ramsey Number of $r(K sub 1,3 ,^C sub 4 ,^K sub 4 ^)$,
.I
Utilitas Mathematica,
.R
\fB52\fP (1997) 65-81.
.IP [-]
K. Klamroth, see also [ArKM].
.IP [-]
M. Klawe, see [GHK].
.IP [-]
D.J. Kleitman, see [GoK].
.IP [KoSS1]
Y. Kohayakawa, M. Simonovits and J. Skokan,
The 3-colored Ramsey Number of Odd Cycles,
.I
Electronic Notes in Discrete Mathematics,
.R
\fB19\fP (2005) 397-402.
.IP [KoSS2]
Y. Kohayakawa, M. Simonovits and J. Skokan,
The 3-colored Ramsey Number of Odd Cycles,
to appear in
.I
Journal of Combinatorial Theory,
.R
Series B (2013).
.IP [K\o'o\(:a'h]
W. K\o'o\(:a'hler, On a Conjecture by Grossman,
.I
Ars Combinatoria,
.R
\fB23\fP (1987) 103-106.
.IP [-]
J. Koml\o'o\(aa's, see [CsKo, AjKS, AjKSS].
.IP [Kor]
A. Korolova, Ramsey Numbers of Stars versus Wheels of Similar Sizes,
.I
Discrete Mathematics,
.R
\fB292\fP (2005) 107-117.
.IP [KosMV1]
$^$A. Kostochka, D. Mubayi and J. Verstra\o'e\(:a'te,
On Independent Sets in Hypergraphs,
.I
preprint,
.R
arXiv,
\s-1\fHhttp://arxiv.org/abs/1106.3098\fP\s0
(2011).
.IP [KosMV2]
$^$A. Kostochka, D. Mubayi and J. Verstra\o'e\(:a'te,
Hypergraph Ramsey Numbers: Triangles versus Cliques,
to appear in
.I
Journal of Combinatorial Theory,
.R
Series B (2013).
.IP [KosPR]
A. Kostochka, P. Pudl\o'a\(aa'k and V. R\o'o\(:a'dl,
Some Constructive Bounds on Ramsey Numbers,
.I
Journal of Combinatorial Theory,
.R
Series B, \fB100\fP (2010) 439-445.
.IP [KoR\o'o\(:a'1]
A.V. Kostochka and V. R\o'o\(:a'dl,
On Graphs with Small Ramsey Numbers,
.I
Journal of Graph Theory,
.R
\fB37\fP (2001) 198-204.
.IP [KoR\o'o\(:a'2]
A.V. Kostochka and V. R\o'o\(:a'dl,
On Graphs with Small Ramsey Numbers, II,
.I
Combinatorica,
.R
\fB24\fP (2004) 389-401.
.IP [KoR\o'o\(:a'3]
A.V. Kostochka and V. R\o'o\(:a'dl,
On Ramsey Numbers of Uniform Hypergraphs with Given Maximum Degree,
.I
Journal of Combinatorial Theory,
.R
Series A, \fB113\fP (2006) 1555-1564.
.IP [KoSu]
A.V. Kostochka and B. Sudakov,
On Ramsey Numbers of Sparse Graphs,
.I
Combinatorics, Probability and Computing,
.R
\fB12\fP (2003) 627-641.
.IP [-]
R.L. Kramer, see [FKR].
.IP [KrRod]
I. Krasikov and Y. Roditty,
On Some Ramsey Numbers of Unicyclic Graphs,
.I
Bulletin of the Institute of Combinatorics and its Applications,
.R
\fB33\fP (2001) 29-34.
.IP [-]
S. Krause, see [HaKr1, HaKr2].
.IP [KLR]*
D.L. Kreher, Li Wei and S.P. Radziszowski, Lower Bounds for Multi-Colored
Ramsey Numbers From Group Orbits,
.I
Journal of Combinatorial Mathematics and Combinatorial Computing,
.R
\fB4\fP (1988) 87-95.
.IP [-]
D.L. Kreher, see also [RK1, RK2, RK3, RK4].
.IP [Kriv]
M. Krivelevich,
Bounding Ramsey Numbers through Large Deviation Inequalities,
.I
Random Structures and Algorithms,
.R
\fB7\fP (1995) 145-155.
.IP [-]
M. Krivelevich, see also [AlBK, AlKS].
.IP [KroMe]
M. Krone and I. Mengersen,
The Ramsey Numbers $r(K sub 5 ^-^2K sub 2 ,^2K sub 3 )$,
$r(K sub 5 ^-^e ,^2K sub 3 )$ and $r(K sub 5 ,^2K sub 3 )$,
.I
Journal of Combinatorial Mathematics and Combinatorial Computing,
.R
\fB81\fP (2012) 257-260.
.IP [-]
M. Kubale, see [DzKP].
.IP [K\o'u\(:a'CFO]
D. K\o'u\(:a'hn, O. Cooley, N. Fountoulakis and D. Osthus,
Ramsey Numbers of Sparse Hypergraphs,
.I
Electronic Notes in Discrete Mathematics,
.R
\fB29\fP (2007) 29-33.
.IP [-]
D. K\o'u\(:a'hn, see also [CooFKO1, CooFKO2].

.nr PS 12
.DS C
\fBLa - Li\fP
.DE
.nr PS 10
.IP [-]
A. Lange, see [LivLR].
.IP [-]
P.C.B. Lam, see [ShiuLL].
.IP [La1]
S.L. Lawrence, Cycle-Star Ramsey Numbers,
.I
Notices of the American Mathematical Society,
.R
\fB20\fP (1973) Abstract A-420.
.IP [La2]
S.L. Lawrence, Bipartite Ramsey Theory,
.I
Notices of the American Mathematical Society,
.R
\fB20\fP (1973) Abstract A-562.
.IP [-]
S.L. Lawrence, see also [FLPS].
.IP [LayMa]
C. Laywine and J.P. Mayberry, A Simple Construction Giving the Two
Non-isomorphic Triangle-Free 3-Colored $K sub 16$'s,
.I
Journal of Combinatorial Theory,
.R
Series B, \fB45\fP (1988) 120-124.
.IP [LaMu]
F. Lazebnik and D. Mubayi,
New Lower Bounds for Ramsey Numbers of Graphs and Hypergraphs,
.I
Advances in Applied Mathematics,
.R
\fB28\fP (2002) 544-559.
.IP [LaWo1]
F. Lazebnik and A. Woldar,
New Lower Bounds on the Multicolor Ramsey Numbers $r sub k (C sub 4 ^)$,
.I
Journal of Combinatorial Theory,
.R
Series B, \fB79\fP (2000) 172-176.
.R
.IP [LaWo2]
F. Lazebnik and A. Woldar,
General Properties of Some Families of Graphs Defined by Systems of Equations,
.I
Journal of Graph Theory,
.R
\fB38\fP (2001) 65-86.
.IP [Lef]
H. Lefmann, Ramsey Numbers for Monotone Paths and Cycles,
.I
Ars Combinatoria,
.R
\fB35\fP (1993) 271-279.
.IP [-]
H. Lefmann, see also [DLR].
.IP [-]
J. Lehel, see [BaLS, GyLSS].
.IP [Les]*
A. Lesser, Theoretical and Computational Aspects of Ramsey Theory,
.I
Examensarbeten i Matematik,
.R
Matematiska Institutionen, Stockholms Universitet, \fB3\fP (2001).
.IP [-]
D. Leven, see [BlLR].
.IP [-]
Li Bingxi, see [SunYWLX, SunYXL].
.IP [LiWa1]
Li Da Yong and Wang Zhi Jian,
The Ramsey Number $r(mC sub 4 ,^nC sub 4 ^)$ (in Chinese),
.I
Journal of Shanghai Tiedao University,
.R
\fB20\fP (1999) 66-70, 83.
.IP [LiWa2]
Li Da Yong and Wang Zhi Jian,
The Ramsey Numbers $r(mC sub 4 ,^nC sub 5 ^)$,
.I
Journal of Combinatorial Mathematics and Combinatorial Computing,
.R
\fB45\fP (2003) 245-252.
.IP [-]
Li Guiqing, see [SLLL, SLZL].
.IP [-]
Li Jinwen, see [ZLLS].
.IP [LSLW]*
Li Qiao, Su Wenlong, Luo Haipeng and Wu Kang,
Lower Bounds for Some Two-Color Ramsey Numbers,
.I
manuscript
.R
(2011).
.IP [-]
Li Qiao, see also [SLL, SLLL].
.IP [-]
Li Wei, see [KLR].
.IP [Li1]
Li Yusheng, Some Ramsey Numbers of Graphs with Bridge,
.I
Journal of Combinatorial Mathematics and Combinatorial Computing,
.R
\fB25\fP (1997) 225-229.
.IP [Li2]
Li Yusheng, The Shannon Capacity of a Communication Channel,
Graph Ramsey Number and a Conjecture of Erd\o'o\(hu's,
.I
Chinese Science Bulletin,
.R
\fB46\fP (2001) 2025-2028.
.IP [Li3]
Yusheng Li, Ramsey Numbers of a Cycle,
.I
Taiwanese Journal of Mathematics,
.R
\fB12\fP (2008) 1007-1013.
.IP [Li4]
Yusheng Li, The Multi-Color Ramsey Number of an Odd Cycle,
.I
Journal of Graph Theory,
.R
\fB62\fP (2009) 324-328.
.IP [LiLih]
Yusheng Li and Ko-Wei Lih,
Multi-Color Ramsey Numbers of Even Cycles,
.I
European Journal of Combinatorics,
.R
\fB30\fP (2009) 114-118.
.IP [LiR1]
Li Yusheng and C.C. Rousseau, On Book-Complete Graph
Ramsey Numbers,
.I
Journal of Combinatorial Theory,
.R
Series B, \fB68\fP (1996) 36-44.
.IP [LiR2]
Li Yusheng and C.C. Rousseau, Fan-Complete Graph Ramsey Numbers,
.I
Journal of Graph Theory,
.R
\fB23\fP (1996) 413-420.
.IP [LiR3]
Li Yusheng and C.C. Rousseau, On the Ramsey Number
$r(H^+^K bar sub n ,^K sub n )$,
.I
Discrete Mathematics,
.R
\fB170\fP (1997) 265-267.
.IP [LiR4]
Li Yusheng and C.C. Rousseau,
A Ramsey Goodness Result for Graphs with Many Pendant Edges,
.I
Ars Combinatoria,
.R
\fB49\fP (1998) 315-318.
.IP [LiRS]
Li Yusheng, C.C. Rousseau and L. Solt\o'e\(aa's,
Ramsey Linear Families and Generalized Subdivided Graphs,
.I
Discrete Mathematics,
.R
\fB170\fP (1997) 269-275.
.IP [LiRZ1]
Li Yusheng, C.C. Rousseau and Zang Wenan,
Asymptotic Upper Bounds for Ramsey Functions,
.I
Graphs and Combinatorics,
.R
\fB17\fP (2001) 123-128.
.IP [LiRZ2]
Li Yusheng, C.C. Rousseau and Zang Wenan,
An Upper Bound on Ramsey Numbers,
.I
Applied Mathematics Letters,
.R
\fB17\fP (2004) 663-665.
.IP [LiShen]
Yusheng Li and Jian Shen,
Bounds for Ramsey Numbers of Complete Graphs Dropping an Edge,
.I
European Journal of Combinatorics,
.R
\fB29\fP (2008) 88-94.
.IP [LiTZ]
Li Yusheng, Tang Xueqing and Zang Wenan,
Ramsey Functions Involving $K sub m,n ^$ with $n$ Large,
.I
Discrete Mathematics,
.R
\fB300\fP (2005) 120-128.
.IP [LiZa1]
Li Yusheng and Zang Wenan,
Ramsey Numbers Involving Large Dense Graphs and Bipartite
Tur\o'a\(aa'n Numbers,
.I
Journal of Combinatorial Theory,
.R
Series B, \fB87\fP (2003) 280-288.
.IP [LiZa2]
Li Yusheng and Zang Wenan,
The Independence Number of Graphs with a
Forbidden Cycle and Ramsey Numbers,
.I
Journal of Combinatorial Optimization,
.R
\fB7\fP (2003) 353-359.
.IP [-]
Li Yusheng, see also [BaiLi, BaLX, CaLRZ, Doli,
DoLL1, DoLL2, GuLi, HeLD, LinLi1, LinLi2, LinLD,
Shiu LL, SonLi, SunLi, WaLi].
.IP [-]
Li Zhenchong, see [LSL, LuLL].
.IP [-]
Meilian Liang, see [LuLL].
.IP [LiaWXS]*
$~^$Wenzhong Liang, Kang Wu, Xiaodong Xu and Wenlong Su,
New Lower Bounds for Seven Classical Ramsey Numbers,
.I
in preparation,
.R
(2011).
.IP [LiaWXCS]* 0.69i
$~$
Liang Wenzhong, Wu Kang, Xu Chengzhang, Chen Hong and Su Wenlong,
Using the Two Stage Automorphism of Paley to Calculate the Lower Bound of Ramsey,
.I
Journal of Inner Mongolia Normal University,
.R
\fB41\fP (2012) 591-596.
.IP [-] 0.65i
Liang Wenzhong, see also [ChWXSL].
.IP [-]
Ko-Wei Lih, see [LiLih].
.IP [LinLi1]
Qizhong Lin and Yusheng Li,
On Ramsey Numbers of Fans,
.I
Discrete Applied Mathematics,
.R
\fB157\fP (2009) 191-194.
.IP [LinLi2]
Qizhong Lin and Yusheng Li,
Ramsey Numbers of $K sub 3$ and $K sub n,n$,
.I
Applied Mathematics Letters,
.R
\fB25\fP (2012) 380-384.
.IP [LinLD]
Qizhong Lin, Yusheng Li and Lin Dong,
Ramsey Goodness and Generalized Stars,
.I
European Journal of Combinatorics,
.R
\fB31\fP (2010) 1228-1234.
.IP [-]
Qizhong Lin, see also [DoLL1, DoLL2].
.IP [-]
Lin Xiaohui, see [SunYJLS, SunYLZ1, SunYLZ2].
.IP [Lind]
B. Lindstr\o'o\(:a'm, Undecided Ramsey-Numbers for Paths,
.I
Discrete Mathematics,
.R
\fB43\fP (1983) 111-112.
.IP [Ling]
A.C.H. Ling,
Some Applications of Combinatorial Designs to Extremal Graph Theory,
.I
Ars Combinatoria,
.R
\fB67\fP (2003) 221-229.
.IP [-]
Andy Liu, see [AbbL].
.IP [-]
Hong Liu, see [AxGLM].
.IP [-]
Liu Linzhong, see [ZLLS].
.IP [-]
Liu Shu Yan, see [SonBL].
.IP [-]
Liu Xiangyang, see [GuSL].
.IP [-]
Liu Yanwu, see [SonYL].
.IP [LivLR]**
I. Livinsky, A. Lange and S.P. Radziszowski,
Computation of the Ramsey Numbers
$R(C sub 4 ,^K sub 9 )$ and $R(C sub 4 ,^K sub 10 )$,
.I
manuscript
.R
(2013).

.nr PS 12

.DS C
\fBLo - Lu\fP
.DE
.nr PS 10
.IP [Loc]
S.C. Locke, Bipartite Density and the Independence Ratio,
.I
Journal of Graph Theory,
.R
\fB10\fP (1986) 47-53.
.IP [-]
S.C. Locke, see also [FrLo].
.IP [Lor]
P.J. Lorimer, The Ramsey Numbers for Stripes and One
Complete Graph,
.I
Journal of Graph Theory,
.R
\fB8\fP (1984) 177-184.
.IP [LorMu]
P.J. Lorimer and P.R. Mullins, Ramsey Numbers for Quadrangles
and Triangles,
.I
Journal of Combinatorial Theory,
.R
Series B, \fB23\fP (1977) 262-265.
.IP [LorSe]
P.J. Lorimer and R.J. Segedin, Ramsey Numbers for Multiple Copies
of Complete Graphs,
.I
Journal of Graph Theory,
.R
\fB2\fP (1978) 89-91.
.IP [LorSo]
P.J. Lorimer and W. Solomon, The Ramsey Numbers for Stripes and
Complete Graphs 1,
.I
Discrete Mathematics,
.R
\fB104\fP (1992) 91-97. Corrigendum in
.I
Discrete Mathematics,
.R
\fB131\fP (1994) 395.
.IP [-]
P.J. Lorimer, see also [CocL1, CocL2].
.IP [Lortz]
R. Lortz,
A Note on the Ramsey Number of $K sub 2,2$ versus $K sub 3,n$,
.I
Discrete Mathematics,
.R
\fB306\fP (2006) 2976-2982.
.IP [LoM1]
R. Lortz and I. Mengersen, On the Ramsey Numbers
$r(K sub {2,n^-^1},^K sub {2,n})$ and
$r(K sub {2,n},^K sub {2,n})$,
.I
Utilitas Mathematica,
.R
\fB61\fP (2002) 87-95.
.IP [LoM2]
R. Lortz and I. Mengersen,
Bounds on Ramsey Numbers of Certain Complete Bipartite Graphs,
.I
Results in Mathematics,
.R
\fB41\fP (2002) 140-149.
.IP [LoM3]*
R. Lortz and I. Mengersen,
Off-Diagonal and Asymptotic Results on the Ramsey Number
$r(K sub {2,m},^K sub {2,n})$,
.I
Journal of Graph Theory,
.R
\fB43\fP (2003) 252-268.
.IP [LoM4]*
R. Lortz and I. Mengersen,
Further Ramsey Numbers for Small Complete Bipartite Graphs,
.I
Ars Combinatoria,
.R
\fB79\fP (2006) 195-203.
.IP [LoM5]
R. Lortz and I. Mengersen,
Ramsey Numbers for Small Graphs versus Small Disconnected Graphs,
.I
Australasian Journal of Combinatorics,
.R
\fB51\fP (2011) 89-108.
.IP [\(L/uc]
T. \(L/uczak,
$R(C sub n ,^C sub n ,^C sub n )~<=~(4^+^o(1))^n$,
.I
Journal of Combinatorial Theory,
.R
Series B, \fB75\fP (1999) 174-187.
.IP [\(L/ucSS]
T. \(L/uczak, M. Simonovits and J. Skokan,
On the Multi-Colored Ramsey Numbers of Cycles,
.I
Journal of Graph Theory,
.R
\fB69\fP (2012) 169-175.
.IP [-]
T. \(L/uczak, see also [Fi\(L/u1, Fi\(L/u2, Ha\(L/P1+, Ha\(L/P2+, Ha\(L/T].
.IP [LSL]*
Luo Haipeng, Su Wenlong and Li Zhenchong,
The Properties of Self-Complementary Graphs and New Lower Bounds
for Diagonal Ramsey Numbers,
.I
Australasian Journal of Combinatorics,
.R
\fB25\fP (2002) 103-116.
.IP [LSS1]*
Luo Haipeng, Su Wenlong and Shen Yun-Qiu,
New Lower Bounds of Ten Classical Ramsey Numbers,
.I
Australasian Journal of Combinatorics,
.R
\fB24\fP (2001) 81-90.
.IP [LSS2]*
Luo Haipeng, Su Wenlong and Shen Yun-Qiu,
New Lower Bounds for Two Multicolor Classical Ramsey Numbers,
.I
Radovi Matemati\o'c\(be'ki,
.R
\fB13\fP (2004) 15-21.
.IP [-]
Luo Haipeng, see also [LSLW, SL, SLL, SLLL, SLZL, WSLX1, WSLX2].
.IP [LuLL]*
Liang Luo, Meilian Liang and Zhenchong Li,
Computation of Ramsey Numbers $R(C sub m ,^W sub n )$,
.I
Journal of Combinatorial Mathematics and Combinatorial Computing,
.R
\fB81\fP (2012) 145-149.

.nr PS 12
.DS C
\fBM\fP
.DE
.nr PS 10
.IP [Mac]*
J. Mackey, Combinatorial Remedies,
.I
Ph.D. thesis,
.R
Department of Mathematics, University of Hawaii, 1994.
.IP [MaOm]
L. Maherani and G.R. Omidi,
Around a Conjecture of Erd\o'o\(hu's on Graph Ramsey Numbers,
.I
preprint,
.R
arXiv,
\s-1\fHhttp://arxiv.org/abs/1211.6287\fP\s0
(2012).
.IP [MaORS1]
$^$ L. Maherani, G.R. Omidi, G. Raeisi and M. Shahsiah,
The Ramsey Number of Loose Paths in 3-Uniform Hypergraphs,
.I
Electronic Journal of Combinatorics,
.R
\s-1\fHhttp://www.combinatorics.org\fP\s0, #P12,
\fB20\fP(1) (2013), 8 pages.
.IP [MaORS2]
$^$ L. Maherani, G.R. Omidi, G. Raeisi and M. Shahsiah,
On Three-Color Ramsey Number of Paths,
.I
preprint,
.R
arXiv,
\s-1\fHhttp://arxiv.org/abs/1207.3771\fP\s0
(2012).
.IP [Mat]*
R. Mathon, Lower Bounds for Ramsey Numbers and Association Schemes,
.I
Journal of Combinatorial Theory,
.R
Series B, \fB42\fP (1987) 122-127.
.IP [-]
J.P. Mayberry, see [LayMa].
.IP [McS]
C. McDiarmid and A. Steger,
Tidier Examples for Lower Bounds on Diagonal Ramsey Numbers,
.I
Journal of Combinatorial Theory,
.R
Series A, \fB74\fP (1996) 147-152.
.IP [McK]**
B.D. McKay, Australian National University,
.I
personal communication
.R
(2003+). Graphs available at
\s-1\fHhttp://cs.anu.edu.au/people/bdm/data/ramsey.html\fP\s0.
.IP [MPR]**
B.D. McKay, K. Piwakowski and S.P. Radziszowski,
Ramsey Numbers for Triangles versus Almost-Complete Graphs,
.I
Ars Combinatoria,
.R
\fB73\fP (2004) 205-214.
.IP [MR1]**
B.D. McKay and S.P. Radziszowski, The First Classical Ramsey Number for
Hypergraphs is Computed,
.I
Proceedings of the Second Annual ACM-SIAM Symposium on Discrete Algorithms,
.R
SODA'91, San Francisco, (1991) 304-308.
.IP [MR2]*
B.D. McKay and S.P. Radziszowski,
A New Upper Bound for the Ramsey Number $R(5,^5)$,
.I
Australasian Journal of Combinatorics,
.R
\fB5\fP (1992) 13-20.
.IP [MR3]**
B.D. McKay and S.P. Radziszowski,
Linear Programming in Some Ramsey Problems,
.I
Journal of Combinatorial Theory,
.R
Series B, \fB61\fP (1994) 125-132.
.IP [MR4]**
B.D. McKay and S.P. Radziszowski, $R(4,^5)~=~25$,
.I
Journal of Graph Theory,
.R
\fB19\fP (1995) 309-322.
.IP [MR5]**
B.D. McKay and S.P. Radziszowski,
Subgraph Counting Identities and Ramsey Numbers,
.I
Journal of Combinatorial Theory,
.R
Series B, \fB69\fP (1997) 193-209.
.IP [MZ]**
B.D. McKay and Zhang Ke Min, The Value of the Ramsey Number $R(3,8)$,
.I
Journal of Graph Theory,
.R
\fB16\fP (1992) 99-105.
.IP [-]
B.D. McKay, see also [FM].
.IP [McN]**
J. McNamara, SUNY Brockport,
.I
personal communication
.R
(1995).
.IP [McR]**
J. McNamara and S.P. Radziszowski, The Ramsey Numbers
$R(K sub 4 ^-^e,^K sub 6 ^-^e)$ and $R(K sub 4 ^-^e,^K sub 7 ^-^e)$,
.I
Congressus Numerantium,
.R
\fB81\fP (1991) 89-96.
.IP [-]
H. M\o'e\(aa'lot, see [BrCGM].
.IP [MeO]
I. Mengersen and J. Oeckermann,
Matching-Star Ramsey Sets,
.I
Discrete Applied Mathematics,
.R
\fB95\fP (1999) 417-424.
.IP [-]
I. Mengersen, see also [ArKM, CEHMS, EHM1, EHM2, HoMe,
HaMe1, HaMe2, HaMe3, HaMe4, KlaM1, KlaM2, KroMe,
LoM1, LoM2, LoM3, LoM4, LoM5].
.IP [-]
Zhengke Miao, see [ChenCMN].
.IP [-]
M. Miller, see [BaSNM].
.IP [MiPal]
T.K. Mishra and S.P. Pal,
Lower Bounds for Ramsey Numbers for Complete Bipartite and
3-Uniform Tripartite Subgraphs, WALCOM 2013,
.I
LNCS
.R
7748, Springer, Berlin (2013) 257-264.
.IP [MiSa]
H. Mizuno and I. Sato, Ramsey Numbers for Unions of Some Cycles,
.I
Discrete Mathematics,
.R
\fB69\fP (1988) 283-294.
.IP [MoCa]
E.L. Monte Carmelo, Configurations in Projective Planes
and Quadrilateral-Star Ramsey Numbers,
.I
Discrete Mathematics,
.R
\fB308\fP (2008) 3986-3991.
.IP [-]
E.L. Monte Carmelo, see also [GoMC].
.IP [-]
L.P. Montejano, see [ChaMR].
.IP [-]
R. Morris, see [FizGM, FizGMSS].
.IP [MoSST]
G.O. Mota, G.N. S\o'a\(aa'rk\o'o\(:a'zy, M. Schacht and A. Taraz,
Ramsey Numbers for Bipartite Graphs with Small Bandwidth,
.I
manuscript
.R
(2013).
.IP [-]
D. Mubayi, see [AxFM, AxGLM, KosMV1, KosMV2, LaMu].
.IP [-]
P.R. Mullins, see [LorMu].
.IP [-]
S. Musdalifah, see [SuAM, SuAAM].

.bp
.nr PS 12
.DS C
\fBN\fP
.DE
.nr PS 10
.IP [-] 0.65i
S.M. Nababan, see [BaSNM].
.IP [NaORS]
B. Nagle, S. Olsen, V. R\o'o\(:a'dl and M. Schacht,
On the Ramsey Number of Sparse 3-Graphs,
.I
Graphs and Combinatorics,
.R
\fB24\fP (2008) 205-228.
.IP [Ne\o's\(be']
J. Ne\o's\(be'et\o'r\(be'il, Ramsey Theory, chapter 25 in
.I
Handbook of Combinatorics,
.R
ed. R.L. Graham, M. Gr\o'o\(:a'tschel and L. Lov\o'a\(aa'sz,
The MIT-Press, Vol. II, 1996, 1331-1403.
.IP [NeOs]
J. Ne\o's\(be'et\o'r\(be'il and P. Ossona de Mendez,
Fraternal Augmentations, Arrangeability and Linear Ramsey Numbers,
.I
European Journal of Combinatorics,
.R
\fB30\fP (2009) 1696-1703.
.IP [-]
J. Ne\o's\(be'et\o'r\(be'il, see also [GrNe].
.IP [-]
C.T. Ng, see [ChenCMN, ChenCNZ, CheCZN].
.IP [Nik]
V. Nikiforov,
The Cycle-Complete Graph Ramsey Numbers,
.I
Combinatorics, Probability and Computing,
.R
\fB14\fP (2005) 349-370.
.IP [NiRo1]
V. Nikiforov and C.C. Rousseau,
Large Generalized Books Are $p$-Good,
.I
Journal of Combinatorial Theory,
.R
Series B, \fB92\fP (2004) 85-97.
.IP [NiRo2]
V. Nikiforov and C.C. Rousseau,
Book Ramsey Numbers I,
.I
Random Structures and Algorithms,
.R
\fB27\fP (2005) 379-400.
.IP [NiRo3]
V. Nikiforov and C.C. Rousseau,
A Note on Ramsey Numbers for Books,
.I
Journal of Graph Theory,
.R
\fB49\fP (2005) 168-176.
.IP [NiRo4]
V. Nikiforov and C.C. Rousseau,
Ramsey Goodness and Beyond,
.I
Combinatorica,
.R
\fB29\fP (2009) 227-262.
.IP [NiRS]
V. Nikiforov, C.C. Rousseau and R.H. Schelp,
Book Ramsey Numbers and Quasi-Randomness,
.I
Combinatorics, Probability and Computing,
.R
\fB14\fP (2005) 851-860.
.IP [-]
A. Nowik, see [DzNS].
.nr PS 12

.DS C
\fBO\fP
.DE
.nr PS 10
.IP [-]
J. Oeckermann, see [MeO].
.IP [-]
S. Olsen, see [NaORS].
.IP [OmRa1]
G.R. Omidi and G. Raeisi,
On Multicolor Ramsey Number of Paths versus Cycles,
.I
Electronic Journal of Combinatorics,
.R
\s-1\fHhttp://www.combinatorics.org\fP\s0, #P24,
\fB18\fP(1) (2011), 16 pages.
.IP [OmRa2]
G.R. Omidi and G. Raeisi,
A Note on the Ramsey Number of Stars - Complete Graphs,
European Journal of Combinatorics,
.R
\fB32\fP (2011) 598-599.
.IP [OmRa3]
G.R. Omidi and G. Raeisi,
Ramsey Numbers for Multiple Copies of Hypergraphs,
.I
preprint,
.R
arXiv,
\s-1\fHhttp://arxiv.org/abs/1303.0474\fP\s0
(2013).
.IP [OmSh]
G.R. Omidi and M. Shahsiah,
Ramsey Numbers of 3-Uniform Loose Paths and Loose Cycles,
.I
preprint,
.R
arXiv,
\s-1\fHhttp://arxiv.org/abs/1211.5800\fP\s0
(2012).
.IP [-]
G.R. Omidi, see also [MaORS1, MaORS2].
.IP [-]
P. Ossona de Mendez, see [NeOs].
.IP [-]
D. Osthus, see [CooFKO1, CooFKO2, K\o'u\(:a'CFO].
.nr PS 12

.DS C
\fBP\fP
.DE
.nr PS 10
.IP [-]
S.P. Pal, see [MiPal].
.IP [-]
Linqiang Pan, see [ShaXBP, ShaXSP].
.IP [Par1]
T.D. Parsons, The Ramsey Numbers $r(P sub m ,^K sub n )$,
.I
Discrete Mathematics,
.R
\fB6\fP (1973) 159-162.
.IP [Par2]
T.D. Parsons, Path-Star Ramsey Numbers,
.I
Journal of Combinatorial Theory,
.R
Series B, \fB17\fP (1974) 51-58.
.IP [Par3]
T.D. Parsons, Ramsey Graphs and Block Designs, I,
.I
Transactions of the American Mathematical Society,
.R
\fB209\fP (1975) 33-44.
.IP [Par4]
T.D. Parsons, Ramsey Graphs and Block Designs,
.I
Journal of Combinatorial Theory,
.R
Series A, \fB20\fP (1976) 12-19.
.IP [Par5]
T.D. Parsons, Graphs from Projective Planes,
.I
Aequationes Mathematica,
.R
\fB14\fP (1976) 167-189.
.IP [Par6]
T.D. Parsons, Ramsey Graph Theory, in
.I
Selected Topics in Graph Theory,
.R
(L.W. Beineke and R.J. Wilson eds.), Academic Press, (1978) 361-384.
.IP [-]
T.D. Parsons, see also [FLPS].
.IP [Peng]
Xing Peng,
The Ramsey Number of Generalized Loose Paths in Uniform Hypergraphs,
.I
preprint,
.R
arXiv,
\s-1\fHhttp://arxiv.org/abs/1305.0294\fP\s0
(2013).
.IP [-]
Yuejian Peng, see [Ha\(L/P1+, Ha\(L/P2+].
.IP [-]
Y. Person, see [JoPe].
.IP [-]
O. Pikhurko, see [BePi].
.IP [Piw1]*
K. Piwakowski, Applying Tabu Search to Determine New Ramsey Graphs,
.I
Electronic Journal of Combinatorics,
.R
\s-1\fHhttp://www.combinatorics.org\fP\s0, #R6,
\fB3\fP(1) (1996), 4 pages.
.IP [Piw2]**
K. Piwakowski,  A New Upper Bound for $R sub 3 (K sub 4 ^-^e)$,
.I
Congressus Numerantium,
.R
\fB128\fP (1997) 135-141.
.IP [PR1]**
K. Piwakowski and S.P. Radziszowski,
$30^<=^R(3,3,4)^<=^31$,
.I
Journal of Combinatorial Mathematics and Combinatorial Computing,
.R
\fB27\fP (1998) 135-141.
.IP [PR2]**
K. Piwakowski and S.P. Radziszowski,
Towards the Exact Value of the Ramsey Number $R(3,3,4)$,
.I
Congressus Numerantium,
.R
\fB148\fP (2001) 161-167.
.IP [-]
K. Piwakowski, see also [MPR, DzKP].
.IP [Pokr]
A. Pokrovskiy,
Calculating Ramsey Numbers by Partitioning Coloured Graphs,
.I
preprint,
.R
arXiv,
\s-1\fHhttp://arxiv.org/abs/1309.3952\fP\s0
(2013).
.IP [PoRRS]
J. Polcyn, V. R\o'o\(:a'dl, A. Ruci\o'n\(aa'ski and E. Szemer\o'e\(aa'di,
Short Paths in Quasi-Random Triple Systems with Sparse Underlying Graphs,
.I
Journal of Combinatorial Theory,
.R
Series B, \fB96\fP (2006) 584-607.
.IP [-]
A.D. Polimeni, see [ChGP, CRSPS].
.IP [-]
J.R. Portillo, see [BoPo].
.IP [-]
L.M. Pretorius, see [SwPr].
.IP [-]
P. Pudl\o'a\(aa'k, see [AlPu, CPR, KosPR].
.nr PS 12

.DS C
\fBQ\fP
.DE
.nr PS 10
.IP [-]
Qian Xinjin, see [SonGQ].
.nr PS 12

.DS C
\fBR\fP
.DE
.nr PS 10
.IP [Ra1]** 0.65i
S.P. Radziszowski, The Ramsey Numbers $R(K sub 3 ,^K sub 8 ^-^e)$ and
$R(K sub 3 ,^K sub 9 ^-^e)$,
.I
Journal of Combinatorial Mathematics and Combinatorial Computing,
.R
\fB8\fP (1990) 137-145.
.IP [Ra2]
S.P. Radziszowski, Small Ramsey Numbers,
.I
Technical Report RIT-TR-93-009,
.R
Department of Computer Science, Rochester Institute of Technology (1993).
.IP [Ra3]**
S.P. Radziszowski, On the Ramsey Number $R(K sub 5 ^-^e,^K sub 5 ^-^e)$,
.I
Ars Combinatoria,
.R
\fB36\fP (1993) 225-232.
.IP [Ra4]
S.P. Radziszowski, Ramsey Numbers Involving Cycles, in
.I
Ramsey Theory: Yesterday, Today and Tomorrow
.R
(ed. A. Soifer), Progress in Mathematics 285,
Springer-Birkhauser 2011, 41-62.
.IP [RaJi]
S.P. Radziszowski and Jin Xia, Paths, Cycles and Wheels in Graphs
without Antitriangles,
.I
Australasian Journal of Combinatorics,
.R
\fB9\fP (1994) 221-232.
.IP [RK1]*
S.P. Radziszowski and D.L. Kreher, Search Algorithm for Ramsey Graphs
by Union of Group Orbits,
.I
Journal of Graph Theory,
.R
\fB12\fP (1988) 59-72.
.IP [RK2]**
S.P. Radziszowski and D.L. Kreher, On $R(3,^k)$ Ramsey Graphs:
Theoretical and Computational Results,
.I
Journal of Combinatorial Mathematics and Combinatorial Computing,
.R
\fB4\fP (1988) 37-52.
.IP [RK3]**
S.P. Radziszowski and D.L. Kreher, Upper Bounds for Some Ramsey
Numbers $R(3,^k)$,
.I
Journal of Combinatorial Mathematics and Combinatorial Computing,
.R
\fB4\fP (1988) 207-212.
.IP [RK4]
S.P. Radziszowski and D.L. Kreher, Minimum Triangle-Free Graphs,
.I
Ars Combinatoria,
.R
\fB31\fP (1991) 65-92.
.IP [RT]*
S.P. Radziszowski and Kung-Kuen Tse,
A Computational Approach for the Ramsey Numbers $R(C sub 4 ,^K sub n )$,
.I
Journal of Combinatorial Mathematics and Combinatorial Computing,
.R
\fB42\fP (2002) 195-207.
.IP [RST]*
S.P. Radziszowski, J. Stinehour and Kung-Kuen Tse,
Computation of the Ramsey Number $R(W sub 5 ,^K sub 5 ^)$,
.I
Bulletin of the Institute of Combinatorics and its Applications,
.R
\fB47\fP (2006) 53-57.
.IP [-]
S.P. Radziszowski, see also [BaRT, BlLR, CalSR, DyDR, FKR, GoR1, GoR2,
KLR, LivLR, MPR, MR1, MR2, MR3, MR4, MR5, McR, PR1, PR2, ShWR, WuSR,
WuSZR, XuR1, XuR2, XuR3, XSR1, XSR2, XXER, XXR].
.IP [-]
G. Raeisi, see [GyRa, MaORS1, MaORS2, OmRa1, OmRa2, OmRa3].
.IP [-]
J.L. Ramirez Alfonsin, see [ChaMR].
.IP [Ram]
F.P. Ramsey, On a Problem of Formal Logic,
.I
Proceedings of the London Mathematical Society,
.R
\fB30\fP (1930) 264-286.
.IP [RaHo]**
Ramsey@Home, A distributed computing project searching
for lower bounds for Ramsey numbers,
\s-1\fHhttp://www.ramseyathome.com/ramsey\fP\s0 (2009).
.IP [-]
A. Rao, see [BarRSW].
.IP [Rao]*
S. Rao, Applying a Genetic Algorithm to Improve
the Lower Bounds of Multi-Color Ramsey Numbers,
.I
MS thesis,
.R
Department of Computer Science, Rochester Institute of Technology, 1997.
.IP [-]
G. Resta, see [CPR].
.IP [-]
M.P. Revuelta, see [BoCGR].
.IP [-]
S.W. Reyner, see [BR].
.IP [-]
D.F. Reynolds, see [ExRe].
.IP [Rob1]
F.S. Roberts,
.I
Applied Combinatorics,
.R
Prentice-Hall, Englewood Cliffs, 1984.
.IP [-]
J.A. Roberts, see [BuRo1, BuRo2].
.IP [-]
S. Roberts, see [GR].
.IP [Rob2]*
A. Robertson,
New Lower Bounds for Some Multicolored Ramsey Numbers,
.I
Electronic Journal of Combinatorics,
.R
\s-1\fHhttp://www.combinatorics.org\fP\s0, #R12,
\fB6\fP (1999), 6 pages.
.IP [Rob3]*
A. Robertson, Difference Ramsey Numbers and Issai Numbers,
.I
Advances in Applied Mathematics,
.R
\fB25\fP (2000) 153-162.
.IP [Rob4]
A. Robertson,
New Lower Bounds Formulas for Multicolored Ramsey Numbers,
.I
Electronic Journal of Combinatorics,
.R
\s-1\fHhttp://www.combinatorics.org\fP\s0, #R13,
\fB9\fP (2002), 6 pages.
.IP [-]
Y. Roditty, see [KrRod].
.IP [R\o'o\(:a'Th]
V. R\o'o\(:a'dl and R. Thomas,
Arrangeability and Clique Subdivisions, in
.I
The Mathematics of Paul Erd\o'o\(hu's II,
.R
236-239, Algorithms and Combinatorics \fB14\fP,
Springer, Berlin, 1997.
.IP [-]
V. R\o'o\(:a'dl, see also [AlR\o'o\(:a', CRST, DLR, GrR\o'o\(:a',
GRR1, GRR2, Ha\(L/P1+, Ha\(L/P2+, KosPR,
KoR\o'o\(:a'1, KoR\o'o\(:a'2, KoR\o'o\(:a'3, NaORS, PoRRS].
.IP [-]
L. R\o'o\(aa'nyai, see [AlR\o'o\(aa'S].
.IP [Ros1]
V. Rosta, On a Ramsey Type Problem of J.A. Bondy and
P. Erd\o'o\(hu's, I & II,
.I
Journal of Combinatorial Theory,
.R
Series B, \fB15\fP (1973) 94-120.
.IP [Ros2]
V. Rosta, Ramsey Theory Applications, Dynamic Survey in
.I
Electronic Journal of Combinatorics,
.R
\s-1\fHhttp://www.combinatorics.org\fP\s0, #DS13,
(2004), 43 pages.
.IP [-]
V. Rosta, see also [BuRo3, K\o'a\(aa'Ros].
.IP [-]
B.L. Rothschild, see [GRS].
.IP [Rou]
C.C. Rousseau,
.I
personal communication,
.R
(2006).
.IP [RoJa1]
C.C. Rousseau and C.J. Jayawardene,
The Ramsey Number for a Quadrilateral vs. a Complete Graph
on Six Vertices,
.I
Congressus Numerantium,
.R
\fB123\fP (1997) 97-108.
.IP [RoJa2]
C.C. Rousseau and C.J. Jayawardene,
Harary's Problem for $K sub 2,k$,
.I
manuscript
.R
(1999).
.IP [RS1]
C.C. Rousseau and J. Sheehan, On Ramsey Numbers for Books,
.I
Journal of Graph Theory,
.R
\fB2\fP (1978) 77-87.
.IP [RS2]
C.C. Rousseau and J. Sheehan, A Class of Ramsey Problems
Involving Trees,
.I
Journal of the London Mathematical Society (2),
.R
\fB18\fP (1978) 392-396.
.IP [-]
C.C. Rousseau, see also [BolJY+, BEFRS1, BEFRS2, BEFRS3, BEFRS4, BEFRSG, BFRSJ,
CaLRZ, CRSPS, EFRS1, EFRS2, EFRS3, EFRS4, EFRS5, EFRS6, EFRS7, EFRS8, EFRS9,
FRS1, FRS2, FRS3, FRS4, FRS5, FRS6, FRS7, FRS8, FRS9, FSR, JR1, JR2, JR3, JR4, JR5,
LiR1, LiR2, LiR3, LiR4, LiRS, LiRZ1, LiRZ2, NiRo1, NiRo2, NiRo3, NiRo4, NiRS].
.IP [-]
C. Rowan, see [KerRo].
.IP [-]
P. Rowlinson, see [YR1, YR2, YR3].
.IP [-]
A. Ruci\o'n\(aa'ski, see [GRR1, GRR2, Ha\(L/P1+, Ha\(L/P2+, PoRRS].
.IP [-]
M. Ruszink\o'o\(aa', see [GyRSS].

.nr PS 12

.DS C
\fBSa - Sh\fP
.DE
.nr PS 10
.IP [-]
M. Salerno, see [JiSa].
.IP [SaBr1] 0.65i
A.N.M. Salman and H.J. Broersma,
The Ramsey Numbers of Paths versus Kipases,
.I
Electronic Notes in Discrete Mathematics,
.R
\fB17\fP (2004) 251-255.
.IP [SaBr2]
A.N.M. Salman and H.J. Broersma,
Paths-Fan Ramsey Numbers,
.I
Discrete Applied Mathematics,
.R
\fB154\fP (2006) 1429-1436.
.IP [SaBr3]
A.N.M. Salman and H.J. Broersma,
The Ramsey Numbers for Paths versus Wheels,
.I
Discrete Mathematics,
.R
\fB307\fP (2007) 975-982.
.IP [SaBr4]
A.N.M. Salman and H.J. Broersma,
Path-Kipas Ramsey Numbers,
.I
Discrete Applied Mathematics,
.R
\fB155\fP (2007) 1878-1884.
.IP [-]
A.N.M. Salman, see also [HaABS].
.IP [San]
A. S\o'a\(aa'nchez-Flores, An Improved Bound for Ramsey Number $N(3,3,3,3;2)$,
.I
Discrete Mathematics,
.R
\fB140\fP (1995) 281-286.
.IP [S\o'a\(aa'r]
G.N. S\o'a\(aa'rk\o'o\(:a'zy,
Monochromatic Cycle Partitions of Edge-Colored Graphs,
.I
Journal of Graph Theory,
.R
\fB66\fP (2011) 57-64.
.IP [-]
G.N. S\o'a\(aa'rk\o'o\(:a'zy, see also [GyLSS, GyRSS,
GyS\o'a\(aa'1, GyS\o'a\(aa'2, GySS1, GySS2, MoSST].
.IP [-]
I. Sato, see [MiSa].
.IP [-]
D. Saxton, see [FizGMSS].
.IP [-]
M. Schacht, see [MoSST, NaORS].
.IP [Scha]
M. Schaefer,
Graph Ramsey Theory and the Polynomial Hierarchy,
.I
Journal of Computer and System Sciences,
.R
\fB62\fP (2001) 290-322.
.IP [-]
R.H. Schelp, see [BaLS, BaSS, BEFRS1, BEFRS2, BEFRS3, BEFRS4, BEFRSGJ,
BEFS, BFRS, ChenS, EFRS1, EFRS2, EFRS3, EFRS4, EFRS5, EFRS6, EFRS7, EFRS8, EFRS9,
FLPS, FRS1, FRS2, FRS3, FRS4, FRS5, FRS6, FS1, FS2, FS3, FS4, FSR, FSS1, GyLSS, NiRS].
.IP [-]
J. Sch\o'o\(:a'nheim, see [BiaS].
.IP [SchSch1]*
$~$
A. Schelten and I. Schiermeyer, Ramsey Numbers $r(K sub 3 ,^G)$
for Connected Graphs $G$ of Order Seven,
.I
Discrete Applied Mathematics,
.R
\fB79\fP (1997) 189-200.
.IP [SchSch2]
A. Schelten and I. Schiermeyer,
Ramsey Numbers $r(K sub 3 ,^G)$ for
$G$ \(=~ $K sub 7 ^-^2P sub 2$ and $G$ \(=~ $K sub 7 ^-^3P sub 2$,
.I
Discrete Mathematics,
.R
\fB191\fP (1998) 191-196.
.IP [-]
A. Schelten, see also [FSS2].
.IP [Schi1]
I. Schiermeyer, All Cycle-Complete Graph Ramsey Numbers $r(C sub m ,^K sub 6 ^)$,
.I
Journal of Graph Theory,
.R
\fB44\fP (2003) 251-260.
.IP [Schi2]
I. Schiermeyer, 
The Cycle-Complete Graph Ramsey Number
$r(C sub 5 ,^K sub 7 ^)$,
.I
Discussiones Mathematicae Graph Theory,
.R
\fB25\fP (2005) 129-139.
.IP [-]
I. Schiermeyer, see also [FSS2, SchSch1, SchSch2].
.IP [-]
J.C. Schlage-Puchta, see [BrGS].
.IP [Schu]
C.-U. Schulte, Ramsey-Zahlen f\o'u\(:a'r B\o'a\(:a'ume und Kreise,
.I
Ph.D. thesis,
.R
Heinrich-Heine-Universit\o'a\(:a't D\o'u\(:a'sseldorf, (1992).
.IP [-]
M.J. Schuster, see [CalSR].
.IP [-]
S. Schuster, see [ChaS].
.IP [-]
A. Schwenk, see [ChvS].
.IP [Scob]
M.W. Scobee, On the Ramsey Number
$R( m sub 1 P sub 3 ,^m sub 2 P sub 3 ,^m sub 3 P sub 3 )$
and Related Results, ...,
.I
MA thesis,
.R
University of Louisville (1993).
.IP [-]
A. Seb\o'o\(hu', see [GySeT].
.IP [-]
R.J. Segedin, see [LorSe].
.IP [-]
M. Shahsiah, see [MaORS1, MaORS2, OmSh].
.IP [-]
R. Shaltiel, see [BarRSW].
.IP [Shao]*
Zehui Shao,
.I
personal communication
.R
(2008).
.IP [ShaoWX]*
$^$ Shao Zehui, Wang Zicheng and Xiao Jianhua,
Lower Bounds for Ramsey Numbers Based on Simulated Annealing Algorithm (in Chinese),
.I
Computer Engineering and Applications,
.R
\fB45\fP (2009) 70-71.
.IP [ShaXBP]*
$~$Zehui Shao, Jin Xu, Qiquan Bao and Linqiang Pan,
Computation of Some Generalized Ramsey Numbers,
.I
Journal of Combinatorial Mathematics and Combinatorial Computing,
.R
\fB75\fP (2010) 217-228.
.IP [ShaXB]*
Zehui Shao, Xiaodong Xu and Qiquan Bao,
On the Ramsey Numbers $R(C sub m ,^B sub n )$,
.I
Ars Combinatoria,
.R
\fB94\fP (2010) 265-271.
.IP [ShaXSP]*
$~$Zehui Shao, Xiaodong Xu, Xiaolong Shi and Linqiang Pan,
Some Three-Color Ramsey Numbers $R(P sub 4 ,^P sub 5 ,^C sub k )$
and $R(P sub 4 ,^P sub 6 ,^C sub k )$,
.I
European Journal of Combinatorics,
.R
\fB30\fP (2009) 396-403.
.IP [-]
Zehui Shao, see also [XSR1, XSR2].
.IP [Shas]
A. Shastri, Lower Bounds for Bi-Colored Quaternary Ramsey Numbers,
.I
Discrete Mathematics,
.R
\fB84\fP (1990) 213-216.
.IP [She1]
J.B. Shearer,
A Note on the Independence Number of Triangle-Free Graphs,
.I
Discrete Mathematics,
.R
\fB46\fP (1983) 83-87.
.IP [She2]*
J.B. Shearer, Lower Bounds for Small Diagonal Ramsey Numbers,
.I
Journal of Combinatorial Theory,
.R
Series A, \fB42\fP (1986) 302-304.
.IP [She3]
J.B. Shearer, A Note on the Independence Number of Triangle-Free Graphs II,
.I
Journal of Combinatorial Theory,
.R
Series B, \fB53\fP (1991) 300-307.
.IP [She4]*
J.B. Shearer, Independence Numbers of Paley Graphs
(data for primes 1 mod 4 up to 7000),
\s-1\fHhttp://www.research.ibm.com/people/s/shearer/indpal.html\fP\s0 (1996).
.IP [-]
J. Sheehan, see [CRSPS, CEHMS, FRS7, FRS8, FRS9, RS1, RS2].
.IP [-]
Jian Shen, see [LiShen].
.IP [-]
Shen Yun-Qiu, see [LSS1, LSS2].
.IP [-]
Sheng Wancheng, see [HWSYZH].
.IP [ShWR]*
D. Shetler, M. Wurtz and S.P. Radziszowski,
On Some Multicolor Ramsey Numbers Involving
$K sub 3 ^+^e$ and $K sub 4 ^-^e$,
.I
SIAM Journal on Discrete Mathematics,
.R
\fB26\fP (2012) 1256-1264.
.IP [-]
Shi Lei, see [SunYJLS].
.IP [Shi1]
Lingsheng Shi,
Cube Ramsey Numbers Are Polynomial,
.I
Random Structures & Algorithms,
.R
\fB19\fP (2001) 99--101.
.IP [Shi2]
Lingsheng Shi,
Upper Bounds for Ramsey Numbers,
.I
Discrete Mathematics,
.R
\fB270\fP (2003) 251-265.
.IP [Shi3]
Lingsheng Shi, Linear Ramsey Numbers of Sparse Graphs,
.I
Journal of Graph Theory,
.R
\fB50\fP (2005) 175-185.
.IP [Shi4]
Lingsheng Shi, The Tail Is Cut for Ramsey Numbers of Cubes,
.I
Discrete Mathematics,
.R
\fB307\fP (2007) 290-292.
.IP [Shi5]
Lingsheng Shi,
Ramsey Numbers of Long Cycles versus Books or Wheels,
.I
European Journal of Combinatorics,
.R
\fB31\fP (2010) 828-838.
.IP [ShZ1]
Shi Ling Sheng and Zhang Ke Min,
An Upper Bound Formula for Ramsey Numbers,
.I
manuscript
.R
(2001).
.IP [ShZ2]
Shi Ling Sheng and Zhang Ke Min,
A Sequence of Formulas for Ramsey Numbers,
.I
manuscript
.R
(2001).
.IP [-]
Xiaolong Shi, see [ShaXSP].
.IP [ShiuLL]
Shiu Wai Chee, Peter Che Bor Lam and Li Yusheng,
On Some Three-Color Ramsey Numbers,
.I
Graphs and Combinatorics,
.R
\fB19\fP (2003) 249-258.
.nr PS 12

.DS C
\fBSi - St\fP
.DE
.nr PS 10
.IP [Sid1]
A.F. Sidorenko, On Tur\o'a\(aa'n Numbers $T(n,^5,4)$ and Number of
Monochromatic 4-cliques in 2-colored 3-graphs (in Russian),
.I
Voprosy Kibernetiki,
.R
\fB64\fP (1980) 117-124.
.IP [Sid2]
A.F. Sidorenko, An Upper Bound on the Ramsey Number $R(K sub 3 ,^G)$
Depending Only on the Size of the Graph $G$,
.I
Journal of Graph Theory,
.R
\fB15\fP (1991) 15-17.
.IP [Sid3]
A.F. Sidorenko, The Ramsey Number of an $N$-Edge Graph versus Triangle
Is at Most $2N^+^1$,
.I
Journal of Combinatorial Theory,
.R
Series B, \fB58\fP (1993) 185-196.
.IP [-]
M. Simonovits, see [AjKSS, BaSS, FSS1, FS, Ha\(L/P1+, KoSS1, KoSS2, \(L/ucSS].
.IP [-]
J. Skokan, see [AllBS, BenSk, FizGMSS, Ha\(L/P1+, Ha\(L/P2+, KoSS1, KoSS2, \(L/ucSS].
.IP [-]
M.J. Smuga-Otto, see [AbbS].
.IP [Sob]
A. Sobczyk, Euclidian Simplices and the Ramsey Number $R(4,4^;^3)$,
.I
Technical Report #10, Clemson University
.R
(1967).
.IP [Soi1]
A. Soifer,
.I
The Mathematical Coloring Book,
Mathematics of coloring and the colorful life of its creators,
.R
Springer 2009.
.IP [Soi2]
A. Soifer,
.I
Ramsey Theory: Yesterday, Today and Tomorrow,
.R
Progress in Mathematics 285,
Springer-Birkhauser 2011.
.IP [-]
W. Solomon, see [LorSo].
.IP [-]
L. Solt\o'e\(aa's, see [LiRS].
.IP [Song1]
Song En Min, Study of Some Ramsey Numbers (in Chinese),
a note (announcement of results without proofs),
.I
Mathematica Applicata,
.R
\fB4\fP(2) (1991) 6.
.IP [Song2]
Song En Min, New Lower Bound Formulas for the Ramsey Numbers
$N(k,k,...,k;2)$ (in Chinese),
.I
Mathematica Applicata,
.R
\fB6\fP (1993) suppl., 113-116.
.IP [Song3]
Song En Min, An Investigation of Properties of Ramsey Numbers (in Chinese),
.I
Mathematica Applicata,
.R
\fB7\fP (1994) 216-221.
.IP [Song4]
Song En Min,
Properties and New Lower Bounds of the Ramsey Numbers $R(p,^q;4)$
(in Chinese),
.I
Journal of Huazhong University of Science and Technology,
.R
\fB23\fP (1995) suppl. II, 1-4.
.IP [SonYL]
Song En Min, Ye Weiguo and Liu Yanwu,
New Lower Bounds for Ramsey Number $R(p,^q;4)$,
.I
Discrete Mathematics,
.R
\fB145\fP (1995) 343-346.
.IP [-]
Song En Min, see also [HuSo, ZLLS].
.IP [Song5]
Song Hongxue,
Asymptotic Upper Bounds for Wheel-Complete Graph Ramsey Numbers,
.I
Journal of Southeast University
.R
(English Edition),
ISSN 1003-7985, \fB20\fP (2004) 126-129.
.IP [Song6]
Song Hongxue,
A Ramsey Goodness Result for Graphs with Large Pendent Trees,
.I
Journal of Mathematical Study (China),
.R
\fB42\fP (2009) 36-39.
.IP [Song7]
Song Hong-xue,
Asymptotic Upper Bounds for $K sub 2 ^+~ T sub m$ :
Complete Graph Ramsey Numbers,
.I
Journal of Mathematics (China),
.R
\fB30\fP (2010) 797-802.
.IP [Song8]
Song Hongxue,
Asymptotic Lower Bounds of Ramsey Numbers for $r$-Uniform Hypergraphs,
.I
Advances in Mathematics, Shuxue Jinzhan,
.R
\fB40\fP (2011) 179-186.
.IP [Song9]
Hongxue Song, Asymptotic Upper Bounds for $K sub 1,m,k$ :
Complete Graph Ramsey Numbers,
.I
Ars Combinatoria,
.R
\fB111\fP (2013) 137-144.
.IP [SonBL]
Song Hong Xue, Bai Lu Feng and Liu Shu Yan,
Asymptotic Upper Bounds for the Wheel-Complete Graph Ramsey Numbers
(in Chinese),
.I
Acta Mathematica Scientia, Series A,
.R
ISSN 1003-3998, \fB26\fP (2006) 741-746.
.IP [SonGQ]
Song Hongxue, Gu Hua and Qian Xinjin,
On the Ramsey Number of $K sub 3$ versus $K sub 2 ^+^ T sub n$
(in Chinese),
.I
Journal of Liaoning Normal University,
Natural Science Edition,
.R
ISSN 1000-1735, \fB27\fP (2004) 142-145.
.IP [SonLi]
Song Hongxue and Li Yusheng,
Asymptotic Lower Bounds of Ramsey Numbers for 4-Uniform Hypergraphs
(in Chinese),
.I
Journal of Nanjing University Mathematical Biquarterly,
.R
\fB26\fP (2009) 216-224.
.IP [-]
Song Hongxue, see also [GuSL].
.IP [Spe1]
J.H. Spencer,
Ramsey's Theorem - A New Lower Bound,
.I
Journal of Combinatorial Theory,
.R
Series A, \fB18\fP (1975) 108-115.
.IP [Spe2]
J.H. Spencer,
Asymptotic Lower Bounds for Ramsey Functions,
.I
Discrete Mathematics,
.R
\fB20\fP (1977) 69-76.
.IP [Spe3]
J.H. Spencer,
Eighty Years of Ramsey $R(3,^k)$ ... and Counting! in
.I
Ramsey Theory: Yesterday, Today and Tomorrow
.R
(ed. A. Soifer), Progress in Mathematics 285,
Springer-Birkhauser 2011, 27-39.
.IP [-]
J.H. Spencer, see also [BES, GRS].
.IP [-]
T.S. Spencer, see [BahS].
.IP [Spe4]*
T. Spencer, University of Nebraska at Omaha,
.I
personal communication
.R
(1993), and, Upper Bounds for Ramsey Numbers via Linear Programming,
.I
manuscript
.R
(1994).
.IP [-]
A.K. Srivastava, see [GauST].
.IP [Stahl]
S. Stahl, On the Ramsey Number $R(F,^K sub m )$ where $F$ is a Forest,
.I
Canadian Journal of Mathematics,
.R
\fB27\fP (1975) 585-589.
.IP [-]
R.G. Stanton, see [KaSt].
.IP [Stat]
W. Staton, Some Ramsey-type Numbers and the Independence Ratio,
.I
Transactions of the American Mathematical Society,
.R
\fB256\fP (1979) 353-370.
.IP [-]
A. Steger, see [McS].
.IP [-]
J. Stinehour, see [RST].
.IP [Stev]
S. Stevens, Ramsey Numbers for Stars versus Complete
Multipartite Graphs,
.I
Congressus Numerantium,
.R
\fB73\fP (1990) 63-71.
.IP [-]
M.J. Stewart, see [CRSPS].
.IP [Stone]
J.C. Stone,
Utilizing a Cancellation Algorithm to Improve the Bounds of $R(5,^5)$,
(1996), \s-1\fHhttp://oas.okstate.edu/ojas/jstone.htm\fP\s0.
This paper claims incorrectly that $R(5,5)^=^50$.
.nr PS 12

.DS C
\fBSu - Sz\fP
.DE
.nr PS 10
.IP [SL]*
Su Wenlong and Luo Haipeng,
Prime Order Cyclic Graphs and New Lower Bounds
for Three Classical Ramsey Numbers $R(4,^n)$ (in Chinese),
.I
Journal of Mathematical Study,
.R
\fB31\fP, 4 (1998) 442-446.
.IP [SLL]*
Su Wenlong, Luo Haipeng and Li Qiao,
New Lower Bounds of Classical Ramsey Numbers
$R(4,12)$, $R(5,11)$ and $R(5,12)$,
.I
Chinese Science Bulletin,
.R
\fB43\fP, 6 (1998) 528.
.IP [SLLL]*
Su Wenlong, Luo Haipeng, Li Guiqing and Li Qiao,
Lower Bounds of Ramsey Numbers Based on Cubic Residues,
.I
Discrete Mathematics,
.R
\fB250\fP (2002) 197-209.
.IP [SLZL]*
Su Wenlong, Luo Haipeng, Zhang Zhengyou and Li Guiqing,
New Lower Bounds of Fifteen Classical Ramsey Numbers,
.I
Australasian Journal of Combinatorics,
.R
\fB19\fP (1999) 91-99.
.IP [-]
Su Wenlong, see also [ChWXSL, LiaWXCS, LiaWXS, LSL, LSLW, LSS1, LSS2, WSLX1, WSLX2, XWCS].
.IP [Sud1]
B. Sudakov, A Note on Odd Cycle-Complete Graph Ramsey Numbers,
.I
Electronic Journal of Combinatorics,
.R
\s-1\fHhttp://www.combinatorics.org\fP\s0, #N1,
\fB9\fP (2002), 4 pages.
.IP [Sud2]
B. Sudakov,
Large $K sub r$-Free Subgraphs in $K sub s$-Free Graphs and
Some Other Ramsey-Type Problems,
.I
Random Structures and Algorithms,
.R
\fB26\fP (2005) 253-265.
.IP [Sud3]
B. Sudakov,
Ramsey Numbers and the Size of Graphs,
.I
SIAM Journal on Discrete Mathematics,
.R
\fB21\fP (2007) 980-986.
.IP [Sud4]
B. Sudakov,
A Conjecture of Erd\o'o\(hu's on Graph Ramsey Numbers,
.I
Advances in Mathematics,
.R
\fB227\fP (2011) 601-609
.IP [-]
B. Sudakov, see also [AlKS, ConFS1, ConFS2, ConFS3, ConFS4,
ConFS5, ConFS6, FoxSu1, FoxSu2, KoSu].
.IP [-]
A. Sudan, see [GGS].
.IP [Sudar]
I.W. Sudarsana,
The Goodness of Long Path with Respect to Multiple Copies of Small Wheel,
.I
Far East Journal of Mathematical Sciences,
.R
\fB59\fP (2011) 47-55.
.IP [SuAM]
I.W. Sudarsana, Adiwijaya and S. Musdalifah,
The Ramsey Number for a Linear Forest versus
Two Identical Copies of Complete Graphs, 
COCOON 2010,
.I
LNCS
.R
6196, Springer, Berlin (2010) 209-215.
.IP [SuAAM]
I.W. Sudarsana, H. Assiyatun, Adiwijaya and S. Musdalifah,
The Ramsey Number for a Linear Forest versus Two Identical Copies of Complete Graph,
.I
Discrete Mathematics, Algorithms and Applications,
.R
\fB2\fP (2010) 437-444.
.IP [SuBAU1]
$^$I.W. Sudarsana, E.T. Baskoro, H. Assiyatun and S. Uttunggadewa,
The Ramsey Number of a Certain Forest with Respect to a Small Wheel,
.I
Journal of Combinatorial Mathematics and Combinatorial Computing,
.R
\fB71\fP (2009) 257-264.
.IP [SuBAU2]
$^$I.W. Sudarsana, E.T. Baskoro, H. Assiyatun and S. Uttunggadewa,
The Ramsey Numbers of Linear Forest versus $3K sub 3 ^ up 20 union ^2K sub 4$,
.I
Journal of the Indonesian Mathematical Society,
.R
\fB15\fP (2009) 61-67.
.IP [SuBAU3]
$^$I.W. Sudarsana, E.T. Baskoro, H. Assiyatun and S. Uttunggadewa,
The Ramsey Numbers for the Union Graph with $H$-Good Components,
.I
Far East Journal of Mathematical Sciences,
.R
\fB39\fP (2010) 29-40.
.IP [Sun]*
Sun Yongqi, Research on Ramsey Numbers of Some Graphs (in Chinese),
.I
Ph. D. thesis,
.R
Dalian University of Technology, China, July 2006.
.IP [SunY]*
Sun Yongqi and Yang Yuansheng,
Study of the Three Color Ramsey Number $R sub 3 (C sub 8 )$ (in Chinese),
.I
Journal of Beijing Jiaotong University,
.R
\fB35\fP (2011) 14-17.
.IP [SunYJLS]
$~$ Sun Yongqi, Yang Yuansheng, Jiang Baoqi, Lin Xiaohui and Shi Lei,
On Multicolor Ramsey Numbers for Even Cycles in Graphs,
.I
Ars Combinatoria,
.R
\fB84\fP (2007) 333-343.
.IP [SunYLZ1]*
$~$Sun Yongqi, Yang Yuansheng, Lin Xiaohui and Zheng Wenping,
The Value of the Ramsey Number $R sub 4 (C sub 4 ^)$,
.I
Utilitas Mathematica,
.R
\fB73\fP (2007) 33-44.
.IP [SunYLZ2]*
$~$Sun Yongqi, Yang Yuansheng, Lin Xiaohui and Zheng Wenping,
On the Three Color Ramsey Numbers $R(C sub m ,^C sub 4 ,^C sub 4 ^)$,
.I
Ars Combinatoria,
.R
\fB84\fP (2007) 3-11.
.IP [SunYW]*
$~$ Sun Yongqi, Yang Yuansheng and Wang Zhihai,
The Value of the Ramsey Number $R sub 5 (C sub 6 ^)$,
.I
Utilitas Mathematica,
.R
\fB76\fP (2008) 25-31.
.IP [SunYWLX]* 0.8i
$~$Sun Yongqi, Yang Yuansheng, Wang Wei, Li Bingxi and Xu Feng,
Study of Three Color Ramsey
.IP "" 0.65i
numbers
$R(C sub {up 10 m sub up 25 1^},^C sub {up 10 m sub up 25 2^},^C sub {up 10 m sub up 25 3^})$
(in Chinese),
.I
Journal of Dalian University of Technology,
.R
ISSN 1000-8608, \fB46\fP (2006) 428-433.
.IP [SunYXL] 0.65i
$~$Sun Yongqi, Yang Yuansheng, Xu Feng and Li Bingxi,
New Lower Bounds on the Multicolor Ramsey Numbers $R sub {^r} (C sub {2m})$,
.I
Graphs and Combinatorics,
.R
\fB22\fP (2006) 283-288.
.IP [-]
Sun Yongqi, see also [WuSR, WuSZR, ZhaSW].
.IP [SunLi]
Sun Yuqin and Li Yusheng,
On an Upper Bound of Ramsey Number $r sub k (K sub {m,^n})$ with Large $n$,
.I
Heilongjiang Daxue Ziran Kexue Xuebao,
.R
ISSN 1001-7011,
\fB23\fP (2006) 668-670.
.IP [SunZ]
Zhi-Hong Sun,
Ramsey Numbers for Trees,
.I
Bulletin of the Australian Mathematical Society,
.R
\fB86\fP (2012) 164-176.
.IP [SunWW]
Zhi-Hong Sun, Lin-Lin Wang and Yi-Li Wu,
Tur\o'a\(aa'n's Problem and Ramsey Numbers for Trees,
.I
preprint,
.R
arXiv,
\s-1\fHhttp://arxiv.org/abs/1110.2725\fP\s0
(2011).
.IP [Sur]
Surahmat,
Cycle-Wheel Ramsey Numbers. Some results, open problems and conjectures.
.I
Math Track,
.R
ISSN 1817-3462, 1818-5495,
\fB2\fP (2006) 56-64.
.IP [SuBa1]
Surahmat and E.T. Baskoro,
On the Ramsey Number of a Path or a Star versus $W sub 4$ or $W sub 5$,
.I
Proceedings of the 12-th Australasian Workshop on Combinatorial Algorithms,
.R
Bandung, Indonesia, July 14-17 (2001) 174-179.
.IP [SuBa2]
Surahmat and E.T. Baskoro,
The Ramsey Number of Linear Forest versus Wheel,
paper presented at the
.I
13-th Australasian Workshop on Combinatorial Algorithms,
.R
Fraser Island, Queensland, Australia, July 7-10, 2002.
.IP [SuBB1]
Surahmat, E.T. Baskoro and H.J. Broersma,
The Ramsey Numbers of Large Star-like Trees versus Large Odd Wheels,
.I
Technical Report
.R
#1621, Faculty of Mathematical Sciences,
University of Twente, The Netherlands, (2002).
.IP [SuBB2]
Surahmat, E.T. Baskoro and H.J. Broersma,
The Ramsey Numbers of Large Cycles versus Small Wheels,
.I
Integers: Electronic Journal of Combinatorial Number Theory,
.R
\s-1\fHhttp://www.integers-ejcnt.org/vol4.html\fP\s0, #A10,
\fB4\fP (2004), 9 pages.
.IP [SuBB3]
Surahmat, E.T. Baskoro and H.J. Broersma,
The Ramsey Numbers of Fans versus $K sub 4$,
.I
Bulletin of the Institute of Combinatorics and its Applications,
.R
\fB43\fP (2005) 96-102.
.IP [SuBB4]
Surahmat, E.T. Baskoro and H.J. Broersma,
The Ramsey Numbers of Large Star and Large Star-Like
Trees versus Odd Wheels,
.I
Journal of Combinatorial Mathematics and Combinatorial Computing,
.R
\fB65\fP (2008) 153-162.
.IP [SuBT1]
Surahmat, E.T. Baskoro and I. Tomescu,
The Ramsey Numbers of Large Cycles versus Wheels,
.I
Discrete Mathematics,
.R
\fB306\fP (2006), 3334-3337.
.IP [SuBT2]
Surahmat, E.T. Baskoro and I. Tomescu,
The Ramsey Numbers of Large Cycles versus Odd Wheels,
.I
Graphs and Combinatorics,
.R
\fB24\fP (2008), 53-58.
.IP [SuBTB]
Surahmat, E.T. Baskoro, I. Tomescu and H.J. Broersma,
On Ramsey Numbers of Cycles with Respect to Generalized Even Wheels,
.I
manuscript
.R
(2006).
.IP [SuBUB]
Surahmat, E.T. Baskoro, S. Uttunggadewa and H.J. Broersma,
An Upper Bound for the Ramsey Number of a Cycle of Length Four
versus Wheels, in
.I
LNCS
.R
3330, Springer, Berlin (2005) 181-184.
.IP [-]
Surahmat, see also [AliSur, BaSu, BaSNM].
.IP [SwPr]
C.J. Swanepoel and L.M. Pretorius,
Upper Bounds for a Ramsey Theorem for Trees,
.I
Graphs and Combinatorics,
.R
\fB10\fP (1994) 377-382.
.IP [-]
M.M. Sweet, see [FreSw].
.IP [-]
T. Szab\o'o\(aa', see [AlR\o'o\(aa'S].
.IP [Szem]
E. Szemer\o'e\(aa'di, Regular Partitions of Graphs,
Probl\o'e\(ga'mes Combinatoires et Th\o'e\(aa'orie des Graphes
.R
(Orsay, 1976),
Colloques Internationaux du Centre National de la Recherche Scientifique,
CNRS Paris,
\fB260\fP (1978) 399--401.
.IP [-]
E. Szemer\o'e\(aa'di, see also [AjKS, AjKSS, CRST, GyRSS, GySS1, GySS2, PoRRS].
.IP [-]
P. Szuca, see [DzNS].
.nr PS 12

.DS C
\fBT\fP
.DE
.nr PS 10
.IP [-]
Tang Xueqing, see [LiTZ].
.IP [-]
A. Taraz, see [MoSST].
.IP [-]
R. Thomas, see [R\o'o\(:a'Th].
.IP [Tho]
A. Thomason, An Upper Bound for Some Ramsey Numbers,
.I
Journal of Graph Theory,
.R
\fB12\fP (1988) 509-517.
.IP [-]
P.W. Tingley, see [Ha\(L/T].
.IP [-]
I. Tomescu, see [AliBT1, AliBT2, SuBT1, SuBT2, SuBTB].
.IP [-]
C.A. Tovey, see [CaET].
.IP [-]
A. Tripathi, see [GauST].
.IP [Tr]
Trivial results.
.IP [-]
N. Trotignon, see [GySeT].
.IP [-]
W.T. Trotter Jr., see [CRST].
.IP [Tse1]*
Kung-Kuen Tse,
On the Ramsey Number of the Quadrilateral versus the Book and the Wheel,
.I
Australasian Journal of Combinatorics,
.R
\fB27\fP (2003) 163-167.
.IP [Tse2]*
Kung-Kuen Tse, A Note on the Ramsey Numbers $R(C sub 4 ,^B sub n ^)$,
.I
Journal of Combinatorial Mathematics and Combinatorial Computing,
.R
\fB58\fP (2006) 97-100.
.IP [Tse3]*
Kung-Kuen Tse, A Note on Some Ramsey Numbers $R(C sub p ,^C sub q ,^C sub r ^)$,
.I
Journal of Combinatorial Mathematics and Combinatorial Computing,
.R
\fB62\fP (2007) 189-192.
.IP [-]
Kung-Kuen Tse, see also [BaRT, RST, RT].
.IP [-]
Z. Tuza, see [GyTu].
.nr PS 12

.DS C
\fBU\fP
.DE
.nr PS 10
.IP [-]
S. Uttunggadewa, see [SuBAU1, SuBAU2, SuBAU3, SuBUB].
.nr PS 12

.DS C
\fBV\fP
.DE
.nr PS 10
.IP [-]
J. Verstra\o'e\(:a'te, see [KosMV1, KosMV2].
.IP [-]
L. Volkmann, see [GuoV].

.nr PS 12

.DS C
\fBW\fP
.DE
.nr PS 10
.IP [Walk]
K. Walker, Dichromatic Graphs and Ramsey Numbers,
.I
Journal of Combinatorial Theory,
.R
\fB5\fP (1968) 238-243.
.IP [Wall]
W.D. Wallis, On a Ramsey Number for Paths,
.I
Journal of Combinatorics, Information & System Sciences,
.R
\fB6\fP (1981) 295-296.
.IP [Wan]
Wan Honghui, Upper Bounds for Ramsey Numbers
$R(3,^3,^ ... ,^3)$ and Schur Numbers,
.I
Journal of Graph Theory,
.R
\fB26\fP (1997) 119-122.
.IP [-]
Wang Gongben, see [WW, WWY1, WWY2].
.IP [-]
Lin-Lin Wang, see [SunWW].
.IP [WW]*
Wang Qingxian and Wang Gongben, New Lower Bounds of Ramsey
Numbers $r(3,^q)$ (in Chinese),
.I
Acta Scientiarum Naturalium, Universitatis Pekinensis,
.R
\fB25\fP (1989) 117-121.
.IP [WWY1]*
Wang Qingxian, Wang Gongben and Yan Shuda, A Search Algorithm And New
Lower Bounds for Ramsey Numbers $r(3,^q)$,
.I
manuscript
.R
(1994).
.IP [WWY2]*
Wang Qingxian, Wang Gongben and Yan Shuda,
The Ramsey Numbers $R(K sub 3 ,^K sub q ^-^e)$ (in Chinese),
.I
Beijing Daxue Xuebao Ziran Kexue Ban,
.R
\fB34\fP (1998) 15-20.
.IP [-]
Wang Wei, see [SunYWLX, SunYXL].
.IP [WaLi]
Ye Wang and Yusheng Li,
Lower Bounds for Ramsey Numbers of $K sub n$ with a Small Subgraph Removed,
.I
Discrete Applied Mathematics,
.R
\fB160\fP (2012) 2063-2068.
.IP [-]
Wang Yuandi, see [HWSYZH].
.IP [-]
Wang Zhihai, see [SunYW].
.IP [-]
Wang Zhi Jian, see [LiWa1, LiWa2].
.IP [-]
Wang Zicheng, see [ShaoWX].
.IP [West]
D. West,
.I
Introduction to Graph Theory,
.R
second edition, Prentice Hall, 2001.
.IP [Wh]
E.G. Whitehead, The Ramsey Number $N(3,3,3,3^;^2)$,
.I
Discrete Mathematics,
.R
\fB4\fP (1973) 389-396.
.IP [-]
A. Widgerson, see [BarRSW].
.IP [-]
E.R. Williams, see [AbbW].
.IP [-]
R.M. Wilson, see [FraWi].
.IP [-]
A. Woldar, see [LaWo1, LaWo2].
.IP [WSLX1]*
$~$Kang Wu, Wenlong Su, Haipeng Luo and Xiaodong Xu,
New Lower Bound for Seven Classical Ramsey Numbers $R(3,^q)$,
.I
Applied Mathematics Letters,
.R
\fB22\fP (2009) 365-368.
.IP [WSLX2]*
$~$Kang Wu, Wenlong Su, Haipeng Luo and Xiaodong Xu,
A Generalization of Generalized Paley Graphs and New
Lower Bounds for $R(3,^q)$,
.I
Electronic Journal of Combinatorics,
.R
\s-1\fHhttp://www.combinatorics.org\fP\s0, #N25,
\fB17\fP (2010), 10 pages.
.IP [-]
Wu Kang, see also [ChWXSL, LiaWXCS, LiaWXS, LSLW, XWCS].
.IP [WuSR]
Wu Yali, Sun Yongqi and S.P. Radziszowski,
Wheel and Star-critical Ramsey Numbers for Quadrilateral,
.I
manuscript
.R
(2013).
.IP [WuSZR]
Wu Yali, Sun Yongqi, Zhang Rui and S.P. Radziszowski,
Ramsey Numbers of $C sub 4$ versus Wheels and Stars,
.I
manuscript
.R
(2013).
.IP [-]
Wu Yali, see also [ZhaSW].
.IP [-]
Yi-Li Wu, see [SunWW].
.IP [-]
M. Wurtz, see [ShWR].
.nr PS 12

.DS C
\fBX\fP
.DE
.nr PS 10
.IP [-]
Xiao Jianhua, see [ShaoWX].
.IP [XieZ]*
Xie Jiguo and Zhang Xiaoxian, A New Lower Bound for Ramsey
Number $r(3,13)$ (in Chinese),
.I
Journal of Lanzhou Railway Institute,
.R
\fB12\fP (1993) 87-89.
.IP [-]
Xie Zheng, see [XX1, XX2, XXER, XXR].
.IP [XWCS]*
Chengzhang Xu, Kang Wu, Hong Chen and Wenlong Su,
New Lower Bounds for Some Ramsey Numbers Based on Cyclic Graphs,
.I
in preparation,
.R
(2011).
.IP [-]
Xu Chengzhang, see also [LiaWXCS].
.IP [-]
Jin Xu, see [ShaXBP].
.IP [-]
Xu Feng, see [SunYWLX, SunYXL].
.IP [-]
Ran Xu, see [ChenCX].
.IP [Xu]
Xu Xiaodong,
.I
personal communication,
.R
(2004).
.IP [XuR1]
Xiaodong Xu and S.P. Radziszowski,
An Improvement to Mathon's Cyclotomic Ramsey Colorings,
.I
Electronic Journal of Combinatorics,
.R
\s-1\fHhttp://www.combinatorics.org\fP\s0, #N1,
\fB16\fP(1) (2009), 5 pages.
.IP [XuR2]
Xiaodong Xu and S.P. Radziszowski,
$28 ~<=~ R(C sub 4 ,^C sub 4 ,^C sub 3 ,^C sub 3 ^) ~<=~ 36$,
.I
Utilitas Mathematica,
.R
\fB79\fP (2009) 253-257.
.IP [XuR3]
Xiaodong Xu and S.P. Radziszowski,
Bounds on Shannon Capacity and Ramsey Numbers from Product of Graphs,
.I
IEEE Transactions on Information Theory,
.R
\fB59\fP (2013) 4767-4770.
.IP [XSR1]*
Xiaodong Xu, Zehui Shao and S.P. Radziszowski,
Bounds on Some Ramsey Numbers Involving Quadrilateral,
.I
Ars Combinatoria,
.R
\fB90\fP (2009) 337-344.
.IP [XSR2]*
Xiaodong Xu, Zehui Shao and S.P. Radziszowski,
More Constructive Lower Bounds on Classical Ramsey Numbers,
.I
SIAM Journal on Discrete Mathematics,
.R
\fB25\fP (2011) 394-400.
.IP [XX1]*
Xu Xiaodong and Xie Zheng,
A Constructive Approach for the Lower Bounds on
the Ramsey Numbers $r(k,^l)$,
.I
manuscript
.R
(2002).
.IP [XX2]
Xu Xiaodong and Xie Zheng,
A Constructive Approach for the Lower Bounds on Multicolor Ramsey Numbers,
.I
manuscript
.R
(2002).
.IP [XXER]*
Xu Xiaodong, Xie Zheng, G. Exoo and S.P. Radziszowski,
Constructive Lower Bounds on Classical Multicolor Ramsey Numbers,
.I
Electronic Journal of Combinatorics,
.R
\s-1\fHhttp://www.combinatorics.org\fP\s0, #R35,
\fB11\fP(1) (2004), 24 pages.
.IP [XXR]
Xu Xiaodong, Xie Zheng and S.P. Radziszowski,
A Constructive Approach for the Lower Bounds on the Ramsey Numbers $R(s,^t)$,
.I
Journal of Graph Theory,
.R
\fB47\fP (2004) 231-239.
.IP [-]
Xu Xiaodong, see also [ChWXSL, LiaWXS, ShaXB, ShaXSP, WSLX1, WSLX2].
.IP [-]
Xu Zhiqiang, see [BaLX].
.nr PS 12

.DS C
\fBY\fP
.DE
.nr PS 10
.IP [-]
J. Yackel, see [GrY].
.IP [-]
Yan Shuda, see [WWY1, WWY2].
.IP [YHZ1]
Yang Jian Sheng, Huang Yi Ru and Zhang Ke Min,
The Value of the Ramsey Number $R(C sub n ,^K sub 4 ^)$ is $3(n^-^1)^+^1$ $~(n^>=^4)$,
.I
Australasian Journal of Combinatorics,
.R
\fB20\fP (1999) 205-206.
.IP [YHZ2]
Yang Jian Sheng, Huang Yi Ru and Zhang Ke Min,
$R(C sub 6 ,^K sub 5^)~=~21$ and $R(C sub 7 ,^K sub 5^)~=~25$,
.I
European Journal of Combinatorics,
.R
\fB22\fP (2001) 561-567.
.IP [-]
Yang Jian Sheng, see also [BolJY+, HWSYZH].
.IP [YY]**
Yang Yuansheng, On the Third Ramsey Numbers of Graphs with Six Edges,
.I
Journal of Combinatorial Mathematics and Combinatorial Computing,
.R
\fB17\fP (1995) 199-208.
.IP [YH]*
Yang Yuansheng and G.R.T. Hendry, The Ramsey Number
$r(K sub 1 ^+^ C sub 4 ,^K sub 5 ^-^e)$,
.I
Journal of Graph Theory,
.R
\fB19\fP (1995) 13-15.
.IP [YR1]**
Yang Yuansheng and P. Rowlinson, On the Third Ramsey Numbers
of Graphs with Five Edges,
.I
Journal of Combinatorial Mathematics and Combinatorial Computing,
.R
\fB11\fP (1992) 213-222.
.IP [YR2]*
Yang Yuansheng and P. Rowlinson, On Graphs without 6-Cycles
and Related Ramsey Numbers,
.I
Utilitas Mathematica,
.R
\fB44\fP (1993) 192-196.
.IP [YR3]*
Yang Yuansheng and P. Rowlinson, The Third Ramsey Numbers for
Graphs with at Most Four Edges,
.I
Discrete Mathematics,
.R
\fB125\fP (1994) 399-406.
.IP [-]
Yang Yuansheng, see also [SunY, SunYJLS, SunYLZ1, SunYLZ2, SunYW, SunYWLX, SunYXL].
.IP [-]
Ye Weiguo, see [SonYL].
.IP [Yu1]*
Yu Song Nian, A Computer Assisted Number Theoretical
Construction of $(3,^k)$-Ramsey Graphs,
.I
Annales Universitatis Scientiarum Budapestinensis, Sect. Comput.,
.R
\fB10\fP (1989) 35-44.
.IP [Yu2]*
Yu Song Nian,
Maximal Triangle-Free Circulant Graphs and the Function $K(c)$
(in Chinese),
.I
Journal of Shanghai University, Natural Science,
.R
\fB2\fP (1996) 678-682.

.nr PS 12
.DS C
\fBZ\fP
.DE
.nr PS 10
.IP [-]
Zang Wenan, see [LiRZ1, LiRZ2, LiTZ, LiZa1, LiZa2].
.IP [Zeng]
Zeng Wei Bin, Ramsey Numbers for Triangles and Graphs of Order
Four with No Isolated Vertex,
.I
Journal of Mathematical Research & Exposition,
.R
\fB6\fP (1986) 27-32.
.IP [ZZ1]
Zhang Ke Min and Zhang Shu Sheng,
Some Tree-Stars Ramsey Numbers,
.I
Proceedings of the Second Asian Mathematical Conference
.R
1995, 287-291, World Sci. Publishing, River Edge, NJ, 1998.
.IP [ZZ2]
Zhang Ke Min and Zhang Shu Sheng,
The Ramsey Numbers for Stars and Stripes,
.I
Acta Mathematica Scientia,
.R
\fB25A\fP (2005) 1067-1072.
.IP [-]
Zhang Ke Min, see also [BolJY+, ChenZZ1, ChenZZ2, ChenZZ3, ChenZZ4,
ChenZZ5, ChenZZ6, HWSYZH, HZ1, HZ2, MZ, ShZ1, ShZ2, YHZ1,
YHZ2, ZhaCZ1, ZhaCZ2, ZZ3].
.IP [ZhaCC1]
Lianmin Zhang, Yaojun Chen and T.C. Edwin Cheng,
The Ramsey Numbers for Cycles versus Wheels of Even Order,
.I
European Journal of Combinatorics,
.R
\fB31\fP (2010) 254-259.
.IP [ZhaSW]*
Zhang Rui, Sun Yongqi and Wu Yali,
On the Four Color Ramsey Numbers for Hexagons,
.I
Ars Combinatoria,
.R
\fB111\fP (2013) 515-522.
.IP [-]
Zhang Rui, see also [WuSZR].
.IP [-]
Zhang Shu Sheng, see [ZZ1, ZZ2].
.IP [-]
Zhang Xiaoxian, see [XieZ].
.IP [-]
Zhang Yuming, see [CaLRZ].
.IP [Zhang1]
Zhang Yunqing,
On Ramsey Numbers of Short Paths versus Large Wheels,
.I
Ars Combinatoria,
.R
\fB89\fP (2008) 11-20.
.IP [Zhang2]
Zhang Yunqing,
The Ramsey Numbers for Stars of Odd Small
Order versus a Wheel of Order Nine,
.I
Nanjing Daxue Xuebao Shuxue Bannian Kan,
.R
ISSN 0469-5097,
\fB25\fP (2008) 35-40.
.IP [ZhaCC2]
Yunqing Zhang, T.C. Edwin Cheng and Yaojun Chen,
The Ramsey Numbers for Stars of Odd Order versus a Wheel of Order Nine,
.I
Discrete Mathematics, Algorithms and Applications,
.R
\fB1\fP (2009) 413-436.
.IP [ZhaCZ1]
Yunqing Zhang, Yaojun Chen and Kemin Zhang,
The Ramsey Numbers for Stars of Even Order versus a Wheel of Order Nine,
.I
European Journal of Combinatorics,
.R
\fB29\fP (2008) 1744-1754.
.IP [ZhaCZ2]
Yunqing Zhang, Yaojun Chen and Kemin Zhang,
The Ramsey Numbers for Trees of High Degree versus a Wheel of Order Nine,
.I
manuscript
.R
(2009).
.IP [ZZ3]
Yunqing Zhang and Ke Min Zhang,
The Ramsey Number $R(C sub 8 ,^K sub 8 ^)$,
.I
Discrete Mathematics,
.R
\fB309\fP (2009) 1084-1090.
.IP [-]
Zhang Yunqing, see also [ChenCNZ, ChenCZ1,
ChenZZ1, ChenZZ2, ChenZZ3, ChenZZ4, ChenZZ5, ChenZZ6, CheCZN]. 
.IP [-]
Zhang Zhengyou, see [SLZL].
.IP [ZLLS]
Zhang Zhongfu, Liu Linzhong, Li Jinwen and Song En Min,
Some Properties of Ramsey Numbers,
.I
Applied Mathematics Letters,
.R
\fB16\fP (2003) 1187-1193.
.IP [Zhao]
Yi Zhao,
Proof of the $(n/^2^-^n/^2^-^n/^2)$ Conjecture for Large $n$,
.I
Electronic Journal of Combinatorics,
.R
\s-1\fHhttp://www.combinatorics.org\fP\s0, #P27,
\fB18\fP(1) (2011), 61 pages.
.IP [-]
Zheng Wenping, see [SunYLZ1, SunYLZ2].
.IP [Zhou1]
Zhou Huai Lu, Some Ramsey Numbers for Graphs with Cycles (in Chinese),
.I
Mathematica Applicata,
.R
\fB6\fP (1993) 218.
.IP [Zhou2]
Zhou Huai Lu, The Ramsey Number of an Odd Cycle with Respect
to a Wheel (in Chinese),
.I
Journal of Mathematics, Shuxue Zazhi
.R
(Wuhan), \fB15\fP (1995) 119-120.
.IP [Zhou3]
Zhou Huai Lu, On Book-Wheel Ramsey Number,
.I
Discrete Mathematics,
.R
\fB224\fP (2000) 239-249.
.nr PS 10
.nr VS 12
.LP
